IF OBJECT_ID('DailyFlightSchedules', 'U') IS NOT NULL
    DROP TABLE DailyFlightSchedules;
IF OBJECT_ID('Airports', 'U') IS NOT NULL
    DROP TABLE Airports;
IF OBJECT_ID('Airlines', 'U') IS NOT NULL
    DROP TABLE Airlines;
GO
CREATE TABLE Airlines
    (AirlineCode   CHAR(2) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL PRIMARY KEY 
    ,AirlineName   VARCHAR(150) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
    ,CallSign      VARCHAR(150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
    ,Country       VARCHAR(100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL)
GO
INSERT INTO Airlines
SELECT AirlineCode, AirlineName, CallSign, Country
FROM (
SELECT 'CG','Airlines PNG','BALUS','Papua New Guinea'
UNION ALL SELECT 'PX','Air Niugini','NUIGINI','Papua New Guinea'
UNION ALL SELECT 'XX', 'Dummy Airlines', 'DUMMY', 'SQL-Land'
) a (AirlineCode, AirlineName, CallSign, Country)

GO
CREATE TABLE Airports(
    ICAO_Code CHAR(4) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
    IATA_Code CHAR(3) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL PRIMARY KEY,
    [Name] VARCHAR(200) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
    [City] VARCHAR(200) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
    [State] CHAR(2) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
    [Country] VARCHAR(100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
    [LatDeg] INT NULL,
    [LatMin] INT NULL,
    [LatSec] INT NULL,
    [LatDir] CHAR(1) NULL,
    [LongDeg] INT NULL,
    [LongMin] INT NULL,
    [LongSec] INT NULL,
    [LongDir] CHAR(1) NULL,
    [LatDec] AS (CAST(CASE LatDir WHEN 'N' THEN 1. WHEN 'S' THEN -1. END *
        LatDeg+LatMin/60.+LatSec/3600. AS FLOAT)) PERSISTED,
    [LongDec] AS(CAST(CASE LongDir WHEN 'E' THEN 1. WHEN 'W' THEN -1. END *
        LongDeg+LongMin/60.+LongSec/3600. AS FLOAT)) PERSISTED,
    [Altitude] FLOAT NULL,
    [UTC] CHAR(6))

GO

INSERT INTO Airports (ICAO_Code, IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir
    ,LongDeg, LongMin, LongSec, LongDir, Altitude)
SELECT ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LongDeg],[LongMin],[LongSec],[LongDir],[Altitude]
FROM (
SELECT x.ICAO_Code,x.IATA_Code,x.[Name],x.[City],x.[Country],x.[LatDeg],x.[LatMin],x.[LatSec],x.[LatDir]
	,x.[LatDec],x.[LongDeg],x.[LongMin],x.[LongSec],x.[LongDir],x.[LongDec],x.[Altitude]
    ,n=ROW_NUMBER() OVER (PARTITION BY x.IATA_Code ORDER BY (SELECT NULL))
FROM (
SELECT 'ZSFZ','FOC','CHANGLE','FUZHOU','CHINA',25,56,0,'N',25.9333333333333,119,39,42,'E',119.661666666667,46
UNION ALL SELECT 'ZSGZ','KOW','','GANZHOU','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZSHC','HGH','XIAOSHAN','HANGZHOU','CHINA',30,13,42,'N',30.2283333333333,120,25,54,'E',120.431666666667,23
UNION ALL SELECT 'ZSJD','JDZ','JINGDEZHEN AIRPORT','JINGDEZHEN','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZSLG','LYG','','LIANYUNGANG','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZSLQ','HYN','','HUANGYAN','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZSNB','NGB','LISHE','NINBO','CHINA',29,49,29,'N',29.8247222222222,121,27,54,'E',121.465,13
UNION ALL SELECT 'ZSNJ','NKG','LU KOU AIRPORT','NANJING','CHINA',31,44,24,'N',31.74,118,51,36,'E',118.86,49
UNION ALL SELECT 'ZSOF','HFE','LUOGANG','HEFEI','CHINA',31,46,48,'N',31.78,117,17,54,'E',117.298333333333,95
UNION ALL SELECT 'ZSQD','TAO','LIUTING','QINGDAO','CHINA',36,15,45,'N',36.2625,120,22,31,'E',120.375277777778,32
UNION ALL SELECT 'ZSSS','SHA','HONGQIAO INTERNATIONAL','SHANGHAI','CHINA',31,11,52,'N',31.1977777777778,121,20,10,'E',121.336111111111,10
UNION ALL SELECT 'ZSTN','TNA','','JINAN','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZSTX','TXN','','TUNXI','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZSWZ','WNZ','','WENZHOU','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZSYT','YNT','LAISHAN','YANTAI','CHINA',37,24,6,'N',37.4016666666667,121,22,18,'E',121.371666666667,59
UNION ALL SELECT 'ZUCK','CKG','JIANGBEI','CHONGQING','CHINA',29,43,8,'N',29.7188888888889,106,38,29,'E',106.641388888889,1365
UNION ALL SELECT 'ZUGY','KWE','','GUIYANG','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZULS','LXA','LHASA AIRPORT','LHASA','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZUUU','CTU','SHUANGLIU','CHENGDU','CHINA',30,34,42,'N',30.5783333333333,103,56,49,'E',103.946944444444,1624
UNION ALL SELECT 'ZUXC','XIC','QINGSHAN','XICHANG','CHINA',27,59,19,'N',27.9886111111111,102,11,3,'E',102.184166666667,5112
UNION ALL SELECT 'ZWSH','KHG','KASHI','KASHI','CHINA',39,32,36,'N',39.5433333333333,76,1,18,'E',76.0216666666667,4528
UNION ALL SELECT 'ZWTN','HTN','HOTAN','HOTAN','CHINA',37,2,16,'N',37.0377777777778,79,51,57,'E',79.8658333333333,4672
UNION ALL SELECT 'ZWTP','N/A','','TURPAN','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZWWW','URC','DIWOPU','URUMQI','CHINA',43,54,25,'N',43.9069444444444,87,28,27,'E',87.4741666666667,2126
UNION ALL SELECT 'ZYHB','HRB','TAIPING','HARBIN','CHINA',45,37,24,'N',45.6233333333333,126,15,1,'E',126.250277777778,456
UNION ALL SELECT 'ZYRD','CGQ','','CHANGCHUN','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZYTL','DLC','ZHOUSHUIZI','DALIAN','CHINA',38,57,56,'N',38.9655555555556,121,32,18,'E',121.538333333333,108
) x (ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LatDec],[LongDeg],[LongMin],[LongSec],[LongDir],[LongDec],[Altitude])
LEFT OUTER JOIN Airports a ON a.IATA_Code = x.IATA_Code
--WHERE x.[LatDir] <> 'U' and x.[LongDir] <> 'U' and x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE n=1
GO

INSERT INTO Airports (ICAO_Code, IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir
    ,LongDeg, LongMin, LongSec, LongDir, Altitude)
SELECT ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LongDeg],[LongMin],[LongSec],[LongDir],[Altitude]
FROM (
SELECT x.ICAO_Code,x.IATA_Code,x.[Name],x.[City],x.[Country],x.[LatDeg],x.[LatMin],x.[LatSec],x.[LatDir]
	,x.[LatDec],x.[LongDeg],x.[LongMin],x.[LongSec],x.[LongDir],x.[LongDec],x.[Altitude]
    ,n=ROW_NUMBER() OVER (PARTITION BY x.IATA_Code ORDER BY (SELECT NULL))
FROM (
SELECT 'AYGA','GKA','GOROKA','GOROKA','PAPUA NEW GUINEA',6,4,54,'S',-6.08166666666667,145,23,30,'E',145.391666666667,5282
UNION ALL SELECT 'AYMD','MAG','MADANG','MADANG','PAPUA NEW GUINEA',5,12,25,'S',-5.20694444444444,145,47,19,'E',145.788611111111,20
UNION ALL SELECT 'AYMH','HGU','MOUNT HAGEN','MOUNT HAGEN','PAPUA NEW GUINEA',5,49,34,'S',-5.82611111111111,144,17,46,'E',144.296111111111,5388
UNION ALL SELECT 'AYNZ','LAE','NADZAB','NADZAB','PAPUA NEW GUINEA',6,34,11,'S',-6.56972222222222,146,43,34,'E',146.726111111111,239
UNION ALL SELECT 'AYPY','POM','PORT MORESBY JACKSONS INTERNATIONAL','PORT MORESBY','PAPUA NEW GUINEA',9,26,36,'S',-9.44333333333333,147,13,12,'E',147.22,146
UNION ALL SELECT 'AYRB','RAB','','RABAUL','PAPUA NEW GUINEA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'AYWK','WWK','WEWAK INTERNATIONAL','WEWAK','PAPUA NEW GUINEA',3,35,1,'S',-3.58361111111111,143,40,9,'E',143.669166666667,19
UNION ALL SELECT 'BGBW','UAK','NARSARSUAQ','NARSSARSSUAQ','GREENLAND',61,9,40,'N',61.1611111111111,45,25,39,'U',0,112
UNION ALL SELECT 'BGCH','JCH','','CHRISTIANSHAAB','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BGEM','JEG','','EGEDESMINDE','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BGFH','JFR','','FREDERIKSHAAB','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BGGD','JGR','','GRONNEDAL','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BGGH','GOH','NUUK','GODTHAAB','GREENLAND',64,11,27,'N',64.1908333333333,51,40,41,'U',0,283
UNION ALL SELECT 'BGGN','JGO','','GODHAVN','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BGHB','JHS','','HOLSTEINSBORG','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BGJH','JJU','','JULIANEHAAB','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BGJN','JAV','JACOBSHAVN','JAKOBSHAVN','GREENLAND',69,14,0,'N',69.2333333333333,51,4,0,'U',0,110
UNION ALL SELECT 'BGKK','KUS','KULUSUK','KULUSUK','GREENLAND',65,35,0,'N',65.5833333333333,37,9,0,'U',0,110
UNION ALL SELECT 'BGNN','JNN','','NANORTALIK','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BGNS','JNS','','NARSSAQ','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BGSF','SFJ','KANGERLUSSUAQ SONDRE STROMFJORD','SONDRESTROM','GREENLAND',67,1,1,'N',67.0169444444444,50,41,21,'U',0,165
UNION ALL SELECT 'BGST','JSU','','SUKKERTOPPEN','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BGTL','THU','THULE AIR BASE','THULE','GREENLAND',76,31,52,'N',76.5311111111111,68,42,11,'U',0,251
UNION ALL SELECT 'BGUP','JUV','','UPERNAVIK','GREENLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BIAR','AEY','AKUREYRI','AKUREYRI','ICELAND',65,39,35,'N',65.6597222222222,18,4,21,'U',0,6
UNION ALL SELECT 'BIEG','EGS','EGILSSTADIR','EGILSSTADIR','ICELAND',65,17,0,'N',65.2833333333333,14,24,5,'U',0,76
UNION ALL SELECT 'BIGR','GRY','','GRIMSEY','ICELAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BIHN','HFN','HORNAFJORDUR','HOFN','ICELAND',64,17,44,'N',64.2955555555556,15,13,38,'U',0,24
UNION ALL SELECT 'BIHU','HZK','HUSAVIK','HUSAVIK','ICELAND',65,57,8,'N',65.9522222222222,17,25,33,'U',0,45
UNION ALL SELECT 'BIIS','IFJ','ISAFJORDUR','ISAFJORDUR','ICELAND',66,3,29,'N',66.0580555555556,23,8,7,'U',0,8
UNION ALL SELECT 'BIKF','KEF','KEFLAVIK NAS','KEFLAVIK','ICELAND',63,59,6,'N',63.985,22,36,20,'U',0,171
UNION ALL SELECT 'BIKP','OPA','KOPASKER','KOPASKER','ICELAND',66,18,49,'N',66.3136111111111,16,27,40,'U',0,20
UNION ALL SELECT 'BIKR','SAK','','SAUDARKROKUR','ICELAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BINF','NOR','','NORDFJORDUR','ICELAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BIPA','PFJ','PATREKSFJORDUR','PATREKSFJORDUR','ICELAND',65,33,21,'N',65.5558333333333,23,57,54,'U',0,11
UNION ALL SELECT 'BIRG','RFN','','RAUFARHOFN','ICELAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BIRK','RKV','REYKJAVIK','REYKJAVIK','ICELAND',64,7,48,'N',64.13,21,56,26,'U',0,48
UNION ALL SELECT 'BISI','SIJ','SIGLUFJORDHUR','SIGLUFJORDUR','ICELAND',66,8,0,'N',66.1333333333333,18,55,0,'U',0,10
UNION ALL SELECT 'BITE','TEY','','THINGEYRI','ICELAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BITH','THO','','THORSHOFN','ICELAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'BIVM','VEY','VESTMANNAEYJAR','VESTMANNAEYJAR','ICELAND',63,25,27,'N',63.4241666666667,20,16,43,'U',0,326
UNION ALL SELECT 'BIVO','VPN','','VOPNAFJORDUR','ICELAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CUHA','YQC','','QUAQTAQ','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYAB','YAB','','ARCTIC BAY','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYAL','YAL','','ALERT BAY','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYAM','YAM','SAULT STE MARIE','SAULT SAINTE MARIE','CANADA',46,29,6,'N',46.485,84,30,34,'U',0,630
UNION ALL SELECT 'CYAV','YAV','WINNIPEG ST ANDREWS','WINNIPEG','CANADA',50,3,23,'N',50.0563888888889,97,1,57,'U',0,760
UNION ALL SELECT 'CYAW','YAW','SHEARWATER','HALIFAX','CANADA',44,38,23,'N',44.6397222222222,63,29,58,'U',0,167
UNION ALL SELECT 'CYAY','YAY','ST ANTHONY','ST. ANTHONY','CANADA',51,23,30,'N',51.3916666666667,56,5,4,'U',0,92
UNION ALL SELECT 'CYAZ','YAZ','TOFINO','TOFINO','CANADA',49,4,56,'N',49.0822222222222,125,46,21,'U',0,80
UNION ALL SELECT 'CYBB','YBB','KUGAARUK','PELLY BAY','CANADA',68,32,4,'N',68.5344444444444,89,48,29,'U',0,56
UNION ALL SELECT 'CYBC','YBC','BAIE COMEAU','BAIE COMEAU','CANADA',49,7,56,'N',49.1322222222222,68,12,26,'U',0,71
UNION ALL SELECT 'CYBG','YBG','BAGOTVILLE','BAGOTVILLE','CANADA',48,19,50,'N',48.3305555555556,70,59,47,'U',0,522
UNION ALL SELECT 'CYBK','YBK','BAKER LAKE','BAKER LAKE','CANADA',64,17,56,'N',64.2988888888889,96,4,40,'U',0,59
UNION ALL SELECT 'CYBL','YBL','CAMPBELL RIVER','CAMPBELL RIVER','CANADA',49,57,3,'N',49.9508333333333,125,16,15,'U',0,346
UNION ALL SELECT 'CYBR','YBR','BRANDON MUNI','BRANDON','CANADA',49,54,36,'N',49.91,99,57,7,'U',0,1343
UNION ALL SELECT 'CYBT','YBT','','BROCHET','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYCA','YRF','','CARTWRIGHT','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYCB','YCB','CAMBRIDGE BAY','CAMBRIDGE BAY','CANADA',69,6,29,'N',69.1080555555556,105,8,18,'U',0,90
UNION ALL SELECT 'CYCD','YCD','NANAIMO','NANAIMO','CANADA',49,3,8,'N',49.0522222222222,123,52,12,'U',0,93
UNION ALL SELECT 'CYCG','YCG','CASTLEGAR','CASTLEGAR','CANADA',49,17,47,'N',49.2963888888889,117,37,57,'U',0,1624
UNION ALL SELECT 'CYCH','YCH','MIRAMICHI','CHATHAM','CANADA',47,0,28,'N',47.0077777777778,65,26,57,'U',0,108
UNION ALL SELECT 'CYCL','YCL','CHARLO','CHARLO','CANADA',47,59,26,'N',47.9905555555556,66,19,53,'U',0,132
UNION ALL SELECT 'CYCO','YCO','KUGLUKTUK','COPPERMINE','CANADA',67,49,0,'N',67.8166666666667,115,8,38,'U',0,74
UNION ALL SELECT 'CYCS','YCS','','CHESTERFIELD INLET','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYCT','YCT','CORONATION','CORONATION','CANADA',52,4,30,'N',52.075,111,26,43,'U',0,2595
UNION ALL SELECT 'CYCV','YCV','','MONTREAL','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYCW','YCW','CHILLIWACK','CHILLIWACK','CANADA',49,9,10,'N',49.1527777777778,121,56,20,'U',0,32
UNION ALL SELECT 'CYCY','YCY','CLYDE RIVER','CLYDE RIVER','CANADA',70,29,10,'N',70.4861111111111,68,31,0,'U',0,87
UNION ALL SELECT 'CYCZ','YZS','FAIRMONT HOT SPRINGS','CORAL HARBOUR','CANADA',50,19,55,'N',50.3319444444444,115,52,25,'U',0,2658
UNION ALL SELECT 'CYDA','YDA','DAWSON','DAWSON','CANADA',64,2,35,'N',64.0430555555556,139,7,40,'U',0,1214
UNION ALL SELECT 'CYDB','YDB','BURWASH','BURWASH','CANADA',61,22,16,'N',61.3711111111111,139,2,26,'U',0,2647
UNION ALL SELECT 'CYDC','YDC','PRINCETON','PRINCETON','CANADA',49,28,3,'N',49.4675,120,30,43,'U',0,2298
UNION ALL SELECT 'CYDF','YDF','DEER LAKE','DEER LAKE','CANADA',49,12,39,'N',49.2108333333333,57,23,29,'U',0,72
UNION ALL SELECT 'CYDL','YDL','DEASE LAKE','DEASE LAKE','CANADA',58,25,20,'N',58.4222222222222,130,1,56,'U',0,2600
UNION ALL SELECT 'CYDN','YDN','DAUPHIN BARKER','DAUPHIN','CANADA',51,6,3,'N',51.1008333333333,100,3,9,'U',0,998
UNION ALL SELECT 'CYDQ','YDQ','DAWSON CREEK','DAWSON CREEK','CANADA',55,44,30,'N',55.7416666666667,120,10,55,'U',0,2148
UNION ALL SELECT 'CYED','YED','EDMONTON NAMAO','EDMONTON','CANADA',53,40,0,'N',53.6666666666667,113,28,0,'U',0,0
UNION ALL SELECT 'CYEG','YEG','EDMONTON INTERNATIONAL','EDMONTON','CANADA',53,18,35,'N',53.3097222222222,113,34,47,'U',0,2373
UNION ALL SELECT 'CYEK','YEK','ARVIAT','ESKIMO POINT','CANADA',61,5,39,'N',61.0941666666667,94,4,15,'U',0,32
UNION ALL SELECT 'CYEN','YEN','ESTEVAN','ESTEVAN','CANADA',49,12,37,'N',49.2102777777778,102,57,57,'U',0,1905
UNION ALL SELECT 'CYET','YET','EDSON','EDSON','CANADA',53,34,44,'N',53.5788888888889,116,27,54,'U',0,3041
UNION ALL SELECT 'CYEU','YEU','EUREKA','EUREKA','CANADA',79,59,41,'N',79.9947222222222,85,48,48,'U',0,256
UNION ALL SELECT 'CYEV','YEV','INUVIK MIKE ZUBKO','INUVIK','CANADA',68,18,15,'N',68.3041666666667,133,28,58,'U',0,224
UNION ALL SELECT 'CYFB','YFB','IQALUIT','IQALUIT','CANADA',63,45,23,'N',63.7563888888889,68,33,21,'U',0,110
UNION ALL SELECT 'CYFC','YFC','FREDERICTON','FREDERICTON','CANADA',45,52,10,'N',45.8694444444444,66,31,54,'U',0,68
UNION ALL SELECT 'CYFO','YFO','FLIN FLON','FLIN FLON','CANADA',54,40,41,'N',54.6780555555556,101,40,54,'U',0,997
UNION ALL SELECT 'CYFR','YFR','FORT RESOLUTION','FORT RESOLUTION','CANADA',61,10,51,'N',61.1808333333333,113,41,23,'U',0,526
UNION ALL SELECT 'CYFS','YFS','FORT SIMPSON','FORT SIMPSON','CANADA',61,45,37,'N',61.7602777777778,121,14,12,'U',0,555
UNION ALL SELECT 'CYGK','YGK','KINGSTON','KINGSTON','CANADA',44,13,31,'N',44.2252777777778,76,35,49,'U',0,305
UNION ALL SELECT 'CYGL','YGL','LA GRANDE RIVIERE','LA GRANDE RIVIERE','CANADA',53,37,31,'N',53.6252777777778,77,42,15,'U',0,639
UNION ALL SELECT 'CYGP','YGP','GASPE','GASPE','CANADA',48,46,31,'N',48.7752777777778,64,28,43,'U',0,108
UNION ALL SELECT 'CYGQ','YGQ','GERALDTON GREENSTONE REGIONAL','GERALDTON','CANADA',49,46,42,'N',49.7783333333333,86,56,22,'U',0,1144
UNION ALL SELECT 'CYGR','YGR','ILES DE LA MADELEINE','ILES DE LA MADELEINE','CANADA',47,25,29,'N',47.4247222222222,61,46,41,'U',0,34
UNION ALL SELECT 'CYGT','YGT','','IGLOOLIK','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYGW','YGW','KUUJJUARAPIK','KUUJJUARARAPIK','CANADA',55,17,0,'N',55.2833333333333,77,46,0,'U',0,65
UNION ALL SELECT 'CYGX','YGX','GILLAM','GILLAM','CANADA',56,21,0,'N',56.35,94,42,0,'U',0,470
UNION ALL SELECT 'CYGZ','YGZ','','GRISE FIORD','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYHB','YHB','HUDSON BAY','HUDSON BAY','CANADA',52,49,0,'N',52.8166666666667,102,18,41,'U',0,1175
UNION ALL SELECT 'CYHD','YHD','DRYDEN RGNL','DRYDEN','CANADA',49,49,54,'N',49.8316666666667,92,44,39,'U',0,1354
UNION ALL SELECT 'CYHI','YHI','HOLMAN','HOLMAN ISLAND','CANADA',70,45,47,'N',70.7630555555556,117,48,21,'U',0,117
UNION ALL SELECT 'CYHK','YHK','GJOA HAVEN','GJOA HAVEN','CANADA',68,38,8,'N',68.6355555555556,95,50,59,'U',0,152
UNION ALL SELECT 'CYHM','YHM','HAMILTON','HAMILTON','CANADA',43,10,23,'N',43.1730555555555,79,56,6,'U',0,780
UNION ALL SELECT 'CYHO','YHO','','HOPEDALE','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYHU','YHU','ST HUBERT','MONTREAL','CANADA',45,31,3,'N',45.5175,73,25,1,'U',0,90
UNION ALL SELECT 'CYHY','YHY','HAY RIVER','HAY RIVER','CANADA',60,50,23,'N',60.8397222222222,115,46,58,'U',0,543
UNION ALL SELECT 'CYHZ','YHZ','HALIFAX INTERNATIONAL','HALIFAX','CANADA',44,52,51,'N',44.8808333333333,63,30,31,'U',0,477
UNION ALL SELECT 'CYIB','YIB','ATIKOKAN MUNI','ATIKOKAN','CANADA',48,46,26,'N',48.7738888888889,91,38,19,'U',0,1408
UNION ALL SELECT 'CYIO','YIO','POND INLET','POND INLET','CANADA',72,41,0,'N',72.6833333333333,77,58,0,'U',0,181
UNION ALL SELECT 'CYIV','YIV','','ISLAND LAKE','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYJN','YJN','ST JEAN','ST. JEAN','CANADA',45,17,40,'N',45.2944444444444,73,16,52,'U',0,136
UNION ALL SELECT 'CYJT','YJT','STEPHENVILLE','STEPHENVILLE','CANADA',48,32,39,'N',48.5441666666667,58,33,0,'U',0,84
UNION ALL SELECT 'CYKA','YKA','KAMLOOPS','KAMLOOPS','CANADA',50,42,8,'N',50.7022222222222,120,26,31,'U',0,1133
UNION ALL SELECT 'CYKF','YKF','WATERLOO RGNL','WATERLOO','CANADA',43,27,32,'N',43.4588888888889,80,23,4,'U',0,1040
UNION ALL SELECT 'CYKL','YKL','SCHEFFERVILLE','SCHEFFERVILLE','CANADA',54,48,18,'N',54.805,66,48,19,'U',0,1709
UNION ALL SELECT 'CYKY','YKY','KINDERSLEY','KINDERSLEY','CANADA',51,31,3,'N',51.5175,109,10,51,'U',0,2277
UNION ALL SELECT 'CYKZ','YKZ','BUTTONVILLE MUNI','TORONTO','CANADA',43,51,44,'N',43.8622222222222,79,22,12,'U',0,650
UNION ALL SELECT 'CYLC','YLC','','LAKE HARBOUR','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYLD','YLD','CHAPLEAU','CHAPLEAU','CANADA',47,49,12,'N',47.82,83,20,47,'U',0,1465
UNION ALL SELECT 'CYLJ','YLJ','MEADOW LAKE','MEADOW LAKE','CANADA',54,7,31,'N',54.1252777777778,108,31,22,'U',0,1576
UNION ALL SELECT 'CYLL','YLL','LLOYDMINSTER','LLOYDMINSTER','CANADA',53,18,33,'N',53.3091666666667,110,4,21,'U',0,2194
UNION ALL SELECT 'CYLT','YLT','ALERT','ALERT','CANADA',82,31,4,'N',82.5177777777778,62,16,50,'U',0,100
UNION ALL SELECT 'CYLW','YLW','KELOWNA','KELOWNA','CANADA',49,57,22,'N',49.9561111111111,119,22,40,'U',0,1409
UNION ALL SELECT 'CYMA','YMA','MAYO','MAYO','CANADA',63,37,0,'N',63.6166666666667,135,52,0,'U',0,1653
UNION ALL SELECT 'CYMJ','YMJ','MOOSE JAW','MOOSE JAW','CANADA',50,19,49,'N',50.3302777777778,105,33,33,'U',0,1892
UNION ALL SELECT 'CYMM','YMM','FORT MCMURRAY','FORT MCMURRAY','CANADA',56,39,12,'N',56.6533333333333,111,13,19,'U',0,1211
UNION ALL SELECT 'CYMO','YMO','MOOSONEE','MOOSONEE','CANADA',51,17,28,'N',51.2911111111111,80,36,28,'U',0,30
UNION ALL SELECT 'CYMW','YMW','MANIWAKI','MANIWAKI','CANADA',46,16,28,'N',46.2744444444444,75,59,24,'U',0,659
UNION ALL SELECT 'CYMX','YMX','MONTREAL INTERNATIONAL MIRABEL','MONTREAL','CANADA',45,40,47,'N',45.6797222222222,74,2,19,'U',0,270
UNION ALL SELECT 'CYNA','YNA','NATASHQUAN','NATASHQUAN','CANADA',50,11,23,'N',50.1897222222222,61,47,21,'U',0,35
UNION ALL SELECT 'CYND','YND','GATINEAU','GATINEAU','CANADA',45,31,17,'N',45.5213888888889,75,33,51,'U',0,211
UNION ALL SELECT 'CYNM','YNM','MATAGAMI','MATAGAMI','CANADA',49,45,42,'N',49.7616666666667,77,48,10,'U',0,918
UNION ALL SELECT 'CYOC','YOC','OLD CROW','OLD CROW','CANADA',67,34,14,'N',67.5705555555556,139,50,21,'U',0,824
UNION ALL SELECT 'CYOD','YOD','COLD LAKE','COLD LAKE','CANADA',54,24,18,'N',54.405,110,16,46,'U',0,1775
UNION ALL SELECT 'CYOJ','YOJ','HIGH LEVEL','HIGH LEVEL','CANADA',58,37,17,'N',58.6213888888889,117,9,53,'U',0,1110
UNION ALL SELECT 'CYOW','YOW','OTTAWA MACDONALD CARTIER INTERNATIONAL','OTTAWA','CANADA',45,19,21,'N',45.3225,75,40,9,'U',0,374
UNION ALL SELECT 'CYPA','YPA','PRINCE ALBERT GLASS FIELD','PRINCE ALBERT','CANADA',53,12,51,'N',53.2141666666667,105,40,22,'U',0,1405
UNION ALL SELECT 'CYPE','YPE','PEACE RIVER','PEACE RIVER','CANADA',56,13,37,'N',56.2269444444444,117,26,50,'U',0,1873
UNION ALL SELECT 'CYPG','YPG','SOUTHPORT','PORTAGE-LA-PRAIRIE','CANADA',49,54,10,'N',49.9027777777778,98,16,29,'U',0,885
UNION ALL SELECT 'CYPH','YPH','','INUKJUAK','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYPL','YPL','PICKLE LAKE','PICKLE LAKE','CANADA',51,26,47,'N',51.4463888888889,90,12,51,'U',0,1267
UNION ALL SELECT 'CYPN','YPN','PORT MENIER','PORT MENIER','CANADA',49,50,11,'N',49.8363888888889,64,17,19,'U',0,167
UNION ALL SELECT 'CYPQ','YPQ','PETERBOROUGH','PETERBOROUGH','CANADA',44,13,48,'N',44.23,78,21,48,'U',0,628
UNION ALL SELECT 'CYPR','YPR','PRINCE RUPERT','PRINCE PUPERT','CANADA',54,17,10,'N',54.2861111111111,130,26,41,'U',0,116
UNION ALL SELECT 'CYPY','YPY','FORT CHIPEWYAN','FORT CHIPEWYAN','CANADA',58,46,2,'N',58.7672222222222,111,7,2,'U',0,761
UNION ALL SELECT 'CYQA','YQA','MUSKOKA','MUSKOKA','CANADA',44,58,29,'N',44.9747222222222,79,18,12,'U',0,925
UNION ALL SELECT 'CYQB','YQB','QUEBEC JEAN LESAGE INTERNATIONAL','QUEBEC','CANADA',46,47,18,'N',46.7883333333333,71,23,51,'U',0,244
UNION ALL SELECT 'CYQF','YQF','RED DEER REGIONAL','RED DEER INDUSTRIAL','CANADA',52,10,43,'N',52.1786111111111,113,53,35,'U',0,2968
UNION ALL SELECT 'CYQG','YQG','WINDSOR','WINDSOR','CANADA',42,16,32,'N',42.2755555555556,82,57,20,'U',0,622
UNION ALL SELECT 'CYQH','YQH','WATSON LAKE','WATSON LAKE','CANADA',60,7,4,'N',60.1177777777778,128,49,19,'U',0,2255
UNION ALL SELECT 'CYQK','YQK','KENORA','KENORA','CANADA',49,47,18,'N',49.7883333333333,94,21,47,'U',0,1332
UNION ALL SELECT 'CYQL','YQL','LETHBRIDGE','LETHBRIDGE','CANADA',49,37,49,'N',49.6302777777778,112,47,59,'U',0,3047
UNION ALL SELECT 'CYQM','YQM','GREATER MONCTON INTERNATIONAL','MONCTON','CANADA',46,6,44,'N',46.1122222222222,64,40,43,'U',0,232
UNION ALL SELECT 'CYQQ','YQQ','COMOX','COMOX','CANADA',49,42,39,'N',49.7108333333333,124,53,12,'U',0,84
UNION ALL SELECT 'CYQR','YQR','REGINA INTERNATIONAL','REGINA','CANADA',50,25,55,'N',50.4319444444444,104,39,57,'U',0,1894
UNION ALL SELECT 'CYQT','YQT','THUNDER BAY','THUNDER BAY','CANADA',48,22,19,'N',48.3719444444444,89,19,26,'U',0,653
UNION ALL SELECT 'CYQU','YQU','GRANDE PRAIRIE','GRANDE PRAIRIE','CANADA',55,10,47,'N',55.1797222222222,118,53,6,'U',0,2195
UNION ALL SELECT 'CYQV','YQV','YORKTON MUNI','YORKTON','CANADA',51,15,53,'N',51.2647222222222,102,27,42,'U',0,1635
UNION ALL SELECT 'CYQW','YQW','NORTH BATTLEFORD','NORTH BATTLEFORD','CANADA',52,46,9,'N',52.7691666666667,108,14,37,'U',0,1799
UNION ALL SELECT 'CYQX','YQX','GANDER INTERNATIONAL','GANDER','CANADA',48,56,13,'N',48.9369444444444,54,34,5,'U',0,496
UNION ALL SELECT 'CYQY','YQY','SYDNEY','SYDNEY','CANADA',46,9,41,'N',46.1613888888889,60,2,52,'U',0,203
UNION ALL SELECT 'CYQZ','YQZ','QUESNEL','QUESNEL','CANADA',53,1,34,'N',53.0261111111111,122,30,36,'U',0,1789
UNION ALL SELECT 'CYRB','YRB','RESOLUTE BAY','RESOLUTE','CANADA',74,43,1,'N',74.7169444444445,94,58,10,'U',0,215
UNION ALL SELECT 'CYRI','YRI','RIVIERE DU LOUP','RIVIERE DU LOUP','CANADA',47,45,52,'N',47.7644444444444,69,35,5,'U',0,427
UNION ALL SELECT 'CYRJ','YRJ','ROBERVAL','ROBERVAL','CANADA',48,31,12,'N',48.52,72,15,56,'U',0,586
UNION ALL SELECT 'CYRM','YRM','ROCKY MOUNTAIN HOUSE','ROCKY MOUNTAIN HOUSE','CANADA',52,25,47,'N',52.4297222222222,114,54,15,'U',0,3242
UNION ALL SELECT 'CYRT','YRT','RANKIN INLET','RANKIN INLET','CANADA',62,48,41,'N',62.8113888888889,92,6,57,'U',0,94
UNION ALL SELECT 'CYSB','YSB','SUDBURY','SUDBURY','CANADA',46,37,30,'N',46.625,80,47,56,'U',0,1140
UNION ALL SELECT 'CYSC','YSC','SHERBROOKE','SHERBROOKE','CANADA',45,26,17,'N',45.4380555555556,71,41,26,'U',0,792
UNION ALL SELECT 'CYSF','YSF','','STONY RAPIDS','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYSJ','YSJ','SAINT JOHN','ST. JOHN','CANADA',45,18,58,'N',45.3161111111111,65,53,25,'U',0,357
UNION ALL SELECT 'CYSK','YSK','','SANIKILUAQ','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYSM','YSM','FORT SMITH','FORT SMITH','CANADA',60,1,20,'N',60.0222222222222,111,57,37,'U',0,673
UNION ALL SELECT 'CYSR','YSR','NANISIVIK','NANISIVIK','CANADA',72,58,56,'N',72.9822222222222,84,36,49,'U',0,2106
UNION ALL SELECT 'CYSU','YSU','SUMMERSIDE','SUMMERSIDE','CANADA',46,26,34,'N',46.4427777777778,63,49,52,'U',0,56
UNION ALL SELECT 'CYSY','YSY','SACHS HARBOUR','SACHS HARBOUR','CANADA',71,59,38,'N',71.9938888888889,125,14,33,'U',0,281
UNION ALL SELECT 'CYTE','YTE','CAPE DORSET','CAPE DORSET','CANADA',64,13,48,'N',64.23,76,31,36,'U',0,164
UNION ALL SELECT 'CYTH','YTH','THOMPSON','THOMPSON','CANADA',55,48,4,'N',55.8011111111111,97,51,51,'U',0,729
UNION ALL SELECT 'CYTL','YTL','','BIG TROUT LAKE','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYTR','YTR','TRENTON','TRENTON','CANADA',44,7,8,'N',44.1188888888889,77,31,41,'U',0,283
UNION ALL SELECT 'CYTS','YTS','TIMMINS','TIMMINS','CANADA',48,34,11,'N',48.5697222222222,81,22,36,'U',0,967
UNION ALL SELECT 'CYTZ','YTZ','CITY CENTRE','TORONTO','CANADA',43,37,39,'N',43.6275,79,23,46,'U',0,251
UNION ALL SELECT 'CYUB','YUB','TUKTOYAKTUK','TUKTOYAKTUK','CANADA',69,26,0,'N',69.4333333333333,133,1,35,'U',0,15
UNION ALL SELECT 'CYUF','YUF','','PELLY BAY','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYUL','YUL','MONTREAL INTERNATIONAL DORVAL','MONTREAL','CANADA',45,28,5,'N',45.4680555555556,73,44,29,'U',0,117
UNION ALL SELECT 'CYUT','YUT','REPULSE BAY','REPULSE BAY','CANADA',66,31,17,'N',66.5213888888889,86,13,29,'U',0,80
UNION ALL SELECT 'CYUX','YUX','HALL BEACH','HALL BEACH','CANADA',68,46,34,'N',68.7761111111111,81,14,37,'U',0,27
UNION ALL SELECT 'CYUY','YUY','ROUYN NORANDA','ROUYN','CANADA',48,12,22,'N',48.2061111111111,78,50,8,'U',0,988
UNION ALL SELECT 'CYVC','YVC','LA RONGE','LA RONGE','CANADA',55,9,5,'N',55.1513888888889,105,15,43,'U',0,1242
UNION ALL SELECT 'CYVG','YVG','VERMILION','VERMILLION','CANADA',53,21,21,'N',53.3558333333333,110,49,26,'U',0,2025
UNION ALL SELECT 'CYVM','YVM','QIKIQTARJUAQ','BROUGHTON ISLAND','CANADA',67,32,45,'N',67.5458333333333,64,1,53,'U',0,21
UNION ALL SELECT 'CYVO','YVO','VAL D OR','VAL D''OR','CANADA',48,3,12,'N',48.0533333333333,77,46,58,'U',0,1107
UNION ALL SELECT 'CYVP','YVP','KUUJJUAQ','QUUJJUAQ','CANADA',58,5,46,'N',58.0961111111111,68,25,37,'U',0,129
UNION ALL SELECT 'CYVQ','YVQ','NORMAN WELLS','NORMAN WELLS','CANADA',65,16,57,'N',65.2825,126,48,1,'U',0,241
UNION ALL SELECT 'CYVR','YVR','VANCOUVER INTERNATIONAL','VANCOUVER','CANADA',49,11,42,'N',49.195,123,10,55,'W',0,14
UNION ALL SELECT 'CYVT','YVT','BUFFALO NARROWS','BUFFALO NARROWS','CANADA',55,50,31,'N',55.8419444444444,108,25,3,'U',0,1444
UNION ALL SELECT 'CYVV','YVV','WIARTON','WIARTON','CANADA',44,44,45,'N',44.7458333333333,81,6,26,'U',0,729
UNION ALL SELECT 'CYWA','YWA','PETAWAWA','PETAWAWA','CANADA',45,57,8,'N',45.9522222222222,77,19,9,'U',0,427
UNION ALL SELECT 'CYWG','YWG','WINNIPEG INTERNATIONAL','WINNIPEG','CANADA',49,54,36,'N',49.91,97,14,4,'U',0,783
UNION ALL SELECT 'CYWK','YWK','WABUSH','WABUSH','CANADA',52,55,19,'N',52.9219444444444,66,51,52,'U',0,1808
UNION ALL SELECT 'CYWL','YWL','WILLIAMS LAKE','WILLIAMS LAKE','CANADA',52,10,59,'N',52.1830555555556,122,3,15,'U',0,3085
UNION ALL SELECT 'CYWY','YWY','WRIGLEY','WRIGLEY','CANADA',63,12,34,'N',63.2094444444445,123,26,12,'U',0,493
UNION ALL SELECT 'CYXC','YXC','CRANBROOK','CRANBROOK','CANADA',49,36,37,'N',49.6102777777778,115,46,57,'U',0,3082
UNION ALL SELECT 'CYXD','YXD','EDMONTON CITY CENTRE','EDMONTON','CANADA',53,34,21,'N',53.5725,113,31,14,'U',0,2200
UNION ALL SELECT 'CYXE','YXE','SASKATOON J G DIEFENBAKER INTERNATIONAL','SASKATOON','CANADA',52,10,15,'N',52.1708333333333,106,41,59,'U',0,1653
UNION ALL SELECT 'CYXH','YXH','MEDICINE HAT','MEDICINE HAT','CANADA',50,1,8,'N',50.0188888888889,110,43,15,'U',0,2352
UNION ALL SELECT 'CYXJ','YXJ','FORT ST JOHN','FORT SAINT JOHN','CANADA',56,14,17,'N',56.2380555555556,120,44,25,'U',0,2280
UNION ALL SELECT 'CYXL','YXL','SIOUX LOOKOUT','SIOUX LOOKOUT','CANADA',50,6,52,'N',50.1144444444444,91,54,15,'U',0,1280
UNION ALL SELECT 'CYXN','YXN','','WHALE COVE','CANADA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'CYXP','YXP','PANGNIRTUNG','PANGNIRTUNG','CANADA',66,8,42,'N',66.145,65,42,49,'U',0,75
UNION ALL SELECT 'CYXR','YXR','TIMISKAMING RGNL','EARLTON','CANADA',47,41,42,'N',47.695,79,50,56,'U',0,798
UNION ALL SELECT 'CYXS','YXS','PRINCE GEORGE','PRINCE GEORGE','CANADA',53,53,22,'N',53.8894444444444,122,40,44,'U',0,2267
UNION ALL SELECT 'CYXT','YXT','TERRACE','TERRACE','CANADA',54,27,59,'N',54.4663888888889,128,34,39,'U',0,713
UNION ALL SELECT 'CYXU','YXU','LONDON','LONDON','CANADA',43,2,8,'N',43.0355555555556,81,9,14,'U',0,912
UNION ALL SELECT 'CYXX','YXX','ABBOTSFORD','ABBOTSFORD','CANADA',49,1,31,'N',49.0252777777778,122,21,48,'U',0,190
UNION ALL SELECT 'CYXY','YXY','WHITEHORSE INTERNATIONAL','WHITEHORSE','CANADA',60,42,34,'N',60.7094444444445,135,4,6,'U',0,2317
UNION ALL SELECT 'CYYB','YYB','NORTH BAY','NORTH BAY','CANADA',46,21,49,'N',46.3636111111111,79,25,22,'U',0,1215
UNION ALL SELECT 'CYYC','YYC','CALGARY INTERNATIONAL','CALGARY','CANADA',51,6,50,'N',51.1138888888889,114,1,13,'U',0,3557
UNION ALL SELECT 'CYYD','YYD','SMITHERS','SMITHERS','CANADA',54,49,29,'N',54.8247222222222,127,10,58,'U',0,1712
UNION ALL SELECT 'CYYE','YYE','FORT NELSON','FORT NELSON','CANADA',58,50,11,'N',58.8363888888889,122,35,49,'U',0,1253
UNION ALL SELECT 'CYYF','YYF','PENTICTON','PENTICTON','CANADA',49,27,46,'N',49.4627777777778,119,36,8,'U',0,1129
UNION ALL SELECT 'CYYG','YYG','CHARLOTTETOWN','CHARLOTTETOWN','CANADA',46,17,24,'N',46.29,63,7,16,'U',0,160
UNION ALL SELECT 'CYYH','YYH','TALOYOAK','SPENCE BAY','CANADA',69,32,48,'N',69.5466666666667,93,34,36,'U',0,92
UNION ALL SELECT 'CYYJ','YYJ','VICTORIA INTERNATIONAL','VICTORIA','CANADA',48,38,49,'N',48.6469444444444,123,25,33,'U',0,63
UNION ALL SELECT 'CYYL','YYL','LYNN LAKE','LYNN LAKE','CANADA',56,51,50,'N',56.8638888888889,101,4,34,'U',0,1170
UNION ALL SELECT 'CYYN','YYN','SWIFT CURRENT','SWIFT CURRENT','CANADA',50,17,31,'N',50.2919444444444,107,41,26,'U',0,2680
UNION ALL SELECT 'CYYQ','YYQ','CHURCHILL','CHURCHILL','CANADA',58,44,21,'N',58.7391666666667,94,3,54,'U',0,94
UNION ALL SELECT 'CYYR','YYR','GOOSE BAY','GOOSE BAY','CANADA',53,19,9,'N',53.3191666666667,60,25,33,'U',0,160
UNION ALL SELECT 'CYYT','YYT','ST JOHNS INTERNATIONAL','ST. JOHN''S','CANADA',47,37,7,'N',47.6186111111111,52,45,7,'U',0,461
UNION ALL SELECT 'CYYU','YYU','KAPUSKASING','KAPUSKASING','CANADA',49,24,50,'N',49.4138888888889,82,28,3,'U',0,743
UNION ALL SELECT 'CYYW','YYW','ARMSTRONG','ARMSTRONG','CANADA',50,17,25,'N',50.2902777777778,88,54,35,'U',0,1058
UNION ALL SELECT 'CYYY','YYY','MONT JOLI','MONT JOLI','CANADA',48,36,31,'N',48.6086111111111,68,12,29,'U',0,172
UNION ALL SELECT 'CYYZ','YYZ','LESTER B PEARSON INTERNATIONAL','TORONTO','CANADA',43,40,38,'N',43.6772222222222,79,37,50,'U',0,569
UNION ALL SELECT 'CYZD','YZD','DOWNSVIEW','TORONTO','CANADA',43,44,33,'N',43.7425,79,27,56,'U',0,652
UNION ALL SELECT 'CYZE','YZE','GORE BAY MANITOULIN','GORE BAY','CANADA',45,53,7,'N',45.8852777777778,82,34,4,'U',0,635
UNION ALL SELECT 'CYZF','YZF','YELLOWKNIFE','YELLOWKNIFE','CANADA',62,27,46,'N',62.4627777777778,114,26,25,'U',0,675
UNION ALL SELECT 'CYZH','YZH','SLAVE LAKE','SLAVE LAKE','CANADA',55,17,36,'N',55.2933333333333,114,46,42,'U',0,1912
UNION ALL SELECT 'CYZP','YZP','SANDSPIT','SANDSPIT','CANADA',53,15,15,'N',53.2541666666667,131,48,50,'U',0,21
UNION ALL SELECT 'CYZR','YZR','CHRIS HADFIELD','SARNIA','CANADA',42,59,58,'N',42.9994444444444,82,18,32,'U',0,594
UNION ALL SELECT 'CYZT','YZT','PORT HARDY','PORT HARDY','CANADA',50,40,50,'N',50.6805555555556,127,22,0,'U',0,71
UNION ALL SELECT 'CYZU','YZU','WHITECOURT','WHITECOURT','CANADA',54,8,38,'N',54.1438888888889,115,47,12,'U',0,2567
UNION ALL SELECT 'CYZV','YZV','SEPT ILES','SEPT-ILES','CANADA',50,13,24,'N',50.2233333333333,66,15,56,'U',0,180
UNION ALL SELECT 'CYZW','YZW','TESLIN','TESLIN','CANADA',60,10,22,'N',60.1727777777778,132,44,34,'U',0,2313
UNION ALL SELECT 'CYZX','YZX','GREENWOOD','GREENWOOD','CANADA',44,59,4,'N',44.9844444444444,64,55,1,'U',0,92
UNION ALL SELECT 'CZFA','ZFA','FARO','FARO','CANADA',62,12,27,'N',62.2075,133,22,33,'U',0,2351
UNION ALL SELECT 'CZFM','ZFM','FORT MCPHERSON','FORT MCPHERSON','CANADA',67,24,28,'N',67.4077777777778,134,51,37,'U',0,142
UNION ALL SELECT 'DAAE','BJA','SOUMMAM','BEJAJA','ALGERIA',36,42,43,'N',36.7119444444444,5,4,11,'E',5.06972222222222,20
UNION ALL SELECT 'DAAG','ALG','HOUARI BOUMEDIENE','ALGIER','ALGERIA',36,41,27,'N',36.6908333333333,3,12,55,'E',3.21527777777778,82
UNION ALL SELECT 'DAAJ','DJG','TISKA','DJANET','ALGERIA',24,17,33,'N',24.2925,9,27,8,'E',9.45222222222222,3176
UNION ALL SELECT 'DAAP','VVZ','ILLIZI','ILLIZI','ALGERIA',26,34,24,'N',26.5733333333333,8,29,1,'E',8.48361111111111,1778
UNION ALL SELECT 'DAAS','GSF','SETIF AIN ARNAT','SETIF','ALGERIA',36,10,41,'N',36.1780555555556,5,19,28,'E',5.32444444444444,3360
UNION ALL SELECT 'DAAT','TMR','TAMANRASSET','TAMANRASSET','ALGERIA',22,48,39,'N',22.8108333333333,5,27,3,'E',5.45083333333333,4518
UNION ALL SELECT 'DAAV','GJL','JIJEL','JIJEL','ALGERIA',36,47,42,'N',36.795,5,52,24,'E',5.87333333333333,33
UNION ALL SELECT 'DABB','AAE','ANNABA','ANNABA','ALGERIA',36,49,20,'N',36.8222222222222,7,48,33,'E',7.80916666666667,16
UNION ALL SELECT 'DABC','CZL','MOHAMED BOUDIAF INTERNATIONAL','CONSTANTINE','ALGERIA',36,16,36,'N',36.2766666666667,6,37,26,'E',6.62388888888889,2265
UNION ALL SELECT 'DABS','TEE','CHEIKH LARBI TEBESSI','TEBESSA','ALGERIA',35,25,53,'N',35.4313888888889,8,7,14,'E',8.12055555555556,2661
UNION ALL SELECT 'DAFH','HRM','HASSI R MEL','TILREMPT','ALGERIA',32,55,47,'N',32.9297222222222,3,18,44,'E',3.31222222222222,2540
UNION ALL SELECT 'DAOB','TID','BOU CHEKIF','TIARET','ALGERIA',35,20,28,'N',35.3411111111111,1,27,47,'E',1.46305555555556,3245
UNION ALL SELECT 'DAOC','CBH','','BECHAR','ALGERIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DAOF','TIN','TINDOUF','TINDOUF','ALGERIA',27,42,1,'N',27.7002777777778,8,10,1,'U',0,1453
UNION ALL SELECT 'DAOI','QAS','ECH CHELIFF','ECH-CHELIFF','ALGERIA',36,12,45,'N',36.2125,1,19,54,'E',1.33166666666667,463
UNION ALL SELECT 'DAOL','TAF','TAFARAOUI','ORAN','ALGERIA',35,32,32,'N',35.5422222222222,0,31,56,'U',0,367
UNION ALL SELECT 'DAON','TLM','ZENATA','TLEMCEN','ALGERIA',35,1,0,'N',35.0166666666667,1,27,0,'U',0,814
UNION ALL SELECT 'DAOO','ORN','ES SENIA','ORAN','ALGERIA',35,37,25,'N',35.6236111111111,0,37,16,'U',0,295
UNION ALL SELECT 'DAOV','MUW','GHRISS','GHRISS','ALGERIA',35,12,27,'N',35.2075,0,8,49,'E',0.146944444444444,1686
UNION ALL SELECT 'DATG','INF','','IN GUEZZAM','ALGERIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DATM','BMW','','BORDJ MOKHTAR','ALGERIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DAUA','AZR','TOUAT CHEIKH SIDI MOHAMED BELKEBIR','ADRAR','ALGERIA',27,50,15,'N',27.8375,0,11,11,'U',0,919
UNION ALL SELECT 'DAUB','BSK','BISKRA','BISKRA','ALGERIA',34,47,35,'N',34.7930555555556,5,44,17,'E',5.73805555555556,289
UNION ALL SELECT 'DAUE','ELG','EL GOLEA','EL GOLEA','ALGERIA',30,34,16,'N',30.5711111111111,2,51,34,'E',2.85944444444444,1306
UNION ALL SELECT 'DAUG','GHA','NOUMERATE','GHARDAIA','ALGERIA',32,23,2,'N',32.3838888888889,3,47,38,'E',3.79388888888889,1512
UNION ALL SELECT 'DAUH','HME','OUED IRARA','HASSI-MESSAOUD','ALGERIA',31,40,22,'N',31.6727777777778,6,8,25,'E',6.14027777777778,463
UNION ALL SELECT 'DAUI','INZ','IN SALAH','IN SALAH','ALGERIA',27,15,3,'N',27.2508333333333,2,30,43,'E',2.51194444444444,883
UNION ALL SELECT 'DAUK','TGR','SIDI MAHDI','TOUGGOURT','ALGERIA',33,4,4,'N',33.0677777777778,6,5,19,'E',6.08861111111111,279
UNION ALL SELECT 'DAUL','LOO','LAGHOUAT','LAGHOUAT','ALGERIA',33,45,50,'N',33.7638888888889,2,55,38,'E',2.92722222222222,2510
UNION ALL SELECT 'DAUT','TMX','TIMIMOUN','TIMIMOUN','ALGERIA',29,14,13,'N',29.2369444444444,0,16,33,'E',0.275833333333333,1027
UNION ALL SELECT 'DAUU','OGX','OUARGLA','OUARGLA','ALGERIA',31,55,2,'N',31.9172222222222,5,24,46,'E',5.41277777777778,492
UNION ALL SELECT 'DAUZ','IAM','IN AMENAS','ZARZAITINE','ALGERIA',28,3,5,'N',28.0513888888889,9,38,34,'E',9.64277777777778,1847
UNION ALL SELECT 'DBBB','COO','COTONOU CADJEHOUN','COTONOU','BENIN',6,21,26,'N',6.35722222222222,2,23,3,'E',2.38416666666667,19
UNION ALL SELECT 'DBBK','KDC','','KANDI','BENIN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DBBN','NAE','','NATITINGOU','BENIN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DBBP','PKO','PARAKOU','PARAKOU','BENIN',9,21,25,'N',9.35694444444444,2,36,32,'E',2.60888888888889,1266
UNION ALL SELECT 'DFCC','OUG','','OUAHIGOUYA','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DFEE','DOR','','DORI','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DFEF','FNG','','FADA N''GOURMA','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DFEG','XGG','','GOROM GOROM','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DFEL','XKA','','KANTCHARI','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DFET','TEG','','TENKODOGO','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DFFD','OUA','OUAGADOUGOU','OUAGADOUGOU','BURKINA FASO',12,21,11,'N',12.3530555555556,1,30,44,'U',0,1037
UNION ALL SELECT 'DFOB','BNR','','BANFORA','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DFOD','DGU','','DEDOUGOU','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DFOG','XGA','','AMILCAR CABRAL DE GAQUA','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DFON','XNU','','NOUNA','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DFOO','BOY','BOBO DIOULASSO','BOBO-DIOULASSO','BURKINA FASO',11,9,36,'N',11.16,4,19,51,'U',0,1511
UNION ALL SELECT 'DGAA','ACC','KOTOKA INTERNATIONAL','ACCRA','GHANA',5,36,10,'N',5.60277777777778,0,10,5,'U',0,205
UNION ALL SELECT 'DGCY','CKY','','CONAKRY','GHANA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DGLE','TML','TAMALE','TAMALE','GHANA',9,33,48,'N',9.56333333333333,0,51,48,'U',0,553
UNION ALL SELECT 'DGSN','NYI','SUNYANI','SUNYANI','GHANA',7,21,42,'N',7.36166666666667,2,19,43,'U',0,1014
UNION ALL SELECT 'DGTK','TKD','TAKORADI','TAKORADI','GHANA',4,53,36,'N',4.89333333333333,1,46,30,'U',0,21
UNION ALL SELECT 'DIAP','ABJ','ABIDJAN FELIX HOUPHOUET BOIGNY INTERNATIONAL','ABIDJAN','IVORY COAST',5,15,35,'N',5.25972222222222,3,55,35,'U',0,20
UNION ALL SELECT 'DIAU','OGO','','ABENGOUROU','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DIBI','BXI','','BOUNDIALI','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DIBK','BYK','BOUAKE','BOUAKE','IVORY COAST',7,44,19,'N',7.73861111111111,5,4,25,'U',0,1230
UNION ALL SELECT 'DIBN','BQO','','BUONA','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DIBU','BDK','','BONDOUKOU','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DIDK','DIM','','DIMBOKRO','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DIDL','DJO','DALOA','DALOA','IVORY COAST',6,47,33,'N',6.7925,6,28,23,'U',0,823
UNION ALL SELECT 'DIGA','GGN','','GAGNOA','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DIGL','GGO','','GUIGLO','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DIGN','BBV','','GRAND BEREBY','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DIKO','HGO','KORHOGO','KORHOGO','IVORY COAST',9,23,13,'N',9.38694444444444,5,33,23,'U',0,1213
UNION ALL SELECT 'DIMN','MJC','MAN','MAN','IVORY COAST',7,16,19,'N',7.27194444444444,7,35,13,'U',0,1089
UNION ALL SELECT 'DIOD','KEO','','ODIENNE','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DIOF','OFI','','OUANGO FITINI','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DISG','SEO','','SEGUELA','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DISP','SPY','SAN PEDRO','SAN PEDRO','IVORY COAST',4,44,48,'N',4.74666666666667,6,39,38,'U',0,26
UNION ALL SELECT 'DISS','ZSS','','SASSANDRA','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DITB','TXU','','TABOU','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DITM','TOZ','','TOUBA','IVORY COAST',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DIYO','ASK','YAMOUSSOUKRO','YAMOUSSOUKRO','IVORY COAST',6,54,11,'N',6.90305555555556,5,21,57,'U',0,699
UNION ALL SELECT 'DNAA','ABV','ABUJA NNAMDI AZIKIWE INTERNATIONAL','ABUJA','NIGERIA',9,0,24,'N',9.00666666666667,7,15,47,'E',7.26305555555556,1123
UNION ALL SELECT 'DNAK','AKR','AKURE','AKURE','NIGERIA',7,14,48,'N',7.24666666666667,5,18,3,'E',5.30083333333333,1100
UNION ALL SELECT 'DNBE','BNI','BENIN','BENIN','NIGERIA',6,19,2,'N',6.31722222222222,5,35,58,'E',5.59944444444444,258
UNION ALL SELECT 'DNCA','CBQ','CALABAR','CALABAR','NIGERIA',4,58,33,'N',4.97583333333333,8,20,49,'E',8.34694444444444,211
UNION ALL SELECT 'DNEN','ENU','ENUGU','ENUGU','NIGERIA',6,28,27,'N',6.47416666666667,7,33,43,'E',7.56194444444444,466
UNION ALL SELECT 'DNGU','QUS','GUSAU','GUSAU','NIGERIA',12,10,18,'N',12.1716666666667,6,41,46,'E',6.69611111111111,1520
UNION ALL SELECT 'DNIB','IBA','IBADAN','IBADAN','NIGERIA',7,21,44,'N',7.36222222222222,3,58,42,'E',3.97833333333333,725
UNION ALL SELECT 'DNIL','ILR','ILORIN','ILORIN','NIGERIA',8,26,24,'N',8.44,4,29,38,'E',4.49388888888889,1125
UNION ALL SELECT 'DNJO','JOS','JOS','JOS','NIGERIA',9,38,23,'N',9.63972222222222,8,52,8,'E',8.86888888888889,4232
UNION ALL SELECT 'DNKA','KAD','KADUNA','KADUNA','NIGERIA',10,41,45,'N',10.6958333333333,7,19,12,'E',7.32,2073
UNION ALL SELECT 'DNKN','KAN','KANO MALLAM AMINU INTERNATIONAL','KANO','NIGERIA',12,2,51,'N',12.0475,8,31,28,'E',8.52444444444444,1565
UNION ALL SELECT 'DNMA','MIU','MAIDUGURI','MAIDUGURI','NIGERIA',11,51,19,'N',11.8552777777778,13,4,51,'E',13.0808333333333,1102
UNION ALL SELECT 'DNMK','MDI','MAKURDI','MAKURDI','NIGERIA',7,42,13,'N',7.70361111111111,8,36,50,'E',8.61388888888889,371
UNION ALL SELECT 'DNMM','LOS','LAGOS MURTALA MUHAMMED','LAGOS','NIGERIA',6,34,38,'N',6.57722222222222,3,19,16,'E',3.32111111111111,135
UNION ALL SELECT 'DNMN','MXJ','MINNA NEW','MINNA','NIGERIA',9,39,7,'N',9.65194444444444,6,27,44,'E',6.46222222222222,834
UNION ALL SELECT 'DNPO','PHC','PORT HARCOURT INTERNATIONAL','PORT HARTCOURT','NIGERIA',5,0,55,'N',5.01527777777778,6,56,58,'E',6.94944444444444,81
UNION ALL SELECT 'DNSO','SKO','SADIQ ABUBAKAR III INTERNATIONAL','SOKOTO','NIGERIA',12,54,58,'N',12.9161111111111,5,12,25,'E',5.20694444444444,1006
UNION ALL SELECT 'DNYO','YOL','YOLA','YOLA','NIGERIA',9,15,37,'N',9.26027777777778,12,25,47,'E',12.4297222222222,599
UNION ALL SELECT 'DNZA','ZAR','ZARIA','ZARIA','NIGERIA',11,7,48,'N',11.13,7,41,8,'E',7.68555555555556,2150
UNION ALL SELECT 'DRRM','MFG','MARADI','MARADI','NIGER',13,30,9,'N',13.5025,7,7,36,'E',7.12666666666667,1240
UNION ALL SELECT 'DRRN','NIM','DIORI HAMANI','NIAMEY','NIGER',13,28,53,'N',13.4813888888889,2,11,1,'E',2.18361111111111,732
UNION ALL SELECT 'DRRT','THZ','TAHOUA','TAHOUA','NIGER',14,52,32,'N',14.8755555555556,5,15,55,'E',5.26527777777778,1266
UNION ALL SELECT 'DRZA','AJY','MANU DAYAK','AGADEZ','NIGER',16,57,53,'N',16.9647222222222,7,59,49,'E',7.99694444444444,1657
UNION ALL SELECT 'DRZR','ZND','ZINDER','ZINDER','NIGER',13,46,44,'N',13.7788888888889,8,59,1,'E',8.98361111111111,1509
UNION ALL SELECT 'DSGI','KMS','','KUMASI','GHANA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'DTMB','MIR','HABIB BOURGUIBA INTERNATIONAL','MONASTIR','TUNISIA',35,45,29,'N',35.7580555555556,10,45,17,'E',10.7547222222222,9
UNION ALL SELECT 'DTTA','TUN','CARTHAGE','TUNIS','TUNISIA',36,51,3,'N',36.8508333333333,10,13,37,'E',10.2269444444444,22
UNION ALL SELECT 'DTTF','GAF','GAFSA','GAFSA','TUNISIA',34,25,19,'N',34.4219444444444,8,49,21,'E',8.8225,1060
UNION ALL SELECT 'DTTG','GAE','GABES','GABES','TUNISIA',33,52,36,'N',33.8766666666667,10,6,12,'E',10.1033333333333,26
UNION ALL SELECT 'DTTJ','DJE','ZARZIS','DJERBA','TUNISIA',33,52,30,'N',33.875,10,46,31,'E',10.7752777777778,19
UNION ALL SELECT 'DTTR','EBM','EL BORMA','EL BORMA','TUNISIA',31,42,15,'N',31.7041666666667,9,15,16,'E',9.25444444444445,827
UNION ALL SELECT 'DTTX','SFA','THYNA','SFAX','TUNISIA',34,43,4,'N',34.7177777777778,10,41,27,'E',10.6908333333333,85
UNION ALL SELECT 'DTTZ','TOE','NEFTA','TOZEUR','TUNISIA',33,56,23,'N',33.9397222222222,8,6,38,'E',8.11055555555556,287
UNION ALL SELECT 'DXNG','LRL','NIAMTOUGOU','NIATOUGOU','TOGO',9,46,2,'N',9.76722222222222,1,5,28,'E',1.09111111111111,1515
UNION ALL SELECT 'DXXX','LFW','LOME TOKOIN','LOME','TOGO',6,9,56,'N',6.16555555555556,1,15,14,'E',1.25388888888889,71
UNION ALL SELECT 'EBAW','ANR','DEURNE','ANTWERP','BELGIUM',51,11,24,'N',51.19,4,27,46,'E',4.46277777777778,39
UNION ALL SELECT 'EBBR','BRU','BRUSSELS NATL','BRUSSELS','BELGIUM',50,54,8,'N',50.9022222222222,4,29,55,'E',4.49861111111111,184
UNION ALL SELECT 'EBCI','CRL','BRUSSELS SOUTH','CHARLEROI','BELGIUM',50,27,33,'N',50.4591666666667,4,27,13,'E',4.45361111111111,614
UNION ALL SELECT 'EBKT','QKT','WEVELGEM','KORTRIJK-VEVELGEM','BELGIUM',50,49,4,'N',50.8177777777778,3,12,30,'E',3.20833333333333,62
UNION ALL SELECT 'EBLG','LGG','LIEGE','LIEGE','BELGIUM',50,38,14,'N',50.6372222222222,5,26,35,'E',5.44305555555556,659
UNION ALL SELECT 'EBOS','OST','OOSTENDE','OSTEND','BELGIUM',51,11,56,'N',51.1988888888889,2,51,44,'E',2.86222222222222,13
UNION ALL SELECT 'EDAB','BBJ','BAUTZEN','BAUTZEN','GERMANY',51,11,36,'N',51.1933333333333,14,31,11,'E',14.5197222222222,568
UNION ALL SELECT 'EDAC','AOC','ALTENBURG NOBITZ','ALTENBURG','GERMANY',50,58,54,'N',50.9816666666667,12,30,22,'E',12.5061111111111,640
UNION ALL SELECT 'EDBG','GWW','GOLDSBORO WAYNE MUNI','GOTHA OST','GERMANY',35,27,38,'N',35.4605555555556,77,57,53,'U',0,134
UNION ALL SELECT 'EDDB','SXF','SCHONEFELD','BERLIN','GERMANY',52,22,48,'N',52.38,13,31,21,'E',13.5225,157
UNION ALL SELECT 'EDDC','DRS','DRESDEN','DRESDEN','GERMANY',51,7,57,'N',51.1325,13,46,1,'E',13.7669444444444,755
UNION ALL SELECT 'EDDE','ERF','ERFURT','ERFURT','GERMANY',50,58,48,'N',50.98,10,57,29,'E',10.9580555555556,1034
UNION ALL SELECT 'EDDF','FRA','FRANKFURT MAIN','FRANKFURT','GERMANY',50,1,35,'N',50.0263888888889,8,32,35,'E',8.54305555555556,364
UNION ALL SELECT 'EDDG','FMO','MUNSTER OSNABRUCK','MUENSTER/OSNABRUECK','GERMANY',52,8,4,'N',52.1344444444444,7,41,5,'E',7.68472222222222,159
UNION ALL SELECT 'EDDH','HAM','HAMBURG','HAMBURG','GERMANY',53,37,49,'N',53.6302777777778,9,59,17,'E',9.98805555555555,53
UNION ALL SELECT 'EDDI','THF','TEMPELHOF','BERLIN','GERMANY',52,28,22,'N',52.4727777777778,13,24,14,'E',13.4038888888889,163
UNION ALL SELECT 'EDDK','CGN','KOLN BONN','COLOGNE','GERMANY',50,51,57,'N',50.8658333333333,7,8,33,'E',7.1425,302
UNION ALL SELECT 'EDDL','DUS','DUSSELDORF','DUESSELDORF','GERMANY',51,17,22,'N',51.2894444444444,6,46,0,'E',6.76666666666667,147
UNION ALL SELECT 'EDDM','MUC','MUNICH','MUNICH','GERMANY',48,21,13,'N',48.3536111111111,11,47,9,'E',11.7858333333333,1487
UNION ALL SELECT 'EDDN','NUE','NURNBERG','NUERNBERG','GERMANY',49,29,55,'N',49.4986111111111,11,4,41,'E',11.0780555555556,1046
UNION ALL SELECT 'EDDP','LEJ','LEIPZIG HALLE','LEIPZIG','GERMANY',51,25,26,'N',51.4238888888889,12,14,10,'E',12.2361111111111,465
UNION ALL SELECT 'EDDR','SCN','SAARBRUCKEN','SAARBRUECKEN','GERMANY',49,12,52,'N',49.2144444444444,7,6,34,'E',7.10944444444444,1057
UNION ALL SELECT 'EDDS','STR','STUTTGART','STUTTGART','GERMANY',48,41,23,'N',48.6897222222222,9,13,19,'E',9.22194444444444,1276
UNION ALL SELECT 'EDDT','TXL','TEGEL','BERLIN','GERMANY',52,33,34,'N',52.5594444444444,13,17,15,'E',13.2875,122
UNION ALL SELECT 'EDDV','HAJ','HANNOVER','HANNOVER','GERMANY',52,27,39,'N',52.4608333333333,9,41,6,'E',9.685,183
UNION ALL SELECT 'EDDW','BRE','BREMEN','BREMEN','GERMANY',53,2,51,'N',53.0475,8,47,12,'E',8.78666666666667,14
UNION ALL SELECT 'EDFH','HHN','FRANKFURT HAHN','HAHN','GERMANY',49,56,59,'N',49.9497222222222,7,15,50,'E',7.26388888888889,1649
UNION ALL SELECT 'EDFM','MHG','MANNHEIM CITY','MANNHEIM','GERMANY',49,28,21,'N',49.4725,8,30,49,'E',8.51361111111111,309
UNION ALL SELECT 'EDHI','XFW','HAMBURG FINKENWERDER','HAMBURG','GERMANY',53,32,7,'N',53.5352777777778,9,50,7,'E',9.83527777777778,18
UNION ALL SELECT 'EDHK','KEL','KIEL HOLTENAU','KIEL','GERMANY',54,22,46,'N',54.3794444444444,10,8,42,'E',10.145,101
UNION ALL SELECT 'EDHL','LBC','LUBECK BLANKENSEE','LUEBECK','GERMANY',53,48,19,'N',53.8052777777778,10,43,9,'E',10.7191666666667,54
UNION ALL SELECT 'EDKA','AAH','AACHEN MERZBRUCK','AACHEN','GERMANY',50,49,22,'N',50.8227777777778,6,11,14,'E',6.18722222222222,623
UNION ALL SELECT 'EDLA','ZCA','ARNSBERG MENDEN','ARNSBERG','GERMANY',51,29,0,'N',51.4833333333333,7,53,57,'E',7.89916666666667,794
UNION ALL SELECT 'EDLE','ESS','ESSEN MULHEIM','ESSEN','GERMANY',51,24,5,'N',51.4013888888889,6,56,9,'E',6.93583333333333,424
UNION ALL SELECT 'EDLN','MGL','MONCHENGLADBACH','MOENCHENGLADBACH','GERMANY',51,13,49,'N',51.2302777777778,6,30,16,'E',6.50444444444444,125
UNION ALL SELECT 'EDLP','PAD','PADERBORN LIPPSTADT','PADERBORN','GERMANY',51,36,51,'N',51.6141666666667,8,36,58,'E',8.61611111111111,699
UNION ALL SELECT 'EDLW','DTM','DORTMUND','DORTMUND','GERMANY',51,31,5,'N',51.5180555555556,7,36,44,'E',7.61222222222222,424
UNION ALL SELECT 'EDMA','AGB','AUGSBURG','AUGSBURG','GERMANY',48,25,30,'N',48.425,10,55,54,'E',10.9316666666667,1515
UNION ALL SELECT 'EDMO','OBF','OBERPFAFFENHOFEN','OBERPFAFFENHOFEN','GERMANY',48,4,53,'N',48.0813888888889,11,17,0,'E',11.2833333333333,1947
UNION ALL SELECT 'EDNY','FDH','FRIEDRICHSHAFEN','FRIEDRICHSHAFEN','GERMANY',47,40,16,'N',47.6711111111111,9,30,41,'E',9.51138888888889,1367
UNION ALL SELECT 'EDOP','SZW','SCHWERIN PARCHIM','PARCHIM','GERMANY',53,25,37,'N',53.4269444444444,11,47,0,'E',11.7833333333333,166
UNION ALL SELECT 'EDQD','BYU','BAYREUTH','BAYREUTH','GERMANY',49,59,3,'N',49.9841666666667,11,38,18,'E',11.6383333333333,1601
UNION ALL SELECT 'EDQM','HOQ','HOF PLAUEN','HOF','GERMANY',50,17,19,'N',50.2886111111111,11,51,17,'E',11.8547222222222,1958
UNION ALL SELECT 'EDRK','ZNV','KOBLENZ WINNINGEN','KOBLENZ','GERMANY',50,19,29,'N',50.3247222222222,7,31,51,'E',7.53083333333333,640
UNION ALL SELECT 'EDRT','ZQF','TRIER FOHREN','TRIER','GERMANY',49,51,48,'N',49.8633333333333,6,47,20,'E',6.78888888888889,665
UNION ALL SELECT 'EDRY','ZQC','SPEYER','SPEYER','GERMANY',49,18,9,'N',49.3025,8,27,4,'E',8.45111111111111,312
UNION ALL SELECT 'EDTB','ZCC','BADEN OOS','BADEN-BADEN','GERMANY',48,47,28,'N',48.7911111111111,8,11,13,'E',8.18694444444444,405
UNION ALL SELECT 'EDTD','ZQL','DONAUESCHINGEN VILLINGEN','DONAUESCHINGEN','GERMANY',47,58,23,'N',47.9730555555556,8,31,20,'E',8.52222222222222,2231
UNION ALL SELECT 'EDVE','BWE','BRAUNSCHWEIG','BRAUNSCHWEIG','GERMANY',52,19,9,'N',52.3191666666667,10,33,22,'E',10.5561111111111,296
UNION ALL SELECT 'EDVK','KSF','KASSEL CALDEN','KASSEL','GERMANY',51,24,30,'N',51.4083333333333,9,22,39,'E',9.3775,908
UNION ALL SELECT 'EDWB','BRV','BREMERHAVEN','BREMERHAVEN','GERMANY',53,30,12,'N',53.5033333333333,8,34,24,'E',8.57333333333333,10
UNION ALL SELECT 'EDWD','LEM','LEMWERDER','LEMWERDER','GERMANY',53,8,35,'N',53.1430555555556,8,37,24,'E',8.62333333333333,20
UNION ALL SELECT 'EDWE','EME','EMDEN','EMDEN','GERMANY',53,23,28,'N',53.3911111111111,7,13,38,'E',7.22722222222222,2
UNION ALL SELECT 'EDWG','AGE','','WANGEROOGE','GERMANY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EDWI','WVN','WILHELMSHAVEN MARIENSIEL','WILHELMSHAVEN','GERMANY',53,30,17,'N',53.5047222222222,8,3,12,'E',8.05333333333333,16
UNION ALL SELECT 'EDWJ','JUI','','JUIST','GERMANY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EDWR','BMK','BORKUM','BORKUM','GERMANY',53,35,43,'N',53.5952777777778,6,42,33,'E',6.70916666666667,3
UNION ALL SELECT 'EDWY','NRD','NORDERNEY','NORDERNEY','GERMANY',53,42,24,'N',53.7066666666667,7,13,48,'E',7.23,6
UNION ALL SELECT 'EDXB','HEI','','HEIDE-BUESUM','GERMANY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EDXH','HGL','','HELGOLAND','GERMANY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EDXW','GWT','WESTERLAND SYLT','WESTERLAND','GERMANY',54,54,47,'N',54.9130555555556,8,20,25,'E',8.34027777777778,51
UNION ALL SELECT 'EDXY','OHR','','WYK','GERMANY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EETN','TLL','TALLINN','TALLINN-ULEMISTE INTERNATIONAL','ESTONIA',59,24,47,'N',59.4130555555556,24,49,58,'E',24.8327777777778,132
UNION ALL SELECT 'EFET','ENF','ENONTEKIO','ENONTEKIO','FINLAND',68,21,45,'N',68.3625,23,25,27,'E',23.4241666666667,1005
UNION ALL SELECT 'EFHA','KEV','HALLI','HALLI','FINLAND',61,51,21,'N',61.8558333333333,24,47,11,'E',24.7863888888889,479
UNION ALL SELECT 'EFHF','HEM','HELSINKI MALMI','HELSINKI','FINLAND',60,15,16,'N',60.2544444444444,25,2,34,'E',25.0427777777778,57
UNION ALL SELECT 'EFHK','HEL','HELSINKI VANTAA','HELSINKI','FINLAND',60,19,12,'N',60.32,24,57,22,'E',24.9561111111111,179
UNION ALL SELECT 'EFIV','IVL','IVALO','IVALO','FINLAND',68,36,26,'N',68.6072222222222,27,24,19,'E',27.4052777777778,481
UNION ALL SELECT 'EFJO','JOE','JOENSUU','JOENSUU','FINLAND',62,39,32,'N',62.6588888888889,29,37,28,'E',29.6244444444444,398
UNION ALL SELECT 'EFJY','JYV','JYVASKYLA','JYVASKYLA','FINLAND',62,23,58,'N',62.3994444444444,25,40,41,'E',25.6780555555556,459
UNION ALL SELECT 'EFKA','KAU','KAUHAVA','KAUHAVA','FINLAND',63,7,37,'N',63.1269444444444,23,3,5,'E',23.0513888888889,151
UNION ALL SELECT 'EFKE','KEM','KEMI TORNIO','KEMI','FINLAND',65,46,54,'N',65.7816666666667,24,35,56,'E',24.5988888888889,61
UNION ALL SELECT 'EFKI','KAJ','KAJAANI','KAJAANI','FINLAND',64,17,7,'N',64.2852777777778,27,41,32,'E',27.6922222222222,483
UNION ALL SELECT 'EFKK','KOK','KRUUNUPYY','KRUUNUPYY','FINLAND',63,43,16,'N',63.7211111111111,23,8,35,'E',23.1430555555556,83
UNION ALL SELECT 'EFKS','KAO','KUUSAMO','KUUSAMO','FINLAND',65,59,15,'N',65.9875,29,14,21,'E',29.2391666666667,866
UNION ALL SELECT 'EFKT','KTT','KITTILA','KITTILA','FINLAND',67,42,3,'N',67.7008333333333,24,50,48,'E',24.8466666666667,644
UNION ALL SELECT 'EFKU','KUO','KUOPIO','KUOPIO','FINLAND',63,0,25,'N',63.0069444444444,27,47,51,'E',27.7975,323
UNION ALL SELECT 'EFLP','LPP','LAPPEENRANTA','LAPPEENRANTA','FINLAND',61,2,40,'N',61.0444444444444,28,8,39,'E',28.1441666666667,349
UNION ALL SELECT 'EFMA','MHQ','MARIEHAMN','MARIEHAMN','FINLAND',60,7,19,'N',60.1219444444444,19,53,53,'E',19.8980555555556,17
UNION ALL SELECT 'EFMI','MIK','MIKKELI','MIKKELI','FINLAND',61,41,11,'N',61.6863888888889,27,12,6,'E',27.2016666666667,329
UNION ALL SELECT 'EFOU','OUL','OULU','OULU','FINLAND',64,55,48,'N',64.93,25,21,16,'E',25.3544444444444,47
UNION ALL SELECT 'EFPO','POR','PORI','PORI','FINLAND',61,27,42,'N',61.4616666666667,21,47,59,'E',21.7997222222222,44
UNION ALL SELECT 'EFRO','RVN','ROVANIEMI','ROVANIEMI','FINLAND',66,33,53,'N',66.5647222222222,25,49,49,'E',25.8302777777778,645
UNION ALL SELECT 'EFSA','SVL','SAVONLINNA','SAVONLINNA','FINLAND',61,56,35,'N',61.9430555555556,28,56,42,'E',28.945,311
UNION ALL SELECT 'EFSO','SOT','SODANKYLA','SODANKYLA','FINLAND',67,23,42,'N',67.395,26,37,8,'E',26.6188888888889,602
UNION ALL SELECT 'EFTP','TMP','TAMPERE PIRKKALA','TAMPERE','FINLAND',61,24,50,'N',61.4138888888889,23,36,15,'E',23.6041666666667,390
UNION ALL SELECT 'EFTU','TKU','TURKU','TURKU','FINLAND',60,30,50,'N',60.5138888888889,22,15,46,'E',22.2627777777778,161
UNION ALL SELECT 'EFUT','QVY','UTTI','UTTI','FINLAND',60,53,47,'N',60.8963888888889,26,56,18,'E',26.9383333333333,339
UNION ALL SELECT 'EFVA','VAA','VAASA','VAASA','FINLAND',63,3,4,'N',63.0511111111111,21,45,41,'E',21.7613888888889,19
UNION ALL SELECT 'EFVR','VRK','VARKAUS','VARKAUS','FINLAND',62,10,16,'N',62.1711111111111,27,52,7,'E',27.8686111111111,286
UNION ALL SELECT 'EGAA','BFS','ALDERGROVE','BELFAST','NORTH IRELAND',54,39,27,'N',54.6575,6,12,57,'U',0,268
UNION ALL SELECT 'EGAB','ENK','ST ANGELO','ENNISKILLEN','ENGLAND',54,23,56,'N',54.3988888888889,7,39,6,'U',0,155
UNION ALL SELECT 'EGAC','BHD','CITY','BELFAST','NORTH IRELAND',54,37,5,'N',54.6180555555556,5,52,21,'U',0,15
UNION ALL SELECT 'EGAE','LDY','LONDONDERRY EGLINTON','LONDONDERRY','NORTH IRELAND',55,2,34,'N',55.0427777777778,7,9,40,'U',0,22
UNION ALL SELECT 'EGBB','BHX','BIRMINGHAM','BIRMINGHAM','ENGLAND',52,27,13,'N',52.4536111111111,1,44,52,'U',0,325
UNION ALL SELECT 'EGBE','CVT','COVENTRY','COVENTRY','ENGLAND',52,22,11,'N',52.3697222222222,1,28,47,'U',0,281
UNION ALL SELECT 'EGBJ','GLO','GLOUCESTERSHIRE','GOLOUCHESTERSHIRE','ENGLAND',51,53,39,'N',51.8941666666667,2,10,2,'U',0,95
UNION ALL SELECT 'EGCC','MAN','MANCHESTER','MANCHESTER','ENGLAND',53,21,13,'N',53.3536111111111,2,16,29,'U',0,257
UNION ALL SELECT 'EGDG','NQY','ST MAWGAN','NEWQUAI','ENGLAND',50,26,26,'N',50.4405555555556,4,59,43,'U',0,390
UNION ALL SELECT 'EGDL','LYE','LYNEHAM','LYNEHAM','U.K.',51,30,18,'N',51.505,1,59,36,'U',0,513
UNION ALL SELECT 'EGDY','YEO','YEOVILTON','YEOVILTON','U.K.',51,0,33,'N',51.0091666666667,2,38,19,'U',0,75
UNION ALL SELECT 'EGFF','CWL','CARDIFF','CARDIFF','WALES',51,23,48,'N',51.3966666666667,3,20,36,'U',0,220
UNION ALL SELECT 'EGFH','SWS','SWANSEA','SWANSEA','ENGLAND',51,36,19,'N',51.6052777777778,4,4,4,'U',0,299
UNION ALL SELECT 'EGGD','BRS','BRISTOL','BRISTOL','ENGLAND',51,22,57,'N',51.3825,2,43,8,'U',0,622
UNION ALL SELECT 'EGGL','LHR','','LONDON','ENGLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EGGP','LPL','LIVERPOOL','LIVERPOOL','ENGLAND',53,20,1,'N',53.3336111111111,2,50,59,'U',0,81
UNION ALL SELECT 'EGGW','LTN','LUTON','LONDON','ENGLAND',51,52,28,'N',51.8744444444444,0,22,6,'U',0,526
UNION ALL SELECT 'EGHD','PLH','PLYMOUTH','PLYMOUTH','ENGLAND',50,25,22,'N',50.4227777777778,4,6,21,'U',0,485
UNION ALL SELECT 'EGHE','ISC','','ISLES OF SCILLY','ENGLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EGHH','BOH','BOURNEMOUTH','BOURNEMOUTH','ENGLAND',50,46,48,'N',50.78,1,50,33,'U',0,38
UNION ALL SELECT 'EGHI','SOU','SOUTHAMPTON','SOUTHAMPTON','ENGLAND',50,57,0,'N',50.95,1,21,24,'U',0,44
UNION ALL SELECT 'EGHK','PZE','','PENZANCE','ENGLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EGHL','QLA','LASHAM','LASHAM','ENGLAND',51,11,6,'N',51.185,1,1,56,'U',0,618
UNION ALL SELECT 'EGJA','ACI','','ALDERNEY','ENGLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EGJB','GCI','GUERNSEY','GUERNSEY','GUERNSEY ISLD.',49,26,5,'N',49.4347222222222,2,36,7,'U',0,336
UNION ALL SELECT 'EGJJ','JER','JERSEY','JERSEY','ENGLAND',49,12,28,'N',49.2077777777778,2,11,43,'U',0,274
UNION ALL SELECT 'EGKA','ESH','SHOREHAM','SHOREHAM BY SEA','ENGLAND',50,50,8,'N',50.8355555555556,0,17,50,'U',0,7
UNION ALL SELECT 'EGKB','BQH','BIGGIN HILL','BIGGIN HILL','ENGLAND',51,19,51,'N',51.3308333333333,0,1,57,'E',0.0325,600
UNION ALL SELECT 'EGKK','LGW','GATWICK','LONDON','ENGLAND',51,8,53,'N',51.1480555555556,0,11,25,'U',0,196
) x (ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LatDec],[LongDeg],[LongMin],[LongSec],[LongDir],[LongDec],[Altitude])
LEFT OUTER JOIN Airports a ON a.IATA_Code = x.IATA_Code
--WHERE x.[LatDir] <> 'U' and x.[LongDir] <> 'U' and x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE n=1
GO

INSERT INTO Airports (ICAO_Code, IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir
    ,LongDeg, LongMin, LongSec, LongDir, Altitude)
SELECT ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LongDeg],[LongMin],[LongSec],[LongDir],[Altitude]
FROM (
SELECT x.ICAO_Code,x.IATA_Code,x.[Name],x.[City],x.[Country],x.[LatDeg],x.[LatMin],x.[LatSec],x.[LatDir]
	,x.[LatDec],x.[LongDeg],x.[LongMin],x.[LongSec],x.[LongDir],x.[LongDec],x.[Altitude]
    ,n=ROW_NUMBER() OVER (PARTITION BY x.IATA_Code ORDER BY (SELECT NULL))
FROM (
SELECT 'EGLC','LCY','CITY','LONDON','ENGLAND',51,30,18,'N',51.505,0,3,15,'E',0.0541666666666667,19
UNION ALL SELECT 'EGLF','FAB','FARNBOROUGH','FARNBOROUGH','ENGLAND',51,16,33,'N',51.2758333333333,0,46,34,'U',0,238
UNION ALL SELECT 'EGLK','BBS','BLACKBUSHE','BLACKBUSHE','ENGLAND',51,19,26,'N',51.3238888888889,0,50,51,'U',0,325
UNION ALL SELECT 'EGLL','LHR','HEATHROW','LONDON','ENGALND',51,28,39,'N',51.4775,0,27,41,'U',0,80
UNION ALL SELECT 'EGMC','SEN','SOUTHEND','SOUTHEND','ENGLAND',51,34,17,'N',51.5713888888889,0,41,44,'E',0.695555555555556,49
UNION ALL SELECT 'EGMD','LYX','LYDD','LYDD','U.K.',50,57,22,'N',50.9561111111111,0,56,21,'E',0.939166666666667,12
UNION ALL SELECT 'EGMH','MSE','MANSTON','MANSTON','ENGLAND',51,20,32,'N',51.3422222222222,1,20,46,'E',1.34611111111111,178
UNION ALL SELECT 'EGNC','CAX','CARLISLE','CARLISLE','ENGLAND',54,56,15,'N',54.9375,2,48,33,'U',0,190
UNION ALL SELECT 'EGNH','BLK','BLACKPOOL','BLACKPOOL','ENGLAND',53,46,18,'N',53.7716666666667,3,1,43,'U',0,34
UNION ALL SELECT 'EGNJ','HUY','HUMBERSIDE','HUMBERSIDE','ENGLAND',53,34,28,'N',53.5744444444444,0,21,3,'U',0,121
UNION ALL SELECT 'EGNL','BWF','WALNEY ISLAND','BARROW ISLAND','ENGLAND',54,7,47,'N',54.1297222222222,3,15,22,'U',0,47
UNION ALL SELECT 'EGNM','LBA','LEEDS BRADFORD','LEEDS','ENGLAND',53,51,57,'N',53.8658333333333,1,39,38,'U',0,682
UNION ALL SELECT 'EGNR','CEG','HAWARDEN','HAWARDEN','ENGLAND',53,10,41,'N',53.1780555555556,2,58,40,'U',0,35
UNION ALL SELECT 'EGNS','IOM','ISLE OF MAN','ISLE OF MAN','ENGLAND',54,5,0,'N',54.0833333333333,4,37,26,'U',0,55
UNION ALL SELECT 'EGNT','NCL','NEWCASTLE','NEWCASTLE','ENGLAND',55,2,15,'N',55.0375,1,41,30,'U',0,266
UNION ALL SELECT 'EGNV','MME','TEESSIDE','TEESSIDE','ENGLAND',54,30,33,'N',54.5091666666667,1,25,45,'U',0,120
UNION ALL SELECT 'EGNX','EMA','EAST MIDLANDS','EAST MIDLANDS','ENGLAND',52,49,52,'N',52.8311111111111,1,19,41,'U',0,306
UNION ALL SELECT 'EGPA','KOI','KIRKWALL','KIRKWALL','SCOTLAND',58,57,29,'N',58.9580555555556,2,54,18,'U',0,51
UNION ALL SELECT 'EGPB','LSI','SUMBURGH','SUMBURGH','U.K.',59,52,44,'N',59.8788888888889,1,17,44,'U',0,20
UNION ALL SELECT 'EGPC','WIC','WICK','WICK','U.K.',58,27,31,'N',58.4586111111111,3,5,34,'U',0,126
UNION ALL SELECT 'EGPD','ABZ','DYCE','ABERDEEN','U.K',57,12,15,'N',57.2041666666667,2,12,1,'U',0,215
UNION ALL SELECT 'EGPE','INV','INVERNESS','INVERNESS','U.K',57,32,24,'N',57.54,4,3,0,'U',0,31
UNION ALL SELECT 'EGPF','GLA','GLASGOW','GLASGOW','U.K',55,52,19,'N',55.8719444444444,4,25,59,'U',0,26
UNION ALL SELECT 'EGPH','EDI','EDINBURGH','EDINBURGH','U.K',55,57,0,'N',55.95,3,22,21,'U',0,135
UNION ALL SELECT 'EGPI','ILY','ISLAY','ISLAY','U.K',55,40,55,'N',55.6819444444444,6,15,24,'U',0,54
UNION ALL SELECT 'EGPK','PIK','PRESTWICK','PRESTWICK','U.K',55,30,28,'N',55.5077777777778,4,35,12,'U',0,65
UNION ALL SELECT 'EGPL','BEB','BENBECULA','BENBECULA','U.K',57,28,52,'N',57.4811111111111,7,21,46,'U',0,19
UNION ALL SELECT 'EGPM','SDZ','SCATSTA','SCATSTA','U.K.',60,25,56,'N',60.4322222222222,1,17,53,'U',0,75
UNION ALL SELECT 'EGPN','DND','DUNDEE','DUNDEE','U.K',56,27,9,'N',56.4525,3,1,33,'U',0,17
UNION ALL SELECT 'EGPO','SYY','STORNOWAY','STORNOWAY','U.K.',58,12,49,'N',58.2136111111111,6,19,44,'U',0,26
UNION ALL SELECT 'EGPR','BRR','','BARRA','U.K',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EGPU','TRE','TIREE','TIREE','U.K.',56,29,57,'N',56.4991666666667,6,52,9,'U',0,38
UNION ALL SELECT 'EGPW','UNT','','UNST','SHETLAND ISLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EGQL','ADX','LEUCHARS','LEUCHARS','U.K',56,22,22,'N',56.3727777777778,2,52,6,'U',0,38
UNION ALL SELECT 'EGQS','LMO','LOSSIEMOUTH','LOSSIEMOUTH','U.K',57,42,18,'N',57.705,3,20,21,'U',0,42
UNION ALL SELECT 'EGSC','CBG','CAMBRIDGE','CAMBRIDGE','ENGLAND',52,12,18,'N',52.205,0,10,30,'E',0.175,50
UNION ALL SELECT 'EGSH','NWI','NORWICH','NORWICH','ENGLAND',52,40,33,'N',52.6758333333333,1,16,58,'E',1.28277777777778,117
UNION ALL SELECT 'EGSS','STN','STANSTED','LONDON','ENGLAND',51,53,6,'N',51.885,0,14,6,'E',0.235,348
UNION ALL SELECT 'EGTE','EXT','EXETER','EXETER','ENGLAND',50,44,4,'N',50.7344444444444,3,24,50,'U',0,100
UNION ALL SELECT 'EGTG','FZO','BRISTOL FILTON','BRISTOL','ENGLAND',51,31,10,'N',51.5194444444444,2,35,27,'U',0,226
UNION ALL SELECT 'EGTH','HTF','HATFIELD','HATFIELD','ENGLAND',51,46,0,'N',51.7666666666667,0,15,0,'E',0.25,77
UNION ALL SELECT 'EGTK','OXF','KIDLINGTON','OXFORD','ENGLAND',51,50,13,'N',51.8369444444444,1,19,12,'U',0,270
UNION ALL SELECT 'EGUN','MHZ','MILDENHALL','MILDENHALL','ENGLAND',52,21,39,'N',52.3608333333333,0,29,18,'E',0.488333333333333,33
UNION ALL SELECT 'EGVA','FFD','FAIRFORD','FAIRFORD','ENGLAND',51,40,55,'N',51.6819444444444,1,47,24,'U',0,286
UNION ALL SELECT 'EGVN','BZZ','BRIZE NORTON','BRIZE NORTON','ENGLAND',51,44,59,'N',51.7497222222222,1,35,1,'U',0,288
UNION ALL SELECT 'EGVO','ODH','ODIHAM','ODIHAM','U.K.',51,14,3,'N',51.2341666666667,0,56,34,'U',0,405
UNION ALL SELECT 'EGWU','NHT','NORTHOLT RAF','NORTHOLT','U.K.',51,33,10,'N',51.5527777777778,0,25,5,'U',0,124
UNION ALL SELECT 'EGXC','QCY','CONINGSBY','CONINGSBY','ENGLAND',53,5,34,'N',53.0927777777778,0,9,57,'U',0,25
UNION ALL SELECT 'EGXH','BEQ','HONINGTON','HONINGTON','ENGLAND',52,20,33,'N',52.3425,0,46,22,'E',0.772777777777778,174
UNION ALL SELECT 'EGXW','WTN','WADDINGTON','WADDINGTON','U.K.',53,9,58,'N',53.1661111111111,0,31,25,'U',0,231
UNION ALL SELECT 'EGYC','CLF','COLTISHALL','COLTISHALL','ENGLAND',52,45,17,'N',52.7547222222222,1,21,26,'E',1.35722222222222,66
UNION ALL SELECT 'EGYM','KNF','MARHAM','MARHAM','U.K.',52,38,54,'N',52.6483333333333,0,33,1,'E',0.550277777777778,75
UNION ALL SELECT 'EGYP','MPN','MOUNT PLEASANT','MOUNT PLEASANT','FALKLAND ISLANDS',51,49,22,'S',-51.8227777777778,58,26,50,'U',0,244
UNION ALL SELECT 'EHAM','AMS','SCHIPHOL','AMSTERDAM','NETHERLANDS',52,18,31,'N',52.3086111111111,4,45,50,'E',4.76388888888889,11
UNION ALL SELECT 'EHBK','MST','MAASTRICHT','MAASTRICHT','NETHERLANDS',50,54,41,'N',50.9113888888889,5,46,12,'E',5.77,375
UNION ALL SELECT 'EHEH','EIN','EINDHOVEN','EINDHOVEN','NETHERLANDS',51,27,0,'N',51.45,5,22,28,'E',5.37444444444444,74
UNION ALL SELECT 'EHGG','GRQ','EELDE','GRONINGEN','NETHERLANDS',53,7,10,'N',53.1194444444444,6,34,46,'E',6.57944444444444,17
UNION ALL SELECT 'EHKD','DHR','DE KOOY','DE KOOY','NETHERLANDS',52,55,24,'N',52.9233333333333,4,46,50,'E',4.78055555555556,3
UNION ALL SELECT 'EHLW','LWR','LEEUWARDEN','LEEUWARDEN','NETHERLANDS',53,13,43,'N',53.2286111111111,5,45,38,'E',5.76055555555556,4
UNION ALL SELECT 'EHRD','RTM','ROTTERDAM','ROTTERDAM','NETHERLANDS',51,57,26,'N',51.9572222222222,4,26,30,'E',4.44166666666667,15
UNION ALL SELECT 'EHSB','UTC','SOESTERBERG','SOESTERBERG','NETHERLANDS',52,7,37,'N',52.1269444444444,5,16,35,'E',5.27638888888889,66
UNION ALL SELECT 'EHTW','ENS','TWENTHE','ENSCHEDE','NETHERLANDS',52,16,12,'N',52.27,6,52,27,'E',6.87416666666667,114
UNION ALL SELECT 'EHVB','LID','VALKENBURG','VALKENBURG','NETHERLANDS',52,10,11,'N',52.1697222222222,4,25,34,'E',4.42611111111111,0
UNION ALL SELECT 'EHWO','WOE','WOENSDRECHT','WOENSDRECHT','NETHERLANDS',51,26,56,'N',51.4488888888889,4,20,31,'E',4.34194444444444,63
UNION ALL SELECT 'EHYP','YPB','','YPENBURG','NETHERLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EICK','ORK','CORK','CORK','IRELAND',51,50,34,'N',51.8427777777778,8,29,31,'U',0,502
UNION ALL SELECT 'EICM','GWY','GALWAY','GALWAY','IRELAND',53,18,5,'N',53.3013888888889,8,56,21,'U',0,81
UNION ALL SELECT 'EIDW','DUB','DUBLIN','DUBLIN','IRELAND',53,25,16,'N',53.4211111111111,6,16,12,'U',0,242
UNION ALL SELECT 'EIIM','IOR','','INISHMORE','IRELAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EIIR','INQ','','INISHEER','IRELAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EIKN','NOC','CONNAUGHT','CONNAUGHT','IRELAND',53,54,37,'N',53.9102777777778,8,49,6,'U',0,665
UNION ALL SELECT 'EIKY','KIR','KERRY','KERRY','IRELAND',52,10,51,'N',52.1808333333333,9,31,25,'U',0,112
UNION ALL SELECT 'EIMN','IIA','','INISHMAAN','IRELAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'EINN','SNN','SHANNON','SHANNON','IRELAND',52,42,7,'N',52.7019444444445,8,55,29,'U',0,46
UNION ALL SELECT 'EISG','SXL','SLIGO','SLIGO','IRELAND',54,16,48,'N',54.28,8,35,57,'U',0,11
UNION ALL SELECT 'EIWF','WAT','WATERFORD','WATERFORD','IRELAND',52,11,13,'N',52.1869444444444,7,5,13,'U',0,119
UNION ALL SELECT 'EKAH','AAR','AARHUS','AARHUS','DENMARK',56,18,15,'N',56.3041666666667,10,37,10,'E',10.6194444444444,82
UNION ALL SELECT 'EKBI','BLL','BILLUND','BILLUND','DENMARK',55,44,25,'N',55.7402777777778,9,9,6,'E',9.15166666666667,247
UNION ALL SELECT 'EKCH','CPH','KASTRUP','COPENHAGEN','DENMARK',55,37,4,'N',55.6177777777778,12,39,21,'E',12.6558333333333,17
UNION ALL SELECT 'EKEB','EBJ','ESBJERG','ESBJERG','DENMARK',55,31,33,'N',55.5258333333333,8,33,12,'E',8.55333333333333,97
UNION ALL SELECT 'EKKA','KRP','KARUP','KARUP','DENMARK',56,17,50,'N',56.2972222222222,9,7,28,'E',9.12444444444444,170
UNION ALL SELECT 'EKOD','ODE','ODENSE','ODENSE','DENMARK',55,28,34,'N',55.4761111111111,10,19,45,'E',10.3291666666667,56
UNION ALL SELECT 'EKRK','RKE','ROSKILDE','COPENHAGEN','DENMARK',55,35,8,'N',55.5855555555556,12,7,53,'E',12.1313888888889,146
UNION ALL SELECT 'EKRN','RNN','BORNHOLM RONNE','RONNE','DENMARK',55,3,47,'N',55.0630555555556,14,45,34,'E',14.7594444444444,52
UNION ALL SELECT 'EKSB','SGD','SONDERBORG','SOENDERBORG','DENMARK',54,57,51,'N',54.9641666666667,9,47,30,'E',9.79166666666667,24
UNION ALL SELECT 'EKSP','SKS','SKRYDSTRUP','SKRYDSTRUP','DENMARK',55,13,31,'N',55.2252777777778,9,15,50,'E',9.26388888888889,141
UNION ALL SELECT 'EKTS','TED','THISTED','THISTED','DENMARK',57,4,7,'N',57.0686111111111,8,42,18,'E',8.705,23
UNION ALL SELECT 'EKVG','FAE','VAGAR','VAGAR','FAROE ISL.',62,3,49,'N',62.0636111111111,7,16,37,'U',0,280
UNION ALL SELECT 'EKVJ','STA','STAUNING','STAUNING','DENMARK',55,59,24,'N',55.99,8,21,14,'E',8.35388888888889,17
UNION ALL SELECT 'EKYT','AAL','AALBORG','AALBORG','DENMARK',57,5,34,'N',57.0927777777778,9,50,56,'E',9.84888888888889,10
UNION ALL SELECT 'ELLX','LUX','FINDEL INTERNATIONAL AIRPORT','LUXEMBURG','LUXEMBURG',49,37,35,'N',49.6263888888889,6,12,41,'E',6.21138888888889,1234
UNION ALL SELECT 'ENAL','AES','VIGRA','ALESUND','NORWAY',62,33,37,'N',62.5602777777778,6,6,36,'E',6.11,69
UNION ALL SELECT 'ENAN','ANX','ANDOYA','ANDOYA','NORWAY',69,17,33,'N',69.2925,16,8,39,'E',16.1441666666667,43
UNION ALL SELECT 'ENAT','ALF','ALTA','ALTA','NORWAY',69,58,37,'N',69.9769444444444,23,21,58,'E',23.3661111111111,9
UNION ALL SELECT 'ENBN','BNN','BRONNOY','BRONNOYSUND','NORWAY',65,27,33,'N',65.4591666666667,12,12,49,'E',12.2136111111111,25
UNION ALL SELECT 'ENBO','BOO','BODO','BODOE','NORWAY',67,16,8,'N',67.2688888888889,14,21,48,'E',14.3633333333333,42
UNION ALL SELECT 'ENBR','BGO','BERGEN FLESLAND','BERGEN','NORWAY',60,17,36,'N',60.2933333333333,5,13,5,'E',5.21805555555556,165
UNION ALL SELECT 'ENBS','BJF','BATSFJORD','BATSFJORD','NORWAY',70,36,0,'N',70.6,29,41,33,'E',29.6925,490
UNION ALL SELECT 'ENBV','BVG','','BERLEVAG','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENCN','KRS','KRISTIANSAND KJEVIK','KRISTIANSAND','NORWAY',58,12,15,'N',58.2041666666667,8,5,7,'E',8.08527777777778,57
UNION ALL SELECT 'ENDU','BDU','BARDUFOSS','BARDUFOSS','NORWAY',69,3,20,'N',69.0555555555556,18,32,25,'E',18.5402777777778,252
UNION ALL SELECT 'ENEV','EVE','EVENES','EVENES','NORWAY',68,29,28,'N',68.4911111111111,16,40,41,'E',16.6780555555556,84
UNION ALL SELECT 'ENFB','FBU','OSLO FORNEBU','OSLO','NORWAY',59,53,44,'N',59.8955555555556,10,37,1,'E',10.6169444444444,55
UNION ALL SELECT 'ENFG','VDB','FAGERNES LEIRIN','FAGERNES','NORWAY',61,0,40,'N',61.0111111111111,9,17,35,'E',9.29305555555556,2697
UNION ALL SELECT 'ENFL','FRO','FLORO','FLORO','NORWAY',61,35,2,'N',61.5838888888889,5,1,30,'E',5.025,37
UNION ALL SELECT 'ENGM','OSL','OSLO GARDERMOEN','OSLO','NORWAY',60,11,38,'N',60.1938888888889,11,6,1,'E',11.1002777777778,681
UNION ALL SELECT 'ENHA','HMR','STAFSBERG','HAMAR','NORWAY',60,49,6,'N',60.8183333333333,11,4,2,'E',11.0672222222222,730
UNION ALL SELECT 'ENHD','HAU','HAUGESUND KARMOY','HAUGESUND','NORWAY',59,20,42,'N',59.345,5,12,30,'E',5.20833333333333,76
UNION ALL SELECT 'ENHF','HFT','','HAMMERFEST','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENHK','HAA','HASVIK','HASVIK','NORWAY',70,29,12,'N',70.4866666666667,22,8,23,'E',22.1397222222222,21
UNION ALL SELECT 'ENKB','KSU','KRISTIANSUND KVERNBERGET','KRISTIANSUND','NORWAY',63,6,42,'N',63.1116666666667,7,49,28,'E',7.82444444444444,204
UNION ALL SELECT 'ENKR','KKN','KIRKENES HOYBUKTMOEN','KIRKENES','NORWAY',69,43,30,'N',69.725,29,53,15,'E',29.8875,283
UNION ALL SELECT 'ENLI','FAN','LISTA','LISTA','NORWAY',58,6,1,'N',58.1002777777778,6,37,30,'E',6.625,29
UNION ALL SELECT 'ENLK','LKN','','LEKNES','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENML','MOL','ARO','MOLDE','NORWAY',62,44,46,'N',62.7461111111111,7,16,21,'E',7.2725,10
UNION ALL SELECT 'ENMR','MEH','','MEHAMN','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENMS','MJF','KJAERSTAD','MOSJOEN','NORWAY',65,47,2,'N',65.7838888888889,13,12,53,'E',13.2147222222222,237
UNION ALL SELECT 'ENNA','LKL','BANAK','BANAK','NORWAY',70,4,7,'N',70.0686111111111,24,58,24,'E',24.9733333333333,25
UNION ALL SELECT 'ENNK','NVK','','NARKVIK','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENNM','OSY','','NAMSOS','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENOL','OLA','ORLAND','ORLAND','NORWAY',63,41,56,'N',63.6988888888889,9,36,14,'E',9.60388888888889,28
UNION ALL SELECT 'ENOV','HOV','','ORSTA-VOLDA','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENRO','RRS','ROEROS','ROROS','NORWAY',62,34,42,'N',62.5783333333333,11,20,32,'E',11.3422222222222,2054
UNION ALL SELECT 'ENRS','RET','','ROST','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENSB','LYR','SVALBARD LONGYEAR','SVALBARD','NORWAY',78,14,46,'N',78.2461111111111,15,27,56,'E',15.4655555555556,88
UNION ALL SELECT 'ENSD','SDN','','SANDANE','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENSG','SOG','SOGNDAL HAUKASEN','SOGNDAL','NORWAY',61,9,22,'N',61.1561111111111,7,8,11,'E',7.13638888888889,1634
UNION ALL SELECT 'ENSH','SVJ','','SVOLVAER','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENSK','SKN','','STOKMARKNES','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENSN','SKE','SKIEN GEITERYGGEN','SKIEN','NORWAY',59,11,6,'N',59.185,9,34,1,'E',9.56694444444444,463
UNION ALL SELECT 'ENSO','SRP','SOERSTOKKEN','STORD','NORWAY',59,47,30,'N',59.7916666666667,5,20,27,'E',5.34083333333333,160
UNION ALL SELECT 'ENSR','SOJ','SORKJOSEN','SORKJOSEN','NORWAY',69,47,13,'N',69.7869444444444,20,57,34,'E',20.9594444444444,2
UNION ALL SELECT 'ENST','SSJ','STOKKA','SANDNESSJOEN','NORWAY',65,57,24,'N',65.9566666666667,12,28,8,'E',12.4688888888889,56
UNION ALL SELECT 'ENTC','TOS','TROMSO','TROMSO','NORWAY',69,41,0,'N',69.6833333333333,18,55,8,'E',18.9188888888889,31
UNION ALL SELECT 'ENTO','TRF','TORP','TORP','NORWAY',59,11,12,'N',59.1866666666667,10,15,31,'E',10.2586111111111,286
UNION ALL SELECT 'ENVA','TRD','TRONDHEIM VAERNES','TRONDHEIM','NORWAY',63,27,27,'N',63.4575,10,56,23,'E',10.9397222222222,56
UNION ALL SELECT 'ENVD','VDS','','VADSO','NORWAY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ENZV','SVG','STAVANGER SOLA','STAVANGER','NORWAY',58,52,36,'N',58.8766666666667,5,38,16,'E',5.63777777777778,29
UNION ALL SELECT 'EPGD','GDN','REBIECHOWO','GDANSK','POLAND',54,22,39,'N',54.3775,18,27,58,'E',18.4661111111111,488
UNION ALL SELECT 'EPKK','KRK','BALICE JP II INTERNATIONAL AIRPORT','KRAKOW','POLAND',50,4,39,'N',50.0775,19,47,5,'E',19.7847222222222,791
UNION ALL SELECT 'EPKT','KTW','PYRZOWICE','KATOWICE','POLAND',50,28,27,'N',50.4741666666667,19,4,48,'E',19.08,995
UNION ALL SELECT 'EPPO','POZ','LAWICA','POZNAN','POLAND',52,25,16,'N',52.4211111111111,16,49,35,'E',16.8263888888889,308
UNION ALL SELECT 'EPRZ','RZE','JASIONKA','RZESZOW','POLAND',50,6,36,'N',50.11,22,1,8,'E',22.0188888888889,692
UNION ALL SELECT 'EPSC','SZZ','GOLENIOW','SZCZECHIN','POLAND',53,35,5,'N',53.5847222222222,14,54,7,'E',14.9019444444444,154
UNION ALL SELECT 'EPSK','OSP','REDZIKOWO','SLUPSK','POLAND',54,28,44,'N',54.4788888888889,17,6,27,'E',17.1075,217
UNION ALL SELECT 'EPWA','WAW','OKECIE','WARSAW','POLAND',52,9,56,'N',52.1655555555556,20,58,1,'E',20.9669444444444,362
UNION ALL SELECT 'EPWR','WRO','STRACHOWICE','WROCLAW','POLAND',51,6,9,'N',51.1025,16,53,9,'E',16.8858333333333,404
UNION ALL SELECT 'EPZG','IEG','BABIMOST','ZIELONA GORA','POLAND',52,8,19,'N',52.1386111111111,15,47,55,'E',15.7986111111111,194
UNION ALL SELECT 'ESCL','SOO','','SODERHAMN','SWEDEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ESDB','AGH','ANGELHOLM','ANGELHOLM','SWEDEN',56,17,45,'N',56.2958333333333,12,50,49,'E',12.8469444444444,68
UNION ALL SELECT 'ESDF','RNB','RONNEBY','RONNEBY','SWEDEN',56,16,0,'N',56.2666666666667,15,15,54,'E',15.265,191
UNION ALL SELECT 'ESGG','GOT','LANDVETTER','GOTHENBORG','SWEDEN',57,39,46,'N',57.6627777777778,12,16,47,'E',12.2797222222222,506
UNION ALL SELECT 'ESGJ','JKG','JONKOPING','JOENKOEPING','SWEDEN',57,45,27,'N',57.7575,14,4,7,'E',14.0686111111111,741
UNION ALL SELECT 'ESGL','LDK','LIDKOPING','LIDKOPING','SWEDEN',58,27,55,'N',58.4652777777778,13,10,27,'E',13.1741666666667,200
UNION ALL SELECT 'ESGP','GSE','SAVE','GOTHENBORG','SWEDEN',57,46,29,'N',57.7747222222222,11,52,13,'E',11.8702777777778,59
UNION ALL SELECT 'ESGR','KVB','SKOVDE','SKOVDE','SWEDEN',58,27,23,'N',58.4563888888889,13,58,21,'E',13.9725,324
UNION ALL SELECT 'ESGT','THN','TROLLHATTAN VANERSBORG','TROLLHATTAN','SWEDEN',58,19,5,'N',58.3180555555556,12,20,42,'E',12.345,137
UNION ALL SELECT 'ESHH','AGH','','HELSINGBORG','SWEDEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ESHM','JMM','','MALMOE','SWEDEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ESKK','KSK','KARLSKOGA','KARLSKOGA','SWEDEN',59,20,45,'N',59.3458333333333,14,29,45,'E',14.4958333333333,400
UNION ALL SELECT 'ESKM','MXX','MORA','MORA','SWEDEN',60,57,28,'N',60.9577777777778,14,30,40,'E',14.5111111111111,634
UNION ALL SELECT 'ESKN','NYO','SKAVSTA','STOCKHOLM','SWEDEN',58,47,19,'N',58.7886111111111,16,54,43,'E',16.9119444444444,140
UNION ALL SELECT 'ESMK','KID','KRISTIANSTAD','KRISTIANSTAD','SWEDEN',55,55,18,'N',55.9216666666667,14,5,7,'E',14.0852777777778,76
UNION ALL SELECT 'ESML','JLD','LANDSKRONA','LANDSKRONA','SWEDEN',55,56,41,'N',55.9447222222222,12,51,39,'E',12.8608333333333,194
UNION ALL SELECT 'ESMO','OSK','OSKARSHAMN','OSKARSHAMN','SWEDEN',57,21,1,'N',57.3502777777778,16,29,52,'E',16.4977777777778,96
UNION ALL SELECT 'ESMQ','KLR','KALMAR','KALKMAR','SWEDEN',56,41,7,'N',56.6852777777778,16,17,15,'E',16.2875,17
UNION ALL SELECT 'ESMS','MMX','STURUP','MALMOE','SWEDEN',55,31,48,'N',55.53,13,22,17,'E',13.3713888888889,236
UNION ALL SELECT 'ESMT','HAD','HALMSTAD','HALMSTAD','SWEDEN',56,41,28,'N',56.6911111111111,12,49,12,'E',12.82,101
UNION ALL SELECT 'ESMX','VXO','KRONOBERG','VAXJO','SWEDEN',56,55,44,'N',56.9288888888889,14,43,40,'E',14.7277777777778,610
UNION ALL SELECT 'ESND','EVG','SVEG','SVEG','SWEDEN',62,2,52,'N',62.0477777777778,14,25,22,'E',14.4227777777778,1178
UNION ALL SELECT 'ESNG','GEV','GALLIVARE','GALLIVARE','SWEDEN',67,7,56,'N',67.1322222222222,20,48,52,'E',20.8144444444444,1027
UNION ALL SELECT 'ESNH','HUV','HUDIKSVALL','HUDIKSVALL','SWEDEN',61,46,5,'N',61.7680555555556,17,4,50,'E',17.0805555555556,95
UNION ALL SELECT 'ESNK','KRF','KRAMFORS SOLLEFTEA','KRAMFORS','SWEDEN',63,2,54,'N',63.0483333333333,17,46,7,'E',17.7686111111111,34
UNION ALL SELECT 'ESNL','LYC','LYCKSELE','LYCKSELE','SWEDEN',64,32,53,'N',64.5480555555555,18,42,58,'E',18.7161111111111,695
UNION ALL SELECT 'ESNN','SDL','SUNDSVALL HARNOSAND','SUNDSVALL','SWEDEN',62,31,41,'N',62.5280555555556,17,26,38,'E',17.4438888888889,16
UNION ALL SELECT 'ESNO','OER','ORNSKOLDSVIK','ORNSKOLDSVIK','SWEDEN',63,24,30,'N',63.4083333333333,18,59,24,'E',18.99,354
UNION ALL SELECT 'ESNQ','KRN','KIRUNA','KIRUNA','SWEDEN',67,49,19,'N',67.8219444444444,20,20,12,'E',20.3366666666667,1508
UNION ALL SELECT 'ESNS','SFT','SKELLEFTEA','SKELLEFTEA','SWEDEN',64,37,29,'N',64.6247222222222,21,4,36,'E',21.0766666666667,157
UNION ALL SELECT 'ESNU','UME','UMEA','UMEA','SWEDEN',63,47,30,'N',63.7916666666667,20,16,57,'E',20.2825,24
UNION ALL SELECT 'ESNV','VHM','VILHELMINA','VILHELMINA','SWEDEN',64,34,44,'N',64.5788888888889,16,50,0,'E',16.8333333333333,1140
UNION ALL SELECT 'ESNX','AJR','ARVIDSJAUR','ARVIDSJAUR','SWEDEN',65,35,24,'N',65.59,19,16,54,'E',19.2816666666667,1245
UNION ALL SELECT 'ESOE','ORB','OREBRO','OREBRO','SWEDEN',59,13,25,'N',59.2236111111111,15,2,16,'E',15.0377777777778,188
UNION ALL SELECT 'ESOW','VST','VASTERAS','VASTERAS','SWEDEN',59,35,22,'N',59.5894444444444,16,38,1,'E',16.6336111111111,21
UNION ALL SELECT 'ESPA','LLA','KALLAX','LULEA','SWEDEN',65,32,37,'N',65.5436111111111,22,7,19,'E',22.1219444444444,65
UNION ALL SELECT 'ESPC','OSD','FROSON','OSTERSUND','SWEDEN',63,11,38,'N',63.1938888888889,14,30,7,'E',14.5019444444444,1231
UNION ALL SELECT 'ESSA','ARN','ARLANDA','STOCKHOLM','SWEDEN',59,39,7,'N',59.6519444444444,17,55,7,'E',17.9186111111111,124
UNION ALL SELECT 'ESSB','BMA','BROMMA','STOCKHOLM','SWEDEN',59,21,15,'N',59.3541666666667,17,56,29,'E',17.9413888888889,47
UNION ALL SELECT 'ESSD','BLE','BORLANGE','BORLANGE','SWEDEN',60,25,19,'N',60.4219444444444,15,30,54,'E',15.515,503
UNION ALL SELECT 'ESSF','HLF','HULTSFRED','HULTSFRED','SWEDEN',57,31,32,'N',57.5255555555556,15,49,26,'E',15.8238888888889,366
UNION ALL SELECT 'ESSK','GVX','GAVLE SANDVIKEN','GAVLE','SWEDEN',60,35,36,'N',60.5933333333333,16,57,5,'E',16.9513888888889,224
UNION ALL SELECT 'ESSL','LPI','SAAB','LINKOEPING','SWEDEN',58,24,22,'N',58.4061111111111,15,40,49,'E',15.6802777777778,172
UNION ALL SELECT 'ESSP','NRK','KUNGSANGEN','NORRKOEPING','SWEDEN',58,35,10,'N',58.5861111111111,16,15,2,'E',16.2505555555556,32
UNION ALL SELECT 'ESSQ','KSD','','KARLSTAD','SWEDEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ESSV','VBY','VISBY','VISBY','SWEDEN',57,39,46,'N',57.6627777777778,18,20,46,'E',18.3461111111111,167
UNION ALL SELECT 'ETAD','SPM','SPANGDAHLEM AB','SPANGDAHLEM','GERMANY',49,58,21,'N',49.9725,6,41,33,'E',6.6925,1197
UNION ALL SELECT 'ETAR','RMS','RAMSTEIN AB','RAMSTEIN','GERMANY',49,26,15,'N',49.4375,7,36,5,'E',7.60138888888889,782
UNION ALL SELECT 'ETEU','GHF','GIEBELSTADT AAF','GIEBELSTADT','GERMANY',49,38,53,'N',49.6480555555556,9,57,59,'E',9.96638888888889,978
UNION ALL SELECT 'ETHC','ZCN','CELLE','CELLE','GERMANY',52,35,28,'N',52.5911111111111,10,1,19,'E',10.0219444444444,128
UNION ALL SELECT 'ETID','ZNF','HANAU AAF','HANAU','GERMANY',50,10,9,'N',50.1691666666667,8,57,41,'E',8.96138888888889,368
UNION ALL SELECT 'ETIE','QHD','HEIDELBERG AAF','HEIDELBERG','GERMANY',49,23,36,'N',49.3933333333333,8,39,7,'E',8.65194444444444,358
UNION ALL SELECT 'ETNG','GKE','GEILENKIRCHEN','GEILENKIRCHEN','GERMANY',50,57,39,'N',50.9608333333333,6,2,33,'E',6.0425,296
UNION ALL SELECT 'ETNL','RLG','LAAGE','LAAGE','GERMANY',53,55,5,'N',53.9180555555556,12,16,45,'E',12.2791666666667,138
UNION ALL SELECT 'ETSF','FEL','FURSTENFELDBRUCK','FUERSTENFELDBRUCK','GERMANY',48,12,20,'N',48.2055555555556,11,16,1,'E',11.2669444444444,1703
UNION ALL SELECT 'ETUL','LRC','LAARBRUCH','LAARBRUCH','GERMANY',51,36,6,'N',51.6016666666667,6,8,33,'E',6.1425,105
UNION ALL SELECT 'ETUO','GUT','GUTERSLOH','GUETERSLOH','GERMANY',51,55,22,'N',51.9227777777778,8,18,22,'E',8.30611111111111,236
UNION ALL SELECT 'ETUR','BGN','BRUGGEN','BRUEGGEN','GERMANY',51,11,59,'N',51.1997222222222,6,7,55,'E',6.13194444444444,241
UNION ALL SELECT 'FAAB','ALJ','ALEXANDER BAY','ALEXANDER BAY','SOUTH AFRICA',28,34,30,'S',-28.575,16,32,0,'E',16.5333333333333,98
UNION ALL SELECT 'FAAG','AGZ','AGGENEYS','AGGENEYS','SOUTH AFRICA',29,16,54,'S',-29.2816666666667,18,48,49,'E',18.8136111111111,2648
UNION ALL SELECT 'FAAR','ADI','','ARANDIS','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FABE','VIY','BISHO','BISHO','SOUTH AFRICA',32,53,49,'S',-32.8969444444444,27,16,44,'E',27.2788888888889,1950
UNION ALL SELECT 'FABL','BFN','BLOEMFONTEIN','BLOEMFONTEIN','SOUTH AFRICA',29,5,33,'S',-29.0925,26,18,8,'E',26.3022222222222,4458
UNION ALL SELECT 'FACT','CPT','CAPE TOWN INTERNATIONAL','CAPE TOWN','SOUTH AFRICA',33,57,53,'S',-33.9647222222222,18,36,6,'E',18.6016666666667,151
UNION ALL SELECT 'FADN','DUR','DURBAN INTERNATIONAL','DURBAN','SOUTH AFRICA',29,58,12,'S',-29.97,30,57,1,'E',30.9502777777778,33
UNION ALL SELECT 'FAEL','ELS','EAST LONDON','EAST LONDON','SOUTH AFRICA',33,2,8,'S',-33.0355555555556,27,49,33,'E',27.8258333333333,435
UNION ALL SELECT 'FAER','ELL','ELLISRAS','ELLISRAS','SOUTH AFRICA',23,43,34,'S',-23.7261111111111,27,41,15,'E',27.6875,2950
UNION ALL SELECT 'FAGC','GCJ','GRAND CENTRAL','JOHANNESBURG','SOUTH AFRICA',25,59,10,'S',-25.9861111111111,28,8,24,'E',28.14,5327
UNION ALL SELECT 'FAGF','GFY','','GROOTFONTEIN','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FAGG','GRJ','GEORGE','GEORGE','SOUTH AFRICA',34,0,19,'S',-34.0052777777778,22,22,44,'E',22.3788888888889,648
UNION ALL SELECT 'FAGM','HCS','RAND','JOHANNESBURG','SOUTH AFRICA',26,14,33,'S',-26.2425,28,9,4,'E',28.1511111111111,5568
UNION ALL SELECT 'FAHG','GHC','HEIDELBERG','HEIDELBERG','SOUTH AFRICA',26,30,22,'S',-26.5061111111111,28,23,38,'E',28.3938888888889,5119
UNION ALL SELECT 'FAHS','HDS','HOEDSPRUIT AFS','HOEDSPRUIT','SOUTH AFRICA',24,22,7,'S',-24.3686111111111,31,2,55,'E',31.0486111111111,1743
UNION ALL SELECT 'FAJS','JNB','JOHANNESBURG INTERNATIONAL','JOHANNESBURG','SOUTH AFRICA',26,8,21,'S',-26.1391666666667,28,14,45,'E',28.2458333333333,5558
UNION ALL SELECT 'FAKM','KIM','KIMBERLEY','KIMBERLEY','SOUTH AFRICA',28,48,10,'S',-28.8027777777778,24,45,54,'E',24.765,3950
UNION ALL SELECT 'FAKT','KMP','','KEETMANSHOOP','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FAKZ','KLZ','KLEINSEE','KLEINSEE','SOUTH AFRICA',29,41,18,'S',-29.6883333333333,17,5,38,'E',17.0938888888889,259
UNION ALL SELECT 'FALA','HLA','LANSERIA','JOHANNESBURG','SOUTH AFRICA',25,56,18,'S',-25.9383333333333,27,55,34,'E',27.9261111111111,4517
UNION ALL SELECT 'FALT','LCD','LOUIS TRICHARDT AFB','LOUIS TRICHARDT','SOUTH AFRICA',23,9,35,'S',-23.1597222222222,29,41,47,'E',29.6963888888889,3069
UNION ALL SELECT 'FALY','LAY','LADYSMITH','LADYSMITH','SOUTH AFRICA',28,34,54,'S',-28.5816666666667,29,44,59,'E',29.7497222222222,3548
UNION ALL SELECT 'FALZ','LUD','','LUDERITZ','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FAMG','MGH','MARGATE','MARGATE','SOUTH AFRICA',30,51,26,'S',-30.8572222222222,30,20,34,'E',30.3427777777778,495
UNION ALL SELECT 'FAMK','MFK','MAFIKENG NORTH','MAFIKENG','SOUTH AFRICA',25,45,10,'S',-25.7527777777778,25,36,43,'E',25.6119444444444,4150
UNION ALL SELECT 'FAMM','MBO','MAFIKENG','MMABATHO','BOPHUTHATSWANA',25,47,54,'S',-25.7983333333333,25,32,52,'E',25.5477777777778,4181
UNION ALL SELECT 'FAMP','MPA','','MPACHA','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FAMS','MEZ','MESSINA','MESSINA','SOUTH AFRICA',22,21,21,'S',-22.3558333333333,29,59,11,'E',29.9863888888889,1881
UNION ALL SELECT 'FAMW','MZF','','MZAMBA','SOUTH AFRICA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FANA','NNI','','NAMUTONI','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FANC','NCS','NEWCASTLE','NEWCASTLE','SOUTH AFRICA',27,46,14,'S',-27.7705555555556,29,58,36,'E',29.9766666666667,4074
UNION ALL SELECT 'FANS','NLP','NELSPRUIT','NELSPRUIT','SOUTH AFRICA',25,30,2,'S',-25.5005555555556,30,54,48,'E',30.9133333333333,2901
UNION ALL SELECT 'FAOA','OND','','ONDANGWA','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FAOG','OMD','','ORANJEMUND','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FAOH','DUH','OUDTSHOORN','OUDTSHOORN','SOUTH AFRICA',33,36,25,'S',-33.6069444444444,22,11,20,'E',22.1888888888889,1063
UNION ALL SELECT 'FAOO','OKF','','OKAUKUEJO','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FAOS','OHI','','OSHAKATI','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FAPE','PLZ','PORT ELIZABETH','PORT ELIZABETH','SOUTH AFRICA',33,59,5,'S',-33.9847222222222,25,37,2,'E',25.6172222222222,226
UNION ALL SELECT 'FAPH','PHW','PHALABORWA','PHALABORWA','SOUTH AFRICA',23,56,13,'S',-23.9369444444444,31,9,19,'E',31.1552777777778,1432
UNION ALL SELECT 'FAPI','PTG','PIETERSBURG MUNI','PIETERSBURG','SOUTH AFRICA',23,55,33,'S',-23.9258333333333,29,29,3,'E',29.4841666666667,4354
UNION ALL SELECT 'FAPM','PZB','PIETERMARITZBURG','PIETERMARITZBURG','SOUTH AFRICA',29,38,56,'S',-29.6488888888889,30,23,55,'E',30.3986111111111,2423
UNION ALL SELECT 'FAPN','NTY','PILANESBERG','PILANESBERG','SOUTH AFRICA',25,20,1,'S',-25.3336111111111,27,10,24,'E',27.1733333333333,3412
UNION ALL SELECT 'FAQT','UTW','QUEENSTOWN','QUEENSTOWN','SOUTH AFRICA',31,55,12,'S',-31.92,26,52,55,'E',26.8819444444444,3637
UNION ALL SELECT 'FARB','RCB','RICHARDS BAY','RICHARD''S BAY','SOUTH AFRICA',28,44,27,'S',-28.7408333333333,32,5,31,'E',32.0919444444444,109
UNION ALL SELECT 'FARK','WVB','','WALVIS BAY','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FARU','NDU','','RUNDU','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FASB','SBU','SPRINGBOK','SPRINGBOK','SOUTH AFRICA',29,41,21,'S',-29.6891666666667,17,56,22,'E',17.9394444444444,2690
UNION ALL SELECT 'FASM','SWP','','SWAKOPMUND','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FASS','SIS','SISHEN','SISHEN','SOUTH AFRICA',27,38,54,'S',-27.6483333333333,22,59,57,'E',22.9991666666667,3848
UNION ALL SELECT 'FASZ','SZK','SKUKUZA','SKUKUZA','SOUTH AFRICA',24,57,39,'S',-24.9608333333333,31,35,19,'E',31.5886111111111,1020
UNION ALL SELECT 'FATH','THY','P R MPHEPHU','THOHOYANDOU','SOUTH AFRICA',23,4,43,'S',-23.0786111111111,30,23,0,'E',30.3833333333333,2018
UNION ALL SELECT 'FATM','TSB','','TSUMEB','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FATN','TCU','THABA NCHU','THABA NCHU','BOPHUTHATSWANA',29,19,9,'S',-29.3191666666667,26,49,24,'E',26.8233333333333,4931
UNION ALL SELECT 'FATZ','LTA','TZANEEN','TZANEEN','SOUTH AFRICA',23,49,27,'S',-23.8241666666667,30,19,45,'E',30.3291666666667,1914
UNION ALL SELECT 'FAUL','ULD','PRINCE MANGOSUTHU BUTHELEZI','ULUNDI','SOUTH AFRICA',28,19,14,'S',-28.3205555555556,31,24,59,'E',31.4163888888889,1720
UNION ALL SELECT 'FAUP','UTN','UPINGTON','UPINGTON','SOUTH AFRICA',28,24,3,'S',-28.4008333333333,21,15,38,'E',21.2605555555556,2791
UNION ALL SELECT 'FAUT','UTT','UMTATA','UMTATA','SOUTH AFRICA',31,32,52,'S',-31.5477777777778,28,40,27,'E',28.6741666666667,2400
UNION ALL SELECT 'FAVB','VRU','VRYBURG','VRYBURG','SOUTH AFRICA',26,58,56,'S',-26.9822222222222,24,43,43,'E',24.7286111111111,3920
UNION ALL SELECT 'FAVG','VIR','VIRGINIA','DURBAN','SOUTH AFRICA',29,46,14,'S',-29.7705555555556,31,3,30,'E',31.0583333333333,20
UNION ALL SELECT 'FAVY','VYD','VRYHEID','VRYHEID','SOUTH AFRICA',27,47,12,'S',-27.7866666666667,30,47,43,'E',30.7952777777778,3800
UNION ALL SELECT 'FAWB','PRY','WONDERBOOM','PRETORIA','SOUTH AFRICA',25,39,13,'S',-25.6536111111111,28,13,27,'E',28.2241666666667,4095
UNION ALL SELECT 'FAWE','WDH','','WINDHOEK','NAMIBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FAWM','WEL','WELKOM','WELKOM','SOUTH AFRICA',27,59,52,'S',-27.9977777777778,26,40,10,'E',26.6694444444444,4399
UNION ALL SELECT 'FBFT','FRW','FRANCISTOWN','FRANCISTOWN','BOTSWANA',21,9,34,'S',-21.1594444444444,27,28,28,'E',27.4744444444444,3283
UNION ALL SELECT 'FBGZ','GNZ','','GHANZI','BOTSWANA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FBJW','JWA','JWANENG','JWANENG','BOTSWANA',24,36,8,'S',-24.6022222222222,24,41,27,'E',24.6908333333333,3900
UNION ALL SELECT 'FBKE','BBK','KASANE','KASANE','BOTSWANA',17,49,58,'S',-17.8327777777778,25,9,44,'E',25.1622222222222,3289
UNION ALL SELECT 'FBKR','KHW','','KHWAI RIVER LODGE','BOTSWANA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FBMN','MUB','MAUN','MAUN','BOTSWANA',19,58,21,'S',-19.9725,23,25,51,'E',23.4308333333333,3093
UNION ALL SELECT 'FBOR','ORP','ORAPA','ORAPA','BOTSWANA',21,15,59,'S',-21.2663888888889,25,19,13,'E',25.3202777777778,3100
UNION ALL SELECT 'FBSK','GBE','SIR SERETSE KHAMA INTERNATIONAL','GABERONE','BOTSWANA',24,33,18,'S',-24.555,25,55,5,'E',25.9180555555556,3299
UNION ALL SELECT 'FBSP','PKW','SELEBI PHIKWE','SELEBI-PHIKWE','BOTSWANA',22,3,30,'S',-22.0583333333333,27,49,43,'E',27.8286111111111,2925
UNION ALL SELECT 'FBSW','SWX','','SHAKAWE','BOTSWANA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FBTL','TLD','','TULI LODGE','BOTSWANA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FBTS','TBY','','TSHABONG','BOTSWANA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCBB','BZV','BRAZZAVILLE MAYA MAYA','BRAZZAVILLE','CONGO',4,15,6,'S',-4.25166666666667,15,15,10,'E',15.2527777777778,1048
UNION ALL SELECT 'FCBD','DJM','','DJAMBALA','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCBK','KNJ','','KINDAMBA','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCBL','LCO','','LAGUE','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCBM','MUY','','MUYONDZI','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCBS','SIB','','SIBITI','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCBY','NKY','','N''KAYI','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCOB','BOE','','BOUNDJI','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCOE','EWO','','EWO','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCOG','GMM','','GAMBOMA','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCOI','ION','IMPFONDO','IMPFONDO','CONGO',1,35,22,'N',1.58944444444444,18,2,49,'E',18.0469444444444,1099
UNION ALL SELECT 'FCOK','KEE','','KELLE','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCOM','MKJ','MAKOUA','MAKOUA','CONGO',0,1,17,'S',-0.0213888888888889,15,34,31,'E',15.5752777777778,1289
UNION ALL SELECT 'FCOO','FTX','OWANDO','OWANDO','CONGO',0,31,52,'S',-0.531111111111111,15,57,0,'E',15.95,1214
UNION ALL SELECT 'FCOS','SOE','','SOUANKE','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCOT','BTB','','BETOU','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCOU','OUE','OUESSO','OUESSO','CONGO',1,36,57,'N',1.61583333333333,16,2,16,'E',16.0377777777778,1158
UNION ALL SELECT 'FCPA','KMK','MAKABANA','MAKABANA','CONGO',3,29,0,'S',-3.48333333333333,12,37,0,'E',12.6166666666667,495
UNION ALL SELECT 'FCPD','DIS','DOLISIE','LOUDIMA','CONGO',4,12,28,'S',-4.20777777777778,12,39,39,'E',12.6608333333333,1079
UNION ALL SELECT 'FCPL','DIS','','LOUBOMO','CONGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FCPP','PNR','POINTE NOIRE','POINTE-NOIRE','CONGO',4,48,48,'S',-4.81333333333333,11,53,9,'E',11.8858333333333,55
UNION ALL SELECT 'FDMS','MTS','MATSAPHA','MANZINI','SWAZILAND',26,31,44,'S',-26.5288888888889,31,18,27,'E',31.3075,2075
UNION ALL SELECT 'FEFB','MKI','','OBO','CENTRAL AFRICAN REP.',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FEFF','BGF','BANGUI M POKO','BANGUI','CENTRAL AFRICAN REP.',4,23,54,'N',4.39833333333333,18,31,7,'E',18.5186111111111,1208
UNION ALL SELECT 'FEFG','BGU','BANGASSOU','BANGASSOU','CENTRAL AFRICAN REP.',4,47,4,'N',4.78444444444444,22,46,53,'E',22.7813888888889,1706
UNION ALL SELECT 'FEFI','IRO','BIRAO','BIRAO','CENTRAL AFRICAN REP.',10,14,10,'N',10.2361111111111,22,43,2,'E',22.7172222222222,1696
UNION ALL SELECT 'FEFL','BEM','','BOSSEMBELE','CENTRAL AFRICAN REP.',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FEFM','BBY','BAMBARI','BAMBARI','CENTRAL AFRICAN REP.',5,50,49,'N',5.84694444444444,20,38,58,'E',20.6494444444444,1549
UNION ALL SELECT 'FEFN','NDL','NDELE','N''DELE','CENTRAL AFRICAN REP.',8,25,36,'N',8.42666666666667,20,38,6,'E',20.635,1631
UNION ALL SELECT 'FEFO','BOP','BOUAR','BOUAR','CENTRAL AFRICAN REP.',5,57,29,'N',5.95805555555556,15,38,15,'E',15.6375,3360
UNION ALL SELECT 'FEFR','BIV','BRIA','BRIA','CENTRAL AFRICAN REP.',6,31,41,'N',6.52805555555556,21,59,20,'E',21.9888888888889,1975
UNION ALL SELECT 'FEFS','BSN','','BOSSANGOA','CENTRAL AFRICAN REP.',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FEFT','BBT','BERBERATI','BERBERATI','CENTRAL AFRICAN REP.',4,13,17,'N',4.22138888888889,15,47,10,'E',15.7861111111111,1929
UNION ALL SELECT 'FEFY','AIG','YALINGA','YALINGA','CENTRAL AFRICAN REP.',45,9,15,'N',45.1541666666667,89,6,39,'U',0,1522
UNION ALL SELECT 'FEFZ','IMO','','ZEMIO','CENTRAL AFRICAN REP.',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FEGZ','BOZ','','BOZOUM','CENTRAL AFRICAN REP.',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FGBT','BSG','BATA','BATA','EQUATORIAL GUINEA',1,54,19,'N',1.90527777777778,9,48,20,'E',9.80555555555556,36
UNION ALL SELECT 'FGSL','SSG','MALABO','MALABO','EQUATORIAL GUINEA',3,45,19,'N',3.75527777777778,8,42,31,'E',8.70861111111111,76
UNION ALL SELECT 'FIMP','MRU','SIR SEEWOOSAGUR RAMGOOLAM INTERNATIONAL','PLAISANCE','MAURITIUS',20,25,48,'S',-20.43,57,41,0,'E',57.6833333333333,186
UNION ALL SELECT 'FIMR','RRG','PLAINE CORAIL','RODRIGUEZ ISLAND','MAURITIUS',19,45,28,'S',-19.7577777777778,63,21,43,'E',63.3619444444444,95
UNION ALL SELECT 'FKKB','KBI','','KRIBI','CAMEROON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FKKC','TKC','TIKO','TIKO','CAMEROON',4,5,21,'N',4.08916666666667,9,21,37,'E',9.36027777777778,151
UNION ALL SELECT 'FKKD','DLA','DOUALA','DOUALA','CAMEROON',4,0,21,'N',4.00583333333333,9,43,10,'E',9.71944444444444,33
UNION ALL SELECT 'FKKF','MMF','','MAMFE','CAMEROON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FKKG','BLC','','BALI','CAMEROON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FKKH','KLE','','KAELE','CAMEROON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FKKI','OUR','BATOURI','BATOURI','CAMEROON',4,28,23,'N',4.47305555555556,14,21,49,'E',14.3636111111111,2152
UNION ALL SELECT 'FKKJ','GXX','','YAGOUA','CAMEROON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FKKL','MVR','MAROUA SALAK','MAROUA','CAMEROON',10,27,5,'N',10.4513888888889,14,15,26,'E',14.2572222222222,1391
UNION ALL SELECT 'FKKM','FOM','FOUMBAN NKOUNJA','FOUMBAN','CAMEROON',5,38,12,'N',5.63666666666667,10,45,2,'E',10.7505555555556,3963
UNION ALL SELECT 'FKKN','NGE','NGAOUNDERE','N''GAOUNDERE','CAMEROON',7,21,25,'N',7.35694444444444,13,33,33,'E',13.5591666666667,3655
UNION ALL SELECT 'FKKO','BTA','','BERTOUA','CAMEROON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FKKR','GOU','GAROUA','GAROUA','CAMEROON',9,20,9,'N',9.33583333333333,13,22,12,'E',13.37,794
UNION ALL SELECT 'FKKS','DSC','','DSCHANG','CAMEROON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FKKU','BFX','BAFOUSSAM','BAFOUSSAM','CAMEROON',5,32,13,'N',5.53694444444444,10,21,15,'E',10.3541666666667,4347
UNION ALL SELECT 'FKKV','BPC','BAMENDA','BAMENDA','CAMEROON',6,2,21,'N',6.03916666666667,10,7,21,'E',10.1225,4065
UNION ALL SELECT 'FKKW','EBW','','EBOLOWA','CAMEROON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FKKY','YAO','YAOUNDE','YAOUNDE','CAMEROON',3,50,7,'N',3.83527777777778,11,31,25,'E',11.5236111111111,2464
UNION ALL SELECT 'FLCP','CIP','','CHIPATA','ZAMBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FLKS','KAA','','KASAMA','ZAMBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FLKY','ZKB','','KASABA BAY','ZAMBIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FLLI','LVI','LIVINGSTONE','LIVINGSTONE','ZAMBIA',17,49,18,'S',-17.8216666666667,25,49,21,'E',25.8225,3250
UNION ALL SELECT 'FLLS','LUN','LUSAKA INTERNATIONAL','LUSAKA','ZAMBIA',15,19,50,'S',-15.3305555555556,28,27,9,'E',28.4525,3779
UNION ALL SELECT 'FLMF','MFU','MFUWE','MFUWE','ZAMBIA',13,15,31,'S',-13.2586111111111,31,56,11,'E',31.9363888888889,1880
UNION ALL SELECT 'FLND','NLA','NDOLA','NDOLA','ZAMBIA',12,59,53,'S',-12.9980555555556,28,39,53,'E',28.6647222222222,4167
UNION ALL SELECT 'FLSO','KIW','SOUTHDOWNS','SOUTHDOWNS','ZAMBIA',12,54,1,'S',-12.9002777777778,28,8,59,'E',28.1497222222222,4145
UNION ALL SELECT 'FMCH','HAH','MORONI HAHAIA','MORONI','COMOROS ISLANDS',11,32,1,'S',-11.5336111111111,43,16,18,'E',43.2716666666667,89
UNION ALL SELECT 'FMCI','NWA','MOHELI BANDAR ES SALAM','MOHELI','COMOROS ISLANDS',12,17,53,'S',-12.2980555555556,43,45,59,'E',43.7663888888889,46
UNION ALL SELECT 'FMCN','YVA','MORONI ICONI','MORONI','COMOROS ISLANDS',11,42,38,'S',-11.7105555555556,43,14,37,'E',43.2436111111111,33
) x (ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LatDec],[LongDeg],[LongMin],[LongSec],[LongDir],[LongDec],[Altitude])
LEFT OUTER JOIN Airports a ON a.IATA_Code = x.IATA_Code
--WHERE x.[LatDir] <> 'U' and x.[LongDir] <> 'U' and x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE n=1
GO

INSERT INTO Airports (ICAO_Code, IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir
    ,LongDeg, LongMin, LongSec, LongDir, Altitude)
SELECT ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LongDeg],[LongMin],[LongSec],[LongDir],[Altitude]
FROM (
SELECT x.ICAO_Code,x.IATA_Code,x.[Name],x.[City],x.[Country],x.[LatDeg],x.[LatMin],x.[LatSec],x.[LatDir]
	,x.[LatDec],x.[LongDeg],x.[LongMin],x.[LongSec],x.[LongDir],x.[LongDec],x.[Altitude]
    ,n=ROW_NUMBER() OVER (PARTITION BY x.IATA_Code ORDER BY (SELECT NULL))
FROM (
SELECT 'FMCV','AJN','ANJOUAN OUANI','ANJOUAN','COMOROS ISLANDS',12,7,54,'S',-12.1316666666667,44,25,49,'E',44.4302777777778,62
UNION ALL SELECT 'FMCZ','DZA','DZAOUDZI PAMANZI','DZAOUDZI','MAYOTTE ISLAND',12,48,17,'S',-12.8047222222222,45,16,52,'E',45.2811111111111,23
UNION ALL SELECT 'FMEE','RUN','ST DENIS GILLOT','ST.-DENIS','REUNION ISLAND',20,53,13,'S',-20.8869444444444,55,30,37,'E',55.5102777777778,66
UNION ALL SELECT 'FMEP','ZSE','ST PIERRE PIERREFONDS','ST.-PIERRE','REUNION ISLAND',21,19,15,'S',-21.3208333333333,55,25,29,'E',55.4247222222222,52
UNION ALL SELECT 'FMMC','WML','','MALAIMBRANDY','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMME','ATJ','','ANTSIRABE','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMMG','WAQ','','ANTSALOVA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMMH','VVB','','MAHANORO','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMMI','TNR','ANTANANARIVO IVATO','ANTANANARIVO','MADAGASCAR',18,47,48,'S',-18.7966666666667,47,28,43,'E',47.4786111111111,4198
UNION ALL SELECT 'FMMK','JVA','','ANKAVANDRA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMML','BMD','','BELO SUR TSIRIBIHINA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMMN','ZVA','MIANDRIVAZO','MIANDRIVAZO','MADAGASCAR',19,33,46,'S',-19.5627777777778,45,27,3,'E',45.4508333333333,203
UNION ALL SELECT 'FMMO','MXT','','MAINTIRANO','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMMQ','ILK','','ILAKA EAST','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMMR','TVA','','MORAFENOBE','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMMS','SMS','SAINTE MARIE','SAINTE MARIE','MADAGASCAR',17,5,38,'S',-17.0938888888889,49,48,57,'E',49.8158333333333,7
UNION ALL SELECT 'FMMT','TMM','TOAMASINA','TOAMASINA','MADAGASCAR',18,6,34,'S',-18.1094444444444,49,23,33,'E',49.3925,22
UNION ALL SELECT 'FMMU','WTA','','TAMBOHORANO','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMMV','MOQ','MORONDAVA','MORONDAVA','MADAGASCAR',20,17,5,'S',-20.2847222222222,44,19,3,'E',44.3175,30
UNION ALL SELECT 'FMMX','WTS','','TSIROANOMANDIDY','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMMY','VAT','','VATOMANDRY','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMNA','DIE','ANTSIRANANA ARRACHART','ANTSIRANANA','MADAGASCAR',12,20,57,'S',-12.3491666666667,49,17,30,'E',49.2916666666667,374
UNION ALL SELECT 'FMNC','WMR','MANANARA AVARATRA','MANANARA','MADAGASCAR',16,9,50,'S',-16.1638888888889,49,46,25,'E',49.7736111111111,9
UNION ALL SELECT 'FMND','ZWA','ANDAPA','ANDAPA','MADAGASCAR',14,39,6,'S',-14.6516666666667,49,37,14,'E',49.6205555555556,1552
UNION ALL SELECT 'FMNE','AMB','AMBILOBE MAHAVAVY','AMBILOBE','MADAGASCAR',13,11,18,'S',-13.1883333333333,48,59,16,'E',48.9877777777778,72
UNION ALL SELECT 'FMNF','WBD','','BEFANDRIANA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMNG','WPB','','PORT BERGE','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMNH','ANM','ANTALAHA ANTSIRABATO','ANTALAHA','MADAGASCAR',14,59,57,'S',-14.9991666666667,50,19,12,'E',50.32,20
UNION ALL SELECT 'FMNJ','IVA','','AMBANJA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMNL','HVA','ANALALAVA','ANALALAVA','MADAGASCAR',14,37,46,'S',-14.6294444444444,47,45,49,'E',47.7636111111111,345
UNION ALL SELECT 'FMNM','MJN','MAHAJANGA PHILIBERT TSIRANANA','MAHAJANGA','MADAGASCAR',15,40,2,'S',-15.6672222222222,46,21,6,'E',46.3516666666667,87
UNION ALL SELECT 'FMNN','NOS','NOSY BE FASCENE','NOSY-BE','MADAGASCAR',13,18,44,'S',-13.3122222222222,48,18,50,'E',48.3138888888889,37
UNION ALL SELECT 'FMNO','DWB','','SOALALA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMNQ','BPY','BESALAMPY','BESALAMPY','MADAGASCAR',16,44,31,'S',-16.7419444444444,44,28,53,'E',44.4813888888889,125
UNION ALL SELECT 'FMNR','WMN','MAROANTSETRA','MAROANTSETRA','MADAGASCAR',15,26,12,'S',-15.4366666666667,49,41,18,'E',49.6883333333333,13
UNION ALL SELECT 'FMNS','SVB','SAMBAVA SUD','SAMBAVA','MADAGASCAR',14,16,43,'S',-14.2786111111111,50,10,29,'E',50.1747222222222,20
UNION ALL SELECT 'FMNT','TTS','','TSARATANANA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMNV','VOH','VOHIMARINA','VOHEMAR','MADAGASCAR',13,22,33,'S',-13.3758333333333,50,0,10,'E',50.0027777777778,19
UNION ALL SELECT 'FMNW','WAI','ANTSOHIHY AMBALABE','ANTSOHIHY','MADAGASCAR',14,53,55,'S',-14.8986111111111,47,59,38,'E',47.9938888888889,92
UNION ALL SELECT 'FMNX','WMA','','MANDRITSARA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMSB','WBO','','BEROROHA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMSC','WMD','','MANDABE','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMSD','FTU','TOLAGNARO','TOLAGNARO','MADAGASCAR',25,2,17,'S',-25.0380555555556,46,57,22,'E',46.9561111111111,29
UNION ALL SELECT 'FMSF','WFI','FIANARANTSOA','FIANARANTSOA','MADAGASCAR',21,26,29,'S',-21.4413888888889,47,6,42,'E',47.1116666666667,3658
UNION ALL SELECT 'FMSG','RVA','FARAFANGANA','FARAFANGANA','MADAGASCAR',22,48,19,'S',-22.8052777777778,47,49,14,'E',47.8205555555556,26
UNION ALL SELECT 'FMSI','IHO','','IHOSY','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMSJ','MJA','','MANJA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMSK','WVK','MANAKARA SUD','MANAKARA','MADAGASCAR',22,7,11,'S',-22.1197222222222,48,1,18,'E',48.0216666666667,33
UNION ALL SELECT 'FMSL','OVA','','BEKILY','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMSM','MNJ','MANANJARY','MANANJARY','MADAGASCAR',21,12,6,'S',-21.2016666666667,48,21,29,'E',48.3580555555556,20
UNION ALL SELECT 'FMSN','TDV','','TANANDAVA','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMSR','MXM','MOROMBE','MOROMBE','MADAGASCAR',21,45,13,'S',-21.7536111111111,43,22,31,'E',43.3752777777778,16
UNION ALL SELECT 'FMST','TLE','TOLIARA','TOLIARA','MADAGASCAR',23,23,0,'S',-23.3833333333333,43,43,42,'E',43.7283333333333,29
UNION ALL SELECT 'FMSV','BKU','','BETIOKY','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FMSY','AMP','','AMPANIHY','MADAGASCAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FNAM','AZZ','','AMBRIZ','ANGOLA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FNBC','SSY','MBANZA CONGO','M''BANZA-CONGO','ANGOLA',6,16,11,'S',-6.26972222222222,14,14,49,'E',14.2469444444444,1860
UNION ALL SELECT 'FNBG','BUG','BENGUELA','BENGUELA','ANGOLA',12,36,32,'S',-12.6088888888889,13,24,13,'E',13.4036111111111,118
UNION ALL SELECT 'FNCA','CAB','CABINDA','CABINDA','ANGOLA',5,35,49,'S',-5.59694444444444,12,11,18,'E',12.1883333333333,66
UNION ALL SELECT 'FNCH','PGI','CHITATO','CHITATO','ANGOLA',7,21,27,'S',-7.3575,20,48,13,'E',20.8036111111111,2500
UNION ALL SELECT 'FNCM','CBT','','CAMABATELA','ANGOLA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FNCZ','CAV','CAZOMBO','CAZOMBO','ANGOLA',11,53,37,'S',-11.8936111111111,22,54,58,'E',22.9161111111111,3700
UNION ALL SELECT 'FNGI','NGV','NGIVA','N''GIVA','ANGOLA',17,2,41,'S',-17.0447222222222,15,41,13,'E',15.6869444444444,3566
UNION ALL SELECT 'FNHU','NOV','HUAMBO','HUAMBO','ANGOLA',12,48,31,'S',-12.8086111111111,15,45,37,'E',15.7602777777778,5587
UNION ALL SELECT 'FNKU','SVP','KUITO','KUITO','ANGOLA',12,24,16,'S',-12.4044444444444,16,56,50,'E',16.9472222222222,5618
UNION ALL SELECT 'FNLU','LAD','LUANDA 4 DE FEVEREIRO','LUANDA','ANGOLA',8,51,30,'S',-8.85833333333333,13,13,52,'E',13.2311111111111,243
UNION ALL SELECT 'FNMA','MEG','MALANJE','MALANJE','ANGOLA',9,31,30,'S',-9.525,16,18,44,'E',16.3122222222222,3868
UNION ALL SELECT 'FNME','SPP','MENONGUE','MENONGUE','ANGOLA',14,39,27,'S',-14.6575,17,43,11,'E',17.7197222222222,4469
UNION ALL SELECT 'FNNG','GXG','NEGAGE','NEGAGE','ANGOLA',7,45,16,'S',-7.75444444444444,15,17,15,'E',15.2875,4105
UNION ALL SELECT 'FNPA','PBN','PORTO AMBOIM','PORTO AMBOIM','ANGOLA',10,43,19,'S',-10.7219444444444,13,45,55,'E',13.7652777777778,16
UNION ALL SELECT 'FNSA','VHC','SAURIMO','SAURIMO','ANGOLA',9,41,20,'S',-9.68888888888889,20,25,54,'E',20.4316666666667,3584
UNION ALL SELECT 'FNSO','SZA','SOYO','SOYO','ANGOLA',6,8,27,'S',-6.14083333333333,12,22,18,'E',12.3716666666667,15
UNION ALL SELECT 'FNUA','UAL','','LUAU','ANGOLA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FNUB','SDD','','LUBANGO','ANGOLA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FNUE','LUO','LUENA','LUENA','ANGOLA',11,46,5,'S',-11.7680555555556,19,53,51,'E',19.8975,4360
UNION ALL SELECT 'FNUG','UGO','UIGE','UIGE','ANGOLA',7,36,11,'S',-7.60305555555555,15,1,40,'E',15.0277777777778,2720
UNION ALL SELECT 'FNWK','CEO','','WAKO KUNGO','ANGOLA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FNXA','XGN','XANGONGO','XANGONGO','ANGOLA',16,45,19,'S',-16.7552777777778,14,57,55,'E',14.9652777777778,3635
UNION ALL SELECT 'FNZE','ARZ','','N''ZETO','ANGOLA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FOGB','BGB','','BODOUE','GABON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FOGF','FOU','','FOUGAMOU','GABON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FOGI','MGX','','MOABI','GABON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FOGO','OYE','OYEM','OYEM','GABON',1,32,28,'N',1.54111111111111,11,34,51,'E',11.5808333333333,2158
UNION ALL SELECT 'FOGQ','OKN','OKONDJA','OKONDJA','GABON',0,39,55,'S',-0.665277777777778,13,40,23,'E',13.6730555555556,1325
UNION ALL SELECT 'FOGR','LBQ','LAMBARENE','LAMBARENE','GABON',0,42,15,'S',-0.704166666666667,10,14,44,'E',10.2455555555556,82
UNION ALL SELECT 'FOGV','MVX','','MINVOUL','GABON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FOOA','MJL','','MOUILA','GABON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FOOB','BMM','BITAM','BITAM','GABON',2,4,32,'N',2.07555555555556,11,29,35,'E',11.4930555555556,1969
UNION ALL SELECT 'FOOD','MFF','MOANDA','MOANDA','GABON',1,32,15,'S',-1.5375,13,16,9,'E',13.2691666666667,1877
UNION ALL SELECT 'FOOE','MKB','','MEKAMBO','GABON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FOOG','POG','PORT GENTIL','PORT GENTIL','GABON',0,42,42,'S',-0.711666666666667,8,45,15,'E',8.75416666666667,13
UNION ALL SELECT 'FOOH','OMB','OMBOUE HOPITAL','OMBOUE HOSPIAL','GABON',1,34,29,'S',-1.57472222222222,9,15,46,'E',9.26277777777778,33
UNION ALL SELECT 'FOOK','MKU','MAKOKOU','MAKOKOU','GABON',0,34,45,'N',0.579166666666667,12,53,27,'E',12.8908333333333,1726
UNION ALL SELECT 'FOOL','LBV','LIBREVILLE LEON M BA','LIBREVILLE','GABON',0,27,30,'N',0.458333333333333,9,24,44,'E',9.41222222222222,39
UNION ALL SELECT 'FOOM','MZC','MITZIC','MITZIC','GABON',0,46,32,'N',0.775555555555556,11,33,9,'E',11.5525,1913
UNION ALL SELECT 'FOON','MVB','FRANCEVILLE MVENGUE','FRANCEVILLE','GABON',1,39,22,'S',-1.65611111111111,13,26,16,'E',13.4377777777778,1450
UNION ALL SELECT 'FOOR','LTL','LASTOURVILLE','LASTOURVILLE','GABON',0,49,35,'S',-0.826388888888889,12,44,48,'E',12.7466666666667,1585
UNION ALL SELECT 'FOOS','ZKM','','SETTE-CAMA','GABON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FOOT','TCH','TCHIBANGA','TCHIBANGA','GABON',2,53,20,'S',-2.88888888888889,10,55,10,'E',10.9194444444444,269
UNION ALL SELECT 'FOOY','MYB','','MAYUMBA','GABON',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FPPR','PCP','PRINCIPE','PRINCIPE','SAO TOME & PRINCIPE',1,39,46,'N',1.66277777777778,7,24,42,'E',7.41166666666667,591
UNION ALL SELECT 'FPST','TMS','SAO TOME INTERNATIONAL','SAO TOME','SAO TOME & PRINCIPE',0,22,41,'N',0.378055555555556,6,42,43,'E',6.71194444444444,33
UNION ALL SELECT 'FQAG','ANO','','ANGOCHE','MOZAMBIQUE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FQBR','BEW','BEIRA','BEIRA','MOZAMBIQUE',19,47,47,'S',-19.7963888888889,34,54,27,'E',34.9075,33
UNION ALL SELECT 'FQCB','FXO','CUAMBA','CUAMBA','MOZAMBIQUE',14,49,12,'S',-14.82,36,31,55,'E',36.5319444444444,1920
UNION ALL SELECT 'FQIN','INH','INHAMBANE','INHAMBANE','MOZAMBIQUE',23,52,35,'S',-23.8763888888889,35,24,30,'E',35.4083333333333,30
UNION ALL SELECT 'FQLC','VXC','LICHINGA','LICHINGA','MOZAMBIQUE',13,16,26,'S',-13.2738888888889,35,15,58,'E',35.2661111111111,4505
UNION ALL SELECT 'FQMA','MPM','MAPUTO','MAPUTO','MOZAMBIQUE',25,55,15,'S',-25.9208333333333,32,34,21,'E',32.5725,145
UNION ALL SELECT 'FQMP','MZB','MOCIMBOA DA PRAIA','MOCIMBOA DA PRAIA','MOZAMBIQUE',11,21,42,'S',-11.3616666666667,40,21,17,'E',40.3547222222222,89
UNION ALL SELECT 'FQNC','MNC','NACALA','NACALA','MOZAMBIQUE',14,29,17,'S',-14.4880555555556,40,42,44,'E',40.7122222222222,410
UNION ALL SELECT 'FQNP','APL','NAMPULA','NAMPULA','MOZAMBIQUE',15,6,20,'S',-15.1055555555556,39,16,54,'E',39.2816666666667,1444
UNION ALL SELECT 'FQPB','POL','PEMBA','PEMBA','MOZAMBIQUE',12,59,12,'S',-12.9866666666667,40,31,20,'E',40.5222222222222,331
UNION ALL SELECT 'FQQL','UEL','QUELIMANE','QUELIMANE','MOZAMBIQUE',17,51,20,'S',-17.8555555555556,36,52,9,'E',36.8691666666667,36
UNION ALL SELECT 'FQTT','TET','TETE CHINGOZI','TETE','MOZAMBIQUE',16,6,17,'S',-16.1047222222222,33,38,24,'E',33.64,525
UNION ALL SELECT 'FQVL','VNX','VILANKULO','VILANKULU','MOZAMBIQUE',22,1,6,'S',-22.0183333333333,35,18,47,'E',35.3130555555556,46
UNION ALL SELECT 'FSDR','DES','DESROCHES','DESROCHES','SEYCHELLES',5,41,45,'S',-5.69583333333333,53,39,16,'E',53.6544444444444,10
UNION ALL SELECT 'FSIA','SEZ','SEYCHELLES INTERNATIONAL','MAHE','SEYCHELLES',4,40,27,'S',-4.67416666666667,55,31,18,'E',55.5216666666667,10
UNION ALL SELECT 'FSPP','PRI','PRASLIN','PRASLIN','SEYCHELLES',4,19,9,'S',-4.31916666666667,55,41,29,'E',55.6913888888889,10
UNION ALL SELECT 'FSSB','BDI','','BIRD ISLAND','SEYCHELLES',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FSSD','DEI','','DENIS ISLAND','SEYCHELLES',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FTTA','SRH','SARH','SARH','CHAD',9,9,4,'N',9.15111111111111,18,22,46,'E',18.3794444444444,1198
UNION ALL SELECT 'FTTB','OGR','','BONGOR','CHAD',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FTTC','AEH','ABECHE','ABECHE','CHAD',13,50,49,'N',13.8469444444444,20,50,39,'E',20.8441666666667,1788
UNION ALL SELECT 'FTTD','MQQ','MOUNDOU','MOUNDOU','CHAD',8,37,13,'N',8.62027777777778,16,4,6,'E',16.0683333333333,1404
UNION ALL SELECT 'FTTI','ATV','','ATI','CHAD',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FTTJ','NDJ','NDJAMENA','N''DJAMENA','CHAD',12,8,1,'N',12.1336111111111,15,2,2,'E',15.0338888888889,968
UNION ALL SELECT 'FTTK','BKR','','BOKORO','CHAD',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FTTL','OTC','','BOL','CHAD',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FTTM','MVO','','MONGO','CHAD',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FTTN','AMC','','AM-TIMAN','CHAD',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FTTP','PLF','PALA','PALA','CHAD',9,22,45,'N',9.37916666666667,14,55,33,'E',14.9258333333333,1532
UNION ALL SELECT 'FTTS','OUT','','BOUSSO','CHAD',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FTTU','AMO','','MAO','CHAD',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FTTY','FYT','FAYA LARGEAU','FAYA-LARGEAU','CHAD',17,55,1,'N',17.9169444444444,19,6,39,'E',19.1108333333333,771
UNION ALL SELECT 'FVBU','BUQ','JOSHUA MQABUKO NKOMO INTERNATIONAL','BULAWAYO','ZIMBABWE',20,1,2,'S',-20.0172222222222,28,37,4,'E',28.6177777777778,4359
UNION ALL SELECT 'FVCZ','BFO','CHIREDZI BUFFALO RANGE','CHIREDZI','ZIMBABWE',21,0,29,'S',-21.0080555555556,31,34,42,'E',31.5783333333333,1421
UNION ALL SELECT 'FVFA','VFA','VICTORIA FALLS INTERNATIONAL','VICTORIA FALLS','ZIMBABWE',18,5,46,'S',-18.0961111111111,25,50,21,'E',25.8391666666667,3490
UNION ALL SELECT 'FVGR','UTA','MUTARE GRAND REEF','MUTARE','ZIMBABWE',18,58,39,'S',-18.9775,32,27,2,'E',32.4505555555556,3344
UNION ALL SELECT 'FVGW','GWE','','GWERU','ZIMBABWE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FVHA','HRE','HARARE INTERNATIONAL','HARARE','ZIMBABWE',17,55,54,'S',-17.9316666666667,31,5,34,'E',31.0927777777778,4887
UNION ALL SELECT 'FVKB','KAB','KARIBA INTERNATIONAL','KARIBA','ZIMBABWE',16,31,11,'S',-16.5197222222222,28,53,5,'E',28.8847222222222,1706
UNION ALL SELECT 'FVMV','MVZ','MASVINGO','MASVINGO','ZIMBABWE',20,3,19,'S',-20.0552777777778,30,51,32,'E',30.8588888888889,3595
UNION ALL SELECT 'FVSV','VFA','','VICTORIA FALLS','ZIMBABWE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FVTL','GWE','GWERU THORNHILL','GWERT','ZIMBABWE',19,26,12,'S',-19.4366666666667,29,51,42,'E',29.8616666666667,4680
UNION ALL SELECT 'FVWN','WKM','HWANGE NATIONAL PARK','HWANGE NATIONAL PARK','ZIMBABWE',18,37,47,'S',-18.6297222222222,27,1,15,'E',27.0208333333333,3543
UNION ALL SELECT 'FWCL','BLZ','CHILEKA INTERNATIONAL','BLANTYRE','MALAWI',15,40,44,'S',-15.6788888888889,34,58,26,'E',34.9738888888889,2555
UNION ALL SELECT 'FWDW','DWA','','DWANGWA','MALAWI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FWKA','KGJ','KARONGA','KARONGA','MALAWI',9,57,12,'S',-9.95333333333333,33,53,34,'E',33.8927777777778,1765
UNION ALL SELECT 'FWKI','LLW','','LILONGWE','MALAWI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FWMY','MYZ','','MONKEY BAY','MALAWI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FWSM','LMB','','SALIMA','MALAWI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FWUU','ZZU','MZUZU','MZUZU','MALAWI',11,26,41,'S',-11.4447222222222,34,0,42,'E',34.0116666666667,4115
UNION ALL SELECT 'FXLR','LRB','','LERIBE','LESOTHO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FXLS','LES','','LESOBENG','LESOTHO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FXMF','MFC','','MAFETENG','LESOTHO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FXMK','MKH','','MOKHOTLONG','LESOTHO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FXMM','MSU','MOSHOESHOE I INTERNATIONAL','MASERU','LESOTHO',29,27,44,'S',-29.4622222222222,27,33,9,'E',27.5525,5351
UNION ALL SELECT 'FXNK','NKU','','NKAUS','LESOTHO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FXQN','UNE','','QACHAS NEK','LESOTHO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FXSH','SHK','','SEHONGHONG','LESOTHO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FXSM','SOK','','SEMONKONG','LESOTHO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZAA','FIH','KINSHASA NDJILI INTERNATIONAL','KINSHASA','ZAIRE',4,23,8,'S',-4.38555555555556,15,26,40,'E',15.4444444444444,1027
UNION ALL SELECT 'FZAB','NLO','KINSHASA NDOLO','KINSHASA','ZAIRE',4,19,29,'S',-4.32472222222222,15,19,42,'E',15.3283333333333,915
UNION ALL SELECT 'FZAG','MNB','MUANDA','MUANDA','ZAIRE',5,55,51,'S',-5.93083333333333,12,21,6,'E',12.3516666666667,89
UNION ALL SELECT 'FZAM','MAT','MATADI TSHIMPI','MATADI','ZAIRE',5,47,58,'S',-5.79944444444444,13,26,27,'E',13.4408333333333,1115
UNION ALL SELECT 'FZBA','INO','','INONGO','ZAIRE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZBO','FDU','BANDUNDU','BANDOUNDU','ZAIRE',3,18,40,'S',-3.31111111111111,17,22,54,'E',17.3816666666667,1063
UNION ALL SELECT 'FZCA','KKW','KIKWIT','KIKWIT','ZAIRE',5,2,8,'S',-5.03555555555556,18,47,8,'E',18.7855555555556,1572
UNION ALL SELECT 'FZDO','MNB','','MOANZA','ZAIRE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZEA','MDK','MBANDAKA','MBANDAKA','ZAIRE',0,1,21,'N',0.0225,18,17,19,'E',18.2886111111111,1040
UNION ALL SELECT 'FZEN','BSU','','BASANKUSU','ZAIRE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZFD','BDT','GBADOLITE','GBADOLITE','ZAIRE',4,15,11,'N',4.25305555555556,20,58,31,'E',20.9752777777778,1509
UNION ALL SELECT 'FZFK','GMA','GEMENA','GEMENA','ZAIRE',3,14,7,'N',3.23527777777778,19,46,16,'E',19.7711111111111,1378
UNION ALL SELECT 'FZFU','BMB','','BUMBA','ZAIRE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZGA','LIQ','LISALA','LISALA','ZAIRE',2,10,14,'N',2.17055555555556,21,29,48,'E',21.4966666666667,1509
UNION ALL SELECT 'FZGN','BNB','','BOENDE','ZAIRE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZIA','FKI','KISANGANI SIMISINI','KISANGANI','ZAIRE',0,31,3,'N',0.5175,25,9,18,'E',25.155,1289
UNION ALL SELECT 'FZJH','IRP','ISIRO MATARI','ISIRO','ZAIRE',2,49,39,'N',2.8275,27,35,17,'E',27.5880555555556,2438
UNION ALL SELECT 'FZKA','BUX','BUNIA','BUNIA','ZAIRE',1,33,56,'N',1.56555555555556,30,13,15,'E',30.2208333333333,4045
UNION ALL SELECT 'FZMA','BKY','BUKAVU KAVUMU','BUKAVU/KAVUMU','ZAIRE',2,18,32,'S',-2.30888888888889,28,48,31,'E',28.8086111111111,5643
UNION ALL SELECT 'FZNA','GOM','GOMA','GOMA','ZAIRE',1,40,14,'S',-1.67055555555556,29,14,18,'E',29.2383333333333,5089
UNION ALL SELECT 'FZNP','BNC','','BENI','ZAIRE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZOA','KND','KINDU','KINDU','ZAIRE',2,55,9,'S',-2.91916666666667,25,54,55,'E',25.9152777777778,1630
UNION ALL SELECT 'FZOF','KWH','','KIAPUPE','ZAIRE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZQA','FBM','LUBUMBASHI INTERNATIONAL','LUBUMASHI','ZAIRE',11,35,28,'S',-11.5911111111111,27,31,51,'E',27.5308333333333,4295
UNION ALL SELECT 'FZQM','KWZ','KOLWEZI','KOLWEZI','ZAIRE',10,45,57,'S',-10.7658333333333,25,30,20,'E',25.5055555555556,5007
UNION ALL SELECT 'FZRF','FMI','KALEMIE','KALEMIE','ZAIRE',5,52,32,'S',-5.87555555555556,29,15,0,'E',29.25,2569
UNION ALL SELECT 'FZRQ','KOO','','KONGOLO','ZAIRE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZSA','KMN','KAMINA BASE','KAMINA BASE','ZAIRE',8,38,31,'S',-8.64194444444444,25,15,10,'E',25.2527777777778,3543
UNION ALL SELECT 'FZUA','KGA','KANANGA','KANANGA','ZAIRE',5,54,0,'S',-5.9,22,28,9,'E',22.4691666666667,2139
UNION ALL SELECT 'FZUK','TSH','','TSHIKAPA','ZAIRE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZVA','LJA','','LODJA','ZAIRE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'FZWA','MJM','MBUJI MAYI','MBUJI-MAYI','ZAIRE',6,7,16,'S',-6.12111111111111,23,34,8,'E',23.5688888888889,2221
UNION ALL SELECT 'GABS','BKO','BAMAKO SENOU','BAMAKO','MALI',12,32,0,'N',12.5333333333333,7,56,59,'U',0,1247
UNION ALL SELECT 'GAGM','GUD','','GOUNDAM','MALI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GAGO','GAQ','GAO','GAO','MALI',16,14,54,'N',16.2483333333333,0,0,19,'U',0,869
UNION ALL SELECT 'GAKO','KTX','','KOUTIALA','MALI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GAKY','KYS','KAYES','KAYES','MALI',14,25,52,'N',14.4311111111111,11,26,22,'U',0,161
UNION ALL SELECT 'GAMB','MZI','MOPTI AMBODEDJO','MOPTI','MALI',14,30,46,'N',14.5127777777778,4,4,46,'U',0,906
UNION ALL SELECT 'GANK','NRM','','NARA','MALI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GANR','NIX','NIORO','NIORO','MALI',15,14,19,'N',15.2386111111111,9,34,35,'U',0,778
UNION ALL SELECT 'GASK','KSS','','SIKASSO','MALI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GATB','TOM','TOMBOUCTOU','TOMBOUCTOU','MALI',16,43,49,'N',16.7302777777778,3,0,27,'U',0,863
UNION ALL SELECT 'GAYE','EYL','','YELIMANE','MALI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GBYD','BJL','BANJUL INTERNATIONAL','BANJUL','GAMBIA',13,20,16,'N',13.3377777777778,16,39,7,'U',0,95
UNION ALL SELECT 'GCFV','FUE','FUERTEVENTURA','FUERTEVENTURA','CANARY ISLANDS',28,27,9,'N',28.4525,13,51,49,'U',0,72
UNION ALL SELECT 'GCHI','VDE','HIERRO','HIERRO','CANARY ISLANDS',27,48,53,'N',27.8147222222222,17,53,13,'U',0,102
UNION ALL SELECT 'GCLA','SPC','LA PALMA','SANTA CRUZ DE LA PALMA','SPAIN',28,37,35,'N',28.6263888888889,17,45,20,'U',0,107
UNION ALL SELECT 'GCLP','LPA','GRAN CANARIA','GRAN CANARIA','CANARY ISLANDS',27,55,54,'N',27.9316666666667,15,23,11,'U',0,78
UNION ALL SELECT 'GCRR','ACE','LANZAROTE','LANZEROTE','CANARY ISLANDS',28,56,43,'N',28.9452777777778,13,36,18,'U',0,47
UNION ALL SELECT 'GCTS','TFS','TENERIFE SUR','TENERIFE','CANARY ISLANDS',28,2,40,'N',28.0444444444444,16,34,20,'U',0,209
UNION ALL SELECT 'GCXO','TFN','TENERIFE NORTE','TENERIFE','CANARY ISLANDS',28,28,57,'N',28.4825,16,20,29,'U',0,2073
UNION ALL SELECT 'GEML','MLN','MELILLA','MELILLA','SPANISH NORTH AFRICA',35,16,47,'N',35.2797222222222,2,57,22,'U',0,156
UNION ALL SELECT 'GFBN','BTE','','BONTHE','SIERRA LEONE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GFBO','KBS','','BO','SIERRA LEONE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GFGK','GBK','','GBANGBATOK','SIERRA LEONE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GFHA','HGS','HASTINGS','HASTINGS','SIERRA LEONE',8,23,40,'N',8.39444444444444,13,7,42,'U',0,60
UNION ALL SELECT 'GFKB','KBA','','KABALA','SIERRA LEONE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GFKE','KEN','','KENEMA','SIERRA LEONE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GFLL','FNA','FREETOWN LUNGI','FREETOWN','SIERRA LEONE',8,36,59,'N',8.61638888888889,13,11,43,'U',0,84
UNION ALL SELECT 'GFYE','WYE','','YENGEMA','SIERRA LEONE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GGOV','BXO','BISSAU OSWALDO VIEIRA INTERNATIONAL','BISSAU','GUINEA BISSAU',11,53,41,'N',11.8947222222222,15,39,13,'U',0,129
UNION ALL SELECT 'GLBU','UCN','','BUCHANAN','LIBERIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GLCP','CPA','','HARPER','LIBERIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GLGE','SNI','','GREENVILLE','LIBERIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GLMR','MLW','MONROVIA SPRIGGS PAYNE','MONROVIA','LIBERIA',6,17,20,'N',6.28888888888889,10,45,31,'U',0,25
UNION ALL SELECT 'GLNA','NIA','','GRASSFIELD','LIBERIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GLRB','ROB','MONROVIA ROBERTS INTERNATIONAL','MONROVIA','LIBERIA',6,14,1,'N',6.23361111111111,10,21,44,'U',0,31
UNION ALL SELECT 'GLTN','THC','','TCHIEN','LIBERIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GMAA','AGA','INEZGANE','AGADIR','MOROCCO',30,22,52,'N',30.3811111111111,9,32,46,'U',0,89
UNION ALL SELECT 'GMAT','TTA','PLAGE BLANCHE','TAN TAN','MOROCCO',28,26,53,'N',28.4480555555556,11,9,40,'U',0,653
UNION ALL SELECT 'GMFF','FEZ','SAISS','FEZ','MOROCCO',33,55,38,'N',33.9272222222222,4,58,40,'U',0,1900
UNION ALL SELECT 'GMFK','ERH','MOULAY ALI CHERIF','ER-RACHIDIA','MOROCCO',31,56,56,'N',31.9488888888889,4,24,2,'U',0,3428
UNION ALL SELECT 'GMFM','MEK','BASSATINE','MEKNES','MOROCCO',33,52,44,'N',33.8788888888889,5,30,54,'U',0,1890
UNION ALL SELECT 'GMFO','OUD','ANGADS','OUJDA','MOROCCO',34,47,13,'N',34.7869444444444,1,55,26,'U',0,1535
UNION ALL SELECT 'GMMC','CAS','ANFA','CASABLANCA','MOROCCO',33,33,12,'N',33.5533333333333,7,39,41,'U',0,203
UNION ALL SELECT 'GMME','RBA','SALE','RABAT','MOROCCO',34,3,5,'N',34.0513888888889,6,45,5,'U',0,276
UNION ALL SELECT 'GMMF','SII','SIDI IFNI','SIDI IFINI','MOROCCO',29,22,8,'N',29.3688888888889,10,10,48,'U',0,190
UNION ALL SELECT 'GMMN','CMN','MOHAMMED V','CASABLANCA','MOROCCO',33,22,4,'N',33.3677777777778,7,35,16,'U',0,656
UNION ALL SELECT 'GMMS','SFI','','SAFI','MALTA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GMMX','RAK','MENARA','MARRAKECH','MOROCCO',31,36,24,'N',31.6066666666667,8,2,10,'U',0,1535
UNION ALL SELECT 'GMMY','NNA','KENITRA','KENTIRA','MOROCCO',34,17,56,'N',34.2988888888889,6,35,45,'U',0,16
UNION ALL SELECT 'GMMZ','OZZ','OUARZAZATE','OUARZAZATE','MOROCCO',30,56,20,'N',30.9388888888889,6,54,33,'U',0,3783
UNION ALL SELECT 'GMTA','AHU','CHERIF EL IDRISSI','AL HOCIEMA','MOROCCO',35,10,37,'N',35.1769444444444,3,50,22,'U',0,89
UNION ALL SELECT 'GMTN','TTU','SANIAT RMEL','TETOUAN','MOROCCO',35,35,39,'N',35.5941666666667,5,19,12,'U',0,10
UNION ALL SELECT 'GMTT','TNG','IBN BATOUTA','TANGER','MOROCCO',35,43,36,'N',35.7266666666667,5,55,0,'U',0,62
UNION ALL SELECT 'GOGG','ZIG','ZIGUINCHOR','ZIGUINCHOR','SENEGAL',12,33,20,'N',12.5555555555556,16,16,54,'U',0,75
UNION ALL SELECT 'GOGK','KDA','KOLDA','KOLDA','SENEGAL',12,52,48,'N',12.88,14,57,19,'U',0,3
UNION ALL SELECT 'GOGS','CSK','CAP SKIRING','CAP SKIRING','SENEGAL',12,24,36,'N',12.41,16,44,46,'U',0,52
UNION ALL SELECT 'GOOK','KLC','KAOLACK','KAOLACK','SENEGAL',14,8,48,'N',14.1466666666667,16,3,4,'U',0,26
UNION ALL SELECT 'GOOY','DKR','LEOPOLD SEDAR SENGHOR INTERNATIONAL','DAKAR','SENEGAL',14,44,22,'N',14.7394444444444,17,29,24,'U',0,85
UNION ALL SELECT 'GOSM','MAX','','MATAM','SENEGAL',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GOSP','POD','','PODOR','SENEGAL',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GOSR','RDT','','RICHARD TOLL','SENEGAL',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GOSS','XLS','SAINT LOUIS','ST. LOUIS','SENEGAL',16,2,59,'N',16.0497222222222,16,27,40,'U',0,9
UNION ALL SELECT 'GOTB','BXE','BAKEL','BAKEL','SENEGAL',14,50,50,'N',14.8472222222222,12,28,5,'U',0,98
UNION ALL SELECT 'GOTK','KGG','KEDOUGOU','KEDOUGOU','SENEGAL',12,34,20,'N',12.5722222222222,12,13,13,'U',0,584
UNION ALL SELECT 'GOTS','SMY','','SIMENTI','SENEGAL',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GOTT','TUD','TAMBACOUNDA','TAMBACOUNDA','SENEGAL',13,44,12,'N',13.7366666666667,13,39,11,'U',0,161
UNION ALL SELECT 'GQNA','IEO','AIOUN EL ATROUSS','AIOUN EL ATROUSS','MAURITANIA',16,42,40,'N',16.7111111111111,9,38,16,'U',0,951
UNION ALL SELECT 'GQNB','OTL','','BOUTILIMIT','MAURITANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GQNC','THI','','TICHITT','MAURITANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GQND','TIY','TIDJIKJA','TIDJIKJA','MAURITANIA',18,34,13,'N',18.5702777777778,11,25,23,'U',0,132
UNION ALL SELECT 'GQNE','BGH','','BOGUE','MAURITANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GQNF','KFA','KIFFA','KIFFA','MAURITANIA',16,35,23,'N',16.5897222222222,11,24,22,'U',0,423
UNION ALL SELECT 'GQNI','EMN','NEMA','NEMA','MAURITANIA',16,37,19,'N',16.6219444444444,7,18,52,'U',0,758
UNION ALL SELECT 'GQNJ','AJJ','','AKJOUJT','MAURITANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GQNK','KED','KAEDI','KAEDI','MAURITANIA',16,9,34,'N',16.1594444444444,13,30,27,'U',0,75
UNION ALL SELECT 'GQNL','MOM','','MOUDJERIA','MAURITANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GQNM','TMD','','TIMBEDRA','MAURITANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GQNN','NKC','NOUAKCHOTT','NOUAKSCHOTT','MAURITANIA',18,5,52,'N',18.0977777777778,15,56,52,'U',0,7
UNION ALL SELECT 'GQNS','SEY','SELIBADY','SELIBABI','MAURITANIA',15,10,46,'N',15.1794444444444,12,12,26,'U',0,262
UNION ALL SELECT 'GQNT','THT','','TAMCHAKETT','MAURITANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GQPA','ATR','ATAR','ATAR','MAURITANIA',20,30,24,'N',20.5066666666667,13,2,35,'U',0,758
UNION ALL SELECT 'GQPF','FGD','','F''DERIK','MAURITANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GQPP','NDB','NOUADHIBOU','NOUADHIBOU','MAURITANIA',20,55,42,'N',20.9283333333333,17,1,52,'U',0,16
UNION ALL SELECT 'GQPZ','OUZ','','ZOUERATT','MAURITANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GUFA','FIG','FRIA','FIRA','GUINEA',10,21,2,'N',10.3505555555556,13,34,9,'U',0,498
UNION ALL SELECT 'GUFH','FAA','FARANAH','FARANAH','GUINEA',10,2,8,'N',10.0355555555556,10,46,11,'U',0,1476
UNION ALL SELECT 'GUKU','KSI','','KISSIDOUGOU','GUINEA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GULB','LEK','LABE','LABE','GUINEA',11,19,34,'N',11.3261111111111,12,17,13,'U',0,3396
UNION ALL SELECT 'GUMA','MCA','MACENTA','MACENTA','GUINEA',8,28,52,'N',8.48111111111111,9,31,33,'U',0,1690
UNION ALL SELECT 'GUNZ','NZE','NZEREKORE','N''ZEREKORE','GUINEA',7,48,21,'N',7.80583333333333,8,42,6,'U',0,1657
UNION ALL SELECT 'GUOK','BKJ','','BOKE','GUINEA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GUSB','SBI','','KOUNDARA','GUINEA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GUSI','GII','','SIGUIRI','GUINEA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GUXN','KNN','','KANKAN','GUINEA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GVAC','SID','AMILCAR CABRAL INTERNATIONAL','AMILCAR CABRAL','CAPE VERDE ISLANDS',16,44,29,'N',16.7413888888889,22,56,58,'U',0,177
UNION ALL SELECT 'GVBA','BVC','RABIL','BOA VISTA','CAPE VERDE ISLANDS',16,8,12,'N',16.1366666666667,22,53,20,'U',0,69
UNION ALL SELECT 'GVFM','RAI','FRANCISCO MENDES','FRANCISCO MENDEZ','CAPE VERDE ISLANDS',14,55,28,'N',14.9244444444444,23,29,36,'U',0,230
UNION ALL SELECT 'GVMA','MMO','MAIO','MAIO','CAPE VERDE ISLANDS',15,9,21,'N',15.1558333333333,23,12,49,'U',0,36
UNION ALL SELECT 'GVPR','RAI','','PRAIA','CAPE VERDE ISLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'GVSN','SNE','PREGUICA','SAO NOCOLAU ISLAND','CAPE VERDE ISLANDS',16,35,18,'N',16.5883333333333,24,17,4,'U',0,669
UNION ALL SELECT 'GVSV','VXE','SAO PEDRO','SAO VICENTE ISLAND','CAPE VERDE ISLANDS',16,50,2,'N',16.8338888888889,25,3,24,'U',0,66
UNION ALL SELECT 'HAAB','ADD','BOLE INTERNATIONAL','ADDIS ABABA','ETHIOPIA',8,58,37,'N',8.97694444444445,38,48,0,'E',38.8,7621
UNION ALL SELECT 'HAAM','AMH','','ARBA MINCH','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAAX','AXU','','AXUM','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAAY','ASM','','ASMARA','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HABB','XBL','','BUNNO BEDELE','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HABC','BCO','','BACO','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HABD','BJR','BAHIR DAR','BAHAR DAR','ETHIOPIA',11,36,29,'N',11.6080555555556,37,19,17,'E',37.3213888888889,5999
UNION ALL SELECT 'HABE','BEI','','BEICA','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HABU','BCY','','BULCHI','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HADC','DSE','','DESSIE','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HADD','DEM','','DEMBIDOLLO','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HADK','ABK','','KABRE DARE','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HADM','DBM','','DEBRE MARCOS','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HADR','DIR','ABA TENNA DEJAZMATCH YILMA INTERNATIONAL','DIRE DAWA','ETHIOPIA',9,37,30,'N',9.625,41,51,15,'E',41.8541666666667,3750
UNION ALL SELECT 'HADT','DBT','','DEBRE TABOR','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAGB','GOB','','GOBA','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAGH','GNN','','GHINNIR','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAGM','GMB','GAMBELLA','GAMBELLA','ETHIOPIA',8,7,42,'N',8.12833333333333,34,33,48,'E',34.5633333333333,1591
UNION ALL SELECT 'HAGN','GDQ','GONDER','GONDAR','ETHIOPIA',12,31,6,'N',12.5183333333333,37,25,56,'E',37.4322222222222,645
UNION ALL SELECT 'HAGO','GCE','','GODE','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAGR','GOR','','GORE','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAHU','HUE','','HUMERA','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAJM','JIM','ABA SEGUD','JIMMA','ETHIOPIA',7,39,57,'N',7.66583333333333,36,48,59,'E',36.8163888888889,5520
UNION ALL SELECT 'HALA','AWA','','AWASA','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HALL','LLI','LALIBELLA','LALIBELLA','ETHIOPIA',11,58,29,'N',11.9747222222222,38,58,47,'E',38.9797222222222,6500
UNION ALL SELECT 'HAMK','MQX','MEKELE','MAKALE','ETHIOPIA',13,28,2,'N',13.4672222222222,39,32,0,'E',39.5333333333333,7320
UNION ALL SELECT 'HAML','MZX','','MASSLO','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAMM','ETE','','METEMA','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAMN','NDM','','MENDI','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAMO','OTA','','MOTA','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAMR','MUJ','','MUI RIVER','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAMS','MSW','','MASSAWA','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAMT','MTF','','MIZAN TEFERI','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HANK','NEK','','NEKEMTE','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HASB','ASA','','ASSAB','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HASD','SXU','','SODO','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HASO','ASO','','ASOSA','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HATP','TIE','','TIPPI','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HATS','TES','','TESSENEI','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HAWC','WAC','','WACCA','ETHIOPIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HBBA','BJM','BUJUMBURA INTERNATIONAL','BUJUMBURA','BURUNDI',3,19,26,'S',-3.32388888888889,29,19,6,'E',29.3183333333333,2582
UNION ALL SELECT 'HBBE','GID','','GITEGA','BURUNDI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HBBO','KRE','','KIRUNDO','BURKINA FASO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HCMA','ALU','','ALULA','SOMALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HCMH','HGA','HARGEISA','HARGEISA','SOMALIA',9,31,5,'N',9.51805555555556,44,5,19,'E',44.0886111111111,4423
UNION ALL SELECT 'HCMI','BBO','BERBERA','BERBERA','SOMALIA',10,23,21,'N',10.3891666666667,44,56,27,'E',44.9408333333333,30
UNION ALL SELECT 'HCMK','KMU','KISIMAYU','KISMAYU','SOMALIA',0,22,38,'S',-0.377222222222222,42,27,33,'E',42.4591666666667,49
UNION ALL SELECT 'HCMM','MGQ','MOGADISHU','MOGADISHU','SOMALIA',2,0,49,'N',2.01361111111111,45,18,17,'E',45.3047222222222,31
UNION ALL SELECT 'HCMR','GLK','','GALCAIO','SOMALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HCMV','BUO','','BURAO','SOMALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HEAX','ALY','ALEXANDRIA INTERNATIONAL','ALEXANDRIA','EGYPT',31,11,2,'N',31.1838888888889,29,56,56,'E',29.9488888888889,5
UNION ALL SELECT 'HEBL','ABS','ABU SIMBEL','ABU SIMBEL','EGYPT',22,22,33,'N',22.3758333333333,31,36,42,'E',31.6116666666667,616
UNION ALL SELECT 'HECA','CAI','CAIRO INTERNATIONAL','CAIRO','EGYPT',30,7,19,'N',30.1219444444444,31,24,20,'E',31.4055555555556,382
UNION ALL SELECT 'HEGN','HRG','HURGHADA INTERNATIONAL','HURGHADA','EGYPT',27,11,2,'N',27.1838888888889,33,47,54,'E',33.7983333333333,52
UNION ALL SELECT 'HELX','LXR','LUXOR INTERNATIONAL','LUXOR','EGYPT',25,40,15,'N',25.6708333333333,32,42,23,'E',32.7063888888889,294
UNION ALL SELECT 'HEMM','MUH','MERSA MATRUH','MERSA-MATRUH','EGYPT',31,19,31,'N',31.3252777777778,27,13,18,'E',27.2216666666667,94
UNION ALL SELECT 'HENY','UVL','','NEW VALLEY','EGYPT',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HEPS','PSD','PORT SAID','PORT SAID','EGYPT',31,16,46,'N',31.2794444444444,32,14,24,'E',32.24,8
UNION ALL SELECT 'HESC','SKV','ST CATHERINE INTERNATIONAL','ST. CATHERINE','EGYPT',28,41,7,'N',28.6852777777778,34,3,45,'E',34.0625,4368
UNION ALL SELECT 'HESN','ASW','ASWAN INTERNATIONAL','ASWAN','EGYPT',23,57,51,'N',23.9641666666667,32,49,11,'E',32.8197222222222,662
UNION ALL SELECT 'HETR','ELT','EL TOR','EL-TOR','EGYPT',28,12,32,'N',28.2088888888889,33,38,43,'E',33.6452777777778,115
UNION ALL SELECT 'HFFF','JIB','','DJIBOUTI','DJIBOUTI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HKAM','ASV','','AMBOSELI','KENYA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HKEL','EDL','ELDORET INTERNATIONAL','ELDORET','KENYA',0,24,15,'N',0.404166666666667,35,14,17,'E',35.2380555555556,6941
UNION ALL SELECT 'HKFG','FER','','KALOKOL','KENYA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HKGA','GAS','GARISSA','GARISSA','KENYA',0,27,48,'S',-0.463333333333333,39,38,53,'E',39.6480555555556,475
UNION ALL SELECT 'HKKI','KIS','KISUMU','KISUMU','KENYA',0,5,10,'S',-0.0861111111111111,34,43,44,'E',34.7288888888889,3965
UNION ALL SELECT 'HKKL','ILU','','KILAGUNI','KENYA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HKKR','KEY','','KERICHO','KENYA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HKKT','KTL','KITALE','KITALE','KENYA',0,58,19,'N',0.971944444444444,34,57,30,'E',34.9583333333333,6070
UNION ALL SELECT 'HKLO','LOK','LODWAR','LODWAR','KENYA',3,7,19,'N',3.12194444444444,35,36,31,'E',35.6086111111111,1715
UNION ALL SELECT 'HKLU','LAU','LAMU MANDA','LAMU','KENYA',2,15,8,'S',-2.25222222222222,40,54,47,'E',40.9130555555556,20
UNION ALL SELECT 'HKLY','LOY','LOYENGALANI','LOYANGALANI','KENYA',2,45,47,'N',2.76305555555556,36,43,6,'E',36.7183333333333,1195
UNION ALL SELECT 'HKMA','NDE','MANDERA','MANDERA','KENYA',3,56,1,'N',3.93361111111111,41,50,39,'E',41.8441666666667,805
UNION ALL SELECT 'HKMB','RBT','MARSABIT','MARSABIT','KENYA',2,20,42,'N',2.345,37,59,57,'E',37.9991666666667,4395
UNION ALL SELECT 'HKML','MYD','MALINDI','MALINDI','KENYA',3,13,45,'S',-3.22916666666667,40,6,6,'E',40.1016666666667,80
UNION ALL SELECT 'HKMO','MBA','MOI INTERNATIONAL','MOMBASA','KENYA',4,2,5,'S',-4.03472222222222,39,35,39,'E',39.5941666666667,200
UNION ALL SELECT 'HKMY','OYL','MOYALE LOWER','MOYALE LOWER','KENYA',3,28,11,'N',3.46972222222222,39,6,5,'E',39.1013888888889,2790
UNION ALL SELECT 'HKNA','NBO','','NAIROBI','KENYA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HKNI','NYE','NYERI','NYERI','KENYA',0,22,8,'S',-0.368888888888889,36,58,48,'E',36.98,5830
UNION ALL SELECT 'HKNK','NUU','','NAKURU','KENYA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HKNW','WIL','NAIROBI WILSON','NAIROBI','KENYA',1,19,18,'S',-1.32166666666667,36,48,53,'E',36.8147222222222,5536
UNION ALL SELECT 'HKNY','NYK','NANYUKI','NANYUKI','KENYA',0,3,39,'S',-0.0608333333333333,37,2,19,'E',37.0386111111111,6250
UNION ALL SELECT 'HKSB','UAS','','SAMBURU','KENYA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HKWJ','WJR','WAJIR','WAJIR','KENYA',1,43,59,'N',1.73305555555556,40,5,29,'E',40.0913888888889,770
UNION ALL SELECT 'HLGT','GHT','GHAT','GHAT','LIBYA',25,8,44,'N',25.1455555555556,10,8,33,'E',10.1425,2296
UNION ALL SELECT 'HLKF','AKF','KUFRA','KUFRA','LIBYA',24,10,43,'N',24.1786111111111,23,18,50,'E',23.3138888888889,1367
UNION ALL SELECT 'HLLB','BEN','BENINA','BENGHAZI','LIBYA',32,5,48,'N',32.0966666666667,20,16,10,'E',20.2694444444444,433
UNION ALL SELECT 'HLLS','SEB','SEBHA','SEBHA','LIBYA',26,59,13,'N',26.9869444444444,14,28,21,'E',14.4725,1427
UNION ALL SELECT 'HLLT','TIP','TRIPOLI INTERNATIONAL','TRIPOLI','LIBYA',32,39,48,'N',32.6633333333333,13,9,32,'E',13.1588888888889,263
UNION ALL SELECT 'HLTD','LTD','GHADAMES EAST','GHADAMES','LIBYA',30,9,6,'N',30.1516666666667,9,42,55,'E',9.71527777777778,1122
UNION ALL SELECT 'HRYG','GYI','GISENYI','GISENYI','RWANDA',1,40,37,'S',-1.67694444444444,29,15,31,'E',29.2586111111111,5098
UNION ALL SELECT 'HRYR','KGL','KIGALI INTERNATIONAL','KIGALI','RWANDA',1,58,7,'S',-1.96861111111111,30,8,22,'E',30.1394444444444,4892
UNION ALL SELECT 'HRYU','RHG','','RUHENGERI','RWANDA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HRZA','KME','KAMEMBE','KAMEMBE','RWANDA',2,27,44,'S',-2.46222222222222,28,54,28,'E',28.9077777777778,5220
UNION ALL SELECT 'HSAT','ATB','','ATBARA','SUDAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HSCN','EGN','','GENEINA','SUDAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HSDN','DOG','DONGOLA','DONGOLA','SUDAN',19,9,13,'N',19.1536111111111,30,25,48,'E',30.43,773
UNION ALL SELECT 'HSFS','ELF','EL FASHER','EL FASHER','SUDAN',13,36,54,'N',13.615,25,19,29,'E',25.3247222222222,2404
UNION ALL SELECT 'HSKA','KSL','KASSALA','KASSALA','SUDAN',15,23,9,'N',15.3858333333333,36,19,41,'E',36.3280555555556,1667
UNION ALL SELECT 'HSMR','MWE','','MEROWE','SUDAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HSNL','UYL','NYALA','NYALA','SUDAN',12,3,13,'N',12.0536111111111,24,57,19,'E',24.9552777777778,2149
UNION ALL SELECT 'HSOB','EBD','EL OBEID','EL OBEID','SUDAN',13,9,11,'N',13.1530555555556,30,13,57,'E',30.2325,1883
UNION ALL SELECT 'HSSJ','JUB','JUBA','JUBA','SUDAN',4,52,19,'N',4.87194444444444,31,36,4,'E',31.6011111111111,1509
UNION ALL SELECT 'HSSM','MAK','MALAKAL','MALAKAL','SUDAN',9,33,31,'N',9.55861111111111,31,39,9,'E',31.6525,1270
UNION ALL SELECT 'HSSP','PZU','PORT SUDAN','PORT SUDAN','SUDAN',19,34,35,'N',19.5763888888889,37,12,57,'E',37.2158333333333,10
UNION ALL SELECT 'HSSS','KRT','KHARTOUM','KHARTOUM','SUDAN',15,35,22,'N',15.5894444444444,32,33,11,'E',32.5530555555556,1261
UNION ALL SELECT 'HSWW','WUU','WAU','WAU','SUDAN',7,43,32,'N',7.72555555555556,27,58,46,'E',27.9794444444444,1420
UNION ALL SELECT 'HTAR','ARK','ARUSHA','ARUSHA','TANZANIA',3,22,4,'S',-3.36777777777778,36,38,0,'E',36.6333333333333,4550
UNION ALL SELECT 'HTBU','BKZ','','BUKOBA','TANZANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HTDA','DAR','DAR ES SALAAM','DAR ES SALAAM','TANZANIA',6,52,41,'S',-6.87805555555556,39,12,9,'E',39.2025,182
UNION ALL SELECT 'HTDO','DOD','DODOMA','DODOMA','TANZANIA',6,10,13,'S',-6.17027777777778,35,45,9,'E',35.7525,3637
UNION ALL SELECT 'HTIR','IRI','IRINGA','IRINGA','TANZANIA',7,40,7,'S',-7.66861111111111,35,45,7,'E',35.7519444444444,4678
UNION ALL SELECT 'HTKJ','JRO','KILIMANJARO INTERNATIONAL','KILIMANJARO','TANZANIA',3,25,45,'S',-3.42916666666667,37,4,28,'E',37.0744444444444,2932
UNION ALL SELECT 'HTLI','LDI','','LINDI','TANZANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HTMA','MFA','','MAFIA','TANZANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HTMS','QSI','MOSHI','MOSHI','TANZANIA',3,21,46,'S',-3.36277777777778,37,19,24,'E',37.3233333333333,2801
UNION ALL SELECT 'HTMT','MYW','MTWARA','MTWARA','TANZANIA',10,20,20,'S',-10.3388888888889,40,10,54,'E',40.1816666666667,371
UNION ALL SELECT 'HTMU','MUZ','','MUSOMA','TANZANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HTMW','MWZ','MWANZA','MWANZA','TANZANIA',2,26,40,'S',-2.44444444444444,32,55,57,'E',32.9325,3763
UNION ALL SELECT 'HTNA','NCH','','NACHINGWEA','TANZANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HTPE','PMA','PEMBA','PEMBA','TANZANIA',5,15,26,'S',-5.25722222222222,39,48,41,'E',39.8113888888889,80
UNION ALL SELECT 'HTSO','SGX','','SONGEA','TANZANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HTSU','SUT','','SUMBAWANGA','TANZANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HTSY','SHY','','SHINYANGA','TANZANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HTTB','TBO','','TABORA','TANZANIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HTTG','TGT','TANGA','TANGA','TANZANIA',5,5,32,'S',-5.09222222222222,39,4,16,'E',39.0711111111111,129
UNION ALL SELECT 'HTZA','ZNZ','ZANZIBAR','ZANZIBAR','TANZANIA',6,13,19,'S',-6.22194444444444,39,13,29,'E',39.2247222222222,54
UNION ALL SELECT 'HUAR','RUA','','ARUA','UGANDA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HUEN','EBB','ENTEBBE INTERNATIONAL','ENTEBBE','UGANDA',0,2,32,'N',0.0422222222222222,32,26,36,'E',32.4433333333333,3782
UNION ALL SELECT 'HUKS','KSE','','KASESE','UGANDA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'HUSO','SRT','SOROTI','SOROTI','UGANDA',1,43,39,'N',1.7275,33,37,22,'E',33.6227777777778,3697
UNION ALL SELECT 'KABI','ABI','ABILENE RGNL','ABILENE','USA',32,24,40,'N',32.4111111111111,99,40,54,'U',0,1791
UNION ALL SELECT 'KABQ','ABQ','','ALBUQUERQUE','USA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'KACK','ACK','NANTUCKET MEM','NANTUCKET','USA',41,15,10,'N',41.2527777777778,70,3,36,'U',0,48
UNION ALL SELECT 'KACT','ACT','WACO RGNL','WACO','USA',31,36,40,'N',31.6111111111111,97,13,49,'U',0,516
UNION ALL SELECT 'KACY','ACY','ATLANTIC CITY INTERNATIONAL','ATLANTIC CITY','USA',39,27,27,'N',39.4575,74,34,37,'U',0,75
UNION ALL SELECT 'KADM','ADM','ARDMORE MUNI','ARDMORE','USA',34,18,11,'N',34.3030555555556,97,1,10,'U',0,762
UNION ALL SELECT 'KADW','ADW','ANDREWS AFB','CAMP SPRINGS','USA',38,48,38,'N',38.8105555555556,76,52,1,'U',0,280
UNION ALL SELECT 'KAEX','AEX','ALEXANDRIA INTERNATIONAL','ALEXANDRIA','USA',31,19,38,'N',31.3272222222222,92,32,54,'U',0,89
UNION ALL SELECT 'KAGS','AGS','AUGUSTA RGNL AT BUSH FLD','BUSH FIELD','USA',33,22,11,'N',33.3697222222222,81,57,52,'U',0,144
UNION ALL SELECT 'KAKR','AKR','AKRON FULTON INTERNATIONAL','AKRON','USA',41,2,15,'N',41.0375,81,28,0,'U',0,1067
UNION ALL SELECT 'KALB','ALB','ALBANY INTERNATIONAL','ALBANY','USA',42,44,53,'N',42.7480555555556,73,48,10,'U',0,285
UNION ALL SELECT 'KALI','ALI','ALICE INTERNATIONAL','ALICE','USA',27,44,27,'N',27.7408333333333,98,1,37,'U',0,178
UNION ALL SELECT 'KAMA','AMA','AMARILLO INTERNATIONAL','AMARILLO','USA',35,13,9,'N',35.2191666666667,101,42,21,'U',0,3607
UNION ALL SELECT 'KANB','ANB','ANNISTON METROPOLITAN','ANNISTON','USA',33,35,17,'N',33.5880555555556,85,51,29,'U',0,612
UNION ALL SELECT 'KAND','AND','ANDERSON RGNL','ANDERSEN','USA',34,29,42,'N',34.495,82,42,33,'U',0,782
UNION ALL SELECT 'KAOO','AOO','ALTOONA BLAIR CO','ALTOONA','USA',40,17,47,'N',40.2963888888889,78,19,12,'U',0,1504
UNION ALL SELECT 'KAPG','APG','PHILLIPS AAF','ABERDEEN','USA',39,27,58,'N',39.4661111111111,76,10,10,'U',0,58
UNION ALL SELECT 'KARA','ARA','ACADIANA REGIONAL','LOUISIANA','USA',30,2,15,'N',30.0375,91,53,2,'W',-91.8838888888889,24
UNION ALL SELECT 'KART','ART','WATERTOWN INTERNATIONAL','WATERTOWN','USA',43,59,30,'N',43.9916666666667,76,1,18,'U',0,325
UNION ALL SELECT 'KATL','ATL','THE WILLIAM B HARTSFIELD ATLANTA INTERNATIONAL','ATLANTA','USA',33,38,25,'N',33.6402777777778,84,25,37,'U',0,1026
UNION ALL SELECT 'KAUG','AUG','AUGUSTA STATE','AUGUSTA','USA',44,19,14,'N',44.3205555555556,69,47,50,'U',0,352
UNION ALL SELECT 'KAUS','AUS','AUSTIN BERGSTROM INTERNATIONAL','AUSTIN','USA',30,11,40,'N',30.1944444444444,97,40,11,'U',0,542
UNION ALL SELECT 'KBAB','BAB','BEALE AFB','MARYSVILLE','USA',39,8,9,'N',39.1358333333333,121,26,11,'U',0,113
UNION ALL SELECT 'KBAD','BAD','BARKSDALE AFB','SHREVEPORT','USA',32,30,6,'N',32.5016666666667,93,39,45,'U',0,166
UNION ALL SELECT 'KBCT','BCT','BOCA RATON','BOCA RATON','USA',26,22,42,'N',26.3783333333333,80,6,27,'U',0,13
UNION ALL SELECT 'KBDE','BDE','BAUDETTE INTERNATIONAL','BAUDETTE','USA',48,43,42,'N',48.7283333333333,94,36,44,'U',0,1086
UNION ALL SELECT 'KBDL','BDL','BRADLEY INTERNATIONAL','WINDSOR LOCKS','USA',41,56,20,'N',41.9388888888889,72,40,59,'U',0,173
UNION ALL SELECT 'KBDR','BDR','IGOR I SIKORSKY MEM','STRATFORD','USA',41,9,48,'N',41.1633333333333,73,7,34,'U',0,9
UNION ALL SELECT 'KBED','BED','LAURENCE G HANSCOM FLD','BEDFORD','USA',42,28,11,'N',42.4697222222222,71,17,20,'U',0,133
UNION ALL SELECT 'KBFI','BFI','BOEING FLD KING CO INTERNATIONAL','SEATTLE','USA',47,31,47,'N',47.5297222222222,122,18,7,'U',0,18
UNION ALL SELECT 'KBFL','BFL','MEADOWS FLD','BAKERSFIELD','USA',35,26,0,'N',35.4333333333333,119,3,24,'U',0,507
UNION ALL SELECT 'KBFM','BFM','MOBILE DOWNTOWN','MOBILE','USA',30,37,35,'N',30.6263888888889,88,4,4,'U',0,26
UNION ALL SELECT 'KBGR','BGR','BANGOR INTERNATIONAL','BANGOR','USA',44,48,26,'N',44.8072222222222,68,49,41,'U',0,192
UNION ALL SELECT 'KBHM','BHM','BIRMINGHAM INTERNATIONAL','BIRMINGHAM','USA',33,33,46,'N',33.5627777777778,86,45,12,'U',0,644
UNION ALL SELECT 'KBIF','BIF','BIGGS AAF','EL PASO','USA',31,50,58,'N',31.8494444444444,106,22,48,'U',0,3946
UNION ALL SELECT 'KBIX','BIX','KEESLER AFB','BILOXI','USA',30,24,39,'N',30.4108333333333,88,55,25,'U',0,34
UNION ALL SELECT 'KBKF','BKF','BUCKLEY AFB','BUCKLEY','USA',39,42,6,'N',39.7016666666667,104,45,5,'U',0,5662
UNION ALL SELECT 'KBLI','BLI','BELLINGHAM INTERNATIONAL','BELLINGHAM','USA',48,47,33,'N',48.7925,122,32,15,'U',0,170
UNION ALL SELECT 'KBLV','BLV','SCOTT AFB MIDAMERICA','BELLEVILLE','USA',38,32,42,'N',38.545,89,50,6,'U',0,459
UNION ALL SELECT 'KBNA','BNA','NASHVILLE INTERNATIONAL','NASHVILLE','USA',36,7,28,'N',36.1244444444444,86,40,41,'U',0,599
UNION ALL SELECT 'KBOI','BOI','BOISE AIR TERMINAL','BOISE','USA',43,33,51,'N',43.5641666666667,116,13,22,'U',0,2871
UNION ALL SELECT 'KBOS','BOS','GENERAL EDWARD LAWRENCE LOGAN INTERNATIONAL','BOSTON','USA',42,21,51,'N',42.3641666666667,71,0,18,'U',0,19
UNION ALL SELECT 'KBPT','BPT','SOUTHEAST TEXAS RGNL','BEAUMONT','USA',29,57,3,'N',29.9508333333333,94,1,14,'U',0,15
UNION ALL SELECT 'KBRO','BRO','BROWNSVILLE SOUTH PADRE ISLAND INTERNATIONAL','BROWNSVILLE','USA',25,54,24,'N',25.9066666666667,97,25,33,'U',0,22
UNION ALL SELECT 'KBTR','BTR','BATON ROUGE METRO RYAN FLD','BATON ROUGE','USA',30,31,59,'N',30.5330555555556,91,8,58,'U',0,70
UNION ALL SELECT 'KBTV','BTV','BURLINGTON INTERNATIONAL','BURLINGTON','USA',44,28,18,'N',44.4716666666667,73,9,11,'U',0,335
UNION ALL SELECT 'KBUF','BUF','BUFFALO NIAGARA INTERNATIONAL','BUFFALO','USA',42,56,25,'N',42.9402777777778,78,43,55,'U',0,724
UNION ALL SELECT 'KBUR','BUR','BURBANK GLENDALE PASADENA','BURBANK','USA',34,12,2,'N',34.2005555555556,118,21,31,'U',0,778
UNION ALL SELECT 'KBWI','BWI','BALTIMORE WASHINGTON INTERNATIONAL','BALTIMORE','USA',39,10,31,'N',39.1752777777778,76,40,6,'U',0,146
UNION ALL SELECT 'KBYH','BYH','ARKANSAS INTERNATIONAL','BLYTHEVILLE','USA',35,57,51,'N',35.9641666666667,89,56,36,'U',0,251
UNION ALL SELECT 'KBYS','BYS','BICYCLE LAKE AAF','FORT IRWIN','USA',35,16,49,'N',35.2802777777778,116,37,48,'U',0,2350
UNION ALL SELECT 'KCAE','CAE','COLUMBIA METROPOLITAN','COLOMBIA','USA',33,56,19,'N',33.9386111111111,81,7,10,'U',0,236
UNION ALL SELECT 'KCAR','CAR','CARIBOU MUNI','CARIBOU','USA',46,52,17,'N',46.8713888888889,68,1,4,'U',0,626
UNION ALL SELECT 'KCBM','CBM','COLUMBUS AFB','COLOMBUS','USA',33,38,38,'N',33.6438888888889,88,26,37,'U',0,219
UNION ALL SELECT 'KCDC','CDC','CEDAR CITY RGNL','CEDAR CITY','USA',37,42,3,'N',37.7008333333333,113,5,55,'U',0,5622
UNION ALL SELECT 'KCDS','CDS','CHILDRESS MUNI','CHILDRESS','USA',34,26,1,'N',34.4336111111111,100,17,17,'U',0,1954
UNION ALL SELECT 'KCEF','CEF','WESTOVER ARB METROPOLITAN','CHICOPEE FALLS','USA',42,11,53,'N',42.1980555555556,72,32,3,'U',0,245
UNION ALL SELECT 'KCEW','CEW','BOB SIKES','CRESTVIEW','USA',30,46,43,'N',30.7786111111111,86,31,19,'U',0,213
UNION ALL SELECT 'KCFD','CFD','COULTER FLD','BRYAN','USA',30,42,56,'N',30.7155555555556,96,19,52,'U',0,367
UNION ALL SELECT 'KCHA','CHA','LOVELL FLD','CHATTANOOGA','USA',35,2,7,'N',35.0352777777778,85,12,13,'U',0,682
UNION ALL SELECT 'KCHS','CHS','CHARLESTON AFB INTERNATIONAL','CHARLESTON','USA',32,53,55,'N',32.8986111111111,80,2,25,'U',0,45
UNION ALL SELECT 'KCIC','CIC','CHICO MUNI','CHICO','USA',39,47,43,'N',39.7952777777778,121,51,30,'U',0,238
UNION ALL SELECT 'KCLE','CLE','CLEVELAND HOPKINS INTERNATIONAL','CLEVELAND','USA',41,24,42,'N',41.4116666666667,81,50,59,'U',0,791
UNION ALL SELECT 'KCLL','CLL','EASTERWOOD FLD','COLLEGE STATION','USA',30,35,18,'N',30.5883333333333,96,21,49,'U',0,321
UNION ALL SELECT 'KCLT','CLT','CHARLOTTE DOUGLAS INTERNATIONAL','CHARLOTTE','USA',35,12,50,'N',35.2138888888889,80,56,35,'U',0,749
UNION ALL SELECT 'KCMH','CMH','PORT COLUMBUS INTERNATIONAL','COLUMBUS','USA',39,59,52,'N',39.9977777777778,82,53,30,'U',0,815
UNION ALL SELECT 'KCNM','CNM','CAVERN CITY AIR TERMINAL','CARLSBAD','USA',32,20,14,'N',32.3372222222222,104,15,47,'U',0,3295
UNION ALL SELECT 'KCNW','CNW','TSTC WACO','WACO','USA',31,38,16,'N',31.6377777777778,97,4,26,'U',0,470
UNION ALL SELECT 'KCOF','COF','PATRICK AFB','COCO BEACH','USA',28,14,5,'N',28.2347222222222,80,36,36,'U',0,8
UNION ALL SELECT 'KCOS','COS','CITY OF COLORADO SPRINGS MUNI','COLORADO SPRINGS','USA',38,48,20,'N',38.8055555555556,104,42,0,'U',0,6184
UNION ALL SELECT 'KCOT','COT','COTULLA LA SALLE CO','COTULLA','USA',28,27,29,'N',28.4580555555556,99,13,12,'U',0,476
UNION ALL SELECT 'KCOU','COU','COLUMBIA RGNL','COLUMBIA','USA',38,49,5,'N',38.8180555555556,92,13,10,'U',0,889
UNION ALL SELECT 'KCPR','CPR','NATRONA CO INTERNATIONAL','CASPER','USA',42,54,28,'N',42.9077777777778,106,27,51,'U',0,5348
UNION ALL SELECT 'KCRP','CRP','CORPUS CHRISTI INTERNATIONAL','CORPUS CHRISTI','USA',27,46,13,'N',27.7702777777778,97,30,4,'U',0,44
UNION ALL SELECT 'KCTB','CTB','CUT BANK MUNI','CUTBANK','USA',48,36,30,'N',48.6083333333333,112,22,34,'U',0,3854
UNION ALL SELECT 'KCVG','CVG','CINCINNATI NORTHERN KENTUCKY INTERNATIONAL','CINCINNATI','USA',39,2,46,'N',39.0461111111111,84,39,43,'U',0,896
UNION ALL SELECT 'KCVS','CVS','CANNON AFB','CLOVIS','USA',34,22,57,'N',34.3825,103,19,19,'U',0,4295
UNION ALL SELECT 'KCXL','CXL','CALEXICO INTERNATIONAL','CALEXICO','USA',32,40,10,'N',32.6694444444444,115,30,47,'U',0,4
UNION ALL SELECT 'KCXO','CXO','MONTGOMERY CO','CONROE','USA',30,21,6,'N',30.3516666666667,95,24,52,'U',0,245
UNION ALL SELECT 'KCYS','CYS','CHEYENNE','CHEYENNE','USA',41,9,20,'N',41.1555555555556,104,48,42,'U',0,6156
UNION ALL SELECT 'KDAL','DAL','DALLAS LOVE FLD','DALLAS','USA',32,50,49,'N',32.8469444444444,96,51,6,'U',0,487
UNION ALL SELECT 'KDAY','DAY','JAMES M COX DAYTON INTERNATIONAL','DAYTON','USA',39,54,8,'N',39.9022222222222,84,13,9,'U',0,1009
UNION ALL SELECT 'KDCA','DCA','RONALD REAGAN WASHINGTON NATIONAL','WASHINGTON','USA',38,51,7,'N',38.8519444444444,77,2,15,'U',0,15
UNION ALL SELECT 'KDEN','DEN','DENVER INTERNATIONAL','DENVER','USA',39,51,30,'N',39.8583333333333,104,40,1,'U',0,5431
UNION ALL SELECT 'KDET','DET','DETROIT CITY','DETROIT','USA',42,24,33,'N',42.4091666666667,83,0,35,'U',0,626
UNION ALL SELECT 'KDFW','DFW','DALLAS FORT WORTH INTERNATIONAL','DALLAS-FORT WORTH','USA',32,53,47,'N',32.8963888888889,97,2,15,'U',0,603
UNION ALL SELECT 'KDHN','DHN','DOTHAN RGNL','DOTHAN','USA',31,19,16,'N',31.3211111111111,85,26,58,'U',0,401
UNION ALL SELECT 'KDHT','DHT','DALHART MUNI','DALHART','USA',36,1,21,'N',36.0225,102,32,50,'U',0,3991
UNION ALL SELECT 'KDLF','DLF','LAUGHLIN AFB','DEL RIO','USA',29,21,34,'N',29.3594444444444,100,46,40,'U',0,1081
UNION ALL SELECT 'KDLH','DLH','DULUTH INTERNATIONAL','DULUTH','USA',46,50,31,'N',46.8419444444444,92,11,37,'U',0,1428
UNION ALL SELECT 'KDMA','DMA','DAVIS MONTHAN AFB','TUCSON','USA',32,9,59,'N',32.1663888888889,110,52,59,'U',0,2704
UNION ALL SELECT 'KDOV','DOV','DOVER AFB','DOVER','USA',39,7,48,'N',39.13,75,27,59,'U',0,30
UNION ALL SELECT 'KDPA','DPA','DU PAGE','WEST CHICAGO','USA',41,54,28,'N',41.9077777777778,88,14,55,'U',0,758
UNION ALL SELECT 'KDRI','DRI','BEAUREGARD PARISH','DERIDDER','USA',30,49,54,'N',30.8316666666667,93,20,23,'U',0,204
UNION ALL SELECT 'KDRO','DRO','DURANGO LA PLATA CO','DURANGO','USA',37,9,5,'N',37.1513888888889,107,45,13,'U',0,6685
UNION ALL SELECT 'KDRT','DRT','DEL RIO INTERNATIONAL','DEL RIO','USA',29,22,22,'N',29.3727777777778,100,55,33,'U',0,999
UNION ALL SELECT 'KDSM','DSM','DES MOINES INTERNATIONAL','DES MOINES','USA',41,32,2,'N',41.5338888888889,93,39,45,'U',0,957
UNION ALL SELECT 'KDTW','DTW','DETROIT METRO WAYNE CO','DETROIT','USA',42,12,44,'N',42.2122222222222,83,21,12,'U',0,646
UNION ALL SELECT 'KDUG','DUG','BISBEE DOUGLAS INTERNATIONAL','DOUGLAS','USA',31,28,8,'N',31.4688888888889,109,36,13,'U',0,4154
UNION ALL SELECT 'KDYS','DYS','DYESS AFB','ABILENE','USA',32,25,14,'N',32.4205555555556,99,51,16,'U',0,1789
UNION ALL SELECT 'KECG','ECG','ELIZABETH CITY CGAS RGNL','ELIZABETH CITY','USA',36,15,38,'N',36.2605555555556,76,10,28,'U',0,12
UNION ALL SELECT 'KEDW','EDW','EDWARDS AFB','EDWARDS AFB','USA',34,54,19,'N',34.9052777777778,117,53,1,'U',0,2302
UNION ALL SELECT 'KEFD','EFD','ELLINGTON FLD','HOUSTON','USA',29,36,26,'N',29.6072222222222,95,9,31,'U',0,32
UNION ALL SELECT 'KEGP','EGP','EAGLE PASS MUNI','EAGLE PASS','USA',28,42,0,'N',28.7,100,28,46,'U',0,805
UNION ALL SELECT 'KEKN','EKN','ELKINS RANDOLPH CO JENNINGS RANDOLPH','ELKINS','USA',38,53,22,'N',38.8894444444444,79,51,25,'U',0,1987
UNION ALL SELECT 'KELD','ELD','SOUTH ARKANSAS RGNL AT GOODWIN FLD','EL DORADO','USA',33,13,15,'N',33.2208333333333,92,48,47,'U',0,277
UNION ALL SELECT 'KELP','ELP','EL PASO INTERNATIONAL','EL PASO','USA',31,48,24,'N',31.8066666666667,106,22,40,'U',0,3958
UNION ALL SELECT 'KEND','END','VANCE AFB','ENID','USA',36,20,23,'N',36.3397222222222,97,54,58,'U',0,1307
UNION ALL SELECT 'KENV','ENV','WENDOVER','WENDOVER','USA',40,43,7,'N',40.7186111111111,114,1,51,'U',0,4235
UNION ALL SELECT 'KESF','ESF','ESLER RGNL','ALEXANDRIA','USA',31,23,41,'N',31.3947222222222,92,17,44,'U',0,112
UNION ALL SELECT 'KEWN','EWN','CRAVEN CO RGNL','NEW BERN','USA',35,4,22,'N',35.0727777777778,77,2,34,'U',0,18
UNION ALL SELECT 'KEWR','EWR','NEWARK LIBERTY INTERNATIONAL','NEWARK','USA',40,41,32,'N',40.6922222222222,74,10,7,'U',0,18
UNION ALL SELECT 'KEYW','EYW','KEY WEST INTERNATIONAL','KEY WEST','USA',24,33,22,'N',24.5561111111111,81,45,34,'U',0,3
UNION ALL SELECT 'KFAF','FAF','FELKER AAF','FORT EUSTIS','USA',37,7,57,'N',37.1325,76,36,31,'U',0,12
UNION ALL SELECT 'KFAT','FAT','FRESNO YOSEMITE INTERNATIONAL','FRESNO','USA',36,46,34,'N',36.7761111111111,119,43,5,'U',0,336
UNION ALL SELECT 'KFCS','FCS','BUTTS AAF','FORT CARSON','USA',38,40,42,'N',38.6783333333333,104,45,23,'U',0,5838
UNION ALL SELECT 'KFFO','FFO','WRIGHT PATTERSON AFB','DAYTON','USA',39,49,34,'N',39.8261111111111,84,2,54,'U',0,823
UNION ALL SELECT 'KFHU','FHU','SIERRA VISTA MUNI LIBBY AAF','FORT HUACHUCA','USA',31,35,18,'N',31.5883333333333,110,20,39,'U',0,4719
UNION ALL SELECT 'KFLL','FLL','FORT LAUDERDALE HOLLYWOOD INTERNATIONAL','FORT LAUDERDALE','USA',26,4,21,'N',26.0725,80,9,9,'U',0,9
UNION ALL SELECT 'KFLO','FLO','FLORENCE RGNL','FLORENCE','USA',34,11,7,'N',34.1852777777778,79,43,26,'U',0,146
UNION ALL SELECT 'KFLV','FLV','SHERMAN AAF','FORT LEAVENWORTH','USA',39,22,6,'N',39.3683333333333,94,54,52,'U',0,772
UNION ALL SELECT 'KFMH','FMH','OTIS ANGB','FALMOUTH','USA',41,39,30,'N',41.6583333333333,70,31,17,'U',0,131
UNION ALL SELECT 'KFMN','FMN','FOUR CORNERS RGNL','FARMINGTON','USA',36,44,28,'N',36.7411111111111,108,13,47,'U',0,5506
UNION ALL SELECT 'KFMY','FMY','PAGE FLD','FORT MYERS','USA',26,35,11,'N',26.5863888888889,81,51,47,'U',0,17
UNION ALL SELECT 'KFOD','FOD','FORT DODGE RGNL','FORT DODGE','USA',42,33,5,'N',42.5513888888889,94,11,33,'U',0,1157
UNION ALL SELECT 'KFOE','FOE','FORBES FLD','TOPEKA','USA',38,57,3,'N',38.9508333333333,95,39,49,'U',0,1078
UNION ALL SELECT 'KFOK','FOK','THE FRANCIS S GABRESKI','WEST HAMPTON BEACH','USA',40,50,37,'N',40.8436111111111,72,37,54,'U',0,67
UNION ALL SELECT 'KFRI','FRI','MARSHALL AAF','FORT RILEY','USA',39,3,18,'N',39.055,96,45,52,'U',0,1063
UNION ALL SELECT 'KFSI','FSI','HENRY POST AAF','FORT SILL','USA',34,38,59,'N',34.6497222222222,98,24,7,'U',0,1189
UNION ALL SELECT 'KFSM','FSM','FORT SMITH RGNL','FORT SMITH','USA',35,20,11,'N',35.3363888888889,94,22,2,'U',0,469
UNION ALL SELECT 'KFTK','FTK','GODMAN AAF','FORT KNOX','USA',37,54,25,'N',37.9069444444444,85,58,19,'U',0,756
UNION ALL SELECT 'KFTW','FTW','FORT WORTH MEACHAM INTERNATIONAL','FORT WORTH','USA',32,49,11,'N',32.8197222222222,97,21,44,'U',0,710
UNION ALL SELECT 'KFXE','FXE','FORT LAUDERDALE EXECUTIVE','FORT LAUDERDALE','USA',26,11,50,'N',26.1972222222222,80,10,14,'U',0,14
UNION ALL SELECT 'KFYV','FYV','DRAKE FLD','FAYETTEVILLE','USA',36,0,18,'N',36.005,94,10,12,'U',0,1251
UNION ALL SELECT 'KGAG','GAG','GAGE','GAGE','USA',36,17,43,'N',36.2952777777778,99,46,35,'U',0,2223
UNION ALL SELECT 'KGCK','GCK','GARDEN CITY RGNL','GARDEN CITY','USA',37,55,39,'N',37.9275,100,43,27,'U',0,2890
UNION ALL SELECT 'KGEG','GEG','SPOKANE INTERNATIONAL','SPOKANE','USA',47,37,11,'N',47.6197222222222,117,32,1,'U',0,2372
UNION ALL SELECT 'KGFK','GFK','GRAND FORKS INTERNATIONAL','GRAND FORKS','USA',47,56,57,'N',47.9491666666667,97,10,34,'U',0,845
UNION ALL SELECT 'KGGG','GGG','EAST TEXAS RGNL','LONGVIEW','USA',32,23,5,'N',32.3847222222222,94,42,41,'U',0,365
UNION ALL SELECT 'KGLS','GLS','SCHOLES INTERNATIONAL AT GALVESTON','GALVESTON','USA',29,15,55,'N',29.2652777777778,94,51,37,'U',0,6
) x (ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LatDec],[LongDeg],[LongMin],[LongSec],[LongDir],[LongDec],[Altitude])
LEFT OUTER JOIN Airports a ON a.IATA_Code = x.IATA_Code
--WHERE x.[LatDir] <> 'U' and x.[LongDir] <> 'U' and x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE n=1
GO

INSERT INTO Airports (ICAO_Code, IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir
    ,LongDeg, LongMin, LongSec, LongDir, Altitude)
SELECT ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LongDeg],[LongMin],[LongSec],[LongDir],[Altitude]
FROM (
SELECT x.ICAO_Code,x.IATA_Code,x.[Name],x.[City],x.[Country],x.[LatDeg],x.[LatMin],x.[LatSec],x.[LatDir]
	,x.[LatDec],x.[LongDeg],x.[LongMin],x.[LongSec],x.[LongDir],x.[LongDec],x.[Altitude]
    ,n=ROW_NUMBER() OVER (PARTITION BY x.IATA_Code ORDER BY (SELECT NULL))
FROM (
SELECT 'KGNT','GNT','GRANTS MILAN MUNI','GRANTS','USA',35,9,55,'N',35.1652777777778,107,54,2,'U',0,6521
UNION ALL SELECT 'KGNV','GNV','GAINESVILLE RGNL','GAINESVILLE','USA',29,41,24,'N',29.69,82,16,18,'U',0,152
UNION ALL SELECT 'KGRB','GRB','AUSTIN STRAUBEL INTERNATIONAL','GREEN BAY','USA',44,29,6,'N',44.485,88,7,46,'U',0,695
UNION ALL SELECT 'KGRF','GRF','GRAY AAF','FORT LEWIS','USA',47,4,45,'N',47.0791666666667,122,34,50,'U',0,302
UNION ALL SELECT 'KGRK','GRK','ROBERT GRAY AAF','KILLEEN','USA',31,4,2,'N',31.0672222222222,97,49,44,'U',0,1019
UNION ALL SELECT 'KGRR','GRR','GERALD R FORD INTERNATIONAL','GRAND RAPIDS','USA',42,52,51,'N',42.8808333333333,85,31,22,'U',0,793
UNION ALL SELECT 'KGSB','GSB','SEYMOUR JOHNSON AFB','GOLDSBORO','USA',35,20,21,'N',35.3391666666667,77,57,38,'U',0,110
UNION ALL SELECT 'KGTB','GTB','WHEELER SACK AAF','FORT DRUM','USA',44,3,20,'N',44.0555555555556,75,43,10,'U',0,691
UNION ALL SELECT 'KGTF','GTF','GREAT FALLS INTERNATIONAL','GREAT FALLS','USA',47,28,55,'N',47.4819444444444,111,22,14,'U',0,3677
UNION ALL SELECT 'KGUS','GUS','GRISSOM ARB','PERU','USA',40,38,53,'N',40.6480555555556,86,9,7,'U',0,811
UNION ALL SELECT 'KGVT','GVT','MAJORS','GREENVILE','USA',33,4,4,'N',33.0677777777778,96,3,55,'U',0,535
UNION ALL SELECT 'KGVW','GVW','RICHARDS GEBAUR MEMORIAL','GRANDVIEW','USA',38,50,36,'N',38.8433333333333,94,33,38,'U',0,1090
UNION ALL SELECT 'KGWO','GWO','GREENWOOD LEFLORE','GREENWOOD','USA',33,29,39,'N',33.4941666666667,90,5,4,'U',0,162
UNION ALL SELECT 'KHAR','HAR','','HARRISBURG','USA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'KHBR','HBR','HOBART MUNI','HOBART','USA',34,59,28,'N',34.9911111111111,99,3,4,'U',0,1564
UNION ALL SELECT 'KHFD','HFD','HARTFORD BRAINARD','HARTFORD','USA',41,44,10,'N',41.7361111111111,72,39,0,'U',0,19
UNION ALL SELECT 'KHHR','HHR','JACK NORTHROP FLD HAWTHORNE MUNI','HAWTHORNE','USA',33,55,22,'N',33.9227777777778,118,20,6,'U',0,66
UNION ALL SELECT 'KHIB','HIB','CHISHOLM HIBBING','HIBBING','USA',47,23,11,'N',47.3863888888889,92,50,20,'U',0,1353
UNION ALL SELECT 'KHIF','HIF','HILL AFB','OGDEN','USA',41,7,26,'N',41.1238888888889,111,58,22,'U',0,4789
UNION ALL SELECT 'KHKY','HKY','HICKORY RGNL','HICKORY','USA',35,44,28,'N',35.7411111111111,81,23,22,'U',0,1189
UNION ALL SELECT 'KHLN','HLN','HELENA RGNL','HELENA','USA',46,36,24,'N',46.6066666666667,111,58,57,'U',0,3877
UNION ALL SELECT 'KHLR','HLR','HOOD AAF','FORT HOOD','USA',31,8,19,'N',31.1386111111111,97,42,52,'U',0,924
UNION ALL SELECT 'KHMN','HMN','HOLLOMAN AFB','ALAMOGORDO','USA',32,51,9,'N',32.8525,106,6,23,'U',0,4093
UNION ALL SELECT 'KHOB','HOB','LEA CO RGNL','HOBBS','USA',32,41,15,'N',32.6875,103,13,1,'U',0,3661
UNION ALL SELECT 'KHON','HON','HURON RGNL','HURON','USA',44,23,6,'N',44.385,98,13,42,'U',0,1289
UNION ALL SELECT 'KHOP','HOP','CAMPBELL AAF','HOPKINSVILLE','USA',36,40,6,'N',36.6683333333333,87,29,46,'U',0,573
UNION ALL SELECT 'KHOU','HOU','WILLIAM P HOBBY','HOUSTON','USA',29,38,43,'N',29.6452777777778,95,16,44,'U',0,46
UNION ALL SELECT 'KHPN','HPN','WESTCHESTER CO','WHITE PLAINS','USA',41,4,1,'N',41.0669444444444,73,42,27,'U',0,439
UNION ALL SELECT 'KHRL','HRL','VALLEY INTERNATIONAL','HARLINGEN','USA',26,13,42,'N',26.2283333333333,97,39,15,'U',0,36
UNION ALL SELECT 'KHRO','HRO','BOONE CO','HARRISON','USA',36,15,41,'N',36.2613888888889,93,9,17,'U',0,1365
UNION ALL SELECT 'KHRT','HRT','HURLBURT FLD','MARY ESTHER','USA',30,25,40,'N',30.4277777777778,86,41,21,'U',0,38
UNION ALL SELECT 'KHST','HST','HOMESTEAD ARB','HOMESTEAD','USA',25,29,18,'N',25.4883333333333,80,23,1,'U',0,7
UNION ALL SELECT 'KHTL','HTL','ROSCOMMON CO','HOUGHTON LAKE','USA',44,21,35,'N',44.3597222222222,84,40,16,'U',0,1150
UNION ALL SELECT 'KHUA','HUA','REDSTONE AAF','REDSTONE','USA',34,40,43,'N',34.6786111111111,86,41,5,'U',0,685
UNION ALL SELECT 'KHUF','HUF','TERRE HAUTE INTERNATIONAL HULMAN FLD','TERRE HAUTE','USA',39,27,5,'N',39.4513888888889,87,18,27,'U',0,589
UNION ALL SELECT 'KHUL','HUL','HOULTON INTERNATIONAL','HOULTON','USA',46,7,23,'N',46.1230555555556,67,47,31,'U',0,489
UNION ALL SELECT 'KHVR','HVR','HAVRE CITY CO','HAVRE','USA',48,32,34,'N',48.5427777777778,109,45,44,'U',0,2590
UNION ALL SELECT 'KHWO','HWO','NORTH PERRY','HOLLYWOOD','USA',26,0,5,'N',26.0013888888889,80,14,25,'U',0,9
UNION ALL SELECT 'KIAB','IAB','MC CONNELL AFB','WICHITA','USA',37,37,22,'N',37.6227777777778,97,16,2,'U',0,1371
UNION ALL SELECT 'KIAD','IAD','WASHINGTON DULLES INTERNATIONAL','WASHINGTON','USA',38,56,40,'N',38.9444444444444,77,27,20,'U',0,313
UNION ALL SELECT 'KIAG','IAG','NIAGARA FALLS INTERNATIONAL','NIAGARA FALLS','USA',43,6,26,'N',43.1072222222222,78,56,46,'U',0,590
UNION ALL SELECT 'KIAH','IAH','GEORGE BUSH INTCNTL HOUSTON','HOUSTON','USA',29,58,49,'N',29.9802777777778,95,20,23,'U',0,97
UNION ALL SELECT 'KICT','ICT','WICHITA MID CONTINENT','WICHITA','USA',37,38,59,'N',37.6497222222222,97,25,59,'U',0,1333
UNION ALL SELECT 'KIKK','IKK','GREATER KANKAKEE','KANKAKEE','USA',41,4,17,'N',41.0713888888889,87,50,46,'U',0,630
UNION ALL SELECT 'KIKR','ABQ','ALBUQUERQUE INTERNATIONAL SUNPORT','KIRTLAND A.F.B.','USA',35,2,24,'N',35.04,106,36,33,'U',0,5355
UNION ALL SELECT 'KILG','ILG','NEW CASTLE CO','WILMINGTON','USA',39,40,43,'N',39.6786111111111,75,36,23,'U',0,79
UNION ALL SELECT 'KILM','ILM','WILMINGTON INTERNATIONAL','WILMINGTON','USA',34,16,14,'N',34.2705555555556,77,54,9,'U',0,32
UNION ALL SELECT 'KIND','IND','INDIANAPOLIS INTERNATIONAL','INDIANAPOLIS','USA',39,43,2,'N',39.7172222222222,86,17,39,'U',0,797
UNION ALL SELECT 'KINK','INK','WINKLER CO','WINK','USA',31,46,46,'N',31.7794444444444,103,12,4,'U',0,2820
UNION ALL SELECT 'KINL','INL','FALLS INTERNATIONAL','INTERNATIONAL FALLS','USA',48,33,58,'N',48.5661111111111,93,24,11,'U',0,1185
UNION ALL SELECT 'KINS','INS','INDIAN SPRINGS AF AUX','INDIAN SPRINGS','USA',36,35,13,'N',36.5869444444444,115,40,24,'U',0,3133
UNION ALL SELECT 'KINT','INT','SMITH REYNOLDS','WINSTON-SALEM','USA',36,8,1,'N',36.1336111111111,80,13,19,'U',0,969
UNION ALL SELECT 'KIPL','IPL','IMPERIAL CO','IMPERIAL','USA',32,50,3,'N',32.8341666666667,115,34,43,'U',0,56
UNION ALL SELECT 'KIPT','IPT','WILLIAMSPORT RGNL','WILLIAMSPORT','USA',41,14,31,'N',41.2419444444444,76,55,16,'U',0,529
UNION ALL SELECT 'KISN','ISN','SLOULIN FLD INTERNATIONAL','WILLISTON','USA',48,10,40,'N',48.1777777777778,103,38,32,'U',0,1982
UNION ALL SELECT 'KISP','ISP','LONG ISLAND MAC ARTHUR','ISLIP','USA',40,47,42,'N',40.795,73,6,0,'U',0,99
UNION ALL SELECT 'KJAN','JAN','JACKSON INTERNATIONAL','JACKSON','USA',32,18,40,'N',32.3111111111111,90,4,33,'U',0,346
UNION ALL SELECT 'KJAX','JAX','JACKSONVILLE INTERNATIONAL','JACKSONVILLE','USA',30,29,38,'N',30.4938888888889,81,41,16,'U',0,30
UNION ALL SELECT 'KJBR','JBR','JONESBORO MUNI','JONESBORO','USA',35,49,54,'N',35.8316666666667,90,38,46,'U',0,262
UNION ALL SELECT 'KJFK','JFK','JOHN F KENNEDY INTERNATIONAL','NEW YORK','USA',40,38,23,'N',40.6397222222222,73,46,44,'W',-73.77888889,13
UNION ALL SELECT 'KLAN','LAN','CAPITAL CITY','LANSING','USA',42,46,43,'N',42.7786111111111,84,35,14,'U',0,861
UNION ALL SELECT 'KLAS','LAS','MC CARRAN INTERNATIONAL','LAS VEGAS','USA',36,4,49,'N',36.0802777777778,115,9,8,'U',0,2181
UNION ALL SELECT 'KLAX','LAX','LOS ANGELES INTERNATIONAL','LOS ANGELES','USA',33,56,33,'N',33.9425,118,24,29,'W',-118.4080556,126
UNION ALL SELECT 'KLBB','LBB','LUBBOCK INTERNATIONAL','LUBBOCK','USA',33,39,49,'N',33.6636111111111,101,49,22,'U',0,3282
UNION ALL SELECT 'KLCH','LCH','LAKE CHARLES RGNL','LAKE CHARLES','USA',30,7,34,'N',30.1261111111111,93,13,24,'U',0,15
UNION ALL SELECT 'KLCK','LCK','RICKENBACKER INTERNATIONAL','COLUMBUS','USA',39,48,49,'N',39.8136111111111,82,55,40,'U',0,744
UNION ALL SELECT 'KLFI','LFI','LANGLEY AFB','HAMPTON','USA',37,4,58,'N',37.0827777777778,76,21,37,'U',0,11
UNION ALL SELECT 'KLFK','LFK','ANGELINA CO','LUFKIN','USA',31,14,2,'N',31.2338888888889,94,45,0,'U',0,296
UNION ALL SELECT 'KLFT','LFT','LAFAYETTE RGNL','LAFAYETTE','USA',30,12,19,'N',30.2052777777778,91,59,15,'U',0,42
UNION ALL SELECT 'KLGA','LGA','LA GUARDIA','NEW YORK','USA',40,46,38,'N',40.7772222222222,73,52,21,'U',0,22
UNION ALL SELECT 'KLGB','LGB','LONG BEACH','LONG BEACH','USA',33,49,3,'N',33.8175,118,9,5,'U',0,60
UNION ALL SELECT 'KLHW','LHW','WRIGHT AAF','WRIGHT','USA',31,53,20,'N',31.8888888888889,81,33,44,'U',0,48
UNION ALL SELECT 'KLIT','LIT','ADAMS FLD','LITTLE ROCK','USA',34,43,46,'N',34.7294444444444,92,13,27,'U',0,262
UNION ALL SELECT 'KLNA','LNA','PALM BEACH CO PARK','WEST PALM BEACH','USA',26,35,34,'N',26.5927777777778,80,5,6,'U',0,14
UNION ALL SELECT 'KLNK','LNK','LINCOLN MUNI','LINCOLN','USA',40,51,3,'N',40.8508333333333,96,45,33,'U',0,1219
UNION ALL SELECT 'KLOU','LOU','BOWMAN FLD','LOUISVILLE','USA',38,13,40,'N',38.2277777777778,85,39,49,'U',0,546
UNION ALL SELECT 'KLRD','LRD','LAREDO INTERNATIONAL','LAREDO','USA',27,32,37,'N',27.5436111111111,99,27,41,'U',0,508
UNION ALL SELECT 'KLRF','LRF','LITTLE ROCK AFB','JACKSONVILLE','USA',34,55,5,'N',34.9180555555556,92,8,47,'U',0,311
UNION ALL SELECT 'KLSF','LSF','LAWSON AAF','FORT BENNING','USA',32,20,14,'N',32.3372222222222,84,59,28,'U',0,232
UNION ALL SELECT 'KLSV','LSV','NELLIS AFB','LAS VEGAS','USA',36,14,10,'N',36.2361111111111,115,2,3,'U',0,1868
UNION ALL SELECT 'KLTS','LTS','ALTUS AFB','ALTUS','USA',34,40,1,'N',34.6669444444444,99,16,0,'U',0,1382
UNION ALL SELECT 'KLUF','LUF','LUKE AFB','PHOENIX','USA',33,32,6,'N',33.535,112,22,59,'U',0,1085
UNION ALL SELECT 'KLUK','LUK','CINCINNATI MUNI LUNKEN FLD','CINCINNATI','USA',39,6,12,'N',39.1033333333333,84,25,7,'U',0,483
UNION ALL SELECT 'KMAF','MAF','MIDLAND INTERNATIONAL','MIDLAND','USA',31,56,33,'N',31.9425,102,12,6,'U',0,2871
UNION ALL SELECT 'KMCC','MCC','MC CLELLAN AFLD','SACRAMENTO','USA',38,40,3,'N',38.6675,121,24,2,'U',0,75
UNION ALL SELECT 'KMCF','MCF','MACDILL AFB','TAMPA','USA',27,50,57,'N',27.8491666666667,82,31,16,'U',0,14
UNION ALL SELECT 'KMCI','MCI','KANSAS CITY INTERNATIONAL','KANSAS CITY','USA',39,17,51,'N',39.2975,94,42,50,'U',0,1026
UNION ALL SELECT 'KMCN','MCN','MIDDLE GEORGIA RGNL','MACON','USA',32,41,34,'N',32.6927777777778,83,38,57,'U',0,354
UNION ALL SELECT 'KMCO','MCO','ORLANDO INTERNATIONAL','ORLANDO','USA',28,25,44,'N',28.4288888888889,81,18,57,'U',0,96
UNION ALL SELECT 'KMDT','MDT','HARRISBURG INTERNATIONAL','HARRISBURG','USA',40,11,36,'N',40.1933333333333,76,45,48,'U',0,310
UNION ALL SELECT 'KMDW','MDW','CHICAGO MIDWAY INTERNATIONAL','CHICAGO','USA',41,47,9,'N',41.7858333333333,87,45,8,'U',0,620
UNION ALL SELECT 'KMEM','MEM','MEMPHIS INTERNATIONAL','MEMPHIS','USA',35,2,32,'N',35.0422222222222,89,58,36,'U',0,341
UNION ALL SELECT 'KMER','MER','CASTLE','MERCED','USA',37,22,49,'N',37.3802777777778,120,34,5,'U',0,189
UNION ALL SELECT 'KMFE','MFE','MC ALLEN MILLER INTERNATIONAL','MCALLEN','USA',26,10,33,'N',26.1758333333333,98,14,19,'U',0,107
UNION ALL SELECT 'KMGE','MGE','DOBBINS ARB','MARIETTA','USA',33,54,55,'N',33.9152777777778,84,30,58,'U',0,1068
UNION ALL SELECT 'KMHR','MHR','SACRAMENTO MATHER','SACRAMENTO','USA',38,33,14,'N',38.5538888888889,121,17,51,'U',0,96
UNION ALL SELECT 'KMIA','MIA','MIAMI INTERNATIONAL','MIAMI','USA',25,47,35,'N',25.7930555555556,80,17,26,'U',0,8
UNION ALL SELECT 'KMIB','MIB','MINOT AFB','MINOT','USA',48,24,56,'N',48.4155555555556,101,21,27,'U',0,1668
UNION ALL SELECT 'KMIV','MIV','MILLVILLE MUNI','MILLVILLE','USA',39,22,4,'N',39.3677777777778,75,4,20,'U',0,85
UNION ALL SELECT 'KMKE','MKE','GENERAL MITCHELL INTERNATIONAL','MILWAUKEE','USA',42,56,50,'N',42.9472222222222,87,53,47,'U',0,723
UNION ALL SELECT 'KMKL','MKL','MC KELLAR SIPES RGNL','JACKSON','USA',35,35,59,'N',35.5997222222222,88,54,56,'U',0,434
UNION ALL SELECT 'KMKO','MKO','DAVIS FLD','MUSKOGEE','USA',35,39,27,'N',35.6575,95,21,41,'U',0,610
UNION ALL SELECT 'KMLB','MLB','MELBOURNE INTERNATIONAL','MELBOURNE','USA',28,6,9,'N',28.1025,80,38,42,'U',0,33
UNION ALL SELECT 'KMLC','MLC','MC ALESTER RGNL','MCALESTER','USA',34,52,56,'N',34.8822222222222,95,47,0,'U',0,770
UNION ALL SELECT 'KMLT','MLT','MILLINOCKET MUNI','MILLINOCKET','USA',45,38,52,'N',45.6477777777778,68,41,8,'U',0,408
UNION ALL SELECT 'KMLU','MLU','MONROE RGNL','MONROE','USA',32,30,39,'N',32.5108333333333,92,2,15,'U',0,79
UNION ALL SELECT 'KMMV','MMV','MC MINNVILLE MUNI','MACKMINNVILLE','USA',45,11,40,'N',45.1944444444444,123,8,9,'U',0,163
UNION ALL SELECT 'KMNM','MNM','MENOMINEE MARINETTE TWIN CO','MACON','USA',45,7,35,'N',45.1263888888889,87,38,18,'U',0,625
UNION ALL SELECT 'KMOB','MOB','MOBILE RGNL','MOBILE','USA',30,41,29,'N',30.6913888888889,88,14,34,'U',0,219
UNION ALL SELECT 'KMOD','MOD','MODESTO CITY CO HARRY SHAM','MODESTO','USA',37,37,32,'N',37.6255555555556,120,57,15,'U',0,97
UNION ALL SELECT 'KMOT','MOT','MINOT INTERNATIONAL','MINOT','USA',48,15,33,'N',48.2591666666667,101,16,49,'U',0,1700
UNION ALL SELECT 'KMPV','MPV','EDWARD F KNAPP STATE','MONTPELIER','USA',44,12,12,'N',44.2033333333333,72,33,44,'U',0,1165
UNION ALL SELECT 'KMQT','MQT','SAWYER INTERNATIONAL','MARQUETTE','USA',46,32,2,'N',46.5338888888889,87,33,42,'U',0,1419
UNION ALL SELECT 'KMSN','MSN','DANE CO RGNL TRUAX FLD','MADISON','USA',43,8,23,'N',43.1397222222222,89,20,15,'U',0,887
UNION ALL SELECT 'KMSP','MSP','MINNEAPOLIS ST PAUL INTERNATIONAL','MINNEAPOLIS','USA',44,52,49,'N',44.8802777777778,93,13,0,'U',0,841
UNION ALL SELECT 'KMSS','MSS','MASSENA INTERNATIONAL RICHARDS FLD','MASSENA','USA',44,56,9,'N',44.9358333333333,74,50,43,'U',0,215
UNION ALL SELECT 'KMSY','MSY','LOUIS ARMSTRONG NEW ORLEANS INTERNATIONAL','NEW ORLEANS','USA',29,59,36,'N',29.9933333333333,90,15,28,'U',0,4
UNION ALL SELECT 'KMTC','MTC','SELFRIDGE ANGB','MOUNT CLEMENS','USA',42,36,46,'N',42.6127777777778,82,49,54,'U',0,580
UNION ALL SELECT 'KMUI','MUI','MUIR AAF','MUIR','USA',40,26,5,'N',40.4347222222222,76,34,9,'U',0,489
UNION ALL SELECT 'KMUO','MUO','MOUNTAIN HOME AFB','MOUNTAIN HOME','USA',43,2,36,'N',43.0433333333333,115,52,20,'U',0,2996
UNION ALL SELECT 'KMWH','MWH','GRANT CO INTERNATIONAL','GRANT COUNTY AIRPORT','USA',47,12,27,'N',47.2075,119,19,12,'U',0,1185
UNION ALL SELECT 'KMWL','MWL','MINERAL WELLS','MINERAL WELLS','USA',32,46,53,'N',32.7813888888889,98,3,36,'U',0,973
UNION ALL SELECT 'KMXF','MXF','MAXWELL AFB','MONTGOMERY','USA',32,22,45,'N',32.3791666666667,86,21,45,'U',0,172
UNION ALL SELECT 'KMYR','MYR','MYRTLE BEACH INTERNATIONAL','MYRTLE BEACH','USA',33,40,47,'N',33.6797222222222,78,55,42,'U',0,25
UNION ALL SELECT 'KNAB','ABY','','ALBANY','USA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'KNBC','NBC','BEAUFORT MCAS','BEAUFORT','USA',32,28,38,'N',32.4772222222222,80,43,23,'U',0,36
UNION ALL SELECT 'KNBG','NBG','NEW ORLEANS NAS JRB','NEW ORLEANS','USA',29,49,31,'N',29.8252777777778,90,2,6,'U',0,3
UNION ALL SELECT 'KNEA','BQK','','BRUNSWICK','USA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'KNEL','NEL','LAKEHURST NAES','LAKEHURST','USA',40,2,0,'N',40.0333333333333,74,21,12,'U',0,103
UNION ALL SELECT 'KNFL','NFL','FALLON NAS','FALLON','USA',39,24,59,'N',39.4163888888889,118,42,3,'U',0,3934
UNION ALL SELECT 'KNGU','NGU','NORFOLK NS','NORFOLK','USA',36,56,15,'N',36.9375,76,17,21,'U',0,15
UNION ALL SELECT 'KNHK','NHK','PATUXENT RIVER NAS','PATUXENT RIVER','USA',38,17,9,'N',38.2858333333333,76,24,42,'U',0,39
UNION ALL SELECT 'KNID','NID','CHINA LAKE NAWS','CHINA','USA',35,41,16,'N',35.6877777777778,117,41,26,'U',0,2283
UNION ALL SELECT 'KNIP','NIP','JACKSONVILLE NAS','JACKSONVILLE','USA',30,14,9,'N',30.2358333333333,81,40,50,'U',0,22
UNION ALL SELECT 'KNJK','NJK','EL CENTRO NAF','EL CENTRO','USA',32,49,45,'N',32.8291666666667,115,40,18,'U',0,43
UNION ALL SELECT 'KNKT','NKT','CHERRY POINT MCAS','CHERRY POINT','USA',34,54,9,'N',34.9025,76,52,51,'U',0,28
UNION ALL SELECT 'KNKX','NKX','MIRAMAR MCAS','MIRAMAR','USA',32,52,6,'N',32.8683333333333,117,8,33,'U',0,478
UNION ALL SELECT 'KNLC','NLC','LEMOORE NAS','LEMOORE','USA',36,19,58,'N',36.3327777777778,119,57,7,'U',0,234
UNION ALL SELECT 'KNMM','NMM','MERIDIAN NAS','MERIDIAN','USA',32,33,7,'N',32.5519444444444,88,33,20,'U',0,317
UNION ALL SELECT 'KNOW','NOW','PORT ANGELES CGAS','PORT ANGELES','USA',48,8,29,'N',48.1413888888889,123,24,50,'U',0,13
UNION ALL SELECT 'KNPA','NPA','PENSACOLA NAS','PENSACOLA','USA',30,21,9,'N',30.3525,87,19,7,'U',0,28
UNION ALL SELECT 'KNQA','NQA','MILLINGTON MUNI','MILLINGTON','USA',35,21,24,'N',35.3566666666667,89,52,13,'U',0,320
UNION ALL SELECT 'KNQI','NQI','KINGSVILLE NAS','KINGSVILLE','USA',27,30,26,'N',27.5072222222222,97,48,35,'U',0,50
UNION ALL SELECT 'KNQX','NQX','KEY WEST NAS','KEY WEST','USA',24,34,33,'N',24.5758333333333,81,41,20,'U',0,6
UNION ALL SELECT 'KNRJ','SFB','','SANFORD','USA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'KNSE','NSE','WHITING FLD NAS NORTH','MILTON','USA',30,43,27,'N',30.7241666666667,87,1,19,'U',0,200
UNION ALL SELECT 'KNTD','NTD','POINT MUGU NAS','POINT MUGU','USA',34,7,13,'N',34.1202777777778,119,7,15,'U',0,12
UNION ALL SELECT 'KNTK','NTK','TUSTIN MCAF','TUSTIN','USA',33,42,22,'N',33.7061111111111,117,49,38,'U',0,54
UNION ALL SELECT 'KNTU','NTU','OCEANA NAS','OCEANA','USA',36,49,14,'N',36.8205555555556,76,2,0,'U',0,22
UNION ALL SELECT 'KNUQ','NUQ','MOFFETT FEDERAL AFLD','MOUNTAIN VIEW','USA',37,24,54,'N',37.415,122,2,53,'U',0,32
UNION ALL SELECT 'KNUW','NUW','WHIDBEY ISLAND NAS','WHIDBEY ISLAND','USA',48,21,6,'N',48.3516666666667,122,39,21,'U',0,47
UNION ALL SELECT 'KNXP','NXP','TWENTYNINE PALMS EAF','TWENTY NINE PALMS','USA',34,17,46,'N',34.2961111111111,116,9,43,'U',0,2042
UNION ALL SELECT 'KNXX','NXX','WILLOW GROVE NAS JRB','WILLOW GROVE','USA',40,11,59,'N',40.1997222222222,75,8,53,'U',0,362
UNION ALL SELECT 'KNYG','NYG','QUANTICO MCAF','QUANTICO','USA',38,30,6,'N',38.5016666666667,77,18,19,'U',0,11
UNION ALL SELECT 'KNZC','NZC','CECIL FLD','JACKSONVILLE','USA',30,13,7,'N',30.2186111111111,81,52,35,'U',0,81
UNION ALL SELECT 'KNZY','NZY','NORTH ISLAND NAS','SAN DIEGO','USA',32,41,57,'N',32.6991666666667,117,12,55,'U',0,26
UNION ALL SELECT 'KOAK','OAK','METROPOLITAN OAKLAND INTERNATIONAL','OAKLAND','USA',37,43,16,'N',37.7211111111111,122,13,14,'U',0,6
UNION ALL SELECT 'KOFF','OFF','OFFUTT AFB','OMAHA','USA',41,7,6,'N',41.1183333333333,95,54,45,'U',0,1052
UNION ALL SELECT 'KOGS','OGS','OGDENSBURG INTERNATIONAL','OGDENSBURG','USA',44,40,55,'N',44.6819444444444,75,27,56,'U',0,297
UNION ALL SELECT 'KOKC','OKC','WILL ROGERS WORLD','OKLAHOMA CITY','USA',35,23,35,'N',35.3930555555556,97,36,2,'U',0,1295
UNION ALL SELECT 'KOLS','OLS','NOGALES INTERNATIONAL','NOGALES','USA',31,25,3,'N',31.4175,110,50,52,'U',0,3955
UNION ALL SELECT 'KOMA','OMA','EPPLEY AFLD','OMAHA','USA',41,18,9,'N',41.3025,95,53,37,'U',0,984
UNION ALL SELECT 'KONT','ONT','ONTARIO INTERNATIONAL','ONTARIO','USA',34,3,21,'N',34.0558333333333,117,36,4,'U',0,944
UNION ALL SELECT 'KOPF','OPF','OPA LOCKA','MIAMI','USA',25,54,25,'N',25.9069444444444,80,16,42,'U',0,8
UNION ALL SELECT 'KORD','ORD','CHICAGO OHARE INTERNATIONAL','CHICAGO','USA',41,58,46,'N',41.9794444444444,87,54,16,'U',0,668
UNION ALL SELECT 'KORF','ORF','NORFOLK INTERNATIONAL','NORFOLK','USA',36,53,40,'N',36.8944444444444,76,12,4,'U',0,26
UNION ALL SELECT 'KORL','ORL','EXECUTIVE','ORLANDO','USA',28,32,43,'N',28.5452777777778,81,19,58,'U',0,113
UNION ALL SELECT 'KPAE','PAE','SNOHOMISH CO','EVERETT','USA',47,54,22,'N',47.9061111111111,122,16,53,'U',0,606
UNION ALL SELECT 'KPAM','PAM','TYNDALL AFB','PANAMA CITY','USA',30,4,11,'N',30.0697222222222,85,34,35,'U',0,18
UNION ALL SELECT 'KPBF','PBF','GRIDER FLD','PINE BLUFF','USA',34,10,29,'N',34.1747222222222,91,56,4,'U',0,206
UNION ALL SELECT 'KPBG','PBG','PLATTSBURGH INTERNATIONAL','PLATTSBURGH','USA',44,39,3,'N',44.6508333333333,73,28,5,'U',0,235
UNION ALL SELECT 'KPBI','PBI','PALM BEACH INTERNATIONAL','WEST PALM BEACH','USA',26,40,59,'N',26.6830555555556,80,5,44,'U',0,19
UNION ALL SELECT 'KPDX','PDX','PORTLAND INTERNATIONAL','PORTLAND','USA',45,35,19,'N',45.5886111111111,122,35,51,'U',0,30
UNION ALL SELECT 'KPHF','PHF','NEWPORT NEWS WILLIAMSBURG INTERNATIONAL','NEWPORT NEWS','USA',37,7,54,'N',37.1316666666667,76,29,34,'U',0,43
UNION ALL SELECT 'KPHL','PHL','PHILADELPHIA INTERNATIONAL','PHILADELPHIA','USA',39,52,19,'N',39.8719444444444,75,14,28,'U',0,38
UNION ALL SELECT 'KPHN','PHN','ST CLAIR CO INTERNATIONAL','PORT HURON','USA',42,54,39,'N',42.9108333333333,82,31,43,'U',0,650
UNION ALL SELECT 'KPHX','PHX','PHOENIX SKY HARBOR INTERNATIONAL','PHOENIX','USA',33,26,3,'N',33.4341666666667,112,0,29,'U',0,1135
UNION ALL SELECT 'KPIE','PIE','ST PETERSBURG CLEARWATER INTERNATIONAL','ST. PETERSBURG','USA',27,54,38,'N',27.9105555555556,82,41,14,'U',0,11
UNION ALL SELECT 'KPIT','PIT','PITTSBURGH INTERNATIONAL','PITTSBURGH (PENNSYLVA)','USA',40,29,29,'N',40.4913888888889,80,13,58,'U',0,1204
UNION ALL SELECT 'KPMD','PMD','PALMDALE PROD FLT TEST INSTL AF PLT 42','PALMDALE','USA',34,37,45,'N',34.6291666666667,118,5,4,'U',0,2543
UNION ALL SELECT 'KPNC','PNC','PONCA CITY MUNI','PONCA CITY','USA',36,43,50,'N',36.7305555555556,97,5,59,'U',0,1007
UNION ALL SELECT 'KPNE','PNE','NORTHEAST PHILADELPHIA','PHILADELPHIA','USA',40,4,55,'N',40.0819444444444,75,0,38,'U',0,121
UNION ALL SELECT 'KPNM','PNM','PRINCETON MUNI','PRINCETON','USA',45,33,35,'N',45.5597222222222,93,36,29,'U',0,979
UNION ALL SELECT 'KPNS','PNS','PENSACOLA RGNL','PENSACOLA','USA',30,28,23,'N',30.4730555555556,87,11,14,'U',0,121
UNION ALL SELECT 'KPOB','POB','POPE AFB','FAYETTEVILLE','USA',35,10,15,'N',35.1708333333333,79,0,52,'U',0,217
UNION ALL SELECT 'KPOE','POE','POLK AAF','FORT POLK','USA',31,2,41,'N',31.0447222222222,93,11,29,'U',0,330
UNION ALL SELECT 'KPQI','PQI','NORTHERN MAINE RGNL AT PRESQUE ISLE','PRESQUE ISLE','USA',46,41,20,'N',46.6888888888889,68,2,41,'U',0,534
UNION ALL SELECT 'KPRC','PRC','ERNEST A LOVE FLD','PRESCOTT','USA',34,39,16,'N',34.6544444444444,112,25,10,'U',0,5045
UNION ALL SELECT 'KPSP','PSP','PALM SPRINGS INTERNATIONAL','PALM SPRINGS','USA',33,49,46,'N',33.8294444444444,116,30,24,'U',0,474
UNION ALL SELECT 'KPSX','PSX','PALACIOS MUNI','PALACIOS','USA',28,43,39,'N',28.7275,96,15,3,'U',0,15
UNION ALL SELECT 'KPUB','PUB','PUEBLO MEM','PUEBLO MEMORIAL','USA',38,17,20,'N',38.2888888888889,104,29,47,'U',0,4726
UNION ALL SELECT 'KPVD','PVD','THEODORE FRANCIS GREEN STATE','PROVIDENCE','USA',41,43,26,'N',41.7238888888889,71,25,41,'U',0,55
UNION ALL SELECT 'KPWM','PWM','PORTLAND INTERNATIONAL JETPORT','PORTLAND','USA',43,38,46,'N',43.6461111111111,70,18,31,'U',0,74
UNION ALL SELECT 'KRAL','RAL','RIVERSIDE MUNI','RIVERSIDE','USA',33,57,6,'N',33.9516666666667,117,26,42,'U',0,818
UNION ALL SELECT 'KRBM','RBM','ROBINSON AAF','ROBINSON','USA',34,51,0,'N',34.85,92,18,0,'U',0,587
UNION ALL SELECT 'KRCA','RCA','ELLSWORTH AFB','RAPID CITY','USA',44,8,42,'N',44.145,103,6,12,'U',0,3280
UNION ALL SELECT 'KRDR','RDR','GRAND FORKS AFB','RED RIVER','USA',47,57,39,'N',47.9608333333333,97,24,4,'U',0,911
UNION ALL SELECT 'KRDU','RDU','RALEIGH DURHAM INTERNATIONAL','RALEIGH-DURHAM','USA',35,52,39,'N',35.8775,78,47,14,'U',0,435
UNION ALL SELECT 'KRIC','RIC','RICHMOND INTERNATIONAL','RICHMOND','USA',37,30,18,'N',37.505,77,19,10,'U',0,167
UNION ALL SELECT 'KRIU','RIU','RANCHO MURIETA','RANCHO MURIETA','USA',38,29,19,'N',38.4886111111111,121,6,8,'U',0,141
UNION ALL SELECT 'KRIV','RIV','MARCH ARB','RIVERSIDE','USA',33,52,50,'N',33.8805555555556,117,15,34,'U',0,1535
UNION ALL SELECT 'KRME','RME','GRIFFISS AIRPARK','ROME','USA',43,14,1,'N',43.2336111111111,75,24,25,'U',0,504
UNION ALL SELECT 'KRND','RND','RANDOLPH AFB','SAN ANTONIO','USA',29,31,46,'N',29.5294444444444,98,16,44,'U',0,762
UNION ALL SELECT 'KRNO','RNO','RENO TAHOE INTERNATIONAL','RENO','USA',39,29,54,'N',39.4983333333333,119,46,5,'U',0,4412
UNION ALL SELECT 'KROC','ROC','GREATER ROCHESTER INTERNATIONAL','ROCHESTER','USA',43,7,7,'N',43.1186111111111,77,40,20,'U',0,559
UNION ALL SELECT 'KROW','ROW','ROSWELL INDUSTRIAL AIR CENTER','ROSWELL','USA',33,18,5,'N',33.3013888888889,104,31,50,'U',0,3671
UNION ALL SELECT 'KRSW','RSW','SOUTHWEST FLORIDA INTERNATIONAL','FORT MYERS','USA',26,32,10,'N',26.5361111111111,81,45,18,'U',0,30
UNION ALL SELECT 'KSAC','SAC','SACRAMENTO EXECUTIVE','SACRAMENTO','USA',38,30,45,'N',38.5125,121,29,36,'U',0,24
UNION ALL SELECT 'KSAF','SAF','SANTA FE MUNI','SANTA FE','USA',35,37,0,'N',35.6166666666667,106,5,17,'U',0,6348
UNION ALL SELECT 'KSAN','SAN','SAN DIEGO INTERNATIONAL LINDBERGH FLD','SAN DIEGO','USA',32,44,0,'N',32.7333333333333,117,11,22,'U',0,14
UNION ALL SELECT 'KSAT','SAT','SAN ANTONIO INTERNATIONAL','SAN ANTONIO','USA',29,32,1,'N',29.5336111111111,98,28,11,'U',0,809
UNION ALL SELECT 'KSAV','SAV','SAVANNAH HILTON HEAD INTERNATIONAL','SAVANNAH','USA',32,7,39,'N',32.1275,81,12,7,'U',0,50
UNION ALL SELECT 'KSBO','SBO','EMANUEL CO','SANTA BARBARA','USA',32,36,30,'N',32.6083333333333,82,22,7,'U',0,327
UNION ALL SELECT 'KSBY','SBY','SALISBURY OCEAN CITY WICOMICO RGNL','SALISBURY','USA',38,20,25,'N',38.3402777777778,75,30,37,'U',0,52
UNION ALL SELECT 'KSCI','N/A','','SAN CLEMENTE','USA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'KSCK','SCK','STOCKTON METROPOLITAN','STOCKTON','USA',37,53,39,'N',37.8941666666667,121,14,19,'U',0,30
UNION ALL SELECT 'KSEA','SEA','SEATTLE TACOMA INTERNATIONAL','SEATTLE','USA',47,26,56,'N',47.4488888888889,122,18,33,'U',0,429
UNION ALL SELECT 'KSEM','SEM','CRAIG FLD','SELMA','USA',32,20,38,'N',32.3438888888889,86,59,16,'U',0,166
UNION ALL SELECT 'KSFF','SFF','FELTS FLD','SPOKANE','USA',47,40,58,'N',47.6827777777778,117,19,21,'U',0,1953
UNION ALL SELECT 'KSFO','SFO','SAN FRANCISCO INTERNATIONAL','SAN FRANCISCO','USA',37,37,8,'N',37.6188888888889,122,22,29,'U',0,13
UNION ALL SELECT 'KSFZ','SFZ','NORTH CENTRAL STATE','SMITHFIELD','USA',41,55,14,'N',41.9205555555556,71,29,28,'U',0,441
UNION ALL SELECT 'KSHV','SHV','SHREVEPORT RGNL','SHREVEPORT','USA',32,26,47,'N',32.4463888888889,93,49,32,'U',0,258
UNION ALL SELECT 'KSJC','SJC','NORMAN Y MINETA SAN JOSE INTERNATIONAL','SAN JOSE','USA',37,21,42,'N',37.3616666666667,121,55,44,'U',0,58
UNION ALL SELECT 'KSJT','SJT','SAN ANGELO RGNL MATHIS FLD','SAN ANGELO','USA',31,21,27,'N',31.3575,100,29,46,'U',0,1919
UNION ALL SELECT 'KSKA','SKA','FAIRCHILD AFB','SPOKANE','USA',47,36,54,'N',47.615,117,39,20,'U',0,2462
UNION ALL SELECT 'KSKF','SKF','LACKLAND AFB KELLY FLD ANNEX','SAN ANTONIO','USA',29,23,3,'N',29.3841666666667,98,34,51,'U',0,691
UNION ALL SELECT 'KSKY','SKY','GRIFFING SANDUSKY','SANDUSKY','USA',41,26,0,'N',41.4333333333333,82,39,8,'U',0,580
UNION ALL SELECT 'KSLC','SLC','SALT LAKE CITY INTERNATIONAL','SALT LAKE CITY','USA',40,47,18,'N',40.7883333333333,111,58,39,'U',0,4227
UNION ALL SELECT 'KSMF','SMF','SACRAMENTO INTERNATIONAL','SACRAMENTO','USA',38,41,43,'N',38.6952777777778,121,35,26,'U',0,27
UNION ALL SELECT 'KSNA','SNA','JOHN WAYNE ARPT ORANGE CO','SANTA ANA','USA',33,40,32,'N',33.6755555555556,117,52,5,'U',0,56
UNION ALL SELECT 'KSPB','SPB','SCAPPOOSE INDUSTRIAL AIRPARK','SAN LUIS','USA',45,46,21,'N',45.7725,122,51,44,'U',0,58
UNION ALL SELECT 'KSPG','SPG','ALBERT WHITTED','ST. PETERSBURG','USA',27,45,54,'N',27.765,82,37,37,'U',0,7
UNION ALL SELECT 'KSPS','SPS','SHEPPARD AFB WICHITA FALLS MUNI','WICHITA FALLS','USA',33,59,19,'N',33.9886111111111,98,29,30,'U',0,1019
UNION ALL SELECT 'KSSC','SSC','SHAW AFB','SUMTER','USA',33,58,22,'N',33.9727777777778,80,28,22,'U',0,242
UNION ALL SELECT 'KSTL','STL','LAMBERT ST LOUIS INTERNATIONAL','ST. LOUIS','USA',38,44,51,'N',38.7475,90,21,35,'U',0,604
UNION ALL SELECT 'KSUU','SUU','TRAVIS AFB','FAIRFIELD','USA',38,15,45,'N',38.2625,121,55,38,'U',0,62
UNION ALL SELECT 'KSUX','SUX','SIOUX GATEWAY COL BUD DAY FLD','SIOUX CITY','USA',42,24,9,'N',42.4025,96,23,3,'U',0,1098
UNION ALL SELECT 'KSVN','SVN','HUNTER AAF','HUNTER AAF','USA',32,0,36,'N',32.01,81,8,44,'U',0,42
UNION ALL SELECT 'KSWF','SWF','STEWART INTERNATIONAL','NEWBURGH','USA',41,30,14,'N',41.5038888888889,74,6,17,'U',0,491
UNION ALL SELECT 'KSYR','SYR','SYRACUSE HANCOCK INTERNATIONAL','SYRACUSE','USA',43,6,40,'N',43.1111111111111,76,6,22,'U',0,421
UNION ALL SELECT 'KSZL','SZL','WHITEMAN AFB','KNOBNOSTER','USA',38,43,49,'N',38.7302777777778,93,32,52,'U',0,871
UNION ALL SELECT 'KTBN','TBN','WAYNESVILLE RGNL ARPT AT FORNEY FLD','FORT LEONARDWOOD','USA',37,44,29,'N',37.7413888888889,92,8,26,'U',0,1159
UNION ALL SELECT 'KTCC','TCC','TUCUMCARI MUNI','TUCUMCARI','USA',35,10,58,'N',35.1827777777778,103,36,11,'U',0,4065
UNION ALL SELECT 'KTCM','TCM','MC CHORD AFB','TACOMA','USA',47,8,15,'N',47.1375,122,28,35,'U',0,323
UNION ALL SELECT 'KTCS','TCS','TRUTH OR CONSEQUENCES MUNI','TRUTH OR CONSEQUENCES','USA',33,14,13,'N',33.2369444444444,107,16,18,'U',0,4853
UNION ALL SELECT 'KTEB','TEB','TETERBORO','TETERBORO','USA',40,50,59,'N',40.8497222222222,74,3,39,'U',0,9
UNION ALL SELECT 'KTIK','TIK','TINKER AFB','OKLAHOMA CITY','USA',35,24,53,'N',35.4147222222222,97,23,11,'U',0,1291
UNION ALL SELECT 'KTLH','TLH','TALLAHASSEE RGNL','TALLAHASSEE','USA',30,23,47,'N',30.3963888888889,84,21,1,'U',0,81
UNION ALL SELECT 'KTMB','TMB','KENDALL TAMIAMI EXECUTIVE','KENDALL-TAMIAMI','USA',25,38,52,'N',25.6477777777778,80,25,58,'U',0,8
UNION ALL SELECT 'KTNT','TNT','DADE COLLIER TRAINING AND TRANSITION','MIAMI','USA',25,51,42,'N',25.8616666666667,80,53,49,'U',0,13
UNION ALL SELECT 'KTPA','TPA','TAMPA INTERNATIONAL','TAMPA','USA',27,58,31,'N',27.9752777777778,82,31,59,'U',0,26
UNION ALL SELECT 'KTTN','TTN','TRENTON MERCER','TRENTON','USA',40,16,36,'N',40.2766666666667,74,48,48,'U',0,213
UNION ALL SELECT 'KTUL','TUL','TULSA INTERNATIONAL','TULSA','USA',36,11,54,'N',36.1983333333333,95,53,17,'U',0,677
UNION ALL SELECT 'KTUS','TUS','TUCSON INTERNATIONAL','TUCSON','USA',32,6,58,'N',32.1161111111111,110,56,29,'U',0,2643
UNION ALL SELECT 'KTXK','TXK','TEXARKANA RGNL WEBB FLD','TEXARKANA','USA',33,27,13,'N',33.4536111111111,93,59,27,'U',0,390
UNION ALL SELECT 'KTYR','TYR','TYLER POUNDS RGNL','TYLER','USA',32,21,14,'N',32.3538888888889,95,24,8,'U',0,544
UNION ALL SELECT 'KTYS','TYS','MC GHEE TYSON','KNOXVILLE','USA',35,48,44,'N',35.8122222222222,83,59,34,'U',0,981
UNION ALL SELECT 'KUGN','UGN','WAUKEGAN RGNL','CHICAGO','USA',42,25,19,'N',42.4219444444444,87,52,4,'U',0,727
UNION ALL SELECT 'KVAD','VAD','MOODY AFB','VALDOSTA','USA',30,58,4,'N',30.9677777777778,83,11,34,'U',0,235
UNION ALL SELECT 'KVBG','VBG','VANDENBERG AFB','LOMPOC','USA',34,43,46,'N',34.7294444444444,120,34,36,'U',0,367
UNION ALL SELECT 'KVCV','VCV','SOUTHERN CALIFORNIA LOGISTICS','VICTORVILLE','USA',34,35,35,'N',34.5930555555556,117,22,46,'U',0,2885
UNION ALL SELECT 'KVPS','VPS','EGLIN AFB','VALPARAISO','USA (FLORIDA',30,28,59,'N',30.4830555555556,86,31,31,'U',0,87
UNION ALL SELECT 'KVRB','VRB','VERO BEACH MUNI','VERO BEACH','USA',27,39,20,'N',27.6555555555556,80,25,4,'U',0,24
UNION ALL SELECT 'KWAL','WAL','WALLOPS FLIGHT FACILITY','WALLOPS ISLAND','USA',37,56,24,'N',37.94,75,27,59,'U',0,40
UNION ALL SELECT 'KWRB','WRB','ROBINS AFB','MACON','USA',32,38,24,'N',32.64,83,35,30,'U',0,294
UNION ALL SELECT 'KWRI','WRI','MC GUIRE AFB','WRIGHTSTOWN','USA',40,0,56,'N',40.0155555555556,74,35,37,'U',0,133
UNION ALL SELECT 'KWSD','WSD','CONDRON AAF','WHITE SANDS','USA',32,20,29,'N',32.3413888888889,106,24,9,'U',0,3934
UNION ALL SELECT 'KWWD','WWD','CAPE MAY CO','WILDWOOD','USA',39,0,30,'N',39.0083333333333,74,54,29,'U',0,23
UNION ALL SELECT 'KYIP','YIP','WILLOW RUN','DETROIT','USA',42,14,16,'N',42.2377777777778,83,31,49,'U',0,716
UNION ALL SELECT 'KYNG','YNG','YOUNGSTOWN WARREN RGNL','YOUNGSTOWN','USA',41,15,38,'N',41.2605555555556,80,40,44,'U',0,1196
UNION ALL SELECT 'KYUM','YUM','YUMA MCAS YUMA INTERNATIONAL','YUMA','USA',32,39,23,'N',32.6563888888889,114,36,21,'U',0,213
UNION ALL SELECT 'KZUN','ZUN','BLACK ROCK','ZUNI PUEBLO','USA',35,5,0,'N',35.0833333333333,108,47,30,'U',0,6454
UNION ALL SELECT 'LATI','TIA','TIRANA RINAS','TIRANA','ALBANIA',41,24,53,'N',41.4147222222222,19,43,14,'E',19.7205555555556,125
UNION ALL SELECT 'LBBG','BOJ','BURGAS','BOURGAS','BULGARIA',42,34,8,'N',42.5688888888889,27,30,50,'E',27.5138888888889,135
UNION ALL SELECT 'LBGO','GOZ','GORNA ORYAHOVITSA','GORNA ORECHOVICA','BULGARIA',43,9,5,'N',43.1513888888889,25,42,46,'E',25.7127777777778,285
UNION ALL SELECT 'LBPD','PDV','PLOVDIV','PLOVDIV','BULGARIA',42,4,4,'N',42.0677777777778,24,51,3,'E',24.8508333333333,597
UNION ALL SELECT 'LBRS','ROU','','ROUSSE','BULGARIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LBSF','SOF','SOFIA','SOFIA','BULGARIA',42,41,42,'N',42.695,23,24,22,'E',23.4061111111111,1742
UNION ALL SELECT 'LBWN','VAR','VARNA','VARNA','BULGARIA',43,13,55,'N',43.2319444444444,27,49,30,'E',27.825,230
UNION ALL SELECT 'LCLK','LCA','LARNACA','LARNACA','CYPRUS',34,52,30,'N',34.875,33,37,29,'E',33.6247222222222,8
UNION ALL SELECT 'LCPH','PFO','PAPHOS INTERNATIONAL','PAPHOS','CYPRUS',34,43,4,'N',34.7177777777778,32,29,8,'E',32.4855555555556,41
UNION ALL SELECT 'LCRA','AKT','AKROTIRI','AKROTIRI','CYPRUS',34,35,25,'N',34.5902777777778,32,59,16,'E',32.9877777777778,76
UNION ALL SELECT 'LDAU','ELU','','EL OUED','ALGERIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LDDU','DBV','DUBROVNIK','DUBROVNIK','CROATIA',42,33,40,'N',42.5611111111111,18,16,5,'E',18.2680555555556,528
UNION ALL SELECT 'LDOS','OSI','OSIJEK','OSIJEK','CROATIA',45,27,45,'N',45.4625,18,48,41,'E',18.8113888888889,290
UNION ALL SELECT 'LDPL','PUY','PULA','PULA','CROATIA',44,53,36,'N',44.8933333333333,13,55,19,'E',13.9219444444444,276
UNION ALL SELECT 'LDRI','RJK','RIJEKA','RIJEKA','CROATIA',45,13,0,'N',45.2166666666667,14,34,12,'E',14.57,278
UNION ALL SELECT 'LDSP','SPU','SPLIT','SPLIT','CROATIA',43,32,20,'N',43.5388888888889,16,17,52,'E',16.2977777777778,79
UNION ALL SELECT 'LDZA','ZAG','ZAGREB','ZAGREB','CROATIA',45,44,34,'N',45.7427777777778,16,4,7,'E',16.0686111111111,351
UNION ALL SELECT 'LDZD','ZAD','ZADAR','ZADAR','CROATIA',44,6,29,'N',44.1080555555556,15,20,48,'E',15.3466666666667,289
UNION ALL SELECT 'LEAL','ALC','ALICANTE','ALICANTE','SPAIN',38,16,55,'N',38.2819444444444,0,33,29,'U',0,142
UNION ALL SELECT 'LEAM','LEI','ALMERIA','ALMERIA','SPAIN',36,50,38,'N',36.8438888888889,2,22,12,'U',0,70
UNION ALL SELECT 'LEAS','OVD','ASTURIAS','AVILES','SPAIN',43,33,48,'N',43.5633333333333,6,2,4,'U',0,416
UNION ALL SELECT 'LEBA','ODB','CORDOBA','CORDOBA','SPAIN',37,50,31,'N',37.8419444444444,4,50,55,'U',0,297
UNION ALL SELECT 'LEBB','BIO','BILBAO','BILBAO','SPAIN',43,18,3,'N',43.3008333333333,2,54,38,'U',0,138
UNION ALL SELECT 'LEBL','BCN','BARCELONA','BARCELONA','SPAIN',41,17,49,'N',41.2969444444444,2,4,42,'E',2.07833333333333,12
UNION ALL SELECT 'LEBZ','BJZ','TALAVERA LA REAL','BADAJOZ','SPAIN',38,53,28,'N',38.8911111111111,6,49,16,'U',0,609
UNION ALL SELECT 'LECO','LCG','A CORUNA','LA CORUNA','SPAIN',43,18,7,'N',43.3019444444444,8,22,38,'U',0,329
UNION ALL SELECT 'LEGA','GRX','ARMILLA','GRANADA','SPAIN',37,7,59,'N',37.1330555555556,3,38,8,'U',0,2297
UNION ALL SELECT 'LEGE','GRO','GIRONA','GERONA','SPAIN',41,54,3,'N',41.9008333333333,2,45,37,'E',2.76027777777778,468
UNION ALL SELECT 'LEGR','GRX','GRANADA','GRANADA','SPAIN',37,11,19,'N',37.1886111111111,3,46,38,'U',0,1860
UNION ALL SELECT 'LEIB','IBZ','IBIZA','IBIZA','SPAIN',38,52,22,'N',38.8727777777778,1,22,23,'E',1.37305555555556,21
UNION ALL SELECT 'LEJR','XRY','JEREZ','JEREZ','SPAIN',36,44,40,'N',36.7444444444444,6,3,36,'U',0,93
UNION ALL SELECT 'LELC','MJV','MURCIA SAN JAVIER','MURCIA','SPAIN',37,46,29,'N',37.7747222222222,0,48,44,'U',0,11
UNION ALL SELECT 'LEMD','MAD','BARAJAS','MADRID','SPAIN',40,28,20,'N',40.4722222222222,3,33,39,'U',0,2000
UNION ALL SELECT 'LEMG','AGP','MALAGA','MALAGA','SPAIN',36,40,25,'N',36.6736111111111,4,29,56,'U',0,52
UNION ALL SELECT 'LEMH','MAH','MENORCA','MENORCA','SPAIN',39,51,45,'N',39.8625,4,13,7,'E',4.21861111111111,298
UNION ALL SELECT 'LEMO','OZP','MORON AB','SEVILLA','SPAIN',37,10,29,'N',37.1747222222222,5,36,57,'U',0,285
UNION ALL SELECT 'LEPA','PMI','PALMA DE MALLORCA','PALMA DE MALLORCA','SPAIN',39,33,0,'N',39.55,2,44,0,'E',2.73333333333333,8
UNION ALL SELECT 'LEPP','PNA','PAMPLONA','PAMPLONA','SPAIN',42,46,12,'N',42.77,1,38,46,'U',0,1504
UNION ALL SELECT 'LERS','REU','REUS','REUS','SPAIN',41,8,50,'N',41.1472222222222,1,10,1,'E',1.16694444444444,234
UNION ALL SELECT 'LESA','SLM','SALAMANCA','SALAMANCA','SPAIN',40,57,7,'N',40.9519444444445,5,30,7,'U',0,2595
UNION ALL SELECT 'LESO','EAS','SAN SEBASTIAN','SAN SEBASTIAN','SPAIN',43,21,23,'N',43.3563888888889,1,47,26,'U',0,15
UNION ALL SELECT 'LEST','SCQ','SANTIAGO','SANTIAGO','SPAIN',42,53,46,'N',42.8961111111111,8,24,54,'U',0,1213
UNION ALL SELECT 'LESU','LEU','SEO DE URGEL','SEO DE URGEL','SPAIN',42,20,19,'N',42.3386111111111,1,24,33,'E',1.40916666666667,2625
UNION ALL SELECT 'LETO','TOJ','TORREJON','MADRID','SPAIN',40,29,12,'N',40.4866666666667,3,27,29,'U',0,1994
UNION ALL SELECT 'LEVC','VLC','VALENCIA','VALENCIA','SPAIN',39,29,21,'N',39.4891666666667,0,28,53,'U',0,225
UNION ALL SELECT 'LEVD','VLL','VALLADOLID','VALLADOLID','SPAIN',41,42,22,'N',41.7061111111111,4,51,7,'U',0,2775
UNION ALL SELECT 'LEVT','VIT','VITORIA','VITORIA','SPAIN',42,52,58,'N',42.8827777777778,2,43,28,'U',0,1682
UNION ALL SELECT 'LEVX','VGO','VIGO','VIGO','SPAIN',42,13,54,'N',42.2316666666667,8,37,36,'U',0,855
UNION ALL SELECT 'LEXJ','SDR','SANTANDER','SANTANDER','SPAIN',43,25,37,'N',43.4269444444444,3,49,12,'U',0,16
UNION ALL SELECT 'LEZG','ZAZ','ZARAGOZA AB','ZARAGOZA','SPAIN',41,39,58,'N',41.6661111111111,1,2,29,'U',0,863
UNION ALL SELECT 'LEZL','SVQ','SEVILLA','SEVILLA','SPAIN',37,25,4,'N',37.4177777777778,5,53,35,'U',0,111
UNION ALL SELECT 'LFAC','CQF','CALAIS DUNKERQUE','CALAIS','FRANCE',50,57,43,'N',50.9619444444444,1,57,17,'E',1.95472222222222,11
UNION ALL SELECT 'LFAT','LTQ','LE TOUQUET PARIS PLAGE','LE TOURQUET','FRANCE',50,30,53,'N',50.5147222222222,1,37,38,'E',1.62722222222222,36
UNION ALL SELECT 'LFBA','AGF','LA GARENNE','AGEN','FRANCE',44,10,29,'N',44.1747222222222,0,35,26,'E',0.590555555555556,204
UNION ALL SELECT 'LFBD','BOD','MERIGNAC','BORDEAUX','FRANCE',44,49,42,'N',44.8283333333333,0,42,56,'U',0,162
UNION ALL SELECT 'LFBE','EGC','ROUMANIERE','BERGERAC','FRANCE',44,49,31,'N',44.8252777777778,0,31,7,'E',0.518611111111111,171
UNION ALL SELECT 'LFBG','CNG','CHATEAUBERNARD','COGNAC','FRANCE',45,39,30,'N',45.6583333333333,0,19,3,'U',0,102
UNION ALL SELECT 'LFBI','PIS','BIARD','POITIERS','FRANCE',46,35,15,'N',46.5875,0,18,24,'E',0.306666666666667,423
UNION ALL SELECT 'LFBK','MCU','MONTLUCON GUERET','MONTLUCON-GUERET','FRANCE',46,13,28,'N',46.2244444444444,2,21,47,'E',2.36305555555556,1367
UNION ALL SELECT 'LFBL','LIG','BELLEGARDE','LIMOGES','FRANCE',45,51,46,'N',45.8627777777778,1,10,46,'E',1.17944444444444,1299
UNION ALL SELECT 'LFBN','NIT','SOUCHE','NIORT','FRANCE',46,18,40,'N',46.3111111111111,0,24,5,'U',0,201
UNION ALL SELECT 'LFBO','TLS','BLAGNAC','TOULOUSE','FRANCE',43,37,44,'N',43.6288888888889,1,21,49,'E',1.36361111111111,499
UNION ALL SELECT 'LFBP','PUF','PAU PYRENEES','PAU','FRANCE',43,22,48,'N',43.38,0,25,7,'U',0,616
UNION ALL SELECT 'LFBR','LRH','LHERM','LA ROCHELLE','FRANCE',43,26,56,'N',43.4488888888889,1,15,48,'E',1.26333333333333,622
UNION ALL SELECT 'LFBT','LDE','LOURDES','TARBES','FRANCE',43,10,43,'N',43.1786111111111,0,0,23,'U',0,1260
UNION ALL SELECT 'LFBU','ANG','BRIE CHAMPNIERS','ANGOULEME','FRANCE',45,43,45,'N',45.7291666666667,0,13,17,'E',0.221388888888889,436
UNION ALL SELECT 'LFBV','BVE','LA ROCHE','BRIVE','FRANCE',45,9,3,'N',45.1508333333333,1,28,9,'E',1.46916666666667,379
UNION ALL SELECT 'LFBX','PGX','BASSILLAC','PERIGUEUX','FRANCE',45,11,53,'N',45.1980555555556,0,48,56,'E',0.815555555555556,328
UNION ALL SELECT 'LFBZ','BIQ','ANGLET','BIARRITZ-BAYONNE','FRANCE',43,28,6,'N',43.4683333333333,1,31,23,'U',0,245
UNION ALL SELECT 'LFCH','XAC','LA TESTE DE BUCH','ARCACHON','FRANCE',44,35,47,'N',44.5963888888889,1,6,39,'U',0,49
UNION ALL SELECT 'LFCI','LBI','LE SEQUESTRE','ALBI','FRANCE',43,54,49,'N',43.9136111111111,2,6,47,'E',2.11305555555556,564
UNION ALL SELECT 'LFCK','DCM','MAZAMET','CASTRES','FRANCE',43,33,22,'N',43.5561111111111,2,17,21,'E',2.28916666666667,788
UNION ALL SELECT 'LFCR','RDZ','MARCILLAC','RODEZ','FRANCE',44,24,28,'N',44.4077777777778,2,28,57,'E',2.4825,1906
UNION ALL SELECT 'LFCY','RYN','MEDIS','ROYAN','FRANCE',45,37,41,'N',45.6280555555556,0,58,21,'U',0,72
UNION ALL SELECT 'LFDN','RCO','ST AGNANT','ROCHEFORT','FRANCE',45,53,16,'N',45.8877777777778,0,58,59,'U',0,56
UNION ALL SELECT 'LFGA','CMR','HOUSSEN','COLMAR','FRANCE',48,6,35,'N',48.1097222222222,7,21,32,'E',7.35888888888889,628
UNION ALL SELECT 'LFGJ','DLE','TAVAUX','DOLE','FRANCE',47,2,20,'N',47.0388888888889,5,25,38,'E',5.42722222222222,645
UNION ALL SELECT 'LFHO','OBS','VALS LANAS','AUBENAS-VALS-LANAS','FRANCE',44,32,39,'N',44.5441666666667,4,22,19,'E',4.37194444444444,923
UNION ALL SELECT 'LFHP','LPY','LOUDES','LE PUY','FRANCE',45,4,46,'N',45.0794444444444,3,45,53,'E',3.76472222222222,2731
UNION ALL SELECT 'LFHS','XBK','CEYZERIAT','BOURG','FRANCE',46,12,3,'N',46.2008333333333,5,17,31,'E',5.29194444444444,857
UNION ALL SELECT 'LFHV','XVF','TARARE','VILEFRANCE','FRANCE',45,54,59,'N',45.9163888888889,4,38,26,'E',4.64055555555556,1076
UNION ALL SELECT 'LFHY','XMU','MONTBEUGNY','MOULINS','FRANCE',46,32,4,'N',46.5344444444444,3,25,25,'E',3.42361111111111,915
UNION ALL SELECT 'LFJL','ETZ','METZ NANCY LORRAINE','METZ','FRANCE',48,58,56,'N',48.9822222222222,6,15,13,'E',6.25361111111111,870
UNION ALL SELECT 'LFKB','BIA','PORETTA','BASTIA','CORSE ISL.',42,33,14,'N',42.5538888888889,9,29,0,'E',9.48333333333333,26
UNION ALL SELECT 'LFKC','CLY','SAINT CATHERINE','CALVI','CORSE ISL.',42,31,50,'N',42.5305555555556,8,47,35,'E',8.79305555555556,209
UNION ALL SELECT 'LFKF','FSC','SUD CORSE','FIGARI','CORSE ISL.',41,30,2,'N',41.5005555555556,9,5,52,'E',9.09777777777778,87
UNION ALL SELECT 'LFKJ','AJA','CAMPO DELL ORO','AJACCIO','CORSE ISL.',41,55,25,'N',41.9236111111111,8,48,10,'E',8.80277777777778,18
UNION ALL SELECT 'LFKS','SOZ','SOLENZARA','SOLENZARA','CORSE ISL.',41,55,27,'N',41.9241666666667,9,24,21,'E',9.40583333333333,28
UNION ALL SELECT 'LFLA','AUF','BRANCHES','AUXERRE','FRANCE',47,51,0,'N',47.85,3,29,49,'E',3.49694444444444,523
UNION ALL SELECT 'LFLB','CMF','AIX LES BAINS','CHAMBERY','FRANCE',45,38,16,'N',45.6377777777778,5,52,48,'E',5.88,779
UNION ALL SELECT 'LFLC','CFE','AUVERGNE','CLERMONT FERRAND','FRANCE',45,47,11,'N',45.7863888888889,3,10,9,'E',3.16916666666667,1090
UNION ALL SELECT 'LFLD','BOU','BOURGES','BOURGES','FRANCE',47,3,29,'N',47.0580555555556,2,22,13,'E',2.37027777777778,529
UNION ALL SELECT 'LFLH','XCD','CHAMPFORGEUIL','CHALON','FRANCE',46,49,33,'N',46.8258333333333,4,49,3,'E',4.8175,623
UNION ALL SELECT 'LFLI','QNJ','ANNEMASSE','ANNEMASSE','FRANCE',46,11,31,'N',46.1919444444444,6,16,6,'E',6.26833333333333,1617
UNION ALL SELECT 'LFLJ','CVF','','COURCHEVEL','FRANCE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LFLL','LYS','SAINT EXUPERY','LYON','FRANCE',45,43,34,'N',45.7261111111111,5,5,27,'E',5.09083333333333,821
UNION ALL SELECT 'LFLM','QNX','CHARNAY','MACON','FRANCE',46,17,42,'N',46.295,4,47,44,'E',4.79555555555556,728
UNION ALL SELECT 'LFLO','RNE','RENAISON','ROANNE','FRANCE',46,3,30,'N',46.0583333333333,4,0,5,'E',4.00138888888889,1106
UNION ALL SELECT 'LFLP','NCY','MEYTHET','ANNECY','FRANCE',45,55,45,'N',45.9291666666667,6,5,55,'E',6.09861111111111,1521
UNION ALL SELECT 'LFLS','GNB','SAINT GEOIRS','GRENOBLE','FRANCE',45,21,46,'N',45.3627777777778,5,19,45,'E',5.32916666666667,1302
UNION ALL SELECT 'LFLT','MCU','DOMERAT','MONTLUCON','FRANCE',46,21,9,'N',46.3525,2,34,13,'E',2.57027777777778,771
UNION ALL SELECT 'LFLU','VAF','CHABEUIL','VALENCE','FRANCE',44,55,17,'N',44.9213888888889,4,58,11,'E',4.96972222222222,525
UNION ALL SELECT 'LFLV','VHY','CHARMEIL','VICHY','FRANCE',46,10,10,'N',46.1694444444444,3,24,13,'E',3.40361111111111,817
UNION ALL SELECT 'LFLW','AUR','AURILLAC','AURILLAC','FRANCE',44,53,29,'N',44.8913888888889,2,25,19,'E',2.42194444444444,2096
UNION ALL SELECT 'LFLX','CHR','DEOLS','CHATEAUROUX','FRANCE',46,51,43,'N',46.8619444444444,1,43,50,'E',1.73055555555556,530
UNION ALL SELECT 'LFLY','LYN','BRON','LYON','FRANCE',45,43,41,'N',45.7280555555556,4,56,41,'E',4.94472222222222,659
UNION ALL SELECT 'LFMA','QXB','AIX LES MILLES','AIX-LES-MILLES','FRANCE',43,30,19,'N',43.5052777777778,5,22,4,'E',5.36777777777778,367
UNION ALL SELECT 'LFMD','CEQ','MANDELIEU','CANNES','FRANCE',43,32,31,'N',43.5419444444444,6,57,12,'E',6.95333333333333,13
UNION ALL SELECT 'LFMH','EBU','BOUTHEON','ST.-ETIENNE','FRANCE',45,32,25,'N',45.5402777777778,4,17,47,'E',4.29638888888889,1325
UNION ALL SELECT 'LFMK','CCF','SALVAZA','CARCASSONNE','FRANCE',43,12,57,'N',43.2158333333333,2,18,22,'E',2.30611111111111,433
UNION ALL SELECT 'LFML','MRS','PROVENCE','MARSEILLE','FRANCE',43,26,8,'N',43.4355555555556,5,12,49,'E',5.21361111111111,74
UNION ALL SELECT 'LFMN','NCE','COTE D AZUR','NICE','FRANCE',43,39,38,'N',43.6605555555556,7,13,3,'E',7.2175,13
UNION ALL SELECT 'LFMP','PGF','RIVESALTES','PERPIGNAN','FRANCE',42,44,25,'N',42.7402777777778,2,52,14,'E',2.87055555555556,144
UNION ALL SELECT 'LFMQ','CTT','LE CASTELLET','LE CASTELLET','FRANCE',43,15,9,'N',43.2525,5,47,6,'E',5.785,1391
UNION ALL SELECT 'LFMT','MPL','MEDITERRANEE','MONTPELLIER','FRANCE',43,34,34,'N',43.5761111111111,3,57,46,'E',3.96277777777778,17
UNION ALL SELECT 'LFMU','BZR','VIAS','BEZIERS','FRANCE',43,19,26,'N',43.3238888888889,3,21,20,'E',3.35555555555556,56
UNION ALL SELECT 'LFMV','AVN','CAUMONT','AVIGNON','FRANCE',43,54,26,'N',43.9072222222222,4,54,6,'E',4.90166666666667,124
UNION ALL SELECT 'LFNB','MEN','BRENOUX','MENDE','FRANCE',44,30,7,'N',44.5019444444444,3,31,58,'E',3.53277777777778,3362
UNION ALL SELECT 'LFOB','BVA','TILLE','BEAUVAIS','FRANCE',49,27,16,'N',49.4544444444444,2,6,46,'E',2.11277777777778,359
UNION ALL SELECT 'LFOH','LEH','OCTEVILLE','LE HAVRE','FRANCE',49,32,2,'N',49.5338888888889,0,5,17,'E',0.0880555555555556,313
UNION ALL SELECT 'LFOJ','ORE','BRICY','ORLEANS','FRANCE',47,59,16,'N',47.9877777777778,1,45,38,'E',1.76055555555556,412
UNION ALL SELECT 'LFOP','URO','VALLEE DE SEINE','ROUEN','FRANCE',49,23,3,'N',49.3841666666667,1,10,29,'E',1.17472222222222,512
UNION ALL SELECT 'LFOT','TUF','VAL DE LOIRE','TOURS','FRANCE',47,25,56,'N',47.4322222222222,0,43,39,'E',0.7275,357
UNION ALL SELECT 'LFOU','CET','LE PONTREAU','CHOLET','FRANCE',47,4,55,'N',47.0819444444444,0,52,37,'U',0,443
UNION ALL SELECT 'LFOV','LVA','ENTRAMMES','LAVAL','FRANCE',48,1,52,'N',48.0311111111111,0,44,34,'U',0,328
UNION ALL SELECT 'LFPB','LBG','LE BOURGET','PARIS','FRANCE',48,58,10,'N',48.9694444444444,2,26,29,'E',2.44138888888889,218
UNION ALL SELECT 'LFPC','CSF','CREIL','CREIL','FRANCE',49,15,12,'N',49.2533333333333,2,31,8,'E',2.51888888888889,291
UNION ALL SELECT 'LFPG','CDG','CHARLES DE GAULLE','PARIS','FRANCE',49,0,46,'N',49.0127777777778,2,33,0,'E',2.55,392
UNION ALL SELECT 'LFPI','JDP','','PARIS','FRANCE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LFPN','TNF','TOUSSUS LE NOBLE','TOUSSOUS-LE-NOBLE','FRANCE',48,45,6,'N',48.7516666666667,2,6,22,'E',2.10611111111111,538
UNION ALL SELECT 'LFPO','ORY','ORLY','PARIS','FRANCE',48,43,31,'N',48.7252777777778,2,21,34,'E',2.35944444444444,291
UNION ALL SELECT 'LFPT','POX','CORMEILLES EN VEXIN','PONTOISE','FRANCE',49,5,47,'N',49.0963888888889,2,2,27,'E',2.04083333333333,326
UNION ALL SELECT 'LFQB','QYR','BARBEREY','TROYES','FRANCE',48,19,22,'N',48.3227777777778,4,1,4,'E',4.01777777777778,388
UNION ALL SELECT 'LFQG','NVS','FOURCHAMBAULT','NEVERS','FRANCE',47,0,4,'N',47.0011111111111,3,6,52,'E',3.11444444444444,602
UNION ALL SELECT 'LFQQ','LIL','LESQUIN','LILLE','FRANCE',50,33,42,'N',50.5616666666667,3,5,22,'E',3.08944444444444,157
UNION ALL SELECT 'LFRB','BES','GUIPAVAS','BREST','FRANCE',48,26,52,'N',48.4477777777778,4,25,6,'U',0,325
UNION ALL SELECT 'LFRC','CER','MAUPERTUS','CHERBOURG','FRANCE',49,39,0,'N',49.65,1,28,13,'U',0,459
UNION ALL SELECT 'LFRD','DNR','PLEURTUIT','DINARD','FRANCE',48,35,16,'N',48.5877777777778,2,4,48,'U',0,217
UNION ALL SELECT 'LFRG','DOL','ST GATIEN','DEAUVILLE','FRANCE',49,21,55,'N',49.3652777777778,0,9,15,'E',0.154166666666667,479
UNION ALL SELECT 'LFRH','LRT','LANN BIHOUE','LORIENT','FRANCE',47,45,38,'N',47.7605555555556,3,26,24,'U',0,169
UNION ALL SELECT 'LFRI','EDM','LES AJONCS','LA ROCHE-SUR-YON','FRANCE',46,42,7,'N',46.7019444444445,1,22,43,'U',0,299
UNION ALL SELECT 'LFRK','CFR','CARPIQUET','CAEN','FRANCE',49,10,24,'N',49.1733333333333,0,27,0,'U',0,256
UNION ALL SELECT 'LFRM','LME','ARNAGE','LE MANS','FRANCE',47,56,55,'N',47.9486111111111,0,12,6,'E',0.201666666666667,194
UNION ALL SELECT 'LFRN','RNS','ST JACQUES','RENNES','FRANCE',48,4,10,'N',48.0694444444444,1,44,5,'U',0,124
UNION ALL SELECT 'LFRO','LAI','LANNION','LANNION','FRANCE',48,45,15,'N',48.7541666666667,3,28,17,'U',0,290
UNION ALL SELECT 'LFRQ','UIP','PLUGUFFAN','QUIMPER','FRANCE',47,58,29,'N',47.9747222222222,4,10,4,'U',0,297
UNION ALL SELECT 'LFRS','NTE','NANTES ATLANTIQUE','NANTES','FRANCE',47,9,11,'N',47.1530555555556,1,36,38,'U',0,90
UNION ALL SELECT 'LFRT','SBK','ARMOR','ST.-BRIEUC ARMOR','FRANCE',48,32,16,'N',48.5377777777778,2,51,16,'U',0,453
UNION ALL SELECT 'LFRU','MXN','PLOUJEAN','MORLAIX','FRANCE',48,36,11,'N',48.6030555555556,3,48,56,'U',0,272
UNION ALL SELECT 'LFRV','VNE','MEUCON','VANNES','FRANCE',47,43,23,'N',47.7230555555556,2,43,6,'U',0,440
UNION ALL SELECT 'LFRZ','SNR','MONTOIR','ST.-NAZAIRE','FRANCE',47,18,43,'N',47.3119444444444,2,8,57,'U',0,13
UNION ALL SELECT 'LFSB','MLH','BALE MULHOUSE','MULHOUSE','FRANCE',47,35,22,'N',47.5894444444444,7,31,47,'E',7.52972222222222,885
UNION ALL SELECT 'LFSD','DIJ','LONGVIC','DIJON','FRANCE',47,16,8,'N',47.2688888888889,5,5,24,'E',5.09,726
UNION ALL SELECT 'LFSF','MZM','FRESCATY','METZ','FRANCE',49,4,18,'N',49.0716666666667,6,7,54,'E',6.13166666666667,629
UNION ALL SELECT 'LFSG','EPL','MIRECOURT','EPINAL','FRANCE',48,19,29,'N',48.3247222222222,6,4,11,'E',6.06972222222222,1084
UNION ALL SELECT 'LFSN','ENC','ESSEY','NANCY','FRANCE',48,41,31,'N',48.6919444444444,6,13,49,'E',6.23027777777778,751
UNION ALL SELECT 'LFSQ','BOR','','BELFORT','FRANCE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LFSR','RHE','CHAMPAGNE','REIMS','FRANCE',49,18,36,'N',49.31,4,3,0,'E',4.05,314
UNION ALL SELECT 'LFST','SXB','ENTZHEIM','STRASSBOURG','FRANCE',48,32,17,'N',48.5380555555556,7,37,41,'E',7.62805555555556,505
UNION ALL SELECT 'LFTH','TLN','HYERES','HYERES','FRANCE',43,5,50,'N',43.0972222222222,6,8,45,'E',6.14583333333333,7
UNION ALL SELECT 'LFTR','TLN','','TOULON','FRANCE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LFTW','FNI','GARONS','NIMES','FRANCE',43,45,26,'N',43.7572222222222,4,24,58,'E',4.41611111111111,309
UNION ALL SELECT 'LFVP','FSP','ST PIERRE','ST.-PIERRE','ST. PIERRE & MIQUELON',46,45,45,'N',46.7625,56,10,31,'U',0,27
UNION ALL SELECT 'LGAD','PYR','ANDRAVIDA','ANDRAVIDA','GREECE',37,55,14,'N',37.9205555555556,21,17,33,'E',21.2925,55
UNION ALL SELECT 'LGAG','AGQ','AGRINION','AGRINION','GREECE',38,36,7,'N',38.6019444444444,21,21,4,'E',21.3511111111111,98
UNION ALL SELECT 'LGAL','AXD','DIMOKRITOS','ALEXANDROUPOLIS','GREECE',40,51,21,'N',40.8558333333333,25,57,22,'E',25.9561111111111,24
UNION ALL SELECT 'LGAT','HEW','ATHINAI','ATHENS','GREECE',37,53,16,'N',37.8877777777778,23,43,54,'E',23.7316666666667,68
UNION ALL SELECT 'LGBL','VOL','NEA ANCHIALOS','NEA ANGHIALOS','GREECE',39,13,10,'N',39.2194444444444,22,47,39,'E',22.7941666666667,82
UNION ALL SELECT 'LGHI','JKH','CHIOS','CHIOS','GREECE',38,20,35,'N',38.3430555555556,26,8,26,'E',26.1405555555556,18
UNION ALL SELECT 'LGIO','IOA','IOANNINA','IOANNINA','GREECE',39,41,47,'N',39.6963888888889,20,49,21,'E',20.8225,1563
UNION ALL SELECT 'LGIR','HER','NIKOS KAZANTZAKIS','HERAKLION','GREECE',35,20,22,'N',35.3394444444444,25,10,49,'E',25.1802777777778,115
UNION ALL SELECT 'LGKA','KSO','ARISTOTELIS','KASTORIA','GREECE',40,26,58,'N',40.4494444444444,21,16,34,'E',21.2761111111111,2183
UNION ALL SELECT 'LGKC','KIT','KITHIRA','KITHIRA','GREECE',36,16,27,'N',36.2741666666667,23,1,1,'E',23.0169444444444,1043
UNION ALL SELECT 'LGKF','EFL','KEFALLINIA','KEFFALLINIA','GREECE',38,7,11,'N',38.1197222222222,20,30,2,'E',20.5005555555556,60
UNION ALL SELECT 'LGKJ','KZS','','KASTELORIZO','GREECE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LGKL','KLX','KALAMATA','KALAMATA','GREECE',37,4,6,'N',37.0683333333333,22,1,32,'E',22.0255555555556,27
UNION ALL SELECT 'LGKO','KGS','KOS','KOS','GREECE',36,47,36,'N',36.7933333333333,27,5,30,'E',27.0916666666667,409
UNION ALL SELECT 'LGKP','AOK','KARPATHOS','KARPATHOS','GREECE',35,25,17,'N',35.4213888888889,27,8,45,'E',27.1458333333333,66
UNION ALL SELECT 'LGKR','CFU','IOANNIS KAPODISTRIAS INTERNATIONAL','KERKYRA/CORFU','GREECE',39,36,7,'N',39.6019444444444,19,54,42,'E',19.9116666666667,6
UNION ALL SELECT 'LGKS','KSJ','KASOS','KASOS','GREECE',35,25,16,'N',35.4211111111111,26,54,36,'E',26.91,33
UNION ALL SELECT 'LGKV','KVA','MEGAS ALEXANDROS INTERNATIONAL','KAVALA','GREECE',40,54,47,'N',40.9130555555556,24,37,9,'E',24.6191666666667,18
UNION ALL SELECT 'LGKZ','KZI','FILIPPOS','KOZANI','GREECE',40,17,10,'N',40.2861111111111,21,50,27,'E',21.8408333333333,2080
UNION ALL SELECT 'LGLE','LRS','LEROS','LEROS','GREECE',37,11,5,'N',37.1847222222222,26,48,1,'E',26.8002777777778,36
UNION ALL SELECT 'LGLM','LXS','LIMNOS','LIMNOS','GREECE',39,55,1,'N',39.9169444444444,25,14,10,'E',25.2361111111111,15
UNION ALL SELECT 'LGLR','LRA','LARISA','LARISSA','GREECE',39,39,0,'N',39.65,22,27,55,'E',22.4652777777778,241
UNION ALL SELECT 'LGMK','JMK','MIKONOS','MYKONOS','GREECE',37,26,6,'N',37.435,25,20,53,'E',25.3480555555556,405
UNION ALL SELECT 'LGML','MLO','','MILOS','GREECE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LGMT','MJT','MITILINI','MYTILINI','GREECE',39,3,24,'N',39.0566666666667,26,35,54,'E',26.5983333333333,57
UNION ALL SELECT 'LGPA','PAS','','PAROS','GREECE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LGPZ','PVK','AKTIO','PREVEZA','GREECE',38,55,31,'N',38.9252777777778,20,45,55,'E',20.7652777777778,13
UNION ALL SELECT 'LGRP','RHO','DIAGORAS','RHODOS','GREECE',36,24,19,'N',36.4052777777778,28,5,10,'E',28.0861111111111,17
UNION ALL SELECT 'LGRX','GPA','ARAXOS','PATRAS','GREECE',38,9,4,'N',38.1511111111111,21,25,32,'E',21.4255555555556,46
UNION ALL SELECT 'LGSA','CHQ','SOUDA','CHANIA','GREECE',35,31,54,'N',35.5316666666667,24,8,58,'E',24.1494444444444,492
UNION ALL SELECT 'LGSK','JSI','SKIATHOS','SKIATHOS','GREECE',39,10,37,'N',39.1769444444444,23,30,13,'E',23.5036111111111,51
UNION ALL SELECT 'LGSM','SMI','SAMOS','SAMOS','GREECE',37,41,24,'N',37.69,26,54,42,'E',26.9116666666667,20
UNION ALL SELECT 'LGSR','JTR','SANTORINI','SANTORINI','GREECE',36,24,1,'N',36.4002777777778,25,28,43,'E',25.4786111111111,130
UNION ALL SELECT 'LGST','JSH','SITIA','SITIA','GREECE',35,12,49,'N',35.2136111111111,26,5,51,'E',26.0975,40
UNION ALL SELECT 'LGSY','SKU','SKYROS','SKIROS','GREECE',38,58,3,'N',38.9675,24,29,14,'E',24.4872222222222,48
UNION ALL SELECT 'LGTS','SKG','MAKEDONIA','THESSALONIKI','GREECE',40,31,11,'N',40.5197222222222,22,58,15,'E',22.9708333333333,22
UNION ALL SELECT 'LGVO','VOL','','VOLOS','GREECE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LGZA','ZTH','ZAKINTHOS DIONYSIOS SOLOMOS','ZAKYNTHOS','GREECE',37,45,0,'N',37.75,20,52,55,'E',20.8819444444444,14
UNION ALL SELECT 'LHBP','BUD','FERIHEGY','BUDAPEST','HUNGARY',47,26,12,'N',47.4366666666667,19,15,20,'E',19.2555555555556,495
UNION ALL SELECT 'LHDC','DEB','DEBRECEN','DEBRECEN','HUNGARY',47,29,20,'N',47.4888888888889,21,36,55,'E',21.6152777777778,361
UNION ALL SELECT 'LIBB','BDS','','BRINDISI','ITALY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LIBC','CRV','CROTONE','CROTONE','ITALY',38,59,50,'N',38.9972222222222,17,4,48,'E',17.08,521
UNION ALL SELECT 'LIBD','BRI','PALESE MACCHIE','BARI','ITALY',41,8,18,'N',41.1383333333333,16,45,38,'E',16.7605555555556,177
UNION ALL SELECT 'LIBF','FOG','GINO LISA','FOGGIA','ITALY',41,25,58,'N',41.4327777777778,15,32,6,'E',15.535,266
UNION ALL SELECT 'LIBG','TAR','GROTTAGLIE','GROTTAGLIE','ITALY',40,30,58,'N',40.5161111111111,17,24,8,'E',17.4022222222222,216
UNION ALL SELECT 'LIBN','LCC','LECCE','LECCE','ITALY',40,14,19,'N',40.2386111111111,18,7,59,'E',18.1330555555556,158
UNION ALL SELECT 'LIBP','PSR','PESCARA','PESCARA','ITALY',42,25,53,'N',42.4313888888889,14,10,51,'E',14.1808333333333,48
UNION ALL SELECT 'LIBR','BDS','CASALE','BRINDISI','ITALY',40,39,27,'N',40.6575,17,56,49,'E',17.9469444444444,48
UNION ALL SELECT 'LICA','SUF','LAMEZIA TERME','LAMEZIA','ITALY',38,54,23,'N',38.9063888888889,16,14,32,'E',16.2422222222222,40
UNION ALL SELECT 'LICC','CTA','CATANIA FONTANAROSSA','CATANIA','ITALY',37,28,0,'N',37.4666666666667,15,3,58,'E',15.0661111111111,40
UNION ALL SELECT 'LICD','LMP','LAMPEDUSA','LAMPEDUSA','ITALY',35,29,52,'N',35.4977777777778,12,37,5,'E',12.6180555555556,72
UNION ALL SELECT 'LICG','PNL','PANTELLERIA','PANTELLERIA','ITALY',36,48,59,'N',36.8163888888889,11,58,7,'E',11.9686111111111,636
UNION ALL SELECT 'LICJ','PMO','PALERMO','PALERMO','ITALY',38,10,33,'N',38.1758333333333,13,5,27,'E',13.0908333333333,64
UNION ALL SELECT 'LICP','PMO','BOCCADIFALCO','PALERMO','ITALY',38,6,39,'N',38.1108333333333,13,18,48,'E',13.3133333333333,345
UNION ALL SELECT 'LICR','REG','REGGIO CALABRIA','REGGIO CALABRIA','ITALY',38,4,16,'N',38.0711111111111,15,39,5,'E',15.6513888888889,95
UNION ALL SELECT 'LICT','TPS','TRAPANI BIRGI','TRAPANI','ITALY',37,54,45,'N',37.9125,12,29,17,'E',12.4880555555556,25
UNION ALL SELECT 'LICZ','NSY','SIGONELLA','SIGONELLA','ITALY',37,24,5,'N',37.4013888888889,14,55,20,'E',14.9222222222222,81
UNION ALL SELECT 'LIEA','AHO','ALGHERO','ALGHERO','ITALY',40,37,55,'N',40.6319444444444,8,17,26,'E',8.29055555555555,87
UNION ALL SELECT 'LIED','DCI','DECIMOMANNU','DECIMOMANNU','ITALY',39,21,15,'N',39.3541666666667,8,58,20,'E',8.97222222222222,100
UNION ALL SELECT 'LIEE','CAG','ELMAS','CAGLIARI','ITALY',39,15,5,'N',39.2513888888889,9,3,15,'E',9.05416666666667,13
UNION ALL SELECT 'LIEO','OLB','OLBIA COSTA SMERALDA','OLBIA','ITALY',40,53,55,'N',40.8986111111111,9,31,3,'E',9.5175,37
UNION ALL SELECT 'LIET','TTB','TORTOLI','TORTOLI','ITALY',39,55,7,'N',39.9186111111111,9,40,58,'E',9.68277777777778,22
UNION ALL SELECT 'LIMC','MXP','MALPENSA','MILANO','ITALY',45,37,53,'N',45.6313888888889,8,43,40,'E',8.72777777777778,767
UNION ALL SELECT 'LIME','BGY','BERGAMO ORIO AL SERIO','BERGAMO','ITALY',45,40,26,'N',45.6738888888889,9,42,15,'E',9.70416666666667,779
UNION ALL SELECT 'LIMF','TRN','TORINO','TORINO','ITALY',45,12,2,'N',45.2005555555556,7,38,58,'E',7.64944444444444,989
UNION ALL SELECT 'LIMG','ALL','ALBENGA','ALBENGA','ITALY',44,3,2,'N',44.0505555555556,8,7,38,'E',8.12722222222222,149
UNION ALL SELECT 'LIMJ','GOA','GENOVA SESTRI','GENOA','ITALY',44,24,43,'N',44.4119444444444,8,50,30,'E',8.84166666666667,13
UNION ALL SELECT 'LIML','LIN','LINATE','MILAN','ITALY',45,26,43,'N',45.4452777777778,9,16,37,'E',9.27694444444445,353
UNION ALL SELECT 'LIMP','PMF','PARMA','PARMA','ITALY',44,49,28,'N',44.8244444444444,10,17,46,'E',10.2961111111111,163
UNION ALL SELECT 'LIMS','QPZ','PIACENZA','PIACENZA','ITALY',44,54,47,'N',44.9130555555556,9,43,24,'E',9.72333333333333,455
UNION ALL SELECT 'LIMZ','CUF','LEVALDIGI','LEVALDIGI','ITALY',44,32,47,'N',44.5463888888889,7,37,20,'E',7.62222222222222,1267
UNION ALL SELECT 'LIPA','AVB','AVIANO AB','AVIANO','ITALY',46,1,54,'N',46.0316666666667,12,35,47,'E',12.5963888888889,413
UNION ALL SELECT 'LIPB','BZO','BOLZANO','BOLZANO','ITALY',46,27,38,'N',46.4605555555556,11,19,34,'E',11.3261111111111,784
UNION ALL SELECT 'LIPE','BLQ','BOLOGNA','BOLOGNA','ITALY',44,32,3,'N',44.5341666666667,11,17,25,'E',11.2902777777778,122
UNION ALL SELECT 'LIPH','TSF','TREVISO','TREVISO','ITALY',45,38,55,'N',45.6486111111111,12,11,43,'E',12.1952777777778,59
UNION ALL SELECT 'LIPK','FRL','FORLI','FORLI','ITALY',44,11,41,'N',44.1947222222222,12,4,12,'E',12.07,97
UNION ALL SELECT 'LIPO','VBS','MONTICHIARI','MONTICHIARI','ITALY',45,25,44,'N',45.4288888888889,10,19,50,'E',10.3305555555556,356
UNION ALL SELECT 'LIPQ','TRS','RONCHI DEI LEGIONARI','RONCHI DE LEGIONARI','ITALY',45,49,40,'N',45.8277777777778,13,27,59,'E',13.4663888888889,37
UNION ALL SELECT 'LIPR','RMI','RIMINI','RIMINI','ITALY',44,1,13,'N',44.0202777777778,12,36,43,'E',12.6119444444444,41
UNION ALL SELECT 'LIPT','VIC','VICENZA','VICENZA','ITALY',45,34,27,'N',45.5741666666667,11,31,50,'E',11.5305555555556,128
UNION ALL SELECT 'LIPU','QPA','PADOVA','PADOVA','ITALY',45,23,44,'N',45.3955555555556,11,50,52,'E',11.8477777777778,44
UNION ALL SELECT 'LIPX','VRN','VILLAFRANCA','VILLAFRANCA','ITALY',45,23,44,'N',45.3955555555556,10,53,18,'E',10.8883333333333,239
UNION ALL SELECT 'LIPZ','VCE','VENEZIA TESSERA','VENICE','ITALY',45,30,18,'N',45.505,12,21,6,'E',12.3516666666667,7
UNION ALL SELECT 'LIQS','SAY','AMPUGNANO','SIENA','ITALY',43,15,26,'N',43.2572222222222,11,15,15,'E',11.2541666666667,637
UNION ALL SELECT 'LIRA','CIA','CIAMPINO','ROME','ITALY',41,47,57,'N',41.7991666666667,12,35,41,'E',12.5947222222222,427
UNION ALL SELECT 'LIRF','FCO','FIUMICINO','ROME','ITALY',41,48,46,'N',41.8127777777778,12,15,11,'E',12.2530555555556,13
UNION ALL SELECT 'LIRJ','EBA','MARINA DI CAMPO','MARINA DI CAMPO','ITALY',42,45,37,'N',42.7602777777778,10,14,22,'E',10.2394444444444,31
) x (ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LatDec],[LongDeg],[LongMin],[LongSec],[LongDir],[LongDec],[Altitude])
LEFT OUTER JOIN Airports a ON a.IATA_Code = x.IATA_Code
--WHERE x.[LatDir] <> 'U' and x.[LongDir] <> 'U' and x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE n=1
GO

INSERT INTO Airports (ICAO_Code, IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir
    ,LongDeg, LongMin, LongSec, LongDir, Altitude)
SELECT ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LongDeg],[LongMin],[LongSec],[LongDir],[Altitude]
FROM (
SELECT x.ICAO_Code,x.IATA_Code,x.[Name],x.[City],x.[Country],x.[LatDeg],x.[LatMin],x.[LatSec],x.[LatDir]
	,x.[LatDec],x.[LongDeg],x.[LongMin],x.[LongSec],x.[LongDir],x.[LongDec],x.[Altitude]
    ,n=ROW_NUMBER() OVER (PARTITION BY x.IATA_Code ORDER BY (SELECT NULL))
FROM (
SELECT 'LIRK','N/A','','MONTE TERMINILLO','ITALY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LIRL','QLT','LATINA','LATINA','ITALY',41,32,32,'N',41.5422222222222,12,54,32,'E',12.9088888888889,93
UNION ALL SELECT 'LIRN','NAP','CAPODICHINO','NAPLES','ITALY',40,53,9,'N',40.8858333333333,14,17,26,'E',14.2905555555556,298
UNION ALL SELECT 'LIRP','PSA','PISA','PISA','ITALY',43,41,2,'N',43.6838888888889,10,23,33,'E',10.3925,7
UNION ALL SELECT 'LIRQ','FLR','PERETOLA','FIRENZE','ITALY',43,48,35,'N',43.8097222222222,11,12,18,'E',11.205,144
UNION ALL SELECT 'LIRS','GRS','GROSSETO','GROSSETO','ITALY',42,45,39,'N',42.7608333333333,11,4,20,'E',11.0722222222222,15
UNION ALL SELECT 'LIRZ','PEG','PERUGIA','PERUGIA','ITALY',43,5,45,'N',43.0958333333333,12,30,47,'E',12.5130555555556,693
UNION ALL SELECT 'LIVT','TRS','','TRIEST','ITALY',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LJLJ','LJU','LJUBLJANA','LJUBLIANA','SLOVENIA',46,13,25,'N',46.2236111111111,14,27,27,'E',14.4575,1273
UNION ALL SELECT 'LJMB','MBX','MARIBOR','MARIBOR','SLOVENIA',46,28,47,'N',46.4797222222222,15,41,10,'E',15.6861111111111,876
UNION ALL SELECT 'LJPZ','POW','PORTOROZ','PORTOROZ','SLOVENIA',45,28,24,'N',45.4733333333333,13,36,53,'E',13.6147222222222,7
UNION ALL SELECT 'LKKV','KLV','KARLOVY VARY','KARLOVY VARY','CZECH REPUBLIC',50,12,10,'N',50.2027777777778,12,54,53,'E',12.9147222222222,1989
UNION ALL SELECT 'LKMT','OSR','MOSNOV','OSTRAVA','CZECH REPUBLIC',49,41,47,'N',49.6963888888889,18,6,40,'E',18.1111111111111,844
UNION ALL SELECT 'LKPD','PED','PARDUBICE','PARDUBICE','CZECH REPUBLIC',50,0,48,'N',50.0133333333333,15,44,19,'E',15.7386111111111,741
UNION ALL SELECT 'LKPO','PRV','PREROV','PREROV','CZECH REPUBLIC',49,25,33,'N',49.4258333333333,17,24,17,'E',17.4047222222222,676
UNION ALL SELECT 'LKPR','PRG','RUZYNE','PRAGUE','CZECH REPUBLIC',50,6,3,'N',50.1008333333333,14,15,36,'E',14.26,1247
UNION ALL SELECT 'LKTB','BRQ','TURANY','TURANY','CZECH REPUBLIC',49,9,4,'N',49.1511111111111,16,41,39,'E',16.6941666666667,777
UNION ALL SELECT 'LLBG','TLV','BEN GURION','TEL-AVIV','ISRAEL',32,0,34,'N',32.0094444444444,34,52,36,'E',34.8766666666667,135
UNION ALL SELECT 'LLBS','BEV','TEYMAN','BEER-SHEBA','ISRAEL',31,17,13,'N',31.2869444444444,34,43,22,'E',34.7227777777778,656
UNION ALL SELECT 'LLET','ETH','EILAT','ELAT','ISRAEL',29,33,40,'N',29.5611111111111,34,57,36,'E',34.96,42
UNION ALL SELECT 'LLHA','HFA','HAIFA','HAIFA','ISRAEL',32,48,40,'N',32.8111111111111,35,2,38,'E',35.0438888888889,28
UNION ALL SELECT 'LLIB','RPN','MAHANAIM I BEN YAAKOV','ROSH PINA','ISRAEL',32,58,51,'N',32.9808333333333,35,34,18,'E',35.5716666666667,922
UNION ALL SELECT 'LLJR','JRS','JERUSALEM/ATAROT','JERUSALEM','ISRAEL',31,52,0,'N',31.8666666666667,35,13,0,'E',35.2166666666667,759
UNION ALL SELECT 'LLOV','VDA','OVDA','OVDA','ISRAEL',29,56,24,'N',29.94,34,56,9,'E',34.9358333333333,1492
UNION ALL SELECT 'LLSD','SDV','SDE DOV','TEL-AVIV','ISRAEL',32,6,52,'N',32.1144444444444,34,46,55,'E',34.7819444444444,43
UNION ALL SELECT 'LMML','MLA','LUQA','MALTA','MALTA',35,51,26,'N',35.8572222222222,14,28,39,'E',14.4775,300
UNION ALL SELECT 'LMMM','N/A','MALTA ACC','MALTA ACC','MALTA',35,55,0,'N',35.9166666666667,14,25,0,'E',14.4166666666667,0
UNION ALL SELECT 'LNMC','MCM','','MONACO','MONACO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LOWG','GRZ','GRAZ MIL/CIV','GRAZ','AUSTRIA',47,0,0,'N',47,15,26,0,'E',15.4333333333333,347
UNION ALL SELECT 'LOWI','INN','INNSBRUCK','INNSBRUCK','AUSTRIA',47,15,36,'N',47.26,11,20,38,'E',11.3438888888889,1906
UNION ALL SELECT 'LOWK','KLU','KLAGENFURT(AUS-AFB)','KLAGENFURT','AUSTRIA',46,39,0,'N',46.65,14,20,0,'E',14.3333333333333,452
UNION ALL SELECT 'LOWL','LNZ','HORSCHING INTERNATIONAL AIRPORT (AUS - AFB)','LINZ','AUSTRIA',48,14,0,'N',48.2333333333333,14,11,0,'E',14.1833333333333,313
UNION ALL SELECT 'LOWS','SZG','SALZBURG','SALZBURG','AUSTRIA',47,47,35,'N',47.7930555555556,13,0,15,'E',13.0041666666667,1411
UNION ALL SELECT 'LOWW','VIE','SCHWECHAT','VIENNA','AUSTRIA',48,6,37,'N',48.1102777777778,16,34,11,'E',16.5697222222222,600
UNION ALL SELECT 'LPAZ','SMA','SANTA MARIA','SANTA MARIA (ISLAND)','ACORES',36,58,17,'N',36.9713888888889,25,10,14,'U',0,308
UNION ALL SELECT 'LPBG','BGC','BRAGANCA','BRAGANCA','ACORES',41,52,6,'N',41.8683333333333,6,42,43,'U',0,2241
UNION ALL SELECT 'LPFL','FLW','FLORES','FLORES (FLORES ISL.)','ACORES',39,27,18,'N',39.455,31,7,52,'U',0,112
UNION ALL SELECT 'LPFR','FAO','FARO','FARO','ACORES',37,0,51,'N',37.0141666666667,7,57,57,'U',0,24
UNION ALL SELECT 'LPFU','FNC','','FUNCHAL','MADEIRA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LPGR','GRW','GRACIOSA','GRACIOSA ISLAND','ACORES',39,5,31,'N',39.0919444444444,28,1,47,'U',0,86
UNION ALL SELECT 'LPHR','HOR','HORTA','HORTA','ACORES',38,31,11,'N',38.5197222222222,28,42,57,'U',0,118
UNION ALL SELECT 'LPLA','TER','LAJES','LAJES (TERCEIRA ISLAND)','ACORES',38,45,51,'N',38.7641666666667,27,5,36,'U',0,180
UNION ALL SELECT 'LPPD','PDL','PONTA DELGADA','PONTA DELGADA','ACORES',37,44,28,'N',37.7411111111111,25,41,52,'U',0,259
UNION ALL SELECT 'LPPI','PIX','PICO','PICO','ACORES',38,33,16,'N',38.5544444444444,28,26,23,'U',0,110
UNION ALL SELECT 'LPPR','OPO','PORTO','PORTO','ACORES',41,14,53,'N',41.2480555555556,8,40,53,'U',0,228
UNION ALL SELECT 'LPPS','PXO','PORTO SANTO','PORTO SANTO','MADEIRA',33,4,24,'N',33.0733333333333,16,20,59,'U',0,338
UNION ALL SELECT 'LPPT','LIS','LISBOA','LISBON','PORTUGAL',38,46,52,'N',38.7811111111111,9,8,9,'U',0,374
UNION ALL SELECT 'LPSJ','SJZ','SAO JORGE','SAO JORGE ISLAND','ACORES',38,39,55,'N',38.6652777777778,28,10,32,'U',0,311
UNION ALL SELECT 'LPVR','VRL','VILA REAL','VILA REAL','ACORES',41,16,27,'N',41.2741666666667,7,43,13,'U',0,1805
UNION ALL SELECT 'LQMO','OMO','MOSTAR','MOSTAR','BOSNIA-HERCEGOVINA',43,16,58,'N',43.2827777777778,17,50,45,'E',17.8458333333333,156
UNION ALL SELECT 'LQSA','SJJ','SARAJEVO','SARAJEVO','BOSNIA-HERCEGOVINA',43,49,28,'N',43.8244444444444,18,19,53,'E',18.3313888888889,1708
UNION ALL SELECT 'LRAR','ARW','ARAD','ARAD','ROMANIA',46,10,35,'N',46.1763888888889,21,15,43,'E',21.2619444444444,352
UNION ALL SELECT 'LRBC','BCM','BACAU','BACAU','ROMANIA',46,31,19,'N',46.5219444444444,26,54,37,'E',26.9102777777778,607
UNION ALL SELECT 'LRBM','BAY','TAUTII MAGHERAUS','BAIA MARE','ROMANIA',47,39,30,'N',47.6583333333333,23,28,12,'E',23.47,604
UNION ALL SELECT 'LRBS','BBU','BANEASA','BUCHAREST','ROMANIA',44,30,11,'N',44.5030555555556,26,6,7,'E',26.1019444444444,297
UNION ALL SELECT 'LRCK','CND','MIHAIL KOGALNICEANU','CONSTANTA','ROMANIA',44,21,44,'N',44.3622222222222,28,29,18,'E',28.4883333333333,353
UNION ALL SELECT 'LRCL','CLJ','SOMESENI','CLUJ-NAPOCA','ROMANIA',46,47,6,'N',46.785,23,41,10,'E',23.6861111111111,1036
UNION ALL SELECT 'LRCS','CSB','CARANSEBES','CARANSEBES','ROMANIA',45,25,12,'N',45.42,22,15,12,'E',22.2533333333333,866
UNION ALL SELECT 'LRCV','CRA','CRAIOVA','CRAIOVA','ROMANIA',44,19,5,'N',44.3180555555556,23,53,19,'E',23.8886111111111,626
UNION ALL SELECT 'LRIA','IAS','IASI','IASI','ROMANIA',47,10,44,'N',47.1788888888889,27,37,12,'E',27.62,397
UNION ALL SELECT 'LROD','OMR','ORADEA','ORADEA','ROMANIA',47,1,31,'N',47.0252777777778,21,54,9,'E',21.9025,465
UNION ALL SELECT 'LROP','OTP','OTOPENI','BUCHAREST','ROMANIA',44,34,25,'N',44.5736111111111,26,6,12,'E',26.1033333333333,314
UNION ALL SELECT 'LRSB','SBZ','SIBIU','SIBIU','ROMANIA',45,47,8,'N',45.7855555555556,24,5,28,'E',24.0911111111111,1496
UNION ALL SELECT 'LRSM','SUJ','SATU MARE','SATU MARE','ROMANIA',47,42,12,'N',47.7033333333333,22,53,8,'E',22.8855555555556,414
UNION ALL SELECT 'LRSV','SCV','SALCEA','SUCEAVA','ROMANIA',47,41,15,'N',47.6875,26,21,14,'E',26.3538888888889,1375
UNION ALL SELECT 'LRTC','TCE','CATALOI','TULCEA','ROMANIA',45,3,44,'N',45.0622222222222,28,42,51,'E',28.7141666666667,200
UNION ALL SELECT 'LRTM','TGM','VIDRASAU','TIRGU MURES','ROMANIA',46,28,3,'N',46.4675,24,24,45,'E',24.4125,963
UNION ALL SELECT 'LRTR','TSR','GIARMATA','TIMISOARA','ROMANIA',45,48,36,'N',45.81,21,20,16,'E',21.3377777777778,348
UNION ALL SELECT 'LSGG','GVA','GENEVA COINTRIN','GENEVA','SWITZERLAND',46,14,17,'N',46.2380555555556,6,6,32,'E',6.10888888888889,1411
UNION ALL SELECT 'LSGS','SIR','SION','SION','SWITZERLAND',46,13,10,'N',46.2194444444444,7,19,36,'E',7.32666666666667,1581
UNION ALL SELECT 'LSXM','SMV','','ST. MORITZ','SWITZERLAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LSZA','LUG','LUGANO','LUGANO','SWITZERLAND',46,0,15,'N',46.0041666666667,8,54,38,'E',8.91055555555556,915
UNION ALL SELECT 'LSZB','BRN','BERN BELP','BERN','SWITZERLAND',46,54,50,'N',46.9138888888889,7,29,49,'E',7.49694444444444,1673
UNION ALL SELECT 'LSZH','ZRH','ZURICH','ZURICH','SWITZERLAND',47,27,53,'N',47.4647222222222,8,32,57,'E',8.54916666666667,1416
UNION ALL SELECT 'LSZR','ACH','ST GALLEN ALTENRHEIN','ALTENRHEIN','SWITZERLAND',47,29,6,'N',47.485,9,33,38,'E',9.56055555555556,1306
UNION ALL SELECT 'LSZS','SMV','SAMEDAN','SAMEDAN','SWITZERLAND',46,31,57,'N',46.5325,9,52,58,'E',9.88277777777778,5600
UNION ALL SELECT 'LTAC','ESB','ESENBOGA','ANKARA','TURKEY',40,7,41,'N',40.1280555555556,32,59,42,'E',32.995,3125
UNION ALL SELECT 'LTAD','ANK','ETIMESGUT','ANKARA','TURKEY',39,56,59,'N',39.9497222222222,32,41,19,'E',32.6886111111111,2622
UNION ALL SELECT 'LTAF','ADA','ADANA','ADANA','TURKEY',36,58,55,'N',36.9819444444444,35,16,49,'E',35.2802777777778,65
UNION ALL SELECT 'LTAG','ADA','INCIRLIK AB','ADANA','TURKEY',37,0,7,'N',37.0019444444444,35,25,33,'E',35.4258333333333,238
UNION ALL SELECT 'LTAH','AFY','AFYON','AFYON','TURKEY',38,43,34,'N',38.7261111111111,30,36,4,'E',30.6011111111111,3310
UNION ALL SELECT 'LTAI','AYT','ANTALYA','ANTALYA','TURKEY',36,54,5,'N',36.9013888888889,30,47,30,'E',30.7916666666667,177
UNION ALL SELECT 'LTAJ','GZT','OGUZELI','GAZIANTEP','TURKEY',36,56,53,'N',36.9480555555556,37,28,45,'E',37.4791666666667,2316
UNION ALL SELECT 'LTAN','KYA','KONYA','KONYA','TURKEY',37,58,44,'N',37.9788888888889,32,33,42,'E',32.5616666666667,3382
UNION ALL SELECT 'LTAP','MZH','MERZIFON','MERZIFON','TURKEY',40,49,45,'N',40.8291666666667,35,31,19,'E',35.5219444444444,1785
UNION ALL SELECT 'LTAQ','SSX','SAMSUN AIRPORT','SAMSUN','TURKEY',41,16,35,'N',41.2763888888889,36,18,13,'E',36.3036111111111,524
UNION ALL SELECT 'LTAR','VAS','SIVAS','SIVAS','TURKEY',39,48,49,'N',39.8136111111111,36,54,12,'E',36.9033333333333,5236
UNION ALL SELECT 'LTAT','MLX','ERHAC','MALATYA','TURKEY',38,26,9,'N',38.4358333333333,38,5,30,'E',38.0916666666667,2828
UNION ALL SELECT 'LTAU','ASR','ERKILET','KAYSERI','TURKEY',38,46,13,'N',38.7702777777778,35,29,43,'E',35.4952777777778,3506
UNION ALL SELECT 'LTAY','DNZ','CARDAK','DENIZLI','TURKEY',37,47,6,'N',37.785,29,42,4,'E',29.7011111111111,2795
UNION ALL SELECT 'LTBA','IST','ATATURK','ISTANBUL','TURKEY',40,58,36,'N',40.9766666666667,28,49,16,'E',28.8211111111111,163
UNION ALL SELECT 'LTBE','BTZ','BURSA','BURSA','TURKEY',40,13,54,'N',40.2316666666667,29,0,33,'E',29.0091666666667,331
UNION ALL SELECT 'LTBF','BZI','BALIKESIR','BALIKESIR','TURKEY',39,37,8,'N',39.6188888888889,27,55,29,'E',27.9247222222222,331
UNION ALL SELECT 'LTBG','BDM','BANDIRMA','BANDIRMA','TURKEY',40,19,4,'N',40.3177777777778,27,58,39,'E',27.9775,167
UNION ALL SELECT 'LTBI','ESK','ESKISEHIR','ESKISEHIR','TURKEY',39,47,2,'N',39.7838888888889,30,34,55,'E',30.5819444444444,2579
UNION ALL SELECT 'LTBJ','ADB','ADNAN MENDERES','IZMIR','TURKEY',38,17,32,'N',38.2922222222222,27,9,25,'E',27.1569444444444,412
UNION ALL SELECT 'LTBL','IGL','CIGLI','IZMIR','TURKEY',38,30,47,'N',38.5130555555556,27,0,36,'E',27.01,17
UNION ALL SELECT 'LTBS','DLM','DALAMAN','DALAMAN','TURKEY',36,42,47,'N',36.7130555555556,28,47,33,'E',28.7925,20
UNION ALL SELECT 'LTCC','DIY','DIYARBAKIR','DIYABAKIR','TURKEY',37,53,37,'N',37.8936111111111,40,12,2,'E',40.2005555555556,2251
UNION ALL SELECT 'LTCD','ERC','ERZINCAN','ERZINCAN','TURKEY',39,42,36,'N',39.71,39,31,34,'E',39.5261111111111,3783
UNION ALL SELECT 'LTCE','ERZ','ERZURUM','ERZURUM','TURKEY',39,57,23,'N',39.9563888888889,41,10,12,'E',41.17,5763
UNION ALL SELECT 'LTCG','TZX','TRABZON','TRABZON','TURKEY',40,59,42,'N',40.995,39,47,23,'E',39.7897222222222,104
UNION ALL SELECT 'LTCI','VAN','VAN','VAN','TURKEY',38,28,5,'N',38.4680555555556,43,19,56,'E',43.3322222222222,5474
UNION ALL SELECT 'LTCJ','BAL','BATMAN','BATMAN','TURKEY',37,55,44,'N',37.9288888888889,41,6,58,'E',41.1161111111111,1822
UNION ALL SELECT 'LUKK','KIV','CHISINAU','KICHINAU FIR/ACC/COM','MOLDOVA',46,55,40,'N',46.9277777777778,28,55,53,'E',28.9313888888889,399
UNION ALL SELECT 'LWOH','OHD','OHRID','OHRID','FORMER MACEDONIA',41,10,47,'N',41.1797222222222,20,44,32,'E',20.7422222222222,2313
UNION ALL SELECT 'LWSK','SKP','SKOPJE','SKOPJE','FORMER MACEDONIA',41,57,41,'N',41.9613888888889,21,37,17,'E',21.6213888888889,781
UNION ALL SELECT 'LXGB','GIB','GIBRALTAR','GIBRALTAR','GIBRALTAR',36,9,3,'N',36.1508333333333,5,20,58,'U',0,15
UNION ALL SELECT 'LYBE','BEG','BEOGRAD','BEOGRAD','YUGOSLAVIA',44,49,6,'N',44.8183333333333,20,18,32,'E',20.3088888888889,335
UNION ALL SELECT 'LYNI','INI','','NIS','YUGOSLAVIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'LYPG','TGD','PODGORICA','PODGORICA','YUGOSLAVIA',42,21,33,'N',42.3591666666667,19,15,6,'E',19.2516666666667,121
UNION ALL SELECT 'LYPR','PRN','PRISTINA','PRISTINA','YUGOSLAVIA',42,34,22,'N',42.5727777777778,21,2,9,'E',21.0358333333333,1789
UNION ALL SELECT 'LYTV','TIV','TIVAT','TIVAT','YUGOSLAVIA',42,24,16,'N',42.4044444444444,18,43,23,'E',18.7230555555556,20
UNION ALL SELECT 'LZIB','BTS','M R STEFANIK','BRATISLAVA','SLOVAKIA',48,10,12,'N',48.17,17,12,45,'E',17.2125,436
UNION ALL SELECT 'LZKZ','KSC','KOSICE','KOSICE','SLOVAKIA',48,39,47,'N',48.6630555555556,21,14,28,'E',21.2411111111111,755
UNION ALL SELECT 'LZPP','PZY','PIESTANY','PIESTANY','SLOVAKIA',48,37,30,'N',48.625,17,49,42,'E',17.8283333333333,545
UNION ALL SELECT 'LZSL','SLD','SLIAC','SLIAC','SLOVAKIA',48,38,16,'N',48.6377777777778,19,8,2,'E',19.1338888888889,1043
UNION ALL SELECT 'LZTT','TAT','TATRY','POPRAD','SLOVAKIA',49,4,24,'N',49.0733333333333,20,14,27,'E',20.2408333333333,2356
UNION ALL SELECT 'MBJT','GDT','','GRAND TURK','TURKS & CAICOS I.',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MBMC','MDS','','MIDDLE CAICOS','TURKS & CAICOS I.',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MBNC','NCA','NORTH CAICOS','NORTH CAICOS','TURKS & CAICOS I.',21,55,2,'N',21.9172222222222,71,56,22,'U',0,10
UNION ALL SELECT 'MBPV','PLS','PROVIDENCIALES','PROVIDENCIALES','TURKS & CAICOS I.',21,46,25,'N',21.7736111111111,72,15,57,'U',0,15
UNION ALL SELECT 'MBSC','XSC','SOUTH CAICOS','SOUTH CAICOS','TURKS & CAICOS I.',21,30,56,'N',21.5155555555556,71,31,42,'U',0,6
UNION ALL SELECT 'MBSY','SLX','','SALT CAY','TURKS & CAICOS I.',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MDBH','BRX','MARIA MONTEZ INTERNATIONAL','BARAHONA','DOMINICAN REPUBLIC',18,15,5,'N',18.2513888888889,71,7,13,'U',0,10
UNION ALL SELECT 'MDHE','HEX','HERRERA INTERNATIONAL','SANTO DOMINGO','DOMINICAN REPUBLIC',18,28,16,'N',18.4711111111111,69,58,8,'U',0,198
UNION ALL SELECT 'MDLR','LRM','LA ROMANA INTERNATIONAL','LA ROMANA','DOMINICAN REPUBLIC',18,27,7,'N',18.4519444444444,68,54,42,'U',0,230
UNION ALL SELECT 'MDPC','PUJ','PUNTA CANA INTERNATIONAL','PUNTA CANA','DOMINICAN REPUBLIC',18,34,2,'N',18.5672222222222,68,21,48,'U',0,40
UNION ALL SELECT 'MDPP','POP','GREGORIO LUPERON INTERNATIONAL','PUERTO PLATA','DOMINICAN REPUBLIC',19,45,26,'N',19.7572222222222,70,34,11,'U',0,16
UNION ALL SELECT 'MDSD','SDQ','LAS AMERICAS INTERNATIONAL','SANTO DOMINGO','DOMINICAN REPUBLIC',18,25,46,'N',18.4294444444444,69,40,7,'U',0,59
UNION ALL SELECT 'MDST','STI','CIBAO INTERNATIONAL','SANTIAGO','DOMINICAN REPUBLIC',19,24,33,'N',19.4091666666667,70,36,59,'U',0,565
UNION ALL SELECT 'MGCB','CBV','COBAN','COBAN','GUATEMALA',15,28,8,'N',15.4688888888889,90,24,24,'U',0,4339
UNION ALL SELECT 'MGFL','FRS','','FLORES','GUATEMALA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MGGT','GUA','LA AURORA','GUATEMALA CITY','GUATEMALA',14,34,59,'N',14.5830555555556,90,31,39,'U',0,4952
UNION ALL SELECT 'MHLC','LCE','GOLOSON INTERNATIONAL','LA CEIBA','HONDURAS',15,44,32,'N',15.7422222222222,86,51,12,'U',0,49
UNION ALL SELECT 'MHLM','SAP','LA MESA INTERNATIONAL','SAN PEDRO SULA','HONDURAS',15,27,9,'N',15.4525,87,55,24,'U',0,91
UNION ALL SELECT 'MHNJ','GJA','GUANAJA','GUANAJA','HONDURAS',16,26,43,'N',16.4452777777778,85,54,23,'U',0,36
UNION ALL SELECT 'MHPL','PEU','PUERTO LEMPIRA','PUERTO LEMPIRA','HONDURAS',15,15,39,'N',15.2608333333333,83,46,53,'U',0,25
UNION ALL SELECT 'MHRO','RTB','ROATAN','ROATAN','HONDURAS',16,19,0,'N',16.3166666666667,86,31,21,'U',0,18
UNION ALL SELECT 'MHTE','TEA','TELA','TELA','HONDURAS',15,46,33,'N',15.7758333333333,87,28,32,'U',0,7
UNION ALL SELECT 'MHTG','TGU','TONCONTIN INTERNATIONAL','TEGUCIGALPA','HONDURAS',14,3,39,'N',14.0608333333333,87,13,1,'U',0,3294
UNION ALL SELECT 'MHUT','UII','','UTILA','HONDURAS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MKBS','OCJ','BOSCOBEL','OCHO RIOS','JAMAICA',18,24,15,'N',18.4041666666667,76,58,8,'U',0,90
UNION ALL SELECT 'MKJP','KIN','NORMAN MANLEY INTERNATIONAL','KINGSTON','JAMAICA',17,56,8,'N',17.9355555555556,76,47,15,'U',0,10
UNION ALL SELECT 'MKJS','MBJ','SANGSTER INTERNATIONAL','MONTEGO BAY','JAMAICA',18,30,13,'N',18.5036111111111,77,54,48,'U',0,4
UNION ALL SELECT 'MKKJ','POT','KEN JONES','PORT ANTONIO','JAMAICA',18,11,55,'N',18.1986111111111,76,32,4,'U',0,20
UNION ALL SELECT 'MKNG','NEG','','NEGRIL','JAMAICA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MKTP','KTP','TINSON PEN','KINGSTON','JAMAICA',17,59,18,'N',17.9883333333333,76,49,25,'U',0,16
UNION ALL SELECT 'MMAA','ACA','GENERAL JUAN N ALVAREZ INTERNATIONAL','ACAPULCO','MEXICO',16,45,24,'N',16.7566666666667,99,45,12,'U',0,16
UNION ALL SELECT 'MMAN','NTR','DEL NORTE INTERNATIONAL','MONTERREY','MEXICO',25,51,56,'N',25.8655555555556,100,14,14,'U',0,1473
UNION ALL SELECT 'MMAS','AGU','JESUS TERAN INTERNATIONAL','AGUASCALIENTES','MEXICO',21,42,19,'N',21.7052777777778,102,19,4,'U',0,6112
UNION ALL SELECT 'MMBT','HUX','BAHIAS DE HUATULCO INTERNATIONAL','BAHIAS DEHUATULCO','MEXICO',15,46,29,'N',15.7747222222222,96,15,39,'U',0,468
UNION ALL SELECT 'MMCB','CVJ','CUERNAVACA','CUERNAVACA','MEXICO',18,50,6,'N',18.835,99,15,43,'U',0,4262
UNION ALL SELECT 'MMCE','CME','CIUDAD DEL CARMEN INTERNATIONAL','CIUDAD DEL CARMEN','MEXICO',18,39,13,'N',18.6536111111111,91,47,56,'U',0,10
UNION ALL SELECT 'MMCL','CUL','CULIACAN INTERNATIONAL','CULIACAN','MEXICO',24,45,52,'N',24.7644444444444,107,28,28,'U',0,108
UNION ALL SELECT 'MMCM','CTM','CHETUMAL INTERNATIONAL','CHETUMAL','MEXICO',18,30,16,'N',18.5044444444444,88,19,36,'U',0,48
UNION ALL SELECT 'MMCN','CEN','CIUDAD OBREGON INTERNATIONAL','CIUDAD OBREGON','MEXICO',27,23,33,'N',27.3925,109,49,59,'U',0,243
UNION ALL SELECT 'MMCP','CPE','INGENIERO ALBERTO ACUNA ONGAY INTERNATIONAL','CAMPECHE','MEXICO',19,49,0,'N',19.8166666666667,90,30,1,'U',0,31
UNION ALL SELECT 'MMCS','CJS','ABRAHAM GONZALEZ INTERNATIONAL','CIUDAD JUAREZ','MEXICO',31,38,10,'N',31.6361111111111,106,25,43,'U',0,3842
UNION ALL SELECT 'MMCU','CUU','GENERAL R FIERRO VILLALOBOS INTERNATIONAL','CHIHUAHUA','MEXICO',28,42,10,'N',28.7027777777778,105,57,52,'U',0,4462
UNION ALL SELECT 'MMCV','CVM','CIUDAD VICTORIA','CIUDAD VICTORIA','MEXICO',23,42,14,'N',23.7038888888889,98,57,23,'U',0,781
UNION ALL SELECT 'MMCZ','CZM','COZUMEL INTERNATIONAL','COZUMEL','MEXICO',20,31,20,'N',20.5222222222222,86,55,32,'U',0,15
UNION ALL SELECT 'MMDM','MMC','CIUDAD MANTE','CIUDAD MANTE','MEXICO',22,44,25,'N',22.7402777777778,99,1,5,'U',0,341
UNION ALL SELECT 'MMDO','DGO','DURANGO INTERNATIONAL','DURANGO','MEXICO',24,7,27,'N',24.1241666666667,104,31,40,'U',0,6102
UNION ALL SELECT 'MMEP','TPQ','TEPIC','TEPIC','MEXICO',21,25,10,'N',21.4194444444444,104,50,33,'U',0,3012
UNION ALL SELECT 'MMES','ESE','GENERAL ALBERTO L SALINAS C INTERNATIONAL','ENSENADA','MEXICO',31,47,43,'N',31.7952777777778,116,36,9,'U',0,66
UNION ALL SELECT 'MMGL','GDL','DON MIGUEL Y HIDALGO INTERNATIONAL','GUADALAJARA','MEXICO',20,31,18,'N',20.5216666666667,103,18,40,'U',0,5012
UNION ALL SELECT 'MMGM','GYM','GENERAL JOSE MARIA YANEZ INTERNATIONAL','GUAYMAS','MEXICO',27,58,8,'N',27.9688888888889,110,55,30,'U',0,89
UNION ALL SELECT 'MMHC','TCN','TEHUACAN','TEHUACAN','MEXICO',18,29,49,'N',18.4969444444444,97,25,11,'U',0,5510
UNION ALL SELECT 'MMHO','HMO','GENERAL IGNACIO P GARCIA INTERNATIONAL','HERMOSILLO','MEXICO',29,5,45,'N',29.0958333333333,111,2,52,'U',0,646
UNION ALL SELECT 'MMIA','CLQ','COLIMA','COLIMA','MEXICO',19,16,37,'N',19.2769444444444,103,34,38,'U',0,2372
UNION ALL SELECT 'MMIM','ISJ','ISLA MUJERES','ISLA MUJERES','MEXICO',21,14,42,'N',21.245,86,44,23,'U',0,7
UNION ALL SELECT 'MMIO','SLW','PLAN DE GUADALUPE INTERNATIONAL','SALTILLO','MEXICO',25,32,58,'N',25.5494444444444,100,55,43,'U',0,4778
UNION ALL SELECT 'MMLC','LZC','LAZARO CARDENAS','LAZARD CARDENAS','MEXICO',18,0,6,'N',18.0016666666667,102,13,13,'U',0,39
UNION ALL SELECT 'MMLM','LMM','VALLE DEL FUERTE INTERNATIONAL','LOS MOCHIS','MEXICO',25,41,6,'N',25.685,109,4,50,'U',0,14
UNION ALL SELECT 'MMLO','BJX','DE GUANAJUATO INTERNATIONAL','DEL BAJIO','MEXICO',20,59,36,'N',20.9933333333333,101,28,51,'U',0,5968
UNION ALL SELECT 'MMLP','LAP','GENERAL MANUEL MARQUEZ DE LEON INTERNATIONAL','LA PAZ','MEXICO',24,4,21,'N',24.0725,110,21,44,'U',0,89
UNION ALL SELECT 'MMLT','LTO','LORETO INTERNATIONAL','LORETO','MEXICO',25,59,21,'N',25.9891666666667,111,20,54,'U',0,10
UNION ALL SELECT 'MMMA','MAM','GENERAL SERVANDO CANALES INTERNATIONAL','MATAMOROS','MEXICO',25,46,11,'N',25.7697222222222,97,31,31,'U',0,26
UNION ALL SELECT 'MMMD','MID','LICENCIADO MANUEL CRECENCIO REJON INTERNATIONAL','MERIDA','MEXICO',20,56,13,'N',20.9369444444444,89,39,27,'U',0,34
UNION ALL SELECT 'MMML','MXL','GENERAL RODOLFO SANCHEZ TABOADA INTERNATIONAL','MEXICALI','MEXICO',32,37,50,'N',32.6305555555556,115,14,29,'U',0,72
UNION ALL SELECT 'MMMM','MLM','GENERAL FRANCISCO J MUJICA','MORELIA','MEXICO',19,50,59,'N',19.8497222222222,101,1,31,'U',0,6014
UNION ALL SELECT 'MMMT','MTT','MINATITLAN','MINATITLAN','MEXICO',18,6,12,'N',18.1033333333333,94,34,50,'U',0,36
UNION ALL SELECT 'MMMV','LOV','MONCLOVA INTERNATIONAL','MONCLOVA','MEXICO',26,57,20,'N',26.9555555555556,101,28,12,'U',0,1854
UNION ALL SELECT 'MMMX','MEX','LICENCIADO BENITO JUAREZ INTERNATIONAL','MEXICO CITY','MEXICO',19,26,10,'N',19.4361111111111,99,4,19,'U',0,7316
UNION ALL SELECT 'MMMY','MTY','GENERAL MARIANO ESCOBEDO INTERNATIONAL','MONTERREY','MEXICO',25,46,42,'N',25.7783333333333,100,6,24,'U',0,1270
UNION ALL SELECT 'MMMZ','MZT','GENERAL RAFAEL BUELNA INTERNATIONAL','MAZATLAN','MEXICO',23,9,40,'N',23.1611111111111,106,15,57,'U',0,38
UNION ALL SELECT 'MMNG','NOG','NOGALES INTERNATIONAL','NOGALES','MEXICO',31,13,33,'N',31.2258333333333,110,58,32,'U',0,3990
UNION ALL SELECT 'MMNL','NLD','QUETZALCOATL INTERNATIONAL','NUEVO LAREDO','MEXICO',27,26,38,'N',27.4438888888889,99,34,13,'U',0,486
UNION ALL SELECT 'MMOX','OAX','XOXOCOTLAN INTERNATIONAL','OAXACA','MEXICO',16,59,59,'N',16.9997222222222,96,43,35,'U',0,5012
UNION ALL SELECT 'MMPA','PAZ','TAJIN','POZA RICO','MEXICO',20,36,9,'N',20.6025,97,27,39,'U',0,453
UNION ALL SELECT 'MMPB','PBC','HERMANOS SERDAN INTERNATIONAL','PUEBLA','MEXICO',19,9,29,'N',19.1580555555556,98,22,17,'U',0,7380
UNION ALL SELECT 'MMPC','PCA','INGENIERO JUAN GUILLERMO VILLASANA','PACHUCA','MEXICO',20,4,38,'N',20.0772222222222,98,46,56,'U',0,7600
UNION ALL SELECT 'MMPE','PPE','PUNTA PENASCO','PUNTA PENASCO','MEXICO',31,21,6,'N',31.3516666666667,113,31,32,'U',0,30
UNION ALL SELECT 'MMPG','PDS','PIEDRAS NEGRAS INTERNATIONAL','PIEDRAS NEGRAS','MEXICO',28,37,38,'N',28.6272222222222,100,32,6,'U',0,896
UNION ALL SELECT 'MMPN','UPN','LICENCIADO Y GEN IGNACIO LOPEZ RAYON','URUAPAN','MEXICO',19,23,48,'N',19.3966666666667,102,2,21,'U',0,5226
UNION ALL SELECT 'MMPR','PVR','LICENCIADO GUSTAVO DIAZ ORDAZ INTERNATIONAL','PUERTO VALLARTA','MEXICO',20,40,48,'N',20.68,105,15,15,'U',0,20
UNION ALL SELECT 'MMPS','PXM','PUERTO ESCONDIDO','PUERTO ESCONDIDO','MEXICO',15,52,36,'N',15.8766666666667,97,5,20,'U',0,289
UNION ALL SELECT 'MMQT','QRO','INGENIERO F ESPINOZA GUTIERREZ INTERNATIONAL','QUERETARO','MEXICO',20,37,26,'N',20.6238888888889,100,22,7,'U',0,6460
UNION ALL SELECT 'MMRX','REX','GENERAL LUCIO BLANCO INTERNATIONAL','REYNOSA','MEXICO',26,0,32,'N',26.0088888888889,98,13,42,'U',0,128
UNION ALL SELECT 'MMSD','SJD','LOS CABOS INTERNATIONAL','SAN JOSE DEL CABO','MEXICO',23,9,6,'N',23.1516666666667,109,43,15,'U',0,358
UNION ALL SELECT 'MMSP','SLP','PONCIANO ARRIAGA INTERNATIONAL','SAN LUIS POTOSI','MEXICO',22,15,15,'N',22.2541666666667,100,55,50,'U',0,6070
UNION ALL SELECT 'MMTA','TXA','TLAXCALA','TLAXCALA','MEXICO',19,32,11,'N',19.5363888888889,98,10,24,'U',0,8229
UNION ALL SELECT 'MMTC','TRC','TORREON INTERNATIONAL','TORREON','MEXICO',25,34,5,'N',25.5680555555556,103,24,38,'U',0,3694
UNION ALL SELECT 'MMTG','TGZ','FRANCISCO SARABIA','TUXTLA GUTIERREZ','MEXICO',16,46,10,'N',16.7694444444444,93,20,29,'U',0,3451
UNION ALL SELECT 'MMTJ','TIJ','GENERAL ABELARDO L RODRIGUEZ INTERNATIONAL','TIJUANA','MEXICO',32,32,27,'N',32.5408333333333,116,58,12,'U',0,499
UNION ALL SELECT 'MMTM','TAM','GENERAL FRANCISCO JAVIER MINA INTERNATIONAL','TAMPICO','MEXICO',22,17,47,'N',22.2963888888889,97,51,57,'U',0,80
UNION ALL SELECT 'MMTN','TSL','TAMUIN','TAMUIN','MEXICO',22,2,17,'N',22.0380555555556,98,48,23,'U',0,164
UNION ALL SELECT 'MMTO','TLC','LICENCIADO ADOLFO LOPEZ MATEOS INTERNATIONAL','TOLUCA','MEXICO',19,20,13,'N',19.3369444444444,99,33,57,'U',0,8458
UNION ALL SELECT 'MMTP','TAP','TAPACHULA INTERNATIONAL','TAPACHULA','MEXICO',14,47,39,'N',14.7941666666667,92,22,12,'U',0,115
UNION ALL SELECT 'MMUN','CUN','CANCUN INTERNATIONAL','CANCUN','MEXICO',21,2,11,'N',21.0363888888889,86,52,37,'U',0,20
UNION ALL SELECT 'MMVA','VSA','C P A CARLOS ROVIROSA INTERNATIONAL','VILLAHERMOSA','MEXICO',17,59,49,'N',17.9969444444444,92,49,2,'U',0,43
UNION ALL SELECT 'MMVR','VER','GENERAL HERIBERTO JARA INTERNATIONAL','VERA CRUZ','MEXICO',19,8,43,'N',19.1452777777778,96,11,13,'U',0,105
UNION ALL SELECT 'MMZC','ZCL','GENERAL LEOBARDO C RUIZ INTERNATIONAL','ZACATECAS','MEXICO',22,53,49,'N',22.8969444444444,102,41,12,'U',0,7021
UNION ALL SELECT 'MMZH','ZIH','IXTAPA ZIHUATANEJO INTERNATIONAL','ZIHUATANEJO','MEXICO',17,36,5,'N',17.6013888888889,101,27,37,'U',0,20
UNION ALL SELECT 'MMZM','ZMM','ZAMORA','ZAMORA','MEXICO',20,2,42,'N',20.045,102,16,33,'U',0,5141
UNION ALL SELECT 'MMZO','ZLO','PLAYA DE ORO INTERNATIONAL','MANZANILLO','MEXICO',19,8,41,'N',19.1447222222222,104,33,31,'U',0,35
UNION ALL SELECT 'MNBL','BEF','BLUEFIELDS','BLUEFIELDS','NICARAGUA',11,59,20,'N',11.9888888888889,83,46,27,'U',0,86
UNION ALL SELECT 'MNMG','MGA','MANAGUA INTERNATIONAL','MANAGUA','NICARAGUA',12,8,28,'N',12.1411111111111,86,10,5,'U',0,194
UNION ALL SELECT 'MNPC','PUZ','PUERTO CABEZAS','PUERTO CABEZAS','NICARAGUA',14,2,49,'N',14.0469444444444,83,23,12,'U',0,52
UNION ALL SELECT 'MNSI','SIU','','SIUNA','NICARAGUA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MPBO','BOC','BOCAS DEL TORO','BOCAS DEL TORO','PANAMA',9,20,27,'N',9.34083333333333,82,15,3,'U',0,10
UNION ALL SELECT 'MPCH','CHX','CAP MANUEL NINO INTERNATIONAL','CHANGUINOLA','PANAMA',9,27,31,'N',9.45861111111111,82,31,0,'U',0,19
UNION ALL SELECT 'MPDA','DAV','ENRIQUE MALEK INTERNATIONAL','DAVID','PANAMA',8,23,27,'N',8.39083333333333,82,26,5,'U',0,89
UNION ALL SELECT 'MPHO','HOW','HOWARD AFB','HOWARD','PANAMA',8,54,52,'N',8.91444444444445,79,35,58,'U',0,51
UNION ALL SELECT 'MPMG','PAC','MARCOS A GELABERT INTERNATIONAL','PANAMA','PANAMA',8,58,24,'N',8.97333333333333,79,33,20,'U',0,31
UNION ALL SELECT 'MPNU','N/A','','LOS SANTOS','PANAMA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MPTO','PTY','TOCUMEN INTERNATIONAL','PANAMA CITY','PANAMA',9,4,16,'N',9.07111111111111,79,23,0,'U',0,135
UNION ALL SELECT 'MRCC','OTR','COTO 47','COTO 47','COSTA RICA',8,36,4,'N',8.60111111111111,82,58,12,'U',0,26
UNION ALL SELECT 'MRGF','GLF','GOLFITO','GOLFITO','COSTA RICA',8,39,14,'N',8.65388888888889,83,10,55,'U',0,49
UNION ALL SELECT 'MRLB','LIR','DANIEL ODUBER QUIROS INTERNATIONAL','LIBERIA','COSTA RICA',10,35,35,'N',10.5930555555556,85,32,39,'U',0,270
UNION ALL SELECT 'MRLM','LIO','LIMON INTERNATIONAL','LIMON','COSTA RICA',9,57,28,'N',9.95777777777778,83,1,19,'U',0,7
UNION ALL SELECT 'MRLP','LSP','','LAS PIEDRAS','COSTA RICA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MRNS','NOB','NOSARA','NOSARA BEACH','COSTA RICA',9,58,35,'N',9.97638888888889,85,39,10,'U',0,3
UNION ALL SELECT 'MROC','SJO','JUAN SANTAMARIA INTERNATIONAL','SAN JOSE','COSTA RICA',9,59,37,'N',9.99361111111111,84,12,31,'U',0,3021
UNION ALL SELECT 'MRPM','PMZ','PALMAR SUR','PALMAR SUR','COSTA RICA',8,57,3,'N',8.95083333333333,83,28,6,'U',0,49
UNION ALL SELECT 'MRQP','XQP','QUEPOS MANAGUA','QUEPOS','COSTA RICA',9,26,35,'N',9.44305555555556,84,7,47,'U',0,105
UNION ALL SELECT 'MSLP','SAL','EL SALVADOR INTERNATIONAL','SAN SALVADOR','EL SALVADOR',13,26,26,'N',13.4405555555556,89,3,21,'U',0,101
UNION ALL SELECT 'MTCH','CAP','CAP HAITIEN','CAP HAITIEN','HAITI',19,43,57,'N',19.7325,72,11,41,'U',0,10
UNION ALL SELECT 'MTPP','PAP','PORT AU PRINCE INTERNATIONAL','PORT-AU-PRINCE','HAITI',18,34,48,'N',18.58,72,17,33,'U',0,121
UNION ALL SELECT 'MUBA','BCA','GUSTAVO RIZO','BARACOA PLAYA','CUBA',20,21,56,'N',20.3655555555556,74,30,23,'U',0,26
UNION ALL SELECT 'MUBY','BYM','CARLOS MANUEL DE CESPEDES','BAYAMO','CUBA',20,23,47,'N',20.3963888888889,76,37,17,'U',0,203
UNION ALL SELECT 'MUCA','AVI','MAXIMO GOMEZ','CIEGO DE AVILA','CUBA',22,1,37,'N',22.0269444444444,78,47,22,'U',0,335
UNION ALL SELECT 'MUCF','CFG','JAIME GONZALEZ','CIENFUEGOS','CUBA',22,9,0,'N',22.15,80,24,51,'U',0,102
UNION ALL SELECT 'MUCL','CYO','VILO ACUNA','CAYO','CUBA',21,36,58,'N',21.6161111111111,81,32,44,'U',0,10
UNION ALL SELECT 'MUCM','CMW','IGNACIO AGRAMONTE INTERNATIONAL','CAMAGUEY','CUBA',21,25,13,'N',21.4202777777778,77,50,51,'U',0,413
UNION ALL SELECT 'MUCO','ONX','','COLON','CUBA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MUCU','SCU','ANTONIO MACEO INTERNATIONAL','SANTIAGO DE CUBA','CUBA',19,58,12,'N',19.97,75,50,8,'U',0,249
UNION ALL SELECT 'MUGT','GAO','MARIANA GRAJALES','GUANTANAMO','CUBA',20,5,7,'N',20.0852777777778,75,9,30,'U',0,56
UNION ALL SELECT 'MUHA','HAV','JOSE MARTI INTERNATIONAL','HAVANA','CUBA',22,59,21,'N',22.9891666666667,82,24,33,'U',0,210
UNION ALL SELECT 'MUHG','HOG','FRANK PAIS','HOLGUIN','CUBA',20,47,8,'N',20.7855555555556,76,18,54,'U',0,361
UNION ALL SELECT 'MULM','LCL','LA COLOMA','LA COLOMA','CUBA',22,20,9,'N',22.3358333333333,83,38,31,'U',0,98
UNION ALL SELECT 'MUMO','MOA','ORESTES ACOSTA','MOA','CUBA',20,39,15,'N',20.6541666666667,74,55,18,'U',0,16
UNION ALL SELECT 'MUMZ','MZO','SIERRA MAESTRA','MANZANILLO','CUBA',20,17,17,'N',20.2880555555556,77,5,21,'U',0,112
UNION ALL SELECT 'MUNG','GER','RAFAEL PEREZ','NUEVA GERONA','CUBA',21,50,5,'N',21.8347222222222,82,47,2,'U',0,79
UNION ALL SELECT 'MUSC','SNU','ABEL SANTAMARIA','SANTA CLARA','CUBA',22,29,31,'N',22.4919444444444,79,56,37,'U',0,338
UNION ALL SELECT 'MUVR','VRA','JUAN GUALBERTO GOMEZ INTERNATIONAL','VARADERO','CUBA',23,2,4,'N',23.0344444444444,81,26,7,'U',0,210
UNION ALL SELECT 'MUVT','VTU','HERMANOS AMEIJEIRAS','LAS TUNAS','CUBA',20,59,16,'N',20.9877777777778,76,56,9,'U',0,328
UNION ALL SELECT 'MWCB','CYB','GERRARD SMITH INTERNATIONAL','CAYMAN BARAC','CAYMAN ISLANDS',19,41,12,'N',19.6866666666667,79,52,58,'U',0,8
UNION ALL SELECT 'MWCG','GCM','','GRAND CAYMAN','CAYMAN ISLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MWCL','LYB','','LITTLE CAYMAN','CAYMAN ISLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MWCR','GCM','OWEN ROBERTS INTERNATIONAL','GEORGETOWN','CAYMAN ISLANDS',19,17,34,'N',19.2927777777778,81,21,27,'U',0,8
UNION ALL SELECT 'MYAF','ASD','ANDROS TOWN','ANDROS TOWN','BAHAMAS',24,41,52,'N',24.6977777777778,77,47,44,'U',0,5
UNION ALL SELECT 'MYAM','MHH','MARSH HARBOUR','MARSH HARBOR','BAHAMAS',26,30,41,'N',26.5113888888889,77,5,0,'U',0,10
UNION ALL SELECT 'MYAN','SAQ','SAN ANDROS','SAN ANDROS','BAHAMAS',25,3,13,'N',25.0536111111111,78,2,56,'U',0,5
UNION ALL SELECT 'MYAP','AXP','SPRING POINT','SPRING POINT','BAHAMAS',22,26,30,'N',22.4416666666667,73,58,15,'U',0,11
UNION ALL SELECT 'MYAT','TCB','TREASURE CAY','TREASURE CAY','BAHAMAS',26,44,43,'N',26.7452777777778,77,23,28,'U',0,11
UNION ALL SELECT 'MYAW','WKR','','WALKERS CAY','BAHAMAS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MYBC','CCZ','CHUB CAY','CHUB CAY','BAHAMAS',25,25,1,'N',25.4169444444444,77,52,51,'U',0,5
UNION ALL SELECT 'MYBS','BIM','SOUTH BIMINI','ALICE TOWN','BAHAMAS',25,41,59,'N',25.6997222222222,79,15,52,'U',0,10
UNION ALL SELECT 'MYEF','GGT','EXUMA INTERNATIONAL','GREAT EXUMA','BAHAMAS',23,33,45,'N',23.5625,75,52,40,'U',0,9
UNION ALL SELECT 'MYEG','GGT','','GEORGE TOWN','BAHAMAS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'MYEH','ELH','NORTH ELEUTHERA','NORTH ELEUTHERA','BAHAMAS',25,28,32,'N',25.4755555555556,76,40,52,'U',0,5
UNION ALL SELECT 'MYEM','GHB','GOVERNORS HARBOUR','GOVERNOR''S HARBOR','BAHAMAS',25,17,4,'N',25.2844444444444,76,19,51,'U',0,15
UNION ALL SELECT 'MYER','RSD','ROCK SOUND','ROCK SOUND','BAHAMAS',24,53,30,'N',24.8916666666667,76,10,39,'U',0,10
UNION ALL SELECT 'MYGF','FPO','GRAND BAHAMA INTERNATIONAL','FREEPORT','BAHAMAS',26,33,31,'N',26.5586111111111,78,41,43,'U',0,7
UNION ALL SELECT 'MYGW','WTD','WEST END','WEST END','BAHAMAS',26,41,10,'N',26.6861111111111,78,58,39,'U',0,5
UNION ALL SELECT 'MYIG','IGA','MATTHEW TOWN','MATTHEW TOWN','BAHAMAS',20,58,30,'N',20.975,73,40,0,'U',0,8
UNION ALL SELECT 'MYLD','LGI','DEADMANS CAY','DEAD MAN''S CAY','BAHAMAS',23,10,44,'N',23.1788888888889,75,5,36,'U',0,9
UNION ALL SELECT 'MYLS','SML','STELLA MARIS','STELLA MARIS','BAHAMAS',23,34,58,'N',23.5827777777778,75,16,7,'U',0,10
UNION ALL SELECT 'MYMM','MYG','MAYAGUANA','MAYAGUANA','BAHAMAS',22,22,46,'N',22.3794444444444,73,0,48,'U',0,11
UNION ALL SELECT 'MYNN','NAS','NASSAU INTERNATIONAL','NASSAU','BAHAMAS',25,2,20,'N',25.0388888888889,77,27,58,'U',0,16
UNION ALL SELECT 'MYSM','ZSA','SAN SALVADOR','COCKBURN TOWN','BAHAMAS',24,3,47,'N',24.0630555555556,74,31,26,'U',0,22
UNION ALL SELECT 'MZBZ','BZE','PHILIP S W GOLDSON INTERNATIONAL','BELIZE CITY','BELIZE',17,32,20,'N',17.5388888888889,88,18,29,'U',0,15
UNION ALL SELECT 'NCAI','AIT','AITUTAKI','AITUTAKI','COOK ISLANDS',18,49,30,'S',-18.825,159,46,25,'U',0,20
UNION ALL SELECT 'NCAT','AIU','','ATIU ISLAND','COOK ISLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NCPY','PYE','','PENRHYN ISLAND','COOK ISLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NCRG','RAR','RAROTONGA INTERNATIONAL','AVARUA','COOK ISLANDS',21,12,9,'S',-21.2025,159,48,20,'U',0,22
UNION ALL SELECT 'NFCI','ICI','','CICIA','FIJI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFCS','CST','','CASTAWAY ISLD.','FIJI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFFN','NAN','NADI INTERNATIONAL','NANDI','FIJI',17,45,16,'S',-17.7544444444444,177,26,36,'E',177.443333333333,59
UNION ALL SELECT 'NFFO','PTF','','MALOLO LAILAI','FIJI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFMA','MNF','','MANA ISLAND','FIJI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFMO','MFJ','','MOALA','FIJI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFNA','SUV','NAUSORI INTERNATIONAL','NAUSORI','FIJI',18,2,35,'S',-18.0430555555556,178,33,33,'E',178.559166666667,17
UNION ALL SELECT 'NFNK','LKB','','LAKEMBA','FIJI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFNL','LMG','LABASA','LAMBASA','FIJI',16,28,0,'S',-16.4666666666667,179,20,23,'E',179.339722222222,44
UNION ALL SELECT 'NFNR','RTA','','ROTUMA ISLAND','FIJI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFNS','SVU','','SAVU SAVU','FIJI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFSU','SUV','','SUVA','FIJI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFTE','EUA','','EUA','TONGA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFTF','TBU','FUA AMOTU INTERNATIONAL','TONGATAPU','TONGA',21,14,27,'S',-21.2408333333333,175,9,0,'U',0,126
UNION ALL SELECT 'NFTL','HPA','HAAPAI','HA''APAI','TONGA',19,46,37,'S',-19.7769444444444,174,20,28,'U',0,40
UNION ALL SELECT 'NFTO','NFO','','NIUAFO''OU','TONGA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFTP','NTT','','NIUATOPUTAPU','TONGA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NFTV','VAV','VAVAU INTERNATIONAL','VAVA''U','TONGA',18,35,7,'S',-18.5852777777778,173,57,46,'U',0,236
UNION ALL SELECT 'NGAB','ABF','','ABAIANG','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGBR','BEZ','','BERU','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGFU','FUN','FUNAFUTI INTERNATIONAL AIRPORT','FUNAFUTI','TUVALU ISLAND',8,31,0,'S',-8.51666666666667,179,13,0,'E',179.216666666667,0
UNION ALL SELECT 'NGMA','MNK','','MAIANA','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGMK','MZK','','MARAKEI','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGMN','MTK','','MAKIN ISLAND','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGNU','NIG','','NIKUNAU','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGON','OOT','','ONOTOA','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGTA','TRW','BONRIKI INTERNATIONAL','TARAWA','KIRIBATI',1,22,53,'N',1.38138888888889,173,8,49,'E',173.146944444444,9
UNION ALL SELECT 'NGTB','AEA','','ABEMAMA ATOLL','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGTE','TBF','TABITEUEA NORTH','TABITEUEA NORTH','KIRIBATI',1,13,25,'S',-1.22361111111111,174,46,34,'E',174.776111111111,7
UNION ALL SELECT 'NGTM','TMN','','TAMANA','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGTO','NON','','NONOUTI','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGTR','AIS','','ARORAE ISLAND','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGTS','TSU','','TABITEUEA SOUTH','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NGTU','BBG','','BUTARITARI','KIRIBATI',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NIUE','HUE','NIUE INTERNATIONAL','ALOFI','NEW ZEALAND',19,4,48,'S',-19.08,169,55,32,'U',0,209
UNION ALL SELECT 'NLWF','FUT','','FUTUNA','WALLIS & FUTUNA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NLWW','WLS','HIHIFO','WALLIS','WALLIS & FUTUNA',13,14,17,'S',-13.2380555555556,176,11,57,'U',0,79
UNION ALL SELECT 'NSAP','APW','','APIA','SAMOA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NSFA','APW','FALEOLO INTERNATIONAL','FALEOLO','SAMOA',13,49,47,'S',-13.8297222222222,172,0,30,'U',0,58
UNION ALL SELECT 'NSMA','MXS','','MAOTA','SAMOA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NSTU','PPG','PAGO PAGO INTERNATIONAL','PAGO PAGO','SAMOA',14,19,51,'S',-14.3308333333333,170,42,37,'U',0,31
UNION ALL SELECT 'NTAR','RUR','RURUTU','RURUTU','FRENCH POLYNESIA',22,26,2,'S',-22.4338888888889,151,21,38,'U',0,18
UNION ALL SELECT 'NTAT','TUB','TUBUAI','TUBUAI','FRENCH POLYNESIA',23,21,55,'S',-23.3652777777778,149,31,26,'U',0,7
UNION ALL SELECT 'NTGA','AAA','ANAA','ANAA','FRENCH POLYNESIA',17,21,9,'S',-17.3525,145,30,35,'U',0,10
UNION ALL SELECT 'NTGC','TIH','TIKEHAU','TIKEHAU','FRENCH POLYNESIA',15,7,10,'S',-15.1194444444444,148,13,50,'U',0,6
UNION ALL SELECT 'NTGD','APK','','APATAKI','TUAMOTU ISLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NTGE','REA','REAO','REAO','FRENCH POLYNESIA',18,27,57,'S',-18.4658333333333,136,26,22,'U',0,12
UNION ALL SELECT 'NTGF','FAV','FAKARAVA','FAKARAVA','FRENCH POLYNESIA',16,3,16,'S',-16.0544444444444,145,39,25,'U',0,13
UNION ALL SELECT 'NTGI','XMH','MANIHI','MANIHI','FRENCH POLYNESIA',14,26,12,'S',-14.4366666666667,146,4,12,'U',0,14
UNION ALL SELECT 'NTGJ','GMR','TOTEGEGIE','TOTEGEGIE','FRENCH POLYNESIA',23,4,47,'S',-23.0797222222222,134,53,25,'U',0,7
UNION ALL SELECT 'NTGK','KKR','KAUKURA','KAUKURA ATOLL','TUAMOTU ISLANDS',15,39,48,'S',-15.6633333333333,146,53,5,'U',0,11
UNION ALL SELECT 'NTGM','MKP','MAKEMO','MAKEMO','FRENCH POLYNESIA',16,35,5,'S',-16.5847222222222,143,39,26,'U',0,3
UNION ALL SELECT 'NTGN','NAU','NAPUKA','NAPUKA ISLAND','FRENCH POLYNESIA',14,10,36,'S',-14.1766666666667,141,16,2,'U',0,7
UNION ALL SELECT 'NTGO','TKV','','TATAKOTO','FRENCH POLYNESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NTGP','PKP','PUKA PUKA','PUKA PUKA','FRENCH POLYNESIA',14,48,34,'S',-14.8094444444444,138,48,46,'U',0,5
UNION ALL SELECT 'NTGQ','PUK','','PUKARUA','FRENCH POLYNESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NTGT','TKP','TAKAPOTO','TAKAPOTO','FRENCH POLYNESIA',14,42,45,'S',-14.7125,145,15,10,'U',0,12
UNION ALL SELECT 'NTGU','AXR','ARUTUA','ARUTUA','TUAMOTU ISLANDS',15,14,53,'S',-15.2480555555556,146,36,59,'U',0,9
UNION ALL SELECT 'NTGV','MVT','MATAIVA','MATAIVA','FRENCH POLYNESIA',14,52,5,'S',-14.8680555555556,148,43,2,'U',0,11
UNION ALL SELECT 'NTGW','NUK','','NUKUTAVAKE','FRENCH POLYNESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NTKH','FHZ','','FAKAHINA','FRENCH POLYNESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NTKR','TKX','TAKAROA','TAKAROA','FRENCH POLYNESIA',14,27,20,'S',-14.4555555555556,145,1,28,'U',0,13
UNION ALL SELECT 'NTMD','NHV','NUKU HIVA','NUKU HIVA','FRENCH POLYNESIA',8,47,44,'S',-8.79555555555556,140,13,43,'U',0,220
UNION ALL SELECT 'NTMP','UAP','','UA POU','FRENCH POLYNESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NTMU','UAH','','UA HUKA','FRENCH POLYNESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NTTB','BOB','BORA BORA','BORA BORA','FRENCH POLYNESIA',16,26,39,'S',-16.4441666666667,151,45,4,'U',0,10
UNION ALL SELECT 'NTTG','RGI','RANGIROA','RANGIROA','FRENCH POLYNESIA',14,57,15,'S',-14.9541666666667,147,39,38,'U',0,10
UNION ALL SELECT 'NTTH','HUH','HUAHINE','HUAHINE ISLAND','FRENCH POLYNESIA',16,41,14,'S',-16.6872222222222,151,1,18,'U',0,7
UNION ALL SELECT 'NTTM','MOZ','TEMAE','MOOREA','FRENCH POLYNESIA',17,29,23,'S',-17.4897222222222,149,45,42,'U',0,9
UNION ALL SELECT 'NTTO','HOI','HAO','HAO ISLAND','TUAMOTU ISLANDS',18,4,29,'S',-18.0747222222222,140,56,45,'U',0,10
UNION ALL SELECT 'NTTP','MAU','MAUPITI','MAUPITI','FRENCH POLYNESIA',16,25,35,'S',-16.4263888888889,152,14,37,'U',0,15
UNION ALL SELECT 'NTTR','RFP','UTUROA','RAIATEA ISLAND','FRENCH POLYNESIA',16,43,22,'S',-16.7227777777778,151,27,57,'U',0,3
UNION ALL SELECT 'NTUV','VHZ','','VAHITAHI','FRENCH POLYNESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSC','SLH','','SOLA','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSE','EAE','','EMAE','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSF','CCV','','CRAIG COVE','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSG','LOD','','LONGANA','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSH','SSR','','SARA','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSL','LPM','','LAMAP','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSM','LNB','','LAMEN BAY','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSN','MWF','','MAEWO-NAONE','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSO','LNE','','LONORORE','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSP','NUS','','NORSUP','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVST','TGH','','TONGOA','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSU','ULB','','ULEI','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSV','VLS','','VALESDIR','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSW','WLH','','WALAHA','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVSX','SWJ','','SOUTH WEST BAY','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVVB','AWD','','ANIWA','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVVD','DLY','','DILLON''S BAY','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVVF','FTA','','FUTUNA ISLAND','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVVI','IPA','','IPOTA','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
) x (ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LatDec],[LongDeg],[LongMin],[LongSec],[LongDir],[LongDec],[Altitude])
LEFT OUTER JOIN Airports a ON a.IATA_Code = x.IATA_Code
--WHERE x.[LatDir] <> 'U' and x.[LongDir] <> 'U' and x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE n=1
GO


INSERT INTO Airports (ICAO_Code, IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir
    ,LongDeg, LongMin, LongSec, LongDir, Altitude)
SELECT ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LongDeg],[LongMin],[LongSec],[LongDir],[Altitude]
FROM (
SELECT x.ICAO_Code,x.IATA_Code,x.[Name],x.[City],x.[Country],x.[LatDeg],x.[LatMin],x.[LatSec],x.[LatDir]
	,x.[LatDec],x.[LongDeg],x.[LongMin],x.[LongSec],x.[LongDir],x.[LongDec],x.[Altitude]
    ,n=ROW_NUMBER() OVER (PARTITION BY x.IATA_Code ORDER BY (SELECT NULL))
FROM (
SELECT 'NVVQ','N/A','','QUOIN HILL','VANUATU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NVVV','VLI','PORT VILA BAUERFIELD','PORT-VILA','VANUATU',17,41,57,'S',-17.6991666666667,168,19,11,'E',168.319722222222,69
UNION ALL SELECT 'NWEE','ILP','','ILE DES PINS','NEW CALEDONIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NWWA','TGJ','','TIGA','NEW CALEDONIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NWWD','KNQ','KONE','KONE','NEW CALEDONIA',21,3,12,'S',-21.0533333333333,164,50,16,'E',164.837777777778,23
UNION ALL SELECT 'NWWK','KOC','KOUMAC','KOUMAC','NEW CALEDONIA',20,32,46,'S',-20.5461111111111,164,15,20,'E',164.255555555556,42
UNION ALL SELECT 'NWWL','LIF','OUANAHAM','LIFOU','NEW CALEDONIA',20,46,29,'S',-20.7747222222222,167,14,23,'E',167.239722222222,92
UNION ALL SELECT 'NWWM','GEA','NOUMEA MAGENTA','NOUMEA','NEW CALEDONIA',22,15,29,'S',-22.2580555555556,166,28,22,'E',166.472777777778,10
UNION ALL SELECT 'NWWR','MEE','LA ROCHE','MARE','NEW CALEDONIA',21,28,54,'S',-21.4816666666667,168,2,15,'E',168.0375,141
UNION ALL SELECT 'NWWU','TOU','TOUHO','TOUHO','NEW CALEDONIA',20,47,28,'S',-20.7911111111111,165,15,33,'E',165.259166666667,10
UNION ALL SELECT 'NWWV','UVE','OUVEA OULOUP','OUVEA','NEW CALEDONIA',20,38,26,'S',-20.6405555555556,166,34,22,'E',166.572777777778,23
UNION ALL SELECT 'NWWW','NOU','LA TONTOUTA','NOUMEA','NEW CALEDONIA',22,0,52,'S',-22.0144444444444,166,12,46,'E',166.212777777778,52
UNION ALL SELECT 'NZAA','AKL','AUCKLAND INTERNATIONAL','AUCKLAND','NEW ZEALAND',37,0,29,'S',-37.0080555555556,174,47,30,'E',174.791666666667,23
UNION ALL SELECT 'NZAP','TUO','TAUPO','TAUPO','NEW ZEALAND',38,44,23,'S',-38.7397222222222,176,5,4,'E',176.084444444444,1335
UNION ALL SELECT 'NZBM','BHE','','BLENHEIM','NEW ZEALAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NZCH','CHC','CHRISTCHURCH INTERNATIONAL','CHRISTCHURCH','NEW ZEALAND',43,29,21,'S',-43.4891666666667,172,31,56,'E',172.532222222222,123
UNION ALL SELECT 'NZCI','CHT','CHATHAM ISLANDS','CHATHAM ISLAND','NEW ZEALAND',43,48,36,'S',-43.81,176,27,26,'U',0,43
UNION ALL SELECT 'NZDN','DUD','DUNEDIN','DUNEDIN','NEW ZEALAND',45,55,41,'S',-45.9280555555556,170,11,54,'E',170.198333333333,4
UNION ALL SELECT 'NZGS','GIS','GISBORNE','GISBORNE','NEW ZEALAND',38,39,48,'S',-38.6633333333333,177,58,42,'E',177.978333333333,15
UNION ALL SELECT 'NZGT','MON','GLENTANNER','GLENTANNER','NEW ZEALAND',43,54,24,'S',-43.9066666666667,170,7,42,'E',170.128333333333,1824
UNION ALL SELECT 'NZHK','HKK','HOKITIKA','HOKITIKA','NEW ZEALAND',42,42,49,'S',-42.7136111111111,170,59,7,'E',170.985277777778,146
UNION ALL SELECT 'NZHN','HLZ','HAMILTON','HAMILTON','NEW ZEALAND',37,51,59,'S',-37.8663888888889,175,19,55,'E',175.331944444444,172
UNION ALL SELECT 'NZKK','KKE','KERIKERI','KERIKERI','NEW ZEALAND',35,15,46,'S',-35.2627777777778,173,54,43,'E',173.911944444444,492
UNION ALL SELECT 'NZKT','KAT','KAITAIA','KAITAIA','NEW ZEALAND',35,4,12,'S',-35.07,173,17,7,'E',173.285277777778,270
UNION ALL SELECT 'NZLX','ALR','ALEXANDRA','ALEXANDRA','NEW ZEALAND',45,12,42,'S',-45.2116666666667,169,22,24,'E',169.373333333333,752
UNION ALL SELECT 'NZMC','GTN','MOUNT COOK','MOUNT COOK','NEW ZEALAND',43,45,54,'S',-43.765,170,8,0,'E',170.133333333333,2153
UNION ALL SELECT 'NZMF','MFN','','MILFORD SOUND','NEW ZEALAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NZMK','MZP','','MOTUEKA','NEW ZEALAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NZMO','TEU','MANAPOURI','MANAPOURI','NEW ZEALAND',45,31,59,'S',-45.5330555555556,167,39,0,'E',167.65,687
UNION ALL SELECT 'NZMS','MRO','MASTERTON','MASTERTON','NEW ZEALAND',40,58,24,'S',-40.9733333333333,175,38,1,'E',175.633611111111,364
UNION ALL SELECT 'NZNE','NPE','','NAPIER','NEW ZEALAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NZNP','NPL','NEW PLYMOUTH','NEW PLYMOUTH','NEW ZEALAND',39,0,31,'S',-39.0086111111111,174,10,45,'E',174.179166666667,97
UNION ALL SELECT 'NZNS','NSN','NELSON','NELSON','NEW ZEALAND',41,17,54,'S',-41.2983333333333,173,13,16,'E',173.221111111111,17
UNION ALL SELECT 'NZNV','IVC','INVERCARGILL','INVERCARGILL','NEW ZEALAND',46,24,44,'S',-46.4122222222222,168,18,46,'E',168.312777777778,5
UNION ALL SELECT 'NZOK','PCN','','PICTON','NEW ZEALAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NZOU','OAM','OAMARU','OAMARU','NEW ZEALAND',44,58,12,'S',-44.97,171,4,54,'E',171.081666666667,99
UNION ALL SELECT 'NZPM','PMR','PALMERSTON NORTH','PALMERSTON NORTH','NEW ZEALAND',40,19,14,'S',-40.3205555555556,175,37,1,'E',175.616944444444,151
UNION ALL SELECT 'NZPP','PPQ','PARAPARAUMU','PARAPARAUMU','NEW ZEALAND',40,54,17,'S',-40.9047222222222,174,59,21,'E',174.989166666667,22
UNION ALL SELECT 'NZQN','ZQN','QUEENSTOWN','QUEENSTOWN INTERNATIONAL','NEW ZEALAND',45,1,16,'S',-45.0211111111111,168,44,21,'E',168.739166666667,1171
UNION ALL SELECT 'NZRO','ROT','ROTORUA','ROTORUA','NEW ZEALAND',38,6,33,'S',-38.1091666666667,176,19,2,'E',176.317222222222,935
UNION ALL SELECT 'NZTG','TRG','TAURANGA','TAURANGA','NEW ZEALAND',37,40,19,'S',-37.6719444444444,176,11,46,'E',176.196111111111,13
UNION ALL SELECT 'NZTK','TKF','','TAKAKA','NEW ZEALAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NZTU','TIU','TIMARU','TIMARU','NEW ZEALAND',44,18,10,'S',-44.3027777777778,171,13,31,'E',171.225277777778,89
UNION ALL SELECT 'NZTZ','TEU','','TE ANAU','NEW ZEALAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'NZWB','BHE','WOODBOURNE','WOODBOURNE','NEW ZEALAND',41,31,6,'S',-41.5183333333333,173,52,13,'E',173.870277777778,109
UNION ALL SELECT 'NZWF','WKA','WANAKA','WANAKA','NEW ZEALAND',44,43,31,'S',-44.7252777777778,169,14,35,'E',169.243055555556,1142
UNION ALL SELECT 'NZWK','WHK','WHAKATANE','WHAKATANE','NEW ZEALAND',37,55,14,'S',-37.9205555555556,176,54,51,'E',176.914166666667,20
UNION ALL SELECT 'NZWN','WLG','WELLINGTON INTERNATIONAL','WELLINGTON','NEW ZEALAND',41,19,38,'S',-41.3272222222222,174,48,19,'E',174.805277777778,41
UNION ALL SELECT 'NZWR','WRE','WHANGAREI','WHANGAREI','NEW ZEALAND',35,46,6,'S',-35.7683333333333,174,21,54,'E',174.365,133
UNION ALL SELECT 'NZWS','WSZ','WESTPORT','WESTPORT','NEW ZEALAND',41,44,17,'S',-41.7380555555556,171,34,51,'E',171.580833333333,13
UNION ALL SELECT 'NZWU','WAG','WANGANUI','WANGANUI','NEW ZEALAND',39,57,44,'S',-39.9622222222222,175,1,31,'E',175.025277777778,27
UNION ALL SELECT 'OABN','BIM','','BAMYAN','AFGHANISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OABT','BST','','BOST','AFGHANISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OACC','CCN','','CHAKHCHARAN','AFGHANISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OAFR','FAH','','FARAH','AFGHANISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OAFZ','FBD','','FAIZABAD','AFGHANISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OAGZ','GRG','','GARDEZ','AFGHANISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OAHN','KWH','','KHWAHAN','AFGHANISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OAHR','HEA','HERAT','HERAT','AFGHANISTAN',34,12,35,'N',34.2097222222222,62,13,40,'E',62.2277777777778,3206
UNION ALL SELECT 'OAJL','JAA','JALALABAD','JALALABAD','AFGHANISTAN',34,23,57,'N',34.3991666666667,70,29,58,'E',70.4994444444444,1814
UNION ALL SELECT 'OAKB','KBL','KABUL INTERNATIONAL','KABUL','AFGHANISTAN',34,33,57,'N',34.5658333333333,69,12,44,'E',69.2122222222222,5878
UNION ALL SELECT 'OAKN','KDH','KANDAHAR','KANDAHAR','AFGHANISTAN',31,30,21,'N',31.5058333333333,65,50,52,'E',65.8477777777778,3329
UNION ALL SELECT 'OAKS','KHT','','KHOST','AFGHANISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OAMN','MMZ','MAIMANA','MAIMAMA','AFGHANISTAN',35,56,3,'N',35.9341666666667,64,45,33,'E',64.7591666666667,2690
UNION ALL SELECT 'OAMS','MZR','MAZAR I SHARIF','MAZAR-I-SHARIF','AFGHANISTAN',36,42,25,'N',36.7069444444444,67,12,33,'E',67.2091666666667,1284
UNION ALL SELECT 'OASN','SGA','','SHEGHNAN','AFGHANISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OAUZ','UND','KUNDUZ','KUNDUZ','AFGHANISTAN',36,39,54,'N',36.665,68,54,39,'E',68.9108333333333,1426
UNION ALL SELECT 'OAZJ','ZAJ','','ZARANJ','AFGHANISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OBBI','BAH','BAHRAIN INTERNATIONAL','BAHRAIN','BAHRAIN',26,16,15,'N',26.2708333333333,50,38,1,'E',50.6336111111111,6
UNION ALL SELECT 'ODAA','ADE','','ADEN','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ODAB','BHN','','BEIHAN','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ODAG','AAY','','AL GHAIDA','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ODAM','UKR','','MUKEIRAS','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ODAQ','IHN','','QISHAN','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ODAR','RIY','','RIYAN','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ODAT','AXK','','ATAQ','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ODHD','HOD','','HODEIDAH','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ODSN','SAH','','SANAA','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ODSQ','SCT','','SOCOTRA','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ODTZ','TAI','','TAIZ','YEMEN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OEAB','AHB','ABHA','ABHA','SAUDI ARABIA',18,14,24,'N',18.24,42,39,20,'E',42.6555555555556,6858
UNION ALL SELECT 'OEAH','LEA','AL AHSA','AL-AHSA','SAUDI ARABIA',25,17,3,'N',25.2841666666667,49,29,10,'E',49.4861111111111,588
UNION ALL SELECT 'OEBA','ABT','AL BAHA','EL-BAHA','SAUDI ARABIA',20,17,46,'N',20.2961111111111,41,38,3,'E',41.6341666666667,5486
UNION ALL SELECT 'OEBH','BHH','BISHA','BISHA','SAUDI ARABIA',19,59,2,'N',19.9838888888889,42,37,22,'E',42.6227777777778,3887
UNION ALL SELECT 'OEDF','DMM','KING FAHD INTERNATIONAL','DAMMAM','SAUDI ARABIA',26,28,16,'N',26.4711111111111,49,47,52,'E',49.7977777777778,72
UNION ALL SELECT 'OEDR','DHA','KING ABDULAZIZ AB','DHAHRAN','SAUDI ARABIA',26,15,55,'N',26.2652777777778,50,9,7,'E',50.1519444444444,84
UNION ALL SELECT 'OEGN','GIZ','JAZAN','GIZAN','SAUDI ARABIA',16,54,4,'N',16.9011111111111,42,35,9,'E',42.5858333333333,20
UNION ALL SELECT 'OEGS','ELQ','GASSIM','GASSIM','SAUDI ARABIA',26,18,10,'N',26.3027777777778,43,46,28,'E',43.7744444444444,2126
UNION ALL SELECT 'OEGT','URY','GURIAT','GURIAT','SAUDI ARABIA',31,24,39,'N',31.4108333333333,37,16,44,'E',37.2788888888889,1672
UNION ALL SELECT 'OEHL','HAS','HAIL','HAIL','SAUDI ARABIA',27,26,16,'N',27.4377777777778,41,41,10,'E',41.6861111111111,3331
UNION ALL SELECT 'OEJN','JED','KING ABDULAZIZ INTERNATIONAL','JEDDAH','SAUDI ARABIA',21,40,46,'N',21.6794444444444,39,9,23,'E',39.1563888888889,48
UNION ALL SELECT 'OEKK','HBT','KING KHALED MILITARY CITY','KING KHALID MIL.CITY','SAUDI ARABIA',27,54,3,'N',27.9008333333333,45,31,41,'E',45.5280555555556,1352
UNION ALL SELECT 'OEMA','MED','PRINCE MOHAMMAD BIN ABDULAZIZ','MADINAH','SAUDI ARABIA',24,33,12,'N',24.5533333333333,39,42,18,'E',39.705,2151
UNION ALL SELECT 'OENG','EAM','NEJRAN','NEJRAN','SAUDI ARABIA',17,36,41,'N',17.6113888888889,44,25,9,'E',44.4191666666667,3982
UNION ALL SELECT 'OEPA','AQI','QAISUMAH','HAFR AL-BATIN','SAUDI ARABIA',28,20,6,'N',28.335,46,7,30,'E',46.125,1174
UNION ALL SELECT 'OERF','RAH','RAFHA','RAFHA','SAUDI ARABIA',29,37,35,'N',29.6263888888889,43,29,26,'E',43.4905555555556,1474
UNION ALL SELECT 'OERK','RUH','KING KHALED INTERNATIONAL','RIYADH','SAUDI ARABIA',24,57,27,'N',24.9575,46,41,55,'E',46.6986111111111,2049
UNION ALL SELECT 'OERR','RAE','ARAR','ARAR','SAUDI ARABIA',30,54,26,'N',30.9072222222222,41,8,18,'E',41.1383333333333,1813
UNION ALL SELECT 'OESH','SHW','SHARURAH','SHARURAH','SAUDI ARABIA',17,28,0,'N',17.4666666666667,47,7,16,'E',47.1211111111111,2363
UNION ALL SELECT 'OESK','AJO','AL JOUF','AL-JOUF','SAUDI ARABIA',29,47,6,'N',29.785,40,6,0,'E',40.1,2261
UNION ALL SELECT 'OESL','SLF','SULAYEL','SULAYEL','SAUDI ARABIA',20,27,53,'N',20.4647222222222,45,37,10,'E',45.6194444444444,2021
UNION ALL SELECT 'OETB','TUU','TABUK','TABUK','SAUDI ARABIA',28,21,55,'N',28.3652777777778,36,37,8,'E',36.6188888888889,2551
UNION ALL SELECT 'OETF','TIF','TAIF','TAIF','SAUDI ARABIA',21,29,0,'N',21.4833333333333,40,32,39,'E',40.5441666666667,4848
UNION ALL SELECT 'OETR','TUI','TURAIF','TURAIF','SAUDI ARABIA',31,41,33,'N',31.6925,38,43,52,'E',38.7311111111111,2803
UNION ALL SELECT 'OEWJ','EJH','WEJH','WEJH','SAUDI ARABIA',26,11,51,'N',26.1975,36,28,34,'E',36.4761111111111,66
UNION ALL SELECT 'OEYN','YNB','YENBO','YENBO','SAUDI ARABIA',24,8,39,'N',24.1441666666667,38,3,48,'E',38.0633333333333,26
UNION ALL SELECT 'OIAA','ABD','ABADAN','ABADAN','IRAN',30,21,54,'N',30.365,48,13,59,'E',48.2330555555556,10
UNION ALL SELECT 'OIAI','QMJ','SHAHID ASYAEE','MASJED SOLEIMAN','IRAN',32,0,8,'N',32.0022222222222,49,16,14,'E',49.2705555555556,1187
UNION ALL SELECT 'OIAM','MRX','MAHSHAHR','BANDAR MAHSHAHR','IRAN',30,33,22,'N',30.5561111111111,49,9,6,'E',49.1516666666667,8
UNION ALL SELECT 'OIAW','AWZ','AHWAZ','AHWAZ','IRAN',31,20,14,'N',31.3372222222222,48,45,43,'E',48.7619444444444,64
UNION ALL SELECT 'OIBB','BUZ','BUSHEHR','BUSHEHR','IRAN',28,56,41,'N',28.9447222222222,50,50,4,'E',50.8344444444444,70
UNION ALL SELECT 'OIBK','KIH','KISH ISLAND','KISH ISLAND','IRAN',26,31,36,'N',26.5266666666667,53,58,54,'E',53.9816666666667,100
UNION ALL SELECT 'OIBL','BDH','BANDAR LENGEH','BANDAR LENGEH','IRAN',26,31,54,'N',26.5316666666667,54,49,18,'E',54.8216666666667,87
UNION ALL SELECT 'OICC','KSH','SHAHID ASHRAFI ESFAHANI','BAKHTARAN','IRAN',34,20,47,'N',34.3463888888889,47,9,23,'E',47.1563888888889,4307
UNION ALL SELECT 'OICS','SDG','SANANDAJ','SANANDAJ','IRAN',35,14,49,'N',35.2469444444444,47,0,25,'E',47.0069444444444,4618
UNION ALL SELECT 'OIGG','RAS','RASHT','RASHT','IRAN',37,19,31,'N',37.3252777777778,49,36,20,'E',49.6055555555556,40
UNION ALL SELECT 'OIII','THR','MEHRABAD INTERNATIONAL','TEHERAN','IRAN',35,41,21,'N',35.6891666666667,51,18,48,'E',51.3133333333333,3962
UNION ALL SELECT 'OIKB','BND','BANDAR ABBASS INTERNATIONAL','BANDAR ABBAS','IRAN',27,13,5,'N',27.2180555555556,56,22,40,'E',56.3777777777778,22
UNION ALL SELECT 'OIKK','KER','KERMAN','KERMAN','IRAN',30,15,40,'N',30.2611111111111,56,57,24,'E',56.9566666666667,5736
UNION ALL SELECT 'OIMB','XBJ','BIRJAND','BIRJAND','IRAN',32,53,44,'N',32.8955555555556,59,16,32,'E',59.2755555555556,5041
UNION ALL SELECT 'OINR','RZR','RAMSAR','RAMSAR','IRAN',36,54,35,'N',36.9097222222222,50,40,46,'E',50.6794444444444,75
UNION ALL SELECT 'OIRT','OMH','','UROMIYEH','IRAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OISS','SYZ','SHIRAZ SHAHID DASTGHAIB INTERNATIONAL','SHIRAZ','IRAN',29,32,21,'N',29.5391666666667,52,35,22,'E',52.5894444444444,4920
UNION ALL SELECT 'OITT','TBZ','TABRIZ INTERNATIONAL','TABRIZ','IRAN',38,7,58,'N',38.1327777777778,46,14,5,'E',46.2347222222222,4459
UNION ALL SELECT 'OIYY','AZD','YAZD SHAHID SADOOGHI','YAZD','IRAN',31,54,17,'N',31.9047222222222,54,16,35,'E',54.2763888888889,4055
UNION ALL SELECT 'OIZC','ZBR','CHAH BAHAR','CHAH BAHAR','IRAN',25,26,36,'N',25.4433333333333,60,22,55,'E',60.3819444444444,24
UNION ALL SELECT 'OIZH','ZAH','ZAHEDAN INTERNATIONAL','ZAHEDAN','IRAN',29,28,34,'N',29.4761111111111,60,54,21,'E',60.9058333333333,4520
UNION ALL SELECT 'OJAI','AMM','QUEEN ALIA INTERNATIONAL','AMMAN','JORDAN',31,43,21,'N',31.7225,35,59,35,'E',35.9930555555556,2395
UNION ALL SELECT 'OJAM','ADJ','MARKA INTERNATIONAL','AMMAN','JORDAN',31,58,21,'N',31.9725,35,59,29,'E',35.9913888888889,2555
UNION ALL SELECT 'OJAQ','AQJ','AQABA INTERNATIONAL','AQABA','JORDAN',29,36,41,'N',29.6113888888889,35,1,5,'E',35.0180555555556,175
UNION ALL SELECT 'OJMF','OMF','KING HUSSEIN','MAFRAQ','JORDAN',32,21,22,'N',32.3561111111111,36,15,33,'E',36.2591666666667,2240
UNION ALL SELECT 'OKBK','KWI','KUWAIT INTERNATIONAL','KUWAIT','KUWAIT',29,13,36,'N',29.2266666666667,47,58,48,'E',47.98,206
UNION ALL SELECT 'OLBA','BEY','BEIRUT INTERNATIONAL','BEIRUT','LEBANON',33,48,48,'N',33.8133333333333,35,29,19,'E',35.4886111111111,87
UNION ALL SELECT 'OMAA','AUH','ABU DHABI INTERNATIONAL','ABU DHABI','UNITED ARAB EMIRATES',24,25,58,'N',24.4327777777778,54,39,4,'E',54.6511111111111,88
UNION ALL SELECT 'OMAD','AZI','BATEEN','ABU DHABI','UNITED ARAB EMIRATES',24,25,42,'N',24.4283333333333,54,27,29,'E',54.4580555555556,16
UNION ALL SELECT 'OMDB','DXB','DUBAI INTERNATIONAL','DUBAI','UNITED ARAB EMIRATES',25,15,17,'N',25.2547222222222,55,21,51,'E',55.3641666666667,34
UNION ALL SELECT 'OMFJ','FJR','FUJAIRAH INTERNATIONAL','FUJEIRAH','UNITED ARAB EMIRATES',25,6,44,'N',25.1122222222222,56,19,26,'E',56.3238888888889,152
UNION ALL SELECT 'OMRK','RKT','RAS AL KHAIMAH INTERNATIONAL','RAS AL KHAIMAH','UNITED ARAB EMIRATES',25,36,48,'N',25.6133333333333,55,56,19,'E',55.9386111111111,102
UNION ALL SELECT 'OMSJ','SHJ','SHARJAH INTERNATIONAL','SHARJAH','UNITED ARAB EMIRATES',25,19,42,'N',25.3283333333333,55,31,1,'E',55.5169444444444,111
UNION ALL SELECT 'OOKB','KHS','KHASAB','KHASAB','OMAN',26,10,16,'N',26.1711111111111,56,14,26,'E',56.2405555555556,100
UNION ALL SELECT 'OOMA','MSH','MASIRAH','MASIRAH','OMAN',20,40,31,'N',20.6752777777778,58,53,25,'E',58.8902777777778,64
UNION ALL SELECT 'OOMS','MCT','SEEB INTERNATIONAL','MUSCAT','OMAN',23,35,35,'N',23.5930555555556,58,17,4,'E',58.2844444444444,48
UNION ALL SELECT 'OOSA','SLL','SALALAH','SALALAH','OMAN',17,2,19,'N',17.0386111111111,54,5,28,'E',54.0911111111111,73
UNION ALL SELECT 'OOSR','SUH','','SUR','OMAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OOTH','TTH','THUMRAIT','THUMRAIT','OMAN',17,39,57,'N',17.6658333333333,54,1,28,'E',54.0244444444444,1570
UNION ALL SELECT 'OPFA','LYP','FAISALABAD INTERNATIONAL','FAISALABAD','PAKISTAN',31,21,54,'N',31.365,72,59,43,'E',72.9952777777778,591
UNION ALL SELECT 'OPGD','GWD','GWADAR','GWADAR','PAKISTAN',25,13,59,'N',25.2330555555556,62,19,46,'E',62.3294444444444,96
UNION ALL SELECT 'OPGT','GIL','GILGIT','GILGIT','PAKISTAN',35,55,7,'N',35.9186111111111,74,20,1,'E',74.3336111111111,4781
UNION ALL SELECT 'OPKC','KHI','JINNAH INTERNATIONAL','KARACHI','PAKISTAN',24,54,23,'N',24.9063888888889,67,9,38,'E',67.1605555555556,100
UNION ALL SELECT 'OPKD','HDD','HYDERABAD','HYDERABAD','PAKISTAN',25,19,5,'N',25.3180555555556,68,21,58,'E',68.3661111111111,130
UNION ALL SELECT 'OPKT','OHT','','KOHAT','PAKISTAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'OPLA','LHE','ALLAMA IQBAL INTERNATIONAL','LAHORE','PAKISTAN',31,31,17,'N',31.5213888888889,74,24,12,'E',74.4033333333333,712
UNION ALL SELECT 'OPMF','MFG','MUZAFFARABAD','MUZAFFARABAD','PAKISTAN',34,20,18,'N',34.3383333333333,73,30,30,'E',73.5083333333333,2725
UNION ALL SELECT 'OPMJ','MJD','MOENJODARO','MOENJODARO','PAKISTAN',27,20,6,'N',27.335,68,8,34,'E',68.1427777777778,154
UNION ALL SELECT 'OPMT','MUX','MULTAN INTERNATIONAL','MULTAN','PAKISTAN',30,12,11,'N',30.2030555555556,71,25,8,'E',71.4188888888889,403
UNION ALL SELECT 'OPNH','WNS','NAWABSHAH','NAWABSHAH','PAKISTAN',26,13,9,'N',26.2191666666667,68,23,24,'E',68.39,95
UNION ALL SELECT 'OPOR','ORW','ORMARA','ORMARA','PAKISTAN',25,16,23,'N',25.2730555555556,64,35,18,'E',64.5883333333333,62
UNION ALL SELECT 'OPPG','PJG','PANJGUR','PANJGUR','PAKISTAN',26,57,16,'N',26.9544444444444,64,7,57,'E',64.1325,3289
UNION ALL SELECT 'OPPI','PSI','PASNI','PASNI','PAKISTAN',25,17,1,'N',25.2836111111111,63,19,58,'E',63.3327777777778,33
UNION ALL SELECT 'OPPS','PEW','PESHAWAR','PESHAWAR','PAKISTAN',33,59,38,'N',33.9938888888889,71,30,52,'E',71.5144444444445,1211
UNION ALL SELECT 'OPQT','UET','QUETTA','QUETTA','PAKISTAN',30,15,4,'N',30.2511111111111,66,56,15,'E',66.9375,5267
UNION ALL SELECT 'OPRK','RYK','SHAIKH ZAYED','RAHIM YAR KHAN','PAKISTAN',28,23,7,'N',28.3852777777778,70,16,47,'E',70.2797222222222,271
UNION ALL SELECT 'OPRN','ISB','CHAKLALA','ISLAMABAD','PAKISTAN',33,36,59,'N',33.6163888888889,73,5,57,'E',73.0991666666667,1666
UNION ALL SELECT 'OPRT','RAZ','RAWALAKOT','RAWALA KOT','PAKISTAN',33,50,57,'N',33.8491666666667,73,47,52,'E',73.7977777777778,5500
UNION ALL SELECT 'OPSK','SKZ','SUKKUR','SUKKUR','PAKISTAN',27,43,19,'N',27.7219444444444,68,47,30,'E',68.7916666666667,196
UNION ALL SELECT 'OPSS','SDT','SAIDU SHARIF','SAIDU SHARIF','PAKISTAN',34,48,47,'N',34.8130555555556,72,21,7,'E',72.3519444444444,3183
UNION ALL SELECT 'OPSU','SUL','SUI','SUI','PAKISTAN',28,38,42,'N',28.645,69,10,36,'E',69.1766666666667,76
UNION ALL SELECT 'OPTH','BDN','TALHAR','TALHAR','PAKISTAN',24,50,29,'N',24.8413888888889,68,50,18,'E',68.8383333333333,50
UNION ALL SELECT 'OPTU','TRB','TURBAT INTERNATIONAL','TURBO','COLOMBIA',25,59,10,'N',25.9861111111111,63,1,48,'E',63.03,498
UNION ALL SELECT 'OPZB','PZH','ZHOB','ZHOB','PAKISTAN',31,21,30,'N',31.3583333333333,69,27,48,'E',69.4633333333333,4650
UNION ALL SELECT 'ORBS','SDA','SADDAM INTERNATIONAL','BAGHDAD','IRAQ',33,15,43,'N',33.2619444444444,44,14,2,'E',44.2338888888889,113
UNION ALL SELECT 'ORMM','BSR','BASRAH INTERNATIONAL','BASRAH','IRAQ',30,32,55,'N',30.5486111111111,47,39,44,'E',47.6622222222222,11
UNION ALL SELECT 'OSAP','ALP','ALEPPO INTERNATIONAL','ALEPPO','SYRIA',36,10,50,'N',36.1805555555556,37,13,27,'E',37.2241666666667,1276
UNION ALL SELECT 'OSDI','DAM','DAMASCUS INTERNATIONAL','DAMASCUS','SYRIA',33,24,41,'N',33.4113888888889,36,30,56,'E',36.5155555555556,2020
UNION ALL SELECT 'OSDZ','DEZ','DEIR ZZOR','DEIRE ZOR','SYRIA',35,17,7,'N',35.2852777777778,40,10,33,'E',40.1758333333333,700
UNION ALL SELECT 'OSLK','LTK','BASSEL AL ASSAD INTERNATIONAL','LATAKIA','SYRIA',35,24,3,'N',35.4008333333333,35,56,55,'E',35.9486111111111,157
UNION ALL SELECT 'OSPR','PMS','PALMYRA','PALMYRA','SYRIA',34,33,26,'N',34.5572222222222,38,19,0,'E',38.3166666666667,1322
UNION ALL SELECT 'OTBD','DOH','DOHA INTERNATIONAL','DOHA','QATAR',25,15,40,'N',25.2611111111111,51,33,54,'E',51.565,35
UNION ALL SELECT 'PAAQ','PAQ','PALMER MUNI','PALMER','USA',61,35,41,'N',61.5947222222222,149,5,19,'U',0,248
UNION ALL SELECT 'PABA','BTI','BARTER ISLAND LRRS','BARTER ISLAND','USA',70,8,2,'N',70.1338888888889,143,34,37,'U',0,5
UNION ALL SELECT 'PABE','BET','BETHEL','BETHEL','USA',60,46,47,'N',60.7797222222222,161,50,16,'U',0,123
UNION ALL SELECT 'PABH','N/A','','BETHEL','USA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'PABI','BIG','ALLEN AAF','DELTA JUNCTION','USA',63,59,40,'N',63.9944444444444,145,43,17,'U',0,1277
UNION ALL SELECT 'PABR','BRW','WILEY POST WILL ROGERS MEM','BARROW','USA',71,17,7,'N',71.2852777777778,156,45,57,'U',0,44
UNION ALL SELECT 'PABT','BTT','BETTLES','BETTLES','USA',66,54,55,'N',66.9152777777778,151,31,41,'U',0,643
UNION ALL SELECT 'PACD','CDB','COLD BAY','COLD BAY','USA',55,12,20,'N',55.2055555555556,162,43,27,'U',0,98
UNION ALL SELECT 'PACV','CDV','MERLE K MUDHOLE SMITH','CORDOVA','USA',60,29,30,'N',60.4916666666667,145,28,39,'U',0,42
UNION ALL SELECT 'PADK','ADK','ADAK','ADAK ISLAND','USA',51,52,40,'N',51.8777777777778,176,38,45,'U',0,20
UNION ALL SELECT 'PADL','DLG','DILLINGHAM','DILLINGHAM','USA',59,2,43,'N',59.0452777777778,158,30,12,'U',0,86
UNION ALL SELECT 'PADQ','ADQ','KODIAK','KODIAK','USA',57,45,0,'N',57.75,152,29,37,'U',0,73
UNION ALL SELECT 'PADU','DUT','UNALASKA','UNALASKA','USA',53,54,0,'N',53.9,166,32,36,'U',0,22
UNION ALL SELECT 'PAED','EDF','ELMENDORF AFB','ANCHORAGE','USA',61,15,4,'N',61.2511111111111,149,48,23,'U',0,213
UNION ALL SELECT 'PAEH','EHM','CAPE NEWENHAM LRRS','CAPE NEWENHAM','USA',58,38,50,'N',58.6472222222222,162,3,38,'U',0,541
UNION ALL SELECT 'PAEI','EIL','EIELSON AFB','FAIRBANKS','USA',64,39,56,'N',64.6655555555556,147,6,5,'U',0,548
UNION ALL SELECT 'PAEN','ENA','KENAI MUNI','KENAI','USA',60,34,23,'N',60.5730555555556,151,14,42,'U',0,99
UNION ALL SELECT 'PAFA','FAI','FAIRBANKS INTERNATIONAL','FAIRBANKS','USA',64,48,54,'N',64.815,147,51,22,'U',0,434
UNION ALL SELECT 'PAFB','FBK','WAINWRIGHT AAF','FORT WAINWRIGHT','USA',64,50,15,'N',64.8375,147,36,52,'U',0,454
UNION ALL SELECT 'PAGA','GAL','EDWARD G PITKA SR','GALENA','USA',64,44,10,'N',64.7361111111111,156,56,14,'U',0,152
UNION ALL SELECT 'PAGK','GKN','GULKANA','GULKANA','USA',62,9,17,'N',62.1547222222222,145,27,23,'U',0,1579
UNION ALL SELECT 'PAGY','SGY','SKAGWAY','SKAGWAY','USA',59,27,36,'N',59.46,135,18,56,'U',0,44
UNION ALL SELECT 'PAHO','HOM','HOMER','HOMER','USA',59,38,44,'N',59.6455555555556,151,28,35,'U',0,84
UNION ALL SELECT 'PAIL','ILI','ILIAMNA','ILIAMNA','USA',59,45,13,'N',59.7536111111111,154,54,39,'U',0,186
UNION ALL SELECT 'PAIM','UTO','INDIAN MOUNTAIN LRRS','INDIAN MOUNTAINS','USA',65,59,34,'N',65.9927777777778,153,42,15,'U',0,1220
UNION ALL SELECT 'PAJN','JNU','JUNEAU INTERNATIONAL','JUNEAU','USA',58,21,17,'N',58.3547222222222,134,34,34,'U',0,19
UNION ALL SELECT 'PAKN','AKN','KING SALMON','KING SALMON','USA',58,40,36,'N',58.6766666666667,156,38,57,'U',0,57
UNION ALL SELECT 'PAKT','KTN','KETCHIKAN INTERNATIONAL','KETCHIKAN','USA',55,21,20,'N',55.3555555555556,131,42,49,'U',0,97
UNION ALL SELECT 'PALU','LUR','CAPE LISBURNE LRRS','CAPE LISBURNE','USA',68,52,30,'N',68.875,166,6,36,'U',0,12
UNION ALL SELECT 'PAMC','MCG','MC GRATH','MCGRATH','USA',62,57,10,'N',62.9527777777778,155,36,20,'U',0,337
UNION ALL SELECT 'PAMR','MRI','MERRILL FLD','ANCHORAGE','USA',61,12,51,'N',61.2141666666667,149,50,46,'U',0,137
UNION ALL SELECT 'PANC','ANC','TED STEVENS ANCHORAGE INTERNATIONAL','ANCHORAGE','USA',61,10,27,'N',61.1741666666667,149,59,46,'U',0,152
UNION ALL SELECT 'PANT','ANN','ANNETTE ISLAND','ANNETTE ISLAND','USA',55,2,32,'N',55.0422222222222,131,34,20,'U',0,119
UNION ALL SELECT 'PAOM','OME','NOME','NOME','USA',64,30,43,'N',64.5119444444444,165,26,42,'U',0,37
UNION ALL SELECT 'PAOR','ORT','NORTHWAY','NORTHWAY','USA',62,57,40,'N',62.9611111111111,141,55,44,'U',0,1716
UNION ALL SELECT 'PAOT','OTZ','RALPH WIEN MEM','KOTZEBUE','USA',66,53,4,'N',66.8844444444445,162,35,54,'U',0,11
UNION ALL SELECT 'PAPM','PML','PLATINUM','PORT MOLLER','USA',59,0,40,'N',59.0111111111111,161,49,10,'U',0,15
UNION ALL SELECT 'PASC','SCC','DEADHORSE','DEADHORSE','USA',70,11,41,'N',70.1947222222222,148,27,54,'U',0,61
UNION ALL SELECT 'PASI','SIT','SITKA ROCKY GUTIERREZ','SITKA','USA',57,2,49,'N',57.0469444444444,135,21,41,'U',0,26
UNION ALL SELECT 'PASN','SNP','ST PAUL ISLAND','ST. PAUL ISLAND','USA',57,10,2,'N',57.1672222222222,170,13,13,'U',0,63
UNION ALL SELECT 'PASV','SVW','SPARREVOHN LRRS','SPARREVOHN','USA',61,5,50,'N',61.0972222222222,155,34,27,'U',0,1585
UNION ALL SELECT 'PASY','SYA','EARECKSON AS','SHEMYA','USA',52,42,44,'N',52.7122222222222,174,6,49,'E',174.113611111111,97
UNION ALL SELECT 'PATA','TAL','RALPH M CALHOUN','TANANA','USA',65,10,27,'N',65.1741666666667,152,6,33,'U',0,227
UNION ALL SELECT 'PATC','TNC','TIN CITY LRRS','TIN CITY','USA',65,33,47,'N',65.5630555555556,167,55,20,'U',0,271
UNION ALL SELECT 'PATK','TKA','TALKEETNA','TALKEETNA','USA',62,19,13,'N',62.3202777777778,150,5,37,'U',0,358
UNION ALL SELECT 'PATL','TLJ','TATALINA LRRS','TATALINA','USA',62,53,39,'N',62.8941666666667,155,58,35,'U',0,964
UNION ALL SELECT 'PAUN','UNK','UNALAKLEET','UNALAKLEET','USA',63,53,18,'N',63.8883333333333,160,47,56,'U',0,21
UNION ALL SELECT 'PAVD','VDZ','VALDEZ PIONEER FIELD','VALDEZ','USA',61,8,2,'N',61.1338888888889,146,14,54,'U',0,120
UNION ALL SELECT 'PAWT','AIN','WAINWRIGHT AS','FORT WAINWRIGHT','USA',70,36,48,'N',70.6133333333333,159,51,37,'U',0,35
UNION ALL SELECT 'PAYA','YAK','YAKUTAT','YAKUTAT','USA',59,30,11,'N',59.5030555555556,139,39,36,'U',0,38
UNION ALL SELECT 'PCIS','CIS','CANTON ISLAND AIRPORT','CANTON ISLAND','PHOENIX ISL.',2,46,0,'S',-2.76666666666667,0,0,0,'U',0,0
UNION ALL SELECT 'PFYU','FYU','FORT YUKON','FORT YUKON','USA',66,34,17,'N',66.5713888888889,145,15,1,'U',0,433
UNION ALL SELECT 'PGRO','ROP','ROTA INTERNATIONAL','ROTA','MARIANA ISLANDS',14,10,28,'N',14.1744444444444,145,14,36,'E',145.243333333333,607
UNION ALL SELECT 'PGSN','SPN','SAIPAN INTERNATIONAL','SAIPAN','MARIANA ISLANDS',15,7,10,'N',15.1194444444444,145,43,45,'E',145.729166666667,215
UNION ALL SELECT 'PGUA','UAM','ANDERSEN AFB','ANDERSEN','MARIANA ISLANDS',13,35,2,'N',13.5838888888889,144,55,48,'E',144.93,627
UNION ALL SELECT 'PGUM','GUM','GUAM INTERNATIONAL','AGANA','MARIANA ISLANDS',13,29,2,'N',13.4838888888889,144,47,49,'E',144.796944444444,298
UNION ALL SELECT 'PGWT','TNI','WEST TINIAN','WEST TINIAN','MARIANA ISLANDS',14,59,52,'N',14.9977777777778,145,37,9,'E',145.619166666667,268
UNION ALL SELECT 'PHBK','BKH','BARKING SANDS PMRF','BARKING SANDS','USA  KAUAI ISL.',22,1,18,'N',22.0216666666667,159,47,12,'U',0,16
UNION ALL SELECT 'PHDH','HDH','DILLINGHAM','DILLINGHAM','USA  OAHU ISL.',21,34,45,'N',21.5791666666667,158,12,37,'U',0,14
UNION ALL SELECT 'PHHN','HNM','HANA','HANA','USA  MAUI ISL.',20,47,44,'N',20.7955555555556,156,0,51,'U',0,78
UNION ALL SELECT 'PHJH','JHM','KAPALUA','LAHANIA-KAPALUA','USA  MAUI ISL.',20,57,46,'N',20.9627777777778,156,40,27,'U',0,256
UNION ALL SELECT 'PHKO','KOA','KONA INTERNATIONAL AT KEAHOLE','KONA','USA  HAWAII ISL.',19,44,19,'N',19.7386111111111,156,2,44,'U',0,47
UNION ALL SELECT 'PHLI','LIH','LIHUE','LIHUE','USA  KAUAI ISL.',21,58,34,'N',21.9761111111111,159,20,19,'U',0,153
UNION ALL SELECT 'PHMK','MKK','MOLOKAI','MOLOKAI','USA  MOLOKAI ISL.',21,9,10,'N',21.1527777777778,157,5,46,'U',0,454
UNION ALL SELECT 'PHMU','MUE','WAIMEA KOHALA','KAMUELA','USA  HAWAII ISL.',20,0,4,'N',20.0011111111111,155,40,5,'U',0,2671
UNION ALL SELECT 'PHNG','NGF','KANEOHE BAY MCAF','KANEOHE BAY','USA  OAHU ISL.',21,26,57,'N',21.4491666666667,157,46,4,'U',0,17
UNION ALL SELECT 'PHNL','HNL','HONOLULU INTERNATIONAL','HONOLULU','USA  OAHU ISL.',21,18,57,'N',21.3158333333333,157,55,36,'U',0,13
UNION ALL SELECT 'PHNY','LNY','LANAI','LANAI','USA  LANAI ISL.',20,47,8,'N',20.7855555555556,156,57,5,'U',0,1308
UNION ALL SELECT 'PHOG','OGG','KAHULUI','KAHULUI','USA  MAUI ISL.',20,53,55,'N',20.8986111111111,156,25,50,'U',0,54
UNION ALL SELECT 'PHSF','BSF','BRADSHAW AAF','BRADSHAW FIELD','USA  HAWAII ISL.',19,45,36,'N',19.76,155,33,13,'U',0,6190
UNION ALL SELECT 'PHTO','ITO','HILO INTERNATIONAL','HILO','USA  HAWAII ISL.',19,43,13,'N',19.7202777777778,155,2,55,'U',0,38
UNION ALL SELECT 'PHUP','UPP','UPOLU','OPOLU','USA',20,15,54,'N',20.265,155,51,35,'U',0,96
UNION ALL SELECT 'PJON','JON','JOHNSTON ATOLL','JOHNSTON ISLAND','JOHNSTON ATOLL',16,43,43,'N',16.7286111111111,169,32,3,'U',0,7
UNION ALL SELECT 'PKMA','1Z8','ENEWETAK AUX AF','ENIWETOK ISLAND','MARSHALL ISLANDS',11,20,27,'N',11.3408333333333,162,19,40,'E',162.327777777778,13
UNION ALL SELECT 'PKMJ','MAJ','MARSHALL ISLANDS INTERNATIONAL','MAJURO','MARSHALL ISLANDS',7,3,53,'N',7.06472222222222,171,16,19,'E',171.271944444444,6
UNION ALL SELECT 'PKWA','KWA','BUCHOLZ AAF','KWAJALEIN','MARSHALL ISLANDS',8,43,12,'N',8.72,167,43,53,'E',167.731388888889,9
UNION ALL SELECT 'PLCH','CXI','CHRISTMAS ISLAND','KIRITIMATI','KIRIBATI',1,59,10,'N',1.98611111111111,157,20,59,'U',0,5
UNION ALL SELECT 'PMDY','MDY','MIDWAY ATOLL','MIDWAY','MIDWAY ISLAND',28,12,5,'N',28.2013888888889,177,22,53,'U',0,13
UNION ALL SELECT 'POLI','OLI','OLIKTOK LRRS','OLIKTOK POINT','USA',70,29,58,'N',70.4994444444444,149,52,46,'U',0,16
UNION ALL SELECT 'PPIZ','PIZ','POINT LAY LRRS','POINT LAY','USA',69,43,58,'N',69.7327777777778,163,0,19,'U',0,25
UNION ALL SELECT 'PTKK','TKK','CHUUK INTERNATIONAL','CHUUK','MICRONESIA',7,27,42,'N',7.46166666666667,151,50,34,'E',151.842777777778,11
UNION ALL SELECT 'PTPN','PNI','POHNPEI INTERNATIONAL','POHNPEI','MICRONESIA',6,59,6,'N',6.985,158,12,32,'E',158.208888888889,10
UNION ALL SELECT 'PTRO','ROR','BABELTHUAP','BABELTHUAP','PALAU ISLAND',7,22,3,'N',7.3675,134,32,38,'E',134.543888888889,176
UNION ALL SELECT 'PTSA','KSA','KOSRAE','KOSRAE','MICRONESIA',5,21,24,'N',5.35666666666667,162,57,30,'E',162.958333333333,11
UNION ALL SELECT 'PTYA','YAP','YAP INTERNATIONAL','YAP','MICRONESIA',9,29,55,'N',9.49861111111111,138,4,56,'E',138.082222222222,91
UNION ALL SELECT 'RCBS','KNH','SHANG YI','CHINMEN','TAIWAN',24,25,55,'N',24.4319444444444,118,21,34,'E',118.359444444444,93
UNION ALL SELECT 'RCCM','CMJ','','CHIMEI','TAIWAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RCDC','PIF','PINGTUNG SOUTH','PINGTUNG','TAIWAN',22,40,20,'N',22.6722222222222,120,27,42,'E',120.461666666667,78
UNION ALL SELECT 'RCDI','N/A','LUNGTANG','LONGTANG','TAIWAN',24,51,18,'N',24.855,121,14,15,'E',121.2375,792
UNION ALL SELECT 'RCFN','TTT','FENGNIN','FENGNIN','TAIWAN',22,45,24,'N',22.7566666666667,121,5,36,'E',121.093333333333,143
UNION ALL SELECT 'RCGI','GNI','GREEN ISLAND','GREEN ISLAND','TAIWAN',22,40,28,'N',22.6744444444444,121,27,30,'E',121.458333333333,27
UNION ALL SELECT 'RCKH','KHH','KAOHSIUNG INTERNATIONAL','KAOHSIUNG','TAIWAN',22,34,31,'N',22.5752777777778,120,21,3,'E',120.350833333333,31
UNION ALL SELECT 'RCKU','CYI','CHIAYI','CHIAYI','TAIWAN',23,27,42,'N',23.4616666666667,120,23,34,'E',120.392777777778,85
UNION ALL SELECT 'RCLG','TXG','TAICHUNG','CHUNG','TAIWAN',24,11,10,'N',24.1861111111111,120,39,13,'E',120.653611111111,369
UNION ALL SELECT 'RCLY','KYD','LANYU','LANYU','TAIWAN',22,1,46,'N',22.0294444444444,121,31,38,'E',121.527222222222,4
UNION ALL SELECT 'RCMT','MZW','MATSU','MATSU','TAIWAN',26,13,26,'N',26.2238888888889,120,0,9,'E',120.0025,41
UNION ALL SELECT 'RCNN','TNN','TAINAN','TAINAN','TAIWAN',22,57,1,'N',22.9502777777778,120,12,20,'E',120.205555555556,63
UNION ALL SELECT 'RCQC','MZG','MAKUNG','MAKUNG','TAIWAN',23,34,7,'N',23.5686111111111,119,37,41,'E',119.628055555556,103
UNION ALL SELECT 'RCSS','TSA','SUNGSHAN','TAIPEI','TAIWAN',25,4,10,'N',25.0694444444444,121,33,6,'E',121.551666666667,18
UNION ALL SELECT 'RCTP','TPE','CHIANG KAI SHEK INTERNATIONAL','TAIPEI','TAIWAN',25,4,48,'N',25.08,121,13,56,'E',121.232222222222,107
UNION ALL SELECT 'RCWA','WOT','WANG AN','WANG AN','TAIWAN',23,22,15,'N',23.3708333333333,119,29,40,'E',119.494444444444,12
UNION ALL SELECT 'RCYU','HUN','HUALIEN','HUALIEN','TAIWAN',24,1,23,'N',24.0230555555556,121,37,4,'E',121.617777777778,52
UNION ALL SELECT 'RJAA','NRT','NEW TOKYO INTERNATIONAL','TOKYO','JAPAN',35,45,53,'N',35.7647222222222,140,23,11,'E',140.386388888889,141
UNION ALL SELECT 'RJAF','MMJ','MATSUMOTO','MATSUMOTO','JAPAN',36,10,0,'N',36.1666666666667,137,55,22,'E',137.922777777778,2182
UNION ALL SELECT 'RJAN','KIJ','','NIGATA','JAPAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RJAW','IWO','IWO JIMA','IWOJIMA','JAPAN',24,47,2,'N',24.7838888888889,141,19,21,'E',141.3225,378
UNION ALL SELECT 'RJBD','SHM','NANKI SHIRAHAMA','NANKI-SHIRAHAMA','JAPAN',33,39,44,'N',33.6622222222222,135,21,52,'E',135.364444444444,298
UNION ALL SELECT 'RJCB','OBO','OBIHIRO','OBIHIRO','JAPAN',42,44,0,'N',42.7333333333333,143,13,2,'E',143.217222222222,505
UNION ALL SELECT 'RJCC','CTS','CHITOSE INTERNATIONAL AIRPORT','SAPPORO','JAPAN',42,46,30,'N',42.775,141,41,32,'E',141.692222222222,82
UNION ALL SELECT 'RJCH','HKD','HAKODATE','HAKODATE','JAPAN',41,46,12,'N',41.77,140,49,19,'E',140.821944444444,151
UNION ALL SELECT 'RJCJ','SPK','CHITOSE','CHITOSE','JAPAN',42,47,40,'N',42.7944444444444,141,39,59,'E',141.666388888889,87
UNION ALL SELECT 'RJCM','MMB','MEMANBETSU','MEMANBETSU','JAPAN',43,52,50,'N',43.8805555555556,144,9,50,'E',144.163888888889,135
UNION ALL SELECT 'RJCN','SHB','NAKASHIBETSU','NAKASHIBETSU','JAPAN',43,34,38,'N',43.5772222222222,144,57,35,'E',144.959722222222,234
UNION ALL SELECT 'RJCO','SPK','SAPPORO','SAPPORO','JAPAN',43,6,58,'N',43.1161111111111,141,22,48,'E',141.38,25
UNION ALL SELECT 'RJCR','RBJ','','REBUN','JAPAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RJCS','KUH','','KUSHIRO','JAPAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RJCW','WKJ','WAKKANAI','WAKKANAI','JAPAN',45,24,14,'N',45.4038888888889,141,48,3,'E',141.800833333333,30
UNION ALL SELECT 'RJDB','IKI','IKI','IKI','JAPAN',33,44,56,'N',33.7488888888889,129,47,7,'E',129.785277777778,52
UNION ALL SELECT 'RJDC','UBJ','YAMAGUCHI UBE','YAMAGUCHI','JAPAN',33,55,48,'N',33.93,131,16,44,'E',131.278888888889,23
UNION ALL SELECT 'RJDT','TSJ','TSUSHIMA','TSUSHIMA','JAPAN',34,17,5,'N',34.2847222222222,129,19,49,'E',129.330277777778,213
UNION ALL SELECT 'RJEB','MBE','MONBETSU','MONBETSU','JAPAN',44,18,14,'N',44.3038888888889,143,24,14,'E',143.403888888889,80
UNION ALL SELECT 'RJEC','AKJ','ASAHIKAWA','ASAHIKAWA','JAPAN',43,40,15,'N',43.6708333333333,142,26,51,'E',142.4475,721
UNION ALL SELECT 'RJEO','OIR','','OKUSHIRI','JAPAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RJER','RIS','RISHIRI','RISHIRI ISLAND','JAPAN',45,14,31,'N',45.2419444444444,141,11,11,'E',141.186388888889,112
UNION ALL SELECT 'RJFC','KUM','YAKUSHIMA','YAKUSHIMA','JAPAN',30,23,8,'N',30.3855555555556,130,39,32,'E',130.658888888889,123
UNION ALL SELECT 'RJFE','FUJ','FUKUE','FUKUE','JAPAN',32,39,58,'N',32.6661111111111,128,49,58,'E',128.832777777778,273
UNION ALL SELECT 'RJFF','FUK','FUKUOKA','FUKUOKA','JAPAN',33,35,11,'N',33.5863888888889,130,27,0,'E',130.45,32
UNION ALL SELECT 'RJFG','TNE','TANEGASHIMA','TANEGASHIMA','JAPAN',30,32,48,'N',30.5466666666667,130,57,0,'E',130.95,319
UNION ALL SELECT 'RJFK','KOJ','KAGOSHIMA','KAGOSHIMA','JAPAN',31,48,12,'N',31.8033333333333,130,43,9,'E',130.719166666667,906
UNION ALL SELECT 'RJFM','KMI','MIYAZAKI','MIYAZAKI','JAPAN',31,52,37,'N',31.8769444444444,131,26,54,'E',131.448333333333,20
UNION ALL SELECT 'RJFO','OIT','OITA','OITA','JAPAN',33,28,46,'N',33.4794444444444,131,44,14,'E',131.737222222222,19
UNION ALL SELECT 'RJFR','KKJ','KITAKYUSHU','KITAKYUSHU','JAPAN',33,50,10,'N',33.8361111111111,130,56,49,'E',130.946944444444,18
UNION ALL SELECT 'RJFT','KMJ','KUMAMOTO','KUMAMOTO','JAPAN',32,50,14,'N',32.8372222222222,130,51,18,'E',130.855,642
UNION ALL SELECT 'RJFU','NGS','NAGASAKI','NAGASAKI','JAPAN',32,55,21,'N',32.9225,129,55,24,'E',129.923333333333,15
UNION ALL SELECT 'RJKA','ASJ','AMAMI','AMAMI','JAPAN',28,25,50,'N',28.4305555555556,129,42,45,'E',129.7125,27
UNION ALL SELECT 'RJKN','TKN','TOKUNOSHIMA','TOKUNOSHIMA','JAPAN',27,50,10,'N',27.8361111111111,128,52,52,'E',128.881111111111,17
UNION ALL SELECT 'RJNK','KMQ','KOMATSU','KANAZAWA','JAPAN',36,23,37,'N',36.3936111111111,136,24,28,'E',136.407777777778,36
UNION ALL SELECT 'RJNN','NGO','NAGOYA','NAGOYA','JAPAN',35,15,18,'N',35.255,136,55,28,'E',136.924444444444,52
UNION ALL SELECT 'RJNO','OKI','OKI','OKI ISLAND','JAPAN',36,10,52,'N',36.1811111111111,133,19,29,'E',133.324722222222,311
UNION ALL SELECT 'RJNT','TOY','TOYAMA','TOYAMA','JAPAN',36,38,54,'N',36.6483333333333,137,11,14,'E',137.187222222222,95
UNION ALL SELECT 'RJOA','HIJ','HIROSHIMA','HIROSHIMA','JAPAN',34,26,7,'N',34.4352777777778,132,55,19,'E',132.921944444444,1088
UNION ALL SELECT 'RJOB','OKJ','OKAYAMA','OKAYAMA','JAPAN',34,45,25,'N',34.7569444444444,133,51,20,'E',133.855555555556,806
UNION ALL SELECT 'RJOC','IZO','IZUMO','IZUMO','JAPAN',35,24,49,'N',35.4136111111111,132,53,24,'E',132.89,15
UNION ALL SELECT 'RJOH','YGJ','MIHO','MIHO','JAPAN',35,29,32,'N',35.4922222222222,133,14,11,'E',133.236388888889,20
UNION ALL SELECT 'RJOK','KCZ','KOCHI','KOCHI','JAPAN',33,32,40,'N',33.5444444444444,133,40,17,'E',133.671388888889,31
UNION ALL SELECT 'RJOM','MYJ','MATSUYAMA','MATSUYAMA','JAPAN',33,49,38,'N',33.8272222222222,132,41,59,'E',132.699722222222,25
UNION ALL SELECT 'RJOO','ITM','OSAKA INTERNATIONAL','OSAKA','JAPAN',34,47,7,'N',34.7852777777778,135,26,17,'E',135.438055555556,50
UNION ALL SELECT 'RJOP','KMQ','','KOMATSUJIMA','JAPAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RJOR','TTJ','TOTTORI','TOTTORI','JAPAN',35,31,48,'N',35.53,134,9,59,'E',134.166388888889,65
UNION ALL SELECT 'RJOS','TKS','TOKUSHIMA','TOKUSHIMA','JAPAN',34,7,58,'N',34.1327777777778,134,36,23,'E',134.606388888889,26
UNION ALL SELECT 'RJOT','TAK','TAKAMATSU','TAKAMATSU','JAPAN',34,12,50,'N',34.2138888888889,134,0,56,'E',134.015555555556,607
UNION ALL SELECT 'RJSA','AOJ','AOMORI','AOMORI','JAPAN',40,44,4,'N',40.7344444444444,140,41,27,'E',140.690833333333,664
UNION ALL SELECT 'RJSC','GAJ','YAMAGATA','YAMAGATA','JAPAN',38,24,42,'N',38.4116666666667,140,22,16,'E',140.371111111111,353
UNION ALL SELECT 'RJSI','HNA','HANAMAKI','HANAMAKI','JAPAN',39,25,51,'N',39.4308333333333,141,8,9,'E',141.135833333333,297
UNION ALL SELECT 'RJSK','AXT','AKITA','AKITA','JAPAN',39,36,56,'N',39.6155555555556,140,13,7,'E',140.218611111111,313
UNION ALL SELECT 'RJSM','MSJ','MISAWA AB','MISAWA','JAPAN',40,42,11,'N',40.7030555555556,141,22,6,'E',141.368333333333,119
UNION ALL SELECT 'RJSS','SDJ','SENDAI','SENDAI','JAPAN',38,8,22,'N',38.1394444444444,140,55,0,'E',140.916666666667,15
UNION ALL SELECT 'RJTH','HAC','HACHIJOJIMA','HACHIJOJIMA','JAPAN',33,6,54,'N',33.115,139,47,8,'E',139.785555555556,303
UNION ALL SELECT 'RJTO','OIM','OSHIMA','OSHIMA','JAPAN',34,47,4,'N',34.7844444444444,139,21,41,'E',139.361388888889,130
UNION ALL SELECT 'RJTQ','MMY','MIYAKEJIMA','MIYAKE JIMA','JAPAN',34,4,19,'N',34.0719444444444,139,33,35,'E',139.559722222222,67
UNION ALL SELECT 'RJTT','HND','TOKYO INTERNATIONAL','TOKYO','JAPAN',35,33,8,'N',35.5522222222222,139,46,46,'E',139.779444444444,35
UNION ALL SELECT 'RJTY','OKO','YOKOTA AB','YOKOTA','JAPAN',35,44,54,'N',35.7483333333333,139,20,54,'E',139.348333333333,463
UNION ALL SELECT 'RKJJ','KWJ','GWANGJU','KWANGJU','KOREA',35,7,32,'N',35.1255555555556,126,48,35,'E',126.809722222222,48
UNION ALL SELECT 'RKJK','KUB','KUNSAN AB','KUNSAN','KOREA',35,54,13,'N',35.9036111111111,126,36,57,'E',126.615833333333,29
UNION ALL SELECT 'RKJY','RSU','YEOSU','YEOSU','KOREA',34,50,23,'N',34.8397222222222,127,36,55,'E',127.615277777778,68
UNION ALL SELECT 'RKND','SHO','SOKCHO','SOKCH''O','KOREA',38,8,51,'N',38.1475,128,36,2,'E',128.600555555556,99
UNION ALL SELECT 'RKNN','KAG','GANGNEUNG','KANGNUNG','KOREA',37,45,12,'N',37.7533333333333,128,56,38,'E',128.943888888889,35
UNION ALL SELECT 'RKPC','CJU','JEJU INTERNATIONAL','CHEJU','KOREA',33,30,40,'N',33.5111111111111,126,29,34,'E',126.492777777778,118
UNION ALL SELECT 'RKPK','PUS','GIMHAE INTERNATIONAL','KIMHAE','KOREA',35,10,46,'N',35.1794444444444,128,56,17,'E',128.938055555556,13
UNION ALL SELECT 'RKPU','USN','ULSAN','ULSAN','KOREA',35,35,36,'N',35.5933333333333,129,21,6,'E',129.351666666667,45
UNION ALL SELECT 'RKSM','SSN','SEOUL AB','SEOUL EAST','KOREA',37,26,45,'N',37.4458333333333,127,6,50,'E',127.113888888889,92
UNION ALL SELECT 'RKSO','OSN','OSAN AB','OSAN','KOREA',37,5,26,'N',37.0905555555556,127,1,46,'E',127.029444444444,40
UNION ALL SELECT 'RKSS','GMP','GIMPO','SEOUL','KOREA',37,33,29,'N',37.5580555555556,126,47,26,'E',126.790555555556,58
UNION ALL SELECT 'RKTH','KPO','POHANG','POHANG','KOREA',35,59,16,'N',35.9877777777778,129,25,13,'E',129.420277777778,70
UNION ALL SELECT 'RKTN','TAE','DAEGU AB','TAEGU','KOREA',35,53,38,'N',35.8938888888889,128,39,31,'E',128.658611111111,116
UNION ALL SELECT 'RKTY','YEC','YECHEON','YECHON','KOREA',36,37,54,'N',36.6316666666667,128,21,17,'E',128.354722222222,354
UNION ALL SELECT 'ROAH','OKA','NAHA','NAHA','JAPAN',26,11,44,'N',26.1955555555556,127,38,45,'E',127.645833333333,11
UNION ALL SELECT 'RODN','DNA','KADENA AB','KADENA','JAPAN',26,21,20,'N',26.3555555555556,127,46,3,'E',127.7675,143
UNION ALL SELECT 'ROIG','ISG','ISHIGAKI','ISHIGAKI','JAPAN',24,20,40,'N',24.3444444444444,124,11,13,'E',124.186944444444,93
UNION ALL SELECT 'ROKJ','UEO','KUMEJIMA','KUMEJIMA','JAPAN',26,21,48,'N',26.3633333333333,126,42,49,'E',126.713611111111,23
UNION ALL SELECT 'ROMD','MMD','MINAMI DAITO','MINAMI DAITO','JAPAN',25,50,47,'N',25.8463888888889,131,15,48,'E',131.263333333333,167
UNION ALL SELECT 'ROMY','MMY','MIYAKO','MIYAKO','JAPAN',24,46,58,'N',24.7827777777778,125,17,42,'E',125.295,150
UNION ALL SELECT 'RORA','AGJ','','AGUNI','JAPAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RORH','HTR','','HATERUMA','JAPAN',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RORK','KTD','KITADAITO','KITADAITO','JAPAN',25,56,52,'N',25.9477777777778,131,19,17,'E',131.321388888889,80
UNION ALL SELECT 'RORS','SHI','SHIMOJISHIMA','SHIMOJISHIMA','JAPAN',24,49,36,'N',24.8266666666667,125,8,41,'E',125.144722222222,54
UNION ALL SELECT 'RORY','RNJ','YORON','YORON','JAPAN',27,2,38,'N',27.0438888888889,128,24,5,'E',128.401388888889,52
UNION ALL SELECT 'ROYN','OGN','YONAGUNI','YONAGUNI JIMA','JAPAN',24,28,1,'N',24.4669444444444,122,58,40,'E',122.977777777778,70
UNION ALL SELECT 'RPLL','MNL','NINOY AQUINO INTERNATIONAL','MANILA','PHILIPPINES',14,30,31,'N',14.5086111111111,121,1,10,'E',121.019444444444,75
UNION ALL SELECT 'RPMC','CEB','COTABATO','CEBU','PHILIPPINES',7,9,53,'N',7.16472222222222,124,12,37,'E',124.210277777778,189
UNION ALL SELECT 'RPML','CGY','CAGAYAN DE ORO','LADAG','PHILIPPINES',8,24,52,'N',8.41444444444445,124,36,41,'E',124.611388888889,610
UNION ALL SELECT 'RPMM','MNL','MALABANG','MANILA','PHILIPPINES',7,37,2,'N',7.61722222222222,124,3,31,'E',124.058611111111,27
UNION ALL SELECT 'RPMP','LGP','PAGADIAN','LEGAZPI','PHILIPPINES',7,49,40,'N',7.82777777777778,123,27,37,'E',123.460277777778,5
UNION ALL SELECT 'RPMZ','ZAM','ZAMBOANGA INTERNATIONAL','ZAMBOANGA','PHILIPPINES',6,55,20,'N',6.92222222222222,122,3,34,'E',122.059444444444,33
UNION ALL SELECT 'RPUB','BAG','BAGUIO','BAGUIO','PHILIPPINES',16,22,30,'N',16.375,120,37,8,'E',120.618888888889,4251
UNION ALL SELECT 'RPVA','TAC','DANIEL Z ROMUALDEZ','TACLOBAN','PHILIPPINES',11,13,38,'N',11.2272222222222,125,1,40,'E',125.027777777778,10
UNION ALL SELECT 'RPVB','BCD','BACOLOD','BACOLOD','PHILIPPINES',10,38,33,'N',10.6425,122,55,46,'E',122.929444444444,25
UNION ALL SELECT 'RPVD','DGT','DUMAGUETE','DUMAGUETE','PHILIPPINES',9,20,3,'N',9.33416666666667,123,18,7,'E',123.301944444444,15
UNION ALL SELECT 'RPVI','ILO','ILOILO','ILOILO','PHILIPPINES',10,42,47,'N',10.7130555555556,122,32,42,'E',122.545,27
UNION ALL SELECT 'RPVK','KLO','KALIBO','KALIBO','PHILIPPINES',11,40,52,'N',11.6811111111111,122,22,40,'E',122.377777777778,41
UNION ALL SELECT 'RPVM','NOP','MACTAN INTERNATIONAL','MASBATE','PHILIPPINES',10,18,27,'N',10.3075,123,58,45,'E',123.979166666667,31
UNION ALL SELECT 'RPVP','PPS','PUERTO PRINCESA','PUERTO PRINCESA','PHILIPPINES',9,44,31,'N',9.74194444444444,118,45,31,'E',118.758611111111,71
UNION ALL SELECT 'RPVS','SJI','ANTIQUE','SAN JOSE','PHILIPPINES',10,45,58,'N',10.7661111111111,121,55,56,'E',121.932222222222,23
UNION ALL SELECT 'RPWC','CBO','','COTABATO','PHILIPPINES',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RPWD','DVO','','DAVAO','PHILIPPINES',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RPWE','BXU','','BUTUAN','PHILIPPINES',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'RPWL','CGY','','CAGAYAN DE ORO','PHILIPPINES',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SAAC','COC','COMODORO PIERRESTEGUI','CONCORDIA','ARGENTINA',31,17,49,'S',-31.2969444444444,57,59,47,'U',0,112
UNION ALL SELECT 'SAAG','GHU','GUALEGUAYCHU','GUALEGUAYCHU','ARGENTINA',33,0,21,'S',-33.0058333333333,58,36,47,'U',0,75
UNION ALL SELECT 'SAAP','PRA','GENERAL URQUIZA','PARANA','ARGENTINA',31,47,41,'S',-31.7947222222222,60,28,49,'U',0,243
UNION ALL SELECT 'SAAR','ROS','ROSARIO','ROSARIO','ARGENTINA',32,54,12,'S',-32.9033333333333,60,47,4,'U',0,85
UNION ALL SELECT 'SAAV','SFN','SAUCE VIEJO','SANTA FE','ARGENTINA',31,42,42,'S',-31.7116666666667,60,48,42,'U',0,56
UNION ALL SELECT 'SABA','EZE','','BUENOS AIRES','ARGENTINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SABE','AEP','AEROPARQUE JORGE NEWBERY','BUENOS AIRES','ARGENTINA',34,33,33,'S',-34.5591666666667,58,24,56,'U',0,18
UNION ALL SELECT 'SACO','COR','AMBROSIO L V TARAVELLA','CORDOBA','ARGENTINA',31,19,25,'S',-31.3236111111111,64,12,28,'U',0,1604
UNION ALL SELECT 'SADL','LPG','LA PLATA','LA PLATA','ARGENTINA',34,58,20,'S',-34.9722222222222,57,53,40,'U',0,72
UNION ALL SELECT 'SAME','MDZ','EL PLUMERILLO','MENDOZA','ARGENTINA',32,49,54,'S',-32.8316666666667,68,47,34,'U',0,2311
UNION ALL SELECT 'SAMM','LGS','MALARGUE','MALARGUE','ARGENTINA',35,29,2,'S',-35.4838888888889,69,34,57,'U',0,4692
UNION ALL SELECT 'SAMR','AFA','SAN RAFAEL','SAN RAFAEL','ARGENTINA',34,35,17,'S',-34.5880555555556,68,24,9,'U',0,2470
UNION ALL SELECT 'SANC','CTC','CATAMARCA','CATAMARCA','ARGENTINA',28,35,44,'S',-28.5955555555556,65,45,6,'U',0,1522
UNION ALL SELECT 'SANE','SDE','SANTIAGO DEL ESTERO','SANTIAGO DEL ESTERO','ARGENTINA',27,45,56,'S',-27.7655555555556,64,18,36,'U',0,656
UNION ALL SELECT 'SANL','IRJ','LA RIOJA','LA RIOJA','ARGENTINA',29,22,53,'S',-29.3813888888889,66,47,45,'U',0,1437
UNION ALL SELECT 'SANT','TUC','TENIENTE BENJAMIN MATIENZO','TUCUMAN','ARGENTINA',26,50,27,'S',-26.8408333333333,65,6,17,'U',0,1495
UNION ALL SELECT 'SANU','UAQ','SAN JUAN','SAN JULIAN','ARGENTINA',31,34,17,'S',-31.5713888888889,68,25,5,'U',0,1959
UNION ALL SELECT 'SAOC','RCU','RIO CUARTO AREA DE MATERIAL','RIO CUARTO','ARGENTINA',33,5,8,'S',-33.0855555555556,64,15,41,'U',0,1381
UNION ALL SELECT 'SAOD','VDR','VILLA DOLORES','VILLA DOLORES','ARGENTINA',31,56,28,'S',-31.9411111111111,65,8,32,'U',0,1854
UNION ALL SELECT 'SAOU','LUQ','SAN LUIS','SAN LUIS','ARGENTINA',33,16,23,'S',-33.2730555555556,66,21,23,'U',0,2329
UNION ALL SELECT 'SARC','CNQ','CORRIENTES','CORRIENTES','ARGENTINA',27,26,43,'S',-27.4452777777778,58,45,42,'U',0,203
UNION ALL SELECT 'SARE','RES','RESISTENCIA','RESISTENCIA','ARGENTINA',27,26,59,'S',-27.4497222222222,59,3,22,'U',0,174
UNION ALL SELECT 'SARF','FMA','FORMOSA','FORMOSA','ARGENTINA',26,12,45,'S',-26.2125,58,13,41,'U',0,194
UNION ALL SELECT 'SARI','IGR','CATARATAS DEL IGUAZU','IGUAZU FALLS','ARGENTINA',25,44,15,'S',-25.7375,54,28,23,'U',0,916
UNION ALL SELECT 'SARL','AOL','PASO DE LOS LIBRES','PASO DE LOS LIBRES','ARGENTINA',29,41,21,'S',-29.6891666666667,57,9,7,'U',0,230
UNION ALL SELECT 'SARP','PSS','POSADAS','POSADAS','ARGENTINA',27,23,9,'S',-27.3858333333333,55,58,14,'U',0,429
UNION ALL SELECT 'SASA','SLA','SALTA','SALTA','ARGENTINA',24,51,21,'S',-24.8558333333333,65,29,10,'U',0,4077
UNION ALL SELECT 'SASJ','JUJ','JUJUY','JUJUY','ARGENTINA',24,23,34,'S',-24.3927777777778,65,5,52,'U',0,3019
UNION ALL SELECT 'SASO','ORA','ORAN','ORAN','ARGENTINA',23,9,10,'S',-23.1527777777778,64,19,45,'U',0,1168
) x (ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LatDec],[LongDeg],[LongMin],[LongSec],[LongDir],[LongDec],[Altitude])
LEFT OUTER JOIN Airports a ON a.IATA_Code = x.IATA_Code
--WHERE x.[LatDir] <> 'U' and x.[LongDir] <> 'U' and x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE n=1
GO

INSERT INTO Airports (ICAO_Code, IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir
    ,LongDeg, LongMin, LongSec, LongDir, Altitude)
SELECT ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LongDeg],[LongMin],[LongSec],[LongDir],[Altitude]
FROM (
SELECT x.ICAO_Code,x.IATA_Code,x.[Name],x.[City],x.[Country],x.[LatDeg],x.[LatMin],x.[LatSec],x.[LatDir]
	,x.[LatDec],x.[LongDeg],x.[LongMin],x.[LongSec],x.[LongDir],x.[LongDec],x.[Altitude]
    ,n=ROW_NUMBER() OVER (PARTITION BY x.IATA_Code ORDER BY (SELECT NULL))
FROM (
SELECT 'SAVB','EHL','EL BOLSON','EL BOLSON','ARGENTINA',41,56,35,'S',-41.9430555555556,71,31,56,'U',0,1132
UNION ALL SELECT 'SAVC','CRD','COMODORO RIVADAVIA','COMODORO RIVADAVIA','ARGENTINA',45,47,6,'S',-45.785,67,27,56,'U',0,190
UNION ALL SELECT 'SAVD','EMX','EL MAITEN','EL MAITEN','ARGENTINA',42,1,50,'S',-42.0305555555556,71,10,11,'U',0,2356
UNION ALL SELECT 'SAVE','EQS','ESQUEL','ESQUEL','ARGENTINA',42,54,28,'S',-42.9077777777778,71,8,22,'U',0,2585
UNION ALL SELECT 'SAVO','OES','','SAN ANTONIO OESTE','ARGENTINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SAVR','ARR','','ALTO RIO SENGUERR','ARGENTINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SAVS','SGV','','SIERRA GRANDE','ARGENTINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SAVT','REL','ALMIRANTE ZAR','TRELEW','ARGENTINA',43,12,37,'S',-43.2102777777778,65,16,13,'U',0,141
UNION ALL SELECT 'SAVV','VDM','GOBERNADOR CASTELLO','VIEDMA','ARGENTINA',40,52,9,'S',-40.8691666666667,63,0,1,'U',0,20
UNION ALL SELECT 'SAVY','PMY','EL TEHUELCHE','PUERTO MADRYN','ARGENTINA',42,45,32,'S',-42.7588888888889,65,6,9,'U',0,446
UNION ALL SELECT 'SAWA','ING','LAGO ARGENTINO','LAGO ARGENTINO','ARGENTINA',50,20,7,'S',-50.3352777777778,72,14,54,'U',0,732
UNION ALL SELECT 'SAWD','PUD','PUERTO DESEADO','PUERTO DESEADO','ARGENTINA',47,44,7,'S',-47.7352777777778,65,54,14,'U',0,266
UNION ALL SELECT 'SAWE','RGA','RIO GRANDE','RIO GRANDE','ARGENTINA',53,46,39,'S',-53.7775,67,44,57,'U',0,66
UNION ALL SELECT 'SAWG','RGL','RIO GALLEGOS','RIO GALLEGOS','ARGENTINA',51,36,31,'S',-51.6086111111111,69,18,45,'U',0,61
UNION ALL SELECT 'SAWH','USH','USHUAIA MALVINAS ARGENTINAS','USHUAIA','ARGENTINA',54,50,35,'S',-54.8430555555556,68,17,44,'U',0,102
UNION ALL SELECT 'SAWJ','ULA','SAN JULIAN','SAN JULIAN','ARGENTINA',49,18,24,'S',-49.3066666666667,67,48,9,'U',0,190
UNION ALL SELECT 'SAWM','ROY','','RIO MAYO','ARGENTINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SAWP','PMQ','','PERITO MORENO','ARGENTINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SAWR','GGS','','GOBERNADOR GREGORES','ARGENTINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SAWS','JSM','JOSE DE SAN MARTIN','JOSE DE SAN MARTIN','ARGENTINA',44,2,53,'S',-44.0480555555556,70,27,33,'U',0,2408
UNION ALL SELECT 'SAWT','RYO','EL TURBIO','RIO TURBIO','ARGENTINA',51,36,23,'S',-51.6063888888889,72,13,0,'U',0,906
UNION ALL SELECT 'SAWU','RZA','SANTA CRUZ','SANTA CRUZ','ARGENTINA',50,0,59,'S',-50.0163888888889,68,34,45,'U',0,364
UNION ALL SELECT 'SAZB','BHI','COMANDANTE ESPORA','BAHIA BLANCA','ARGENTINA',38,43,29,'S',-38.7247222222222,62,10,9,'U',0,246
UNION ALL SELECT 'SAZM','MDQ','MAR DEL PLATA','MAR DEL PLATA','ARGENTINA',37,56,3,'S',-37.9341666666667,57,34,24,'U',0,73
UNION ALL SELECT 'SAZN','NQN','PRESIDENTE PERON','NEUQUEN','ARGENTINA',38,56,56,'S',-38.9488888888889,68,9,20,'U',0,896
UNION ALL SELECT 'SAZR','RSA','SANTA ROSA','SANTA ROSA','ARGENTINA',36,35,17,'S',-36.5880555555556,64,16,31,'U',0,630
UNION ALL SELECT 'SAZS','BRC','SAN CARLOS DE BARILOCHE','SAN CARLOS DE BARILOCH','ARGENTINA',41,9,4,'S',-41.1511111111111,71,9,27,'U',0,2776
UNION ALL SELECT 'SAZT','TDL','TANDIL','TANDIL','ARGENTINA',37,14,14,'S',-37.2372222222222,59,13,40,'U',0,574
UNION ALL SELECT 'SAZV','VLG','VILLA GESELL','VILLA GESELL','ARGENTINA',37,14,7,'S',-37.2352777777778,57,1,45,'U',0,33
UNION ALL SELECT 'SAZY','CPC','AVIADOR C CAMPOS','SAN MARTIN DES ANDES','ARGENTINA',40,4,31,'S',-40.0752777777778,71,8,14,'U',0,2569
UNION ALL SELECT 'SBAA','CDJ','UNKNOWN','CONCEICAO_Code DO ARAGUAIA','BRAZIL',8,20,54,'S',-8.34833333333333,49,18,5,'U',0,653
UNION ALL SELECT 'SBAQ','AQA','ARARAQUARA','ARARACUARA','BRAZIL',21,48,43,'S',-21.8119444444444,48,7,58,'U',0,2334
UNION ALL SELECT 'SBAR','AJU','SANTA MARIA','ARACAJU','BRAZIL',10,59,2,'S',-10.9838888888889,37,4,13,'U',0,23
UNION ALL SELECT 'SBAT','AFL','ALTA FLORESTA','ALTA FLORESTA','BRAZIL',9,51,57,'S',-9.86583333333333,56,6,22,'U',0,947
UNION ALL SELECT 'SBAU','ARU','ARACATUBA','ARACATUBA','BRAZIL',21,8,28,'S',-21.1411111111111,50,25,29,'U',0,1361
UNION ALL SELECT 'SBBE','BEL','VAL DE CAES','BELEM','BRAZIL',1,22,45,'S',-1.37916666666667,48,28,34,'U',0,54
UNION ALL SELECT 'SBBG','BGX','COMANDANTE GUSTAVO KRAEMER','BAGE','BRAZIL',31,23,25,'S',-31.3902777777778,54,6,44,'U',0,600
UNION ALL SELECT 'SBBH','PLU','PAMPULHA','BELO HORIZONTE','BRAZIL',19,51,6,'S',-19.8516666666667,43,57,1,'U',0,2589
UNION ALL SELECT 'SBBI','BFH','BACACHERI','CURITIBA','BRAZIL',25,24,18,'S',-25.405,49,13,55,'U',0,3057
UNION ALL SELECT 'SBBR','BSB','PRESIDENTE JUSCELINO KUBITSCHEK','BRASILIA','BRAZIL',15,51,45,'S',-15.8625,47,54,45,'U',0,3479
UNION ALL SELECT 'SBBU','BAU','BAURU','BAURU','BRAZIL',22,20,42,'S',-22.345,49,3,13,'U',0,2018
UNION ALL SELECT 'SBBV','BVB','BOA VISTA','BOA VISTA','BRAZIL',2,50,46,'N',2.84611111111111,60,41,24,'U',0,276
UNION ALL SELECT 'SBCA','CAC','CASCAVEL','CASCAVEL','BRAZIL',25,0,1,'S',-25.0002777777778,53,30,2,'U',0,2473
UNION ALL SELECT 'SBCF','CNF','TANCREDO NEVES','BELO HORIZONTE','BRAZIL',19,38,1,'S',-19.6336111111111,43,58,7,'U',0,2715
UNION ALL SELECT 'SBCG','CGR','CAMPO GRANDE','CAMPO GRANDE','BRAZIL',20,28,7,'S',-20.4686111111111,54,40,21,'U',0,1833
UNION ALL SELECT 'SBCH','XAP','CHAPECO','CHAPECO','BRAZIL',27,8,3,'S',-27.1341666666667,52,39,23,'U',0,2146
UNION ALL SELECT 'SBCI','CLN','CAROLINA','CAROLINA','BRAZIL',7,19,13,'S',-7.32027777777778,47,27,31,'U',0,565
UNION ALL SELECT 'SBCP','CAW','BARTOLOMEU LISANDRO','CAMPOS','BRAZIL',21,41,54,'S',-21.6983333333333,41,18,6,'U',0,57
UNION ALL SELECT 'SBCR','CMG','CORUMBA INTERNATIONAL','CORUMBA','BRAZIL',19,0,42,'S',-19.0116666666667,57,40,22,'U',0,461
UNION ALL SELECT 'SBCT','CWB','AFONSO PENA','CURITIBA','BRAZIL',25,31,42,'S',-25.5283333333333,49,10,32,'U',0,2988
UNION ALL SELECT 'SBCV','CRQ','CARAVELAS','CARAVELAS','BRAZIL',17,39,8,'S',-17.6522222222222,39,15,11,'U',0,36
UNION ALL SELECT 'SBCX','CXJ','CAMPO DOS BUGRES','CAXIAS DO SUL','BRAZIL',29,11,49,'S',-29.1969444444444,51,11,15,'U',0,2472
UNION ALL SELECT 'SBCY','CGB','MARECHAL RONDON','CUIABA','BRAZIL',15,39,10,'S',-15.6527777777778,56,7,0,'U',0,614
UNION ALL SELECT 'SBCZ','CZS','CRUZEIRO DO SUL','CRUIZIRO DO SUL','BRAZIL',7,36,0,'S',-7.6,72,46,10,'U',0,637
UNION ALL SELECT 'SBDN','PPB','PRESIDENTE PRUDENTE','PRESIDENT PRUDENTE','BRAZIL',22,10,30,'S',-22.175,51,25,28,'U',0,1477
UNION ALL SELECT 'SBEG','MAO','EDUARDO GOMES INTERNATIONAL','MANAUS','BRAZIL',3,2,19,'S',-3.03861111111111,60,2,59,'U',0,264
UNION ALL SELECT 'SBFC','FRC','FRANCA','FRANCA','BRAZIL',20,35,31,'S',-20.5919444444444,47,22,58,'U',0,3292
UNION ALL SELECT 'SBFI','IGU','CATARATAS INTERNATIONAL','FOZ DO IGUACU','BRAZIL',25,35,46,'S',-25.5961111111111,54,29,13,'U',0,787
UNION ALL SELECT 'SBFL','FLN','HERCILIO LUZ','FLORIANOPOLIS','BRAZIL',27,40,21,'S',-27.6725,48,32,52,'U',0,19
UNION ALL SELECT 'SBFN','FEN','FERNANDO DE NORONHA','FERNANDO DO NORONHA','BRAZIL',3,51,17,'S',-3.85472222222222,32,25,24,'U',0,180
UNION ALL SELECT 'SBFZ','FOR','PINTO MARTINS INTERNATIONAL','FORTALEZA','BRAZIL',3,46,34,'S',-3.77611111111111,38,31,57,'U',0,82
UNION ALL SELECT 'SBGL','GIG','GALEAO ANTONIO CARLOS JOBIM','RIO DE JANEIRO','BRAZIL',22,48,32,'S',-22.8088888888889,43,14,37,'U',0,28
UNION ALL SELECT 'SBGO','GYN','SANTA GENOVEVA','GOIANIA','BRAZIL',16,37,52,'S',-16.6311111111111,49,13,20,'U',0,2450
UNION ALL SELECT 'SBGR','GRU','GUARULHOS','SAO PAULO','BRAZIL',23,25,56,'S',-23.4322222222222,46,28,9,'U',0,2459
UNION ALL SELECT 'SBHT','ATM','ALTAMIRA','ALTAMIRA','BRAZIL',3,15,14,'S',-3.25388888888889,52,15,14,'U',0,369
UNION ALL SELECT 'SBIL','IOS','ILHEUS','ILHEUS','BRAZIL',14,48,57,'S',-14.8158333333333,39,1,59,'U',0,15
UNION ALL SELECT 'SBIP','IPN','USIMINAS','IPATINGA','BRAZIL',19,28,14,'S',-19.4705555555556,42,29,15,'U',0,784
UNION ALL SELECT 'SBIZ','IMP','IMPERATRIZ','IMPERATRIZ','BRAZIL',5,31,52,'S',-5.53111111111111,47,27,36,'U',0,431
UNION ALL SELECT 'SBJA','RIJ','','RIOJA','PERU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SBJF','JDF','FRANCISCO DE ASSIS','JUIZ DE FORA','BRAZIL',21,47,29,'S',-21.7913888888889,43,23,12,'U',0,2989
UNION ALL SELECT 'SBJP','JPA','INTL. PRES. CASTRO PINTO','JOAO PESSOA','BRAZIL',7,16,11,'S',-7.26972222222222,35,53,46,'U',0,1646
UNION ALL SELECT 'SBJV','JOI','JOINVILLE','JOINVILLE','BRAZIL',26,13,29,'S',-26.2247222222222,48,47,50,'U',0,15
UNION ALL SELECT 'SBKG','CPV','','CAMPINA GRANDE','BRAZIL',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SBKP','VCP','VIRACOPOS','CAMPINAS','BRAZIL',23,0,29,'S',-23.0080555555556,47,8,4,'U',0,2170
UNION ALL SELECT 'SBLN','LIP','LINS','LINS','BRAZIL',21,39,50,'S',-21.6638888888889,49,43,49,'U',0,1559
UNION ALL SELECT 'SBLO','LDB','LONDRINA','LONDRINA','BRAZIL',23,20,1,'S',-23.3336111111111,51,7,48,'U',0,1867
UNION ALL SELECT 'SBLP','LAZ','BOM JESUS DA LAPA','BOM JESUS DA LAPA','BRAZIL',13,15,43,'S',-13.2619444444444,43,24,29,'U',0,1454
UNION ALL SELECT 'SBMA','MAB','MARABA','MARABA','BRAZIL',5,22,6,'S',-5.36833333333333,49,8,16,'U',0,357
UNION ALL SELECT 'SBMG','MGF','MARINGA','MARINGA','BRAZIL',23,26,23,'S',-23.4397222222222,51,54,25,'U',0,1832
UNION ALL SELECT 'SBMK','MOC','MONTES CLAROS','MONTES CLAROS','BRAZIL',16,42,24,'S',-16.7066666666667,43,49,8,'U',0,2191
UNION ALL SELECT 'SBMO','MCZ','ZUMBI DOS PALMARES','MACEIO','BRAZIL',9,30,37,'S',-9.51027777777778,35,47,36,'U',0,387
UNION ALL SELECT 'SBMQ','MCP','MACAPA','MACAPA','BRAZIL',0,3,2,'N',0.0505555555555556,51,4,19,'U',0,56
UNION ALL SELECT 'SBNF','NVT','NAVEGANTES ITAJAI','NAVEGANTES','BRAZIL',26,52,48,'S',-26.88,48,39,5,'U',0,18
UNION ALL SELECT 'SBNM','GEL','SANTO ANGELO','SANTO ANGELO','BRAZIL',28,16,54,'S',-28.2816666666667,54,10,8,'U',0,1056
UNION ALL SELECT 'SBNT','NAT','AUGUSTO SEVERO','NATAL','BRAZIL',5,54,40,'S',-5.91111111111111,35,14,52,'U',0,169
UNION ALL SELECT 'SBOU','OUS','','OURINHOS','BRAZIL',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SBPA','POA','SALGADO FILHO','PORTO ALEGRE','BRAZIL',29,59,39,'S',-29.9941666666667,51,10,17,'U',0,11
UNION ALL SELECT 'SBPC','POO','POCOS DE CALDAS','POCOS DE CALDAS','BRAZIL',21,50,34,'S',-21.8427777777778,46,34,4,'U',0,4135
UNION ALL SELECT 'SBPF','PFB','LAURO KURTZ','PASSO FUNDO','BRAZIL',28,14,38,'S',-28.2438888888889,52,19,35,'U',0,2376
UNION ALL SELECT 'SBPK','PET','PELOTAS','PELOTAS','BRAZIL',31,43,6,'S',-31.7183333333333,52,19,39,'U',0,59
UNION ALL SELECT 'SBPL','PNZ','PETROLINA','PETROLINA','BRAZIL',9,21,50,'S',-9.36388888888889,40,33,50,'U',0,1263
UNION ALL SELECT 'SBPN','PNB','PORTO NACIONAL','PORTO NACIONAL','BRAZIL',10,43,9,'S',-10.7191666666667,48,23,59,'U',0,870
UNION ALL SELECT 'SBPP','PMG','PONTA PORA','PONTA PORA','BRAZIL',22,32,58,'S',-22.5494444444444,55,42,9,'U',0,2156
UNION ALL SELECT 'SBPV','PVH','GOVERNADOR JORGE TEIXEIRA DE OLIVEIRA','PORTO VELHO','BRAZIL',8,42,33,'S',-8.70916666666667,63,54,8,'U',0,290
UNION ALL SELECT 'SBRB','RBR','PRESIDENTE MEDICI','RIO BRANCO','BRAZIL',9,52,8,'S',-9.86888888888889,67,53,37,'U',0,634
UNION ALL SELECT 'SBRF','REC','GUARARAPES','RECIFE','BRAZIL',8,7,35,'S',-8.12638888888889,34,55,24,'U',0,33
UNION ALL SELECT 'SBRG','RIG','RIO GRANDE','RIO GRANDE','BRAZIL',32,4,57,'S',-32.0825,52,9,59,'U',0,27
UNION ALL SELECT 'SBRJ','SDU','SANTOS DUMONT','RIO DE JANEIRO','BRAZIL',22,54,37,'S',-22.9102777777778,43,9,47,'U',0,11
UNION ALL SELECT 'SBRP','RAO','LEITE LOPES','RIBEIRAO PRETO','BRAZIL',21,8,3,'S',-21.1341666666667,47,46,27,'U',0,1802
UNION ALL SELECT 'SBSC','STU','SANTA CRUZ','RIO DE JANEIRO','BRAZIL',22,55,56,'S',-22.9322222222222,43,43,8,'U',0,10
UNION ALL SELECT 'SBSI','IGU','','IGUASSU FALLS','BRAZIL',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SBSJ','SJK','SAO JOSE DOS CAMPOS','SAO JOSE DOS CAMPOS','BRAZIL',23,13,45,'S',-23.2291666666667,45,51,41,'U',0,2120
UNION ALL SELECT 'SBSL','SLZ','MARECHAL CUNHA MACHADO','SAO LUIS','BRAZIL',2,35,19,'S',-2.58861111111111,44,14,11,'U',0,178
UNION ALL SELECT 'SBSM','STM','SANTA MARIA','SANTAREM','BRAZIL',29,42,40,'S',-29.7111111111111,53,41,17,'U',0,287
UNION ALL SELECT 'SBSP','CGH','CONGONHAS','SAO PAULO','BRAZIL',23,37,36,'S',-23.6266666666667,46,39,19,'U',0,2631
UNION ALL SELECT 'SBSR','SJP','SAO JOSE DO RIO PRETO','SAO JOSE DO RIO PRETO','BRAZIL',20,48,59,'S',-20.8163888888889,49,24,23,'U',0,1782
UNION ALL SELECT 'SBST','SSZ','SANTOS AIR BASE','SANTOS','BRAZIL',23,55,30,'S',-23.925,46,17,15,'U',0,10
UNION ALL SELECT 'SBSV','SSA','DEPUTADO LUIS EDUARDO MAGALHAES','SALVADOR','BRAZIL',12,54,39,'S',-12.9108333333333,38,19,51,'U',0,63
UNION ALL SELECT 'SBTE','THE','SENADOR PETRONIO PORTELLA','TERESINA','BRAZIL',5,3,35,'S',-5.05972222222222,42,49,24,'U',0,219
UNION ALL SELECT 'SBTF','TFF','TEFE','TEFE','BRAZIL',3,22,58,'S',-3.38277777777778,64,43,26,'U',0,184
UNION ALL SELECT 'SBTT','TBT','TABATINGA','TABATINGA','BRAZIL',4,15,20,'S',-4.25555555555556,69,56,8,'U',0,279
UNION ALL SELECT 'SBTU','TUR','TUCURUI','TUCURUI','BRAZIL',3,47,6,'S',-3.785,49,43,10,'U',0,830
UNION ALL SELECT 'SBUF','PAV','PAULO AFONSO','PAULO ALFONSO','BRAZIL',9,24,3,'S',-9.40083333333333,38,15,2,'U',0,883
UNION ALL SELECT 'SBUG','URG','RUBEM BERTA','URUGUAIANA','BRAZIL',29,46,55,'S',-29.7819444444444,57,2,17,'U',0,256
UNION ALL SELECT 'SBUL','UDI','UBERLANDIA','UBERLANDIA','BRAZIL',18,52,58,'S',-18.8827777777778,48,13,32,'U',0,3094
UNION ALL SELECT 'SBUR','UBA','UBERABA','UBERABA','BRAZIL',19,45,54,'S',-19.765,47,57,53,'U',0,2655
UNION ALL SELECT 'SBVG','VAG','MAJOR BRIGADEIRO TROMPOWSKY','VARGINHA','BRAZIL',21,35,24,'S',-21.59,45,28,24,'U',0,3028
UNION ALL SELECT 'SBVH','BVH','VILHENA','VILHENA','BRAZIL',12,41,39,'S',-12.6941666666667,60,5,53,'U',0,2018
UNION ALL SELECT 'SBVT','VIX','GOIABEIRAS','VITORIA','BRAZIL',20,15,20,'S',-20.2555555555556,40,17,20,'U',0,11
UNION ALL SELECT 'SBXG','BPG','','BARRA DO GARCAS','BRAZIL',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SBYS','QPS','CAMPO FONTENELLE','PIRACUNUNGA','BRAZIL',21,59,7,'S',-21.9852777777778,47,20,17,'U',0,1968
UNION ALL SELECT 'SCAC','ZUD','PUPELDE','ANCUD','CHILE',41,54,22,'S',-41.9061111111111,73,47,48,'U',0,375
UNION ALL SELECT 'SCAP','WAP','ALTO PALENA','ALTO PALENA','CHILE',43,36,55,'S',-43.6152777777778,71,48,25,'U',0,910
UNION ALL SELECT 'SCAR','ARI','CHACALLUTA','ARICA','CHILE',18,20,54,'S',-18.3483333333333,70,20,19,'U',0,166
UNION ALL SELECT 'SCBA','BBA','BALMACEDA','BALMACEDA','CHILE',45,54,57,'S',-45.9158333333333,71,41,21,'U',0,1722
UNION ALL SELECT 'SCCC','CCH','CHILE CHICO','CHILE CHICO','CHILE',46,34,54,'S',-46.5816666666667,71,41,51,'U',0,1070
UNION ALL SELECT 'SCCF','CJC','EL LOA','CALAMA','CHILE',22,29,55,'S',-22.4986111111111,68,54,15,'U',0,7514
UNION ALL SELECT 'SCCI','PUQ','CARLOS IBANEZ DEL CAMPO INTERNATIONAL','PUNTA ARENAS','CHILE',53,0,10,'S',-53.0027777777778,70,51,17,'U',0,139
UNION ALL SELECT 'SCCY','GXQ','TENIENTE VIDAL','COYHAIQUE','CHILE',45,35,39,'S',-45.5941666666667,72,6,22,'U',0,1020
UNION ALL SELECT 'SCDA','IQQ','DIEGO ARACENA INTERNATIONAL','IQUIQUE','CHILE',20,32,6,'S',-20.535,70,10,52,'U',0,157
UNION ALL SELECT 'SCEL','SCL','ARTURO MERINO BENITEZ INTERNATIONAL','SANTIAGO','CHILE',33,23,34,'S',-33.3927777777778,70,47,8,'U',0,1554
UNION ALL SELECT 'SCFA','ANF','CERRO MORENO INTERNATIONAL','ANTOFAGASTA','CHILE',23,26,40,'S',-23.4444444444444,70,26,42,'U',0,455
UNION ALL SELECT 'SCGE','LSQ','MARIA DOLORES','LOS ANGELES','CHILE',37,24,6,'S',-37.4016666666667,72,25,32,'U',0,374
UNION ALL SELECT 'SCHA','CPO','CHAMONATE','COPIAPO','CHILE',27,17,46,'S',-27.2961111111111,70,24,49,'U',0,954
UNION ALL SELECT 'SCIE','CCP','CARRIEL SUR INTERNATIONAL','CONCEPCION','CHILE',36,46,21,'S',-36.7725,73,3,47,'U',0,26
UNION ALL SELECT 'SCIP','IPC','MATAVERI INTERNATIONAL','EASTER ISLAND','CHILE',27,9,53,'S',-27.1647222222222,109,25,18,'U',0,227
UNION ALL SELECT 'SCJO','ZOS','CANAL BAJO CARLOS HOTT SIEBERT','OSORNO','CHILE',40,36,41,'S',-40.6113888888889,73,3,37,'U',0,187
UNION ALL SELECT 'SCSE','LSC','LA FLORIDA','LA SERENA','CHILE',29,54,59,'S',-29.9163888888889,71,11,28,'U',0,481
UNION ALL SELECT 'SCTC','ZCO','MAQUEHUE','TEMUCO','CHILE',38,46,7,'S',-38.7686111111111,72,38,9,'U',0,305
UNION ALL SELECT 'SCTE','PMC','EL TEPUAL INTERNATIONAL','PUERTO MONTT','CHILE',41,26,19,'S',-41.4386111111111,73,5,38,'U',0,294
UNION ALL SELECT 'SCTI','ULC','LOS CERRILLOS','SANTIAGO','CHILE',33,29,36,'S',-33.4933333333333,70,41,51,'U',0,1677
UNION ALL SELECT 'SCTN','WCH','CHAITEN','CHAITEN','CHILE',42,55,59,'S',-42.9330555555556,72,41,57,'U',0,13
UNION ALL SELECT 'SCVD','ZAL','PICHOY','VALDIVIA','CHILE',39,38,59,'S',-39.6497222222222,73,5,10,'U',0,59
UNION ALL SELECT 'SEAM','ATF','CHACHOAN','AMBATO','ECUADOR',1,12,45,'S',-1.2125,78,34,27,'U',0,8440
UNION ALL SELECT 'SECO','OCC','FRANCISCO DE ORELLANA','COCA','ECUADOR',0,27,46,'S',-0.462777777777778,76,59,11,'U',0,820
UNION ALL SELECT 'SECU','CUE','MARISCAL LAMAR','CUENCA','ECUADOR',2,53,22,'S',-2.88944444444444,78,59,3,'U',0,8284
UNION ALL SELECT 'SEES','ESM','','ESMERALDAS','ECUADOR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SEGS','GPS','SEYMOUR','GALAPAGOS','GALAPAGOS I. (ECUADOR',0,27,13,'S',-0.453611111111111,90,15,57,'U',0,52
UNION ALL SELECT 'SEGU','GYE','SIMON BOLIVAR INTERNATIONAL','GUAYAQUIL','ECUADOR',2,9,28,'S',-2.15777777777778,79,53,2,'U',0,15
UNION ALL SELECT 'SELA','LGQ','LAGO AGRIO','LAGO AGRIO','ECUADOR',0,5,32,'N',0.0922222222222222,76,52,9,'U',0,976
UNION ALL SELECT 'SELO','LOH','','LOJA','ECUADOR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SEMC','XMS','MACAS','MACAS','ECUADOR',2,17,57,'S',-2.29916666666667,78,7,14,'U',0,3281
UNION ALL SELECT 'SEMH','MCH','GENERAL SERRANO','MACHALA','ECUADOR',3,16,8,'S',-3.26888888888889,79,57,42,'U',0,13
UNION ALL SELECT 'SEMT','MEC','ELOY ALFARO INTERNATIONAL','MANTA','ECUADOR',0,56,44,'S',-0.945555555555556,80,40,41,'U',0,44
UNION ALL SELECT 'SEPV','PVO','REALES TAMARINDOS','PORTOVIEJO','ECUADOR',1,2,29,'S',-1.04138888888889,80,28,19,'U',0,144
UNION ALL SELECT 'SEQU','UIO','MARISCAL SUCRE INTERNATIONAL','QUITO','ECUADOR',0,8,28,'S',-0.141111111111111,78,29,17,'U',0,9228
UNION ALL SELECT 'SESA','SNC','GENERAL ULPIANO PAEZ','SALINAS','ECUADOR',2,12,17,'S',-2.20472222222222,80,59,19,'U',0,13
UNION ALL SELECT 'SETR','TPC','TARAPOA','TARAPOA','ECUADOR',0,7,22,'S',-0.122777777777778,76,20,15,'U',0,802
UNION ALL SELECT 'SETU','TUA','EL ROSAL TENIENTE MANTILLA','TULCAN','ECUADOR',0,48,34,'N',0.809444444444445,77,42,29,'U',0,9679
UNION ALL SELECT 'SGAS','ASU','SILVIO PETTIROSSI INTERNATIONAL','ASUNCION','PARAGUAY',25,14,23,'S',-25.2397222222222,57,31,8,'U',0,292
UNION ALL SELECT 'SKAR','AXM','EL EDEN','ARMENIA','COLOMBIA',4,27,13,'N',4.45361111111111,75,45,55,'U',0,3998
UNION ALL SELECT 'SKAS','PUU','TRES DE MAYO','PUERTO ASIS','COLOMBIA',0,30,18,'N',0.505,76,30,3,'U',0,811
UNION ALL SELECT 'SKBG','BGA','PALONEGRO','BUCARAMANGA','COLOMBIA',7,7,35,'N',7.12638888888889,73,11,5,'U',0,3897
UNION ALL SELECT 'SKBO','BOG','ELDORADO INTERNATIONAL','BOGOTA','COLOMBIA',4,42,5,'N',4.70138888888889,74,8,49,'U',0,8361
UNION ALL SELECT 'SKBQ','BAQ','ERNESTO CORTISSOZ','BARRANQUILLA','COLOMBIA',10,53,22,'N',10.8894444444444,74,46,50,'U',0,98
UNION ALL SELECT 'SKBS','BSC','JOSE CELESTINO MUTIS','BAHIA SOLANO','COLOMBIA',6,12,10,'N',6.20277777777778,77,23,40,'U',0,80
UNION ALL SELECT 'SKBU','BUN','GERARDO TOBAR LOPEZ','BUENAVENTURA','COLOMBIA',3,49,10,'N',3.81944444444444,76,59,23,'U',0,48
UNION ALL SELECT 'SKCC','CUC','CAMILO DAZA','CUCUTA','COLOMBIA',7,55,39,'N',7.9275,72,30,41,'U',0,1096
UNION ALL SELECT 'SKCD','COG','MANDINGA','CONDOTO','COLOMBIA',5,4,18,'N',5.07166666666667,76,40,35,'U',0,215
UNION ALL SELECT 'SKCG','CTG','RAFAEL NUNEZ','CARTAGENA','COLOMBIA',10,26,32,'N',10.4422222222222,75,30,46,'U',0,4
UNION ALL SELECT 'SKCL','CLO','ALFONSO BONILLA ARAGON INTERNATIONAL','CALI','COLOMBIA',3,32,35,'N',3.54305555555556,76,22,53,'U',0,3162
UNION ALL SELECT 'SKCO','TCO','LA FLORIDA','TUMACO','COLOMBIA',1,48,51,'N',1.81416666666667,78,44,57,'U',0,8
UNION ALL SELECT 'SKCZ','CZU','LAS BRUJAS','COROZAL','COLOMBIA',9,19,57,'N',9.3325,75,17,8,'U',0,480
UNION ALL SELECT 'SKEJ','EJA','YARIGUIES','BARRANCABERMEJA','COLOMBIA',7,1,27,'N',7.02416666666667,73,48,24,'U',0,412
UNION ALL SELECT 'SKFL','FLA','GUSTAVO ARTUNDUAGA PAREDES','FLORENCIA','COLOMBIA',1,35,25,'N',1.59027777777778,75,33,50,'U',0,803
UNION ALL SELECT 'SKGP','GPI','GUAPI','GUAPI','COLOMBIA',2,34,12,'N',2.57,77,53,54,'U',0,164
UNION ALL SELECT 'SKIB','IBE','PERALES','IBAGUE','COLOMBIA',4,25,17,'N',4.42138888888889,75,7,59,'U',0,3114
UNION ALL SELECT 'SKIP','IPI','SAN LUIS','IPIALES','COLOMBIA',0,51,42,'N',0.861666666666667,77,40,18,'U',0,9765
UNION ALL SELECT 'SKLT','LET','ALFREDO VASQUEZ COBO','LETICIA','COLOMBIA',4,11,35,'S',-4.19305555555556,69,56,33,'U',0,277
UNION ALL SELECT 'SKMD','EOH','OLAYA HERRERA','MEDELLIN','COLOMBIA',6,13,12,'N',6.22,75,35,26,'U',0,4940
UNION ALL SELECT 'SKMG','MGN','BARACOA','MAGANGUE','COLOMBIA',9,17,0,'N',9.28333333333333,74,50,22,'U',0,178
UNION ALL SELECT 'SKMR','MTR','LOS GARZONES','MONTERIA','COLOMBIA',8,49,25,'N',8.82361111111111,75,49,33,'U',0,36
UNION ALL SELECT 'SKMU','MVP','FABIO ALBERTO LEON BENTLEY','MITU','COLOMBIA',1,15,13,'N',1.25361111111111,70,14,1,'U',0,680
UNION ALL SELECT 'SKMZ','MZL','LA NUBIA','MANIZALES','COLOMBIA',5,1,47,'N',5.02972222222222,75,27,54,'U',0,6871
UNION ALL SELECT 'SKNV','NVA','BENITO SALAS','NEIVA','COLOMBIA',2,57,0,'N',2.95,75,17,38,'U',0,1440
UNION ALL SELECT 'SKOC','OCV','AGUAS CLARAS','OCANA','COLOMBIA',8,18,53,'N',8.31472222222222,73,21,30,'U',0,3850
UNION ALL SELECT 'SKOT','OTU','OTU','OTU','COLOMBIA',7,0,37,'N',7.01027777777778,74,42,55,'U',0,2000
UNION ALL SELECT 'SKPC','PCR','PUERTO CARRENO','PUERTO CARRENO','COLOMBIA',6,11,4,'N',6.18444444444444,67,29,35,'U',0,164
UNION ALL SELECT 'SKPE','PEI','MATECANA','PEREIRA','COLOMBIA',4,48,45,'N',4.8125,75,44,22,'U',0,4416
UNION ALL SELECT 'SKPP','PPN','GUILLERMO LEON VALENCIA','POPAYAN','COLOMBIA',2,27,15,'N',2.45416666666667,76,36,36,'U',0,5687
UNION ALL SELECT 'SKPS','PSO','ANTONIO NARINO','PASTO','COLOMBIA',1,23,47,'N',1.39638888888889,77,17,27,'U',0,5912
UNION ALL SELECT 'SKPV','PVA','EL EMBRUJO','PROVIDENCIA','COLOMBIA',13,21,25,'N',13.3569444444444,81,21,30,'U',0,10
UNION ALL SELECT 'SKRG','MDE','JOSE MARIA CORDOVA','RIO NEGRO','COLOMBIA',6,9,52,'N',6.16444444444444,75,25,23,'U',0,7028
UNION ALL SELECT 'SKRH','RCH','ALMIRANTE PADILLA','RIO HACHA','COLOMBIA',11,31,34,'N',11.5261111111111,72,55,33,'U',0,43
UNION ALL SELECT 'SKSA','RVE','LOS COLONIZADORES','SARAVENA','COLOMBIA',6,57,29,'N',6.95805555555556,71,51,18,'U',0,700
UNION ALL SELECT 'SKSJ','SJE','JORGE E GONZALEZ TORRES','SAN JOSE DEL GUAVIARE','COLOMBIA',2,34,46,'N',2.57944444444444,72,38,21,'U',0,605
UNION ALL SELECT 'SKSM','SMR','SIMON BOLIVAR','SANTA MARTA','COLOMBIA',11,7,10,'N',11.1194444444444,74,13,50,'U',0,22
UNION ALL SELECT 'SKSP','ADZ','GUSTAVO ROJAS PINILLA','SAN ANDRES ISLAND','COLOMBIA',12,35,0,'N',12.5833333333333,81,42,40,'U',0,19
UNION ALL SELECT 'SKSV','SVI','EDUARDO FALLA SOLANO','SAN VINCENTE DE CAGUAN','COLOMBIA',2,9,7,'N',2.15194444444444,74,45,58,'U',0,920
UNION ALL SELECT 'SKTD','TDA','TRINIDAD','TRINIDAD','COLOMBIA',5,25,49,'N',5.43027777777778,71,39,29,'U',0,650
UNION ALL SELECT 'SKTM','TME','TAME','TAME','COLOMBIA',6,27,3,'N',6.45083333333333,71,45,36,'U',0,1050
UNION ALL SELECT 'SKTU','TRB','GONZALO MEJIA','TURBO','COLOMBIA',8,4,28,'N',8.07444444444444,76,44,28,'U',0,7
UNION ALL SELECT 'SKUC','AUC','SANTIAGO PEREZ','ARAUCA','COLOMBIA',7,4,7,'N',7.06861111111111,70,44,12,'U',0,400
UNION ALL SELECT 'SKUI','UIB','EL CARANO','QUIBDO','COLOMBIA',5,41,26,'N',5.69055555555556,76,38,28,'U',0,204
UNION ALL SELECT 'SKUL','ULQ','FARFAN','TULUA','COLOMBIA',4,5,18,'N',4.08833333333333,76,14,6,'U',0,3132
UNION ALL SELECT 'SKVP','VUP','ALFONSO LOPEZ PUMAREJO','VALLEDUPAR','COLOMBIA',10,26,6,'N',10.435,73,14,58,'U',0,453
UNION ALL SELECT 'SKVV','VVC','VANGUARDIA','VILLAVICENCIO','COLOMBIA',4,10,4,'N',4.16777777777778,73,36,49,'U',0,1394
UNION ALL SELECT 'SLAP','APB','APOLO','APOLO','BOLIVIA',14,44,22,'S',-14.7394444444444,68,24,39,'U',0,4642
UNION ALL SELECT 'SLBJ','BJO','BERMEJO','BERMEJO','BOLIVIA',22,46,10,'S',-22.7694444444444,64,18,54,'U',0,1250
UNION ALL SELECT 'SLCA','CAM','CAMIRI','CAMIRI','BOLIVIA',20,0,25,'S',-20.0069444444444,63,31,39,'U',0,2618
UNION ALL SELECT 'SLCB','CBB','JORGE WILSTERMAN','COCHABAMBA','BOLIVIA',17,25,15,'S',-17.4208333333333,66,10,37,'U',0,8360
UNION ALL SELECT 'SLCO','CIJ','CAPITAN ANIBAL ARAB','COBIJA','BOLIVIA',11,2,25,'S',-11.0402777777778,68,46,58,'U',0,889
UNION ALL SELECT 'SLCP','CEP','CONCEPCION','CONCEPTION','BOLIVIA',16,8,36,'S',-16.1433333333333,62,1,33,'U',0,1631
UNION ALL SELECT 'SLCZ','SRZ','','SANTA CRUZ','BOLIVIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SLGY','GYA','CAP DE AV EMILIO BELTRAN','GUAYARAMERIN','BOLIVIA',10,49,18,'S',-10.8216666666667,65,20,45,'U',0,427
UNION ALL SELECT 'SLJO','SJB','SAN JOAQUIN','SAN JOAQUIN','BOLIVIA',13,3,10,'S',-13.0527777777778,64,39,42,'U',0,459
UNION ALL SELECT 'SLLP','LPB','EL ALTO INTERNATIONAL','LA PAZ','BOLIVIA',16,30,47,'S',-16.5130555555556,68,11,32,'U',0,13313
UNION ALL SELECT 'SLMG','MGD','MAGDALENA','MAGDALENA','BOLIVIA',13,15,13,'S',-13.2536111111111,64,3,46,'U',0,463
UNION ALL SELECT 'SLPO','POI','CAPITAN NICOLAS ROJAS','POTOSI','BOLIVIA',19,32,36,'S',-19.5433333333333,65,43,26,'U',0,12913
UNION ALL SELECT 'SLPS','PSZ','CAP DE AV SALVADOR OGAYA G','PUERTO SUAREZ','BOLIVIA',18,58,31,'S',-18.9752777777778,57,49,14,'U',0,440
UNION ALL SELECT 'SLRI','RIB','CAP DE AV SELIN ZEITUN LOPEZ','RIBERALTA','BOLIVIA',11,0,37,'S',-11.0102777777778,66,4,24,'U',0,463
UNION ALL SELECT 'SLRQ','RBQ','RURRENABAQUE','RURRENABAQUE','BOLIVIA',14,25,42,'S',-14.4283333333333,67,30,5,'U',0,666
UNION ALL SELECT 'SLSB','SRJ','CAPITAN GERMAN QUIROGA G','SAN BORJA','BOLIVIA',14,51,27,'S',-14.8575,66,44,15,'U',0,636
UNION ALL SELECT 'SLSU','SRE','JUANA AZURDUY DE PADILLA','SUCRE','BOLIVIA',19,0,25,'S',-19.0069444444444,65,17,20,'U',0,9528
UNION ALL SELECT 'SLTJ','TJA','CAPITAN ORIEL LEA PLAZA','TARIJA','BOLIVIA',21,33,20,'S',-21.5555555555556,64,42,3,'U',0,6084
UNION ALL SELECT 'SLTR','TDD','TTE AV JORGE HENRICH ARAUZ','TRINIDAD','BOLIVIA',14,49,10,'S',-14.8194444444444,64,55,6,'U',0,509
UNION ALL SELECT 'SLVR','VVI','VIRU VIRU INTERNATIONAL','SANTA CRUZ','BOLIVIA',17,38,41,'S',-17.6447222222222,63,8,7,'U',0,1224
UNION ALL SELECT 'SLYA','BYC','','YACUIBA','BOLIVIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SMJP','PBM','JOHAN A PENGEL INTERNATIONAL','ZANDERY','SURINAM',5,27,10,'N',5.45277777777778,55,11,16,'U',0,59
UNION ALL SELECT 'SMZO','ORG','ZORG EN HOOP','PARAMARIBO','SURINAM',5,48,39,'N',5.81083333333333,55,11,26,'U',0,10
UNION ALL SELECT 'SOCA','CAY','ROCHAMBEAU','CAYENNE','FRENCH GUYANA',4,49,11,'N',4.81972222222222,52,21,37,'U',0,26
UNION ALL SELECT 'SPCL','PCL','CAP FAP DAVID AVENZUR RENGIFO','PUCALLPA','PERU',8,22,40,'S',-8.37777777777778,74,34,27,'U',0,513
UNION ALL SELECT 'SPEO','CHM','TENIENTE FAP JAIME A DE MONTR MORALES','CHIMBOTE','PERU',9,9,3,'S',-9.15083333333333,78,31,25,'U',0,70
UNION ALL SELECT 'SPGM','TGI','TINGO MARIA','TINGO MARIA','PERU',9,17,24,'S',-9.29,76,0,21,'U',0,2010
UNION ALL SELECT 'SPHI','CIX','CAPT JOSE ABELARDO QUINONES GONZALES','CHICLAYO','PERU',6,47,14,'S',-6.78722222222222,79,49,41,'U',0,95
UNION ALL SELECT 'SPHO','AYP','CORONEL FAP ALFREDO MENDIVIL DUARTE','AYACUCHO','PERU',13,9,17,'S',-13.1547222222222,74,12,15,'U',0,8917
UNION ALL SELECT 'SPHY','ANS','ANDAHUAYLAS','ANDAHUAYLAS','PERU',13,42,23,'S',-13.7063888888889,73,21,1,'U',0,11300
UNION ALL SELECT 'SPHZ','ATA','COMMANDANTE FAP GERMAN ARIAS GRAZZIANI','ANTA','PERU',9,20,50,'S',-9.34722222222222,77,35,54,'U',0,9022
UNION ALL SELECT 'SPIM','LIM','JORGE CHAVEZ INTERNATIONAL','LIMA','PERU',12,1,18,'S',-12.0216666666667,77,6,51,'U',0,113
UNION ALL SELECT 'SPJB','CJA','','CAJABAMBA','PERU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SPJI','JJI','JUANJUI','JUANJUI','PERU',7,10,10,'S',-7.16944444444445,76,43,40,'U',0,1148
UNION ALL SELECT 'SPJL','JUL','JULIACA','JULIACA','PERU',15,28,1,'S',-15.4669444444444,70,9,29,'U',0,12546
UNION ALL SELECT 'SPME','TBP','PEDRO CANGA','TUMBES','PERU',3,33,9,'S',-3.5525,80,22,51,'U',0,85
UNION ALL SELECT 'SPMS','YMS','MOISES BENZAQUEN RENGIFO','YURIMAGUAS','PERU',5,53,38,'S',-5.89388888888889,76,7,6,'U',0,587
UNION ALL SELECT 'SPPY','CHH','CHACHAPOYAS','CHACHAPOYAS','PERU',6,12,6,'S',-6.20166666666667,77,51,21,'U',0,8294
UNION ALL SELECT 'SPQT','IQT','CORONEL FAP FRANCISCO SECADA VIGNETTA','IQUITOS','PERU',3,47,5,'S',-3.78472222222222,73,18,31,'U',0,306
UNION ALL SELECT 'SPQU','AQP','RODRIGUEZ BALLON','AREQUIPA','PERU',16,20,27,'S',-16.3408333333333,71,34,59,'U',0,8505
UNION ALL SELECT 'SPRU','TRU','CAPITAN CARLOS MARTINEZ DE PINILLOS','TRUJILLO','PERU',8,5,5,'S',-8.08472222222222,79,6,34,'U',0,75
UNION ALL SELECT 'SPSO','PIO','PISCO','PISCO','PERU',13,44,41,'S',-13.7447222222222,76,13,13,'U',0,39
UNION ALL SELECT 'SPST','TPP','TARAPOTO','TARAPOTO','PERU',6,30,31,'S',-6.50861111111111,76,22,23,'U',0,900
UNION ALL SELECT 'SPTN','TCQ','CORONEL FAP CARLOS CIRIANI SANTA ROSA','TACNA','PERU',18,3,12,'S',-18.0533333333333,70,16,33,'U',0,1537
UNION ALL SELECT 'SPTU','PEM','PADRE ALDAMIZ','PUERTO MALDONADO','PERU',12,36,49,'S',-12.6136111111111,69,13,44,'U',0,659
UNION ALL SELECT 'SPUR','PIU','CAPITAN CONCHA','PIURA','PERU',5,12,20,'S',-5.20555555555556,80,36,59,'U',0,174
UNION ALL SELECT 'SPYL','TYL','CAPITAN MONTES','TALARA','PERU',4,34,35,'S',-4.57638888888889,81,15,14,'U',0,282
UNION ALL SELECT 'SPZO','CUZ','VELAZCO ASTETE','CUZCO','PERU',13,32,8,'S',-13.5355555555556,71,56,19,'U',0,10860
UNION ALL SELECT 'SUAA','MVD','ANGEL S ADAMI','MONTEVIDEO','URUGUAY',34,47,21,'S',-34.7891666666667,56,15,52,'U',0,174
UNION ALL SELECT 'SUAG','ATI','ARTIGAS INTERNATIONAL','ARTIGAS','URUGUAY',30,24,2,'S',-30.4005555555556,56,30,28,'U',0,410
UNION ALL SELECT 'SUCA','CYR','LAGUNA DE LOS PATOS INTERNATIONAL','COLONIA','URUGUAY',34,27,23,'S',-34.4563888888889,57,46,14,'U',0,66
UNION ALL SELECT 'SUMO','MLZ','CERRO LARGO','MELO','URUGUAY',32,20,16,'S',-32.3377777777778,54,13,0,'U',0,364
UNION ALL SELECT 'SUMU','MVD','CARRASCO INTERNATIONAL','MONTEVIDEO','URUGUAY',34,50,16,'S',-34.8377777777778,56,1,49,'U',0,105
UNION ALL SELECT 'SUPE','PDP','EL JAGUEL INTERNATIONAL','PUNTA DEL ESTE','URUGUAY',34,54,49,'S',-34.9136111111111,54,55,14,'U',0,66
UNION ALL SELECT 'SUPU','PDU','TYDEO LARRE BORGES INTERNATIONAL','PAYSANDU','URUGUAY',32,21,54,'S',-32.365,58,3,40,'U',0,177
UNION ALL SELECT 'SURV','RVY','RIVERA INTERNATIONAL','RIVERA','URUGUAY',30,58,28,'S',-30.9744444444444,55,28,34,'U',0,712
UNION ALL SELECT 'SUSO','STY','NUEVA HESPERIDES INTERNATIONAL','SALTO','URUGUAY',31,26,23,'S',-31.4397222222222,57,59,26,'U',0,187
UNION ALL SELECT 'SUTB','TAW','TACUAREMBO','TACUAREMBO','URUGUAY',31,44,56,'S',-31.7488888888889,55,55,32,'U',0,440
UNION ALL SELECT 'SVAC','AGV','OSWALDO GUEVARA MUJICA','ACARIGUA','VENEZUELA',9,33,12,'N',9.55333333333333,69,14,16,'U',0,640
UNION ALL SELECT 'SVAN','AAO','ANACO','ANACO','VENEZUELA',9,25,45,'N',9.42916666666667,64,28,15,'U',0,721
UNION ALL SELECT 'SVBC','BLA','GENERAL JOSE ANTONIO ANZOATEGUI INTERNATIONAL','BARCELONA','VENEZUELA',10,6,25,'N',10.1069444444444,64,41,20,'U',0,26
UNION ALL SELECT 'SVBI','BNS','BARINAS','BARINAS','VENEZUELA',8,37,10,'N',8.61944444444445,70,13,14,'U',0,666
UNION ALL SELECT 'SVBM','BRM','BARQUISIMETO INTERNATIONAL','BARQUISIMETO','VENEZUELA',10,2,33,'N',10.0425,69,21,30,'U',0,2042
UNION ALL SELECT 'SVCB','CBL','CIUDAD BOLIVAR','CIUDAD BOLIVAR','VENEZUELA',8,7,19,'N',8.12194444444444,63,32,13,'U',0,197
UNION ALL SELECT 'SVCN','CAJ','CANAIMA','CANAIMA','VENEZUELA',6,13,55,'N',6.23194444444444,62,51,15,'U',0,1450
UNION ALL SELECT 'SVCP','CUP','GENERAL JOSE FRANCISCO BERMUDEZ','CARUPANO','VENEZUELA',10,39,36,'N',10.66,63,15,42,'U',0,33
UNION ALL SELECT 'SVCR','CZE','JOSE LEONARDO CHIRINOS','CORO','VENEZUELA',11,24,53,'N',11.4147222222222,69,40,51,'U',0,52
UNION ALL SELECT 'SVCU','CUM','ANTONIO JOSE DE SUCRE','CUMANA','VENEZUELA',10,27,1,'N',10.4502777777778,64,7,49,'U',0,14
UNION ALL SELECT 'SVGI','GUI','GUIRIA','GUIRIA','VENEZUELA',10,34,26,'N',10.5738888888889,62,18,45,'U',0,42
UNION ALL SELECT 'SVGU','GUQ','GUANARE','GUANARE','VENEZUELA',9,1,37,'N',9.02694444444445,69,45,18,'U',0,606
UNION ALL SELECT 'SVJC','LSP','JOSEFA CAMEJO','PARAGUANA','VENEZUELA',11,46,51,'N',11.7808333333333,70,9,6,'U',0,75
UNION ALL SELECT 'SVLF','LFR','LA FRIA','LA FRIA','VENEZUELA',8,14,21,'N',8.23916666666667,72,16,15,'U',0,305
UNION ALL SELECT 'SVMC','MAR','LA CHINITA INTERNATIONAL','MARACAIBO','VENEZUELA',10,33,29,'N',10.5580555555556,71,43,40,'U',0,235
UNION ALL SELECT 'SVMD','MRD','ALBERTO CARNEVALLI','MERIDA','VENEZUELA',8,34,55,'N',8.58194444444444,71,9,39,'U',0,5007
UNION ALL SELECT 'SVMG','PMV','DEL CARIBE INTERNATIONAL GEN SANTAGO MARINO','PORLAMAR','VENEZUELA',10,54,45,'N',10.9125,63,57,59,'U',0,74
UNION ALL SELECT 'SVMI','CCS','SIMON BOLIVAR INTERNATIONAL','CARACAS','VENEZUELA',10,36,11,'N',10.6030555555556,66,59,26,'U',0,235
UNION ALL SELECT 'SVMT','MUN','MATURIN','MATURIN','VENEZUELA',9,44,57,'N',9.74916666666667,63,9,8,'U',0,224
UNION ALL SELECT 'SVPA','PYH','CASIQUE ARAMARE','PUERTO AYACUCHO','VENEZUELA',5,37,11,'N',5.61972222222222,67,36,21,'U',0,245
UNION ALL SELECT 'SVPC','PBL','GENERAL BARTOLOME SALOM INTERNATIONAL','PUERTO CABELLO','VENEZUELA',10,28,49,'N',10.4802777777778,68,4,22,'U',0,32
UNION ALL SELECT 'SVPR','PZO','GENERAL MANUEL CARLOS PIAR','GUAYANA','VENEZUELA',8,17,18,'N',8.28833333333333,62,45,37,'U',0,472
UNION ALL SELECT 'SVSA','SVZ','SAN ANTONIO DEL TACHIRA','SAN ANTONIO','VENEZUELA',7,51,8,'N',7.85222222222222,72,26,5,'U',0,1312
UNION ALL SELECT 'SVSO','STD','MAYOR BUENAVENTURA VIVAS','SANTO DOMINGO','VENEZUELA',7,33,54,'N',7.565,72,2,6,'U',0,1083
UNION ALL SELECT 'SVSP','SFH','SUB TENIENTE NESTOR ARIAS','SAN FELIPE','VENEZUELA',10,16,43,'N',10.2786111111111,68,45,18,'U',0,761
UNION ALL SELECT 'SVSR','SFD','SAN FERNANDO DE APURE','SAN FERNANDO DE APURE','VENEZUELA',7,52,57,'N',7.8825,67,26,37,'U',0,154
UNION ALL SELECT 'SVST','SOM','SAN TOME','SAN TOME','VENEZUELA',8,56,42,'N',8.945,64,9,3,'U',0,861
UNION ALL SELECT 'SVSZ','STB','SANTA BARBARA DEL ZULIA','SANTA BARBARA','VENEZUELA',8,58,28,'N',8.97444444444444,71,56,35,'U',0,32
UNION ALL SELECT 'SVTC','TUV','TUCUPITA','TUCUPITA','VENEZUELA',9,5,20,'N',9.08888888888889,62,5,39,'U',0,16
UNION ALL SELECT 'SVVA','VLN','ARTURO MICHELENA INTERNATIONAL','VALENCIA','VENEZUELA',10,9,29,'N',10.1580555555556,67,55,36,'U',0,1411
UNION ALL SELECT 'SVVL','VLV','DR ANTONIO NICOLAS BRICENO','VALERA','VENEZUELA',9,20,26,'N',9.34055555555556,70,35,2,'U',0,2060
UNION ALL SELECT 'SVVP','VDP','VALLE DE LA PASCUA','VALLE DE LA PASCUA','VENEZUELA',9,13,19,'N',9.22194444444444,65,59,36,'U',0,410
UNION ALL SELECT 'SYGT','GEO','','GEORGETOWN','GUYANA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'SYKM','KAR','KAMARANG','KAMARANG','GUYANA',5,51,55,'N',5.86527777777778,60,36,51,'U',0,1601
UNION ALL SELECT 'SYLT','LTM','LETHEM','LETHEM','GUYANA',3,22,21,'N',3.3725,59,47,21,'U',0,351
UNION ALL SELECT 'TAPA','ANU','V C BIRD INTERNATIONAL','ANTIGUA','LEEWARD ISLANDS',17,8,12,'N',17.1366666666667,61,47,33,'U',0,62
UNION ALL SELECT 'TBPB','BGI','GRANTLEY ADAMS INTERNATIONAL','BRIDGETOWN','BARBADOS',13,4,28,'N',13.0744444444444,59,29,32,'U',0,169
UNION ALL SELECT 'TDCF','DCF','CANEFIELD','CANEFIELD','DOMINICA',15,20,12,'N',15.3366666666667,61,23,31,'U',0,13
UNION ALL SELECT 'TDPD','DOM','MELVILLE HALL','DOMINICA','DOMINICA',15,32,49,'N',15.5469444444444,61,18,0,'U',0,73
UNION ALL SELECT 'TFFA','DSD','','DESIRADE','GUADELOUPE',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'TFFF','FDF','LE LAMENTIN','FORT-DE-FRANCE','ANTILLES',14,35,27,'N',14.5908333333333,61,0,11,'U',0,16
UNION ALL SELECT 'TFFG','SFG','GRAND CASE','ST. MARTIN','ANTILLES',18,5,59,'N',18.0997222222222,63,2,49,'U',0,7
UNION ALL SELECT 'TFFJ','SBH','GUSTAVIA/ST.BARTHEL','ST.-BARTHELEMY','ANTILLES',17,54,0,'N',17.9,62,51,0,'U',0,52
UNION ALL SELECT 'TFFR','PTP','LE RAIZET','POINTE-A-PITRE','ANTILLES',16,15,55,'N',16.2652777777778,61,31,54,'U',0,36
UNION ALL SELECT 'TGPY','GND','POINT SALINES INTERNATIONAL','POINT SALINES','GRENADA',12,0,15,'N',12.0041666666667,61,47,10,'U',0,41
UNION ALL SELECT 'TIST','STT','CYRIL E KING','ST. THOMAS','VIRGIN ISL.',18,20,14,'N',18.3372222222222,64,58,24,'U',0,23
UNION ALL SELECT 'TISX','STX','HENRY E ROHLSEN','ST. CRIOX ISLAND','VIRGIN ISL.',17,42,6,'N',17.7016666666667,64,47,54,'U',0,65
UNION ALL SELECT 'TJBQ','BQN','RAFAEL HERNANDEZ','AGUADILLA','PUERTO RICO',18,29,41,'N',18.4947222222222,67,7,46,'U',0,237
UNION ALL SELECT 'TJCG','VQS','','VIEQUES','PUERTO RICO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'TJCP','CPX','','CULEBRA','PUERTO RICO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'TJFA','FAJ','DIEGO JIMENEZ TORRES','FAJARDO','PUERTO RICO',18,18,32,'N',18.3088888888889,65,39,42,'U',0,64
UNION ALL SELECT 'TJIG','SIG','FERNANDO LUIS RIBAS DOMINICCI','SAN JUAN','PUERTO RICO',18,27,24,'N',18.4566666666667,66,5,53,'U',0,10
UNION ALL SELECT 'TJMZ','MAZ','EUGENIO MARIA DE HOSTOS','MAYAGUEZ','PUERTO RICO',18,15,20,'N',18.2555555555556,67,8,54,'U',0,28
UNION ALL SELECT 'TJNR','NRR','ROOSEVELT ROADS NS','ROOSEVELT ROADS','PUERTO RICO',18,14,42,'N',18.245,65,38,36,'U',0,38
UNION ALL SELECT 'TJPS','PSE','MERCEDITA','PONCE','PUERTO RICO',18,0,29,'N',18.0080555555556,66,33,46,'U',0,26
UNION ALL SELECT 'TJSJ','SJU','LUIS MUNOZ MARIN INTERNATIONAL','SAN JUAN','PUERTO RICO',18,26,21,'N',18.4391666666667,66,0,6,'U',0,9
UNION ALL SELECT 'TKPK','SKB','ROBERT L BRADSHAW','BASSE TERRE','ST. KITTS & NEVIS',17,18,40,'N',17.3111111111111,62,43,7,'U',0,170
UNION ALL SELECT 'TLPC','SLU','GEORGE F L CHARLES','CASTRIES','ST. LUCIA ISLAND',14,1,12,'N',14.02,60,59,34,'U',0,22
UNION ALL SELECT 'TLPL','UVF','HEWANORRA INTERNATIONAL','HEWANDORRA','ST. LUCIA ISLAND',13,43,59,'N',13.7330555555556,60,57,9,'U',0,14
UNION ALL SELECT 'TNCA','AUA','REINA BEATRIX INTERNATIONAL','ORANJESTAD','ARUBA',12,30,5,'N',12.5013888888889,70,0,54,'U',0,60
UNION ALL SELECT 'TNCB','BON','FLAMINGO','KRALENDIJK','ANTILLES',12,7,51,'N',12.1308333333333,68,16,6,'U',0,20
UNION ALL SELECT 'TNCC','CUR','HATO','WILLEMSTAD','ANTILLES',12,11,19,'N',12.1886111111111,68,57,35,'U',0,30
UNION ALL SELECT 'TNCE','EUX','F D ROOSEVELT','ORANJESTAD','ANTILLES',17,29,47,'N',17.4963888888889,62,58,45,'U',0,129
UNION ALL SELECT 'TNCM','SXM','PRINCESS JULIANA INTERNATIONAL','PHILIPSBURG','ANTILLES',18,2,27,'N',18.0408333333333,63,6,32,'U',0,13
UNION ALL SELECT 'TNCS','SAB','','SABA','ANTILLES',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'TQPF','AXA','WALLBLAKE','THE VALLEY','ANGUILLA ISL.',18,12,17,'N',18.2047222222222,63,3,18,'U',0,102
UNION ALL SELECT 'TRPM','MNI','SANTEE COOPER RGNL','PLYMOUTH','MONTSERRAT ISLAND',33,35,13,'N',33.5869444444444,80,12,31,'U',0,103
UNION ALL SELECT 'TTCP','TAB','CROWN POINT','SCARBOROUGH','TRINIDAD & TOBAGO',11,8,58,'N',11.1494444444444,60,49,55,'U',0,36
UNION ALL SELECT 'TTPP','POS','PIARCO','PORT-OF-SPAIN','TRINIDAD & TOBAGO',10,35,43,'N',10.5952777777778,61,20,14,'U',0,57
UNION ALL SELECT 'TTPS','POS','','PORT-OF-SPAIN','TRINIDAD & TOBAGO',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'TUPJ','EIS','TERRANCE B LETTSOME INTERNATIONAL','ROADTOWN/BEEF ISLAND','VIRGIN ISL.',18,26,41,'N',18.4447222222222,64,32,34,'U',0,15
UNION ALL SELECT 'TUPW','VIJ','','VIRGIN GORDA','VIRGIN ISL.',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'TVSC','CIW','CANOUAN','CANOUAN ISLAND','ST.VINCENT/GRENADINES',12,41,56,'N',12.6988888888889,61,20,32,'U',0,16
UNION ALL SELECT 'TVSM','MQS','MUSTIQUE','MUSTIQUE','ST.VINCENT/GRENADINES',12,53,15,'N',12.8875,61,10,48,'U',0,5
UNION ALL SELECT 'TVSU','UNI','','UNION ISLAND','ST.VINCENT/GRENADINES',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'TVSV','SVD','E T JOSHUA','KINGSTOWN','ST.VINCENT/GRENADINES',13,8,39,'N',13.1441666666667,61,12,39,'U',0,66
UNION ALL SELECT 'UAAA','ALA','ALMATY','ALMA-ATA','KAZAKHSTAN',43,21,7,'N',43.3519444444444,77,2,25,'E',77.0402777777778,2233
UNION ALL SELECT 'UACC','TSE','ASTANA','TSELINOGRAD','RUSSIA',51,1,20,'N',51.0222222222222,71,28,2,'E',71.4672222222222,1165
UNION ALL SELECT 'UADD','DMB','','DZHAMBUL','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UAFM','FRU','MANAS','BISHKEK','RUSSIA',43,3,42,'N',43.0616666666667,74,28,42,'E',74.4783333333333,2090
UNION ALL SELECT 'UAFO','OSS','OSH','OSH','RUSSIA',40,36,32,'N',40.6088888888889,72,47,35,'E',72.7930555555556,2927
UNION ALL SELECT 'UAGZ','GUW','','GURYEV','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UAII','CIT','SHYMKENT','CHIMKENT','RUSSIA',42,21,52,'N',42.3644444444444,69,28,45,'E',69.4791666666667,1385
UNION ALL SELECT 'UAKD','DZH','ZHEZKAZGAN','DZHEZKAZGAN','RUSSIA',47,42,30,'N',47.7083333333333,67,44,0,'E',67.7333333333333,1250
UNION ALL SELECT 'UARR','URA','URALSK','URALSK','RUSSIA',51,9,6,'N',51.1516666666667,51,32,44,'E',51.5455555555556,125
UNION ALL SELECT 'UASP','PWQ','','PAVLODAR','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UASS','PLX','SEMIPALATINSK','SEMIPLATINSK','RUSSIA',50,21,4,'N',50.3511111111111,80,14,3,'E',80.2341666666667,761
UNION ALL SELECT 'UATT','AKX','AKTYUBINSK','AKTYUBINSK','RUSSIA',50,14,42,'N',50.245,57,12,12,'E',57.2033333333333,738
UNION ALL SELECT 'UAUU','KTQ','KOSTANAY','KUSTANAY','RUSSIA',53,12,23,'N',53.2063888888889,63,33,3,'E',63.5508333333333,596
UNION ALL SELECT 'UBBB','BAK','BINA','BAKU','RUSSIA',40,28,3,'N',40.4675,50,2,48,'E',50.0466666666667,10
UNION ALL SELECT 'UEEA','ADH','ADA MUNI','ALDAN','RUSSIA',34,48,15,'N',34.8041666666667,96,40,16,'U',0,1016
UNION ALL SELECT 'UEEE','YKS','YAKUTSK','YAKUTSK','RUSSIA',62,5,35,'N',62.0930555555556,129,46,14,'E',129.770555555556,325
UNION ALL SELECT 'UGEE','EVN','ZVARTNOTS','YEREVAN','RUSSIA',40,8,54,'N',40.1483333333333,44,23,48,'E',44.3966666666667,2838
UNION ALL SELECT 'UGGG','TBS','LOCHINI','TBILISI','GEORGIA',41,40,9,'N',41.6691666666667,44,57,17,'E',44.9547222222222,1624
UNION ALL SELECT 'UGSS','SUI','SUKHUMI DRANDA','SUKHUMI','GEORGIA',42,51,29,'N',42.8580555555556,41,7,41,'E',41.1280555555556,53
UNION ALL SELECT 'UHBB','BQS','IGNATYEVO','BLAGOVESCHENSK','RUSSIA',50,25,18,'N',50.4216666666667,127,24,36,'E',127.41,640
UNION ALL SELECT 'UHHH','KHV','NOVY','KHABAROVSK','RUSSIA',48,31,40,'N',48.5277777777778,135,11,18,'E',135.188333333333,246
UNION ALL SELECT 'UHMD','PVS','PROVIDENIYA BAY','PROVIDENIYA BAY','RUSSIA',64,22,48,'N',64.38,173,14,48,'U',0,71
UNION ALL SELECT 'UHMM','GDX','SOKOL','MAGADAN','RUSSIA',59,54,36,'N',59.91,150,43,0,'E',150.716666666667,574
UNION ALL SELECT 'UHPP','PKC','YELIZOVO','PETROPAVLOVSK','RUSSIA',53,9,59,'N',53.1663888888889,158,27,10,'E',158.452777777778,131
UNION ALL SELECT 'UHSS','UUS','KHOMUTOVO','YUZHNO-SAKHALINSK','RUSSIA',46,53,19,'N',46.8886111111111,142,43,2,'E',142.717222222222,59
UNION ALL SELECT 'UHWW','VVO','KNEVICHI','VLADIVOSTOK','RUSSIA',43,23,56,'N',43.3988888888889,132,9,5,'E',132.151388888889,43
UNION ALL SELECT 'UIAA','HTA','KADALA','CHITA','RUSSIA',52,1,34,'N',52.0261111111111,113,18,18,'E',113.305,2270
UNION ALL SELECT 'UIBB','BTK','BRATSK','BRATSK','RUSSIA',56,22,15,'N',56.3708333333333,101,41,55,'E',101.698611111111,1611
UNION ALL SELECT 'UIII','IKT','IRKUTSK','IRKUTSK','RUSSIA',52,16,1,'N',52.2669444444444,104,23,41,'E',104.394722222222,1673
UNION ALL SELECT 'UIUU','UUD','MUKHINO','ULAN-UDE','RUSSIA',51,48,24,'N',51.8066666666667,107,26,17,'E',107.438055555556,1690
UNION ALL SELECT 'UKBB','KBP','BORYSPIL','KIEV','RUSSIA',50,20,42,'N',50.345,30,53,42,'E',30.895,427
UNION ALL SELECT 'UKCC','DOK','DONETSK','DONETSK','RUSSIA',48,4,24,'N',48.0733333333333,37,44,24,'E',37.74,791
UNION ALL SELECT 'UKDD','DNK','DNIPROPETROVSK','DNEPROPETROVSK','RUSSIA',48,21,24,'N',48.3566666666667,35,6,6,'E',35.1016666666667,481
UNION ALL SELECT 'UKFF','SIP','SIMFEROPOL','SIMFEROPOL','RUSSIA',45,2,19,'N',45.0386111111111,33,58,59,'E',33.9830555555556,639
UNION ALL SELECT 'UKII','KIV','','KISHINEV','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UKKG','KGO','KIROVOGRAD','KIROVOGRAD','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UKKK','IEV','ZHULIANY','KIEV','RUSSIA',50,24,6,'N',50.4016666666667,30,27,6,'E',30.4516666666667,587
UNION ALL SELECT 'UKLL','LWO','LVIV','LVOV','RUSSIA',49,48,45,'N',49.8125,23,57,22,'E',23.9561111111111,1073
UNION ALL SELECT 'UKOO','ODS','ODESA','ODESSA','RUSSIA',46,25,37,'N',46.4269444444444,30,40,41,'E',30.6780555555556,171
UNION ALL SELECT 'ULLI','LED','PULKOVO','ST. PETERSBURG','RUSSIA',59,48,0,'N',59.8,30,15,54,'E',30.265,79
UNION ALL SELECT 'ULMM','MMK','MURMANSK','MURMANSK','RUSSIA',68,46,54,'N',68.7816666666667,32,45,2,'E',32.7505555555556,266
UNION ALL SELECT 'ULTT','TLL','','TALLINN','ESTONIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UMGG','GME','GOMEL','GOMEL','RUSSIA',52,31,37,'N',52.5269444444444,31,1,0,'E',31.0166666666667,472
UNION ALL SELECT 'UMII','VTB','VITEBSK','VITEBSK','RUSSIA',55,10,0,'N',55.1666666666667,30,8,0,'E',30.1333333333333,151
UNION ALL SELECT 'UMKK','KGD','KHRABROVO','KALININGRAD','RUSSIA',54,53,24,'N',54.89,20,35,33,'E',20.5925,43
UNION ALL SELECT 'UMMM','MHP','MINSK 1','MINSK','RUSSIA',53,51,52,'N',53.8644444444444,27,32,22,'E',27.5394444444444,749
UNION ALL SELECT 'UMMS','MSQ','MINSK 2','MINSK 2','RUSSIA',53,52,56,'N',53.8822222222222,28,1,50,'E',28.0305555555556,669
UNION ALL SELECT 'UMRR','RIX','','RIGA','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UMWW','VNO','','VILNIUS','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UNAA','ABA','ABAKAN','ABAKAN','RUSSIA',53,44,24,'N',53.74,91,23,6,'E',91.385,831
UNION ALL SELECT 'UNBB','BAX','BARNAUL','BARNAUL','RUSSIA',53,21,50,'N',53.3638888888889,83,32,31,'E',83.5419444444444,837
UNION ALL SELECT 'UNEE','KEJ','KEMEROVO','KEMOROVO','RUSSIA',55,16,11,'N',55.2697222222222,86,6,25,'E',86.1069444444444,863
UNION ALL SELECT 'UNKK','KJA','','KRASNOYARSK','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UNKY','KYZ','','KYZYL','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UNNN','OVB','','NOVOSIBIRSK','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UNOO','OMS','TSENTRALNY','OMSK','RUSSIA',54,58,1,'N',54.9669444444444,73,18,36,'E',73.31,312
UNION ALL SELECT 'UNWW','NOZ','','NOVOKUZNETSK','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'URKK','KRR','PASHKOVSKY','KRASNODAR','RUSSIA',45,2,6,'N',45.035,39,10,18,'E',39.1716666666667,118
UNION ALL SELECT 'URML','MCX','UYTASH','MAKHACHKALA','RUSSIA',42,49,0,'N',42.8166666666667,47,39,8,'E',47.6522222222222,13
UNION ALL SELECT 'URMM','MRV','MINERALNYYE VODY','MINERALNYE VODY','RUSSIA',44,13,30,'N',44.225,43,4,54,'E',43.0816666666667,1053
UNION ALL SELECT 'URMT','STW','SHPAKOVSKOYE','STAVROPOL','RUSSIA',45,6,33,'N',45.1091666666667,42,6,46,'E',42.1127777777778,1486
UNION ALL SELECT 'URRR','ROV','ROSTOV NA DONU','ROSTOV','RUSSIA',47,15,29,'N',47.2580555555556,39,49,4,'E',39.8177777777778,279
UNION ALL SELECT 'URSS','AER','SOCHI','SOCHI','RUSSIA',43,26,45,'N',43.4458333333333,39,56,51,'E',39.9475,89
UNION ALL SELECT 'URWA','ASF','ASTRAKHAN','ASTRAKHAN','RUSSIA',46,17,0,'N',46.2833333333333,48,0,22,'E',48.0061111111111,65
UNION ALL SELECT 'URWW','VOG','GUMRAK','VOLGOGRAD','RUSSIA',48,46,56,'N',48.7822222222222,44,20,41,'E',44.3447222222222,482
UNION ALL SELECT 'USCC','CEK','BALANDINO','CHELYABINSK','RUSSIA',55,18,12,'N',55.3033333333333,61,30,24,'E',61.5066666666667,769
UNION ALL SELECT 'USCM','MQF','MAGNITOGORSK','MAGNETIOGORSK','RUSSIA',53,23,36,'N',53.3933333333333,58,45,36,'E',58.76,1430
UNION ALL SELECT 'USKK','KVX','','KIROV','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'USNN','NJC','NIZHNEVARTOVSK','NIZHNEVARTOVSK','RUSSIA',60,57,0,'N',60.95,76,28,0,'E',76.4666666666667,0
UNION ALL SELECT 'USPP','PEE','BOLSHOYE SAVINO','PERM','RUSSIA',57,55,0,'N',57.9166666666667,56,1,32,'E',56.0255555555556,404
UNION ALL SELECT 'USRR','SGC','SURGUT','SURGUT','RUSSIA',61,15,0,'N',61.25,73,30,0,'E',73.5,200
UNION ALL SELECT 'USSS','SVX','KOLTSOVO','SVERDLOVSK','RUSSIA',56,44,29,'N',56.7413888888889,60,48,13,'E',60.8036111111111,764
UNION ALL SELECT 'USTO','TOX','CABOOL MEM','TOBOLSK','RUSSIA',37,7,56,'N',37.1322222222222,92,5,2,'U',0,1220
UNION ALL SELECT 'USUU','KRO','KURGAN','KURGAN','RUSSIA',55,28,30,'N',55.475,65,24,53,'E',65.4147222222222,250
UNION ALL SELECT 'UTAA','ASB','ASHGABAT','ASHKHABAD','RUSSIA',37,59,30,'N',37.9916666666667,58,21,48,'E',58.3633333333333,692
UNION ALL SELECT 'UTAK','KRW','TURKMENBASHI AIRPORT','KRASNOVODSK','RUSSIA',40,2,0,'N',40.0333333333333,52,59,0,'E',52.9833333333333,0
UNION ALL SELECT 'UTDD','DYU','DUSHANBE','DUSHANBE','RUSSIA',38,32,36,'N',38.5433333333333,68,49,30,'E',68.825,2575
) x (ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LatDec],[LongDeg],[LongMin],[LongSec],[LongDir],[LongDec],[Altitude])
LEFT OUTER JOIN Airports a ON a.IATA_Code = x.IATA_Code
--WHERE x.[LatDir] <> 'U' and x.[LongDir] <> 'U' and x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE n=1
GO

INSERT INTO Airports (ICAO_Code, IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir
    ,LongDeg, LongMin, LongSec, LongDir, Altitude)
SELECT ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LongDeg],[LongMin],[LongSec],[LongDir],[Altitude]
FROM (
SELECT x.ICAO_Code,x.IATA_Code,x.[Name],x.[City],x.[Country],x.[LatDeg],x.[LatMin],x.[LatSec],x.[LatDir]
	,x.[LatDec],x.[LongDeg],x.[LongMin],x.[LongSec],x.[LongDir],x.[LongDec],x.[Altitude]
    ,n=ROW_NUMBER() OVER (PARTITION BY x.IATA_Code ORDER BY (SELECT NULL))
FROM (
SELECT 'UTNN','NCU','NUKUS','NUKUS','RUSSIA',42,29,11,'N',42.4863888888889,59,37,21,'E',59.6225,160
UNION ALL SELECT 'UTSB','BHK','BUKHARA','BUKHARA','RUSSIA',39,46,30,'N',39.775,64,28,48,'E',64.48,751
UNION ALL SELECT 'UTSS','SKD','SAMARKAND','SAMARKAND','RUSSIA',39,42,2,'N',39.7005555555556,66,59,5,'E',66.9847222222222,2224
UNION ALL SELECT 'UTTT','TAS','YUZHNY','TASHKENT','UZBEKISTAN',41,15,26,'N',41.2572222222222,69,16,54,'E',69.2816666666667,1414
UNION ALL SELECT 'UUBP','BZK','BRYANSK','BRYANSK','RUSSIA',53,12,51,'N',53.2141666666667,34,10,35,'E',34.1763888888889,663
UNION ALL SELECT 'UUEE','SVO','SHEREMETYEVO','MOSCOW','RUSSIA',55,58,18,'N',55.9716666666667,37,24,54,'E',37.415,630
UNION ALL SELECT 'UUEM','KLD','MIGALOVO','TVER','RUSSIA',56,49,29,'N',56.8247222222222,35,45,27,'E',35.7575,469
UNION ALL SELECT 'UUOO','VOZ','CHERTOVITSKOYE','VORONEZH','RUSSIA',51,48,51,'N',51.8141666666667,39,13,47,'E',39.2297222222222,514
UNION ALL SELECT 'UUWW','VKO','VNUKOVO','MOSCOW','RUSSIA',55,35,29,'N',55.5913888888889,37,15,41,'E',37.2613888888889,686
UNION ALL SELECT 'UUYH','UCT','','UKHTA','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UUYW','VKT','','VORKUTA','RUSSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'UUYY','SCW','SYKTYVKAR','SYKTYVKAR','RUSSIA',61,38,51,'N',61.6475,50,50,44,'E',50.8455555555556,342
UNION ALL SELECT 'UWKD','KZN','KAZAN','KAZAN','RUSSIA',55,36,28,'N',55.6077777777778,49,16,38,'E',49.2772222222222,414
UNION ALL SELECT 'UWOO','REN','ORENBURG','ORENBURG','RUSSIA',51,47,44,'N',51.7955555555556,55,27,24,'E',55.4566666666667,387
UNION ALL SELECT 'UWPP','PEZ','PLEASANTON MUNI','PENZA','RUSSIA',28,57,15,'N',28.9541666666667,98,31,11,'U',0,430
UNION ALL SELECT 'UWUU','UFA','UFA','UFA','RUSSIA',54,33,27,'N',54.5575,55,52,27,'E',55.8741666666667,449
UNION ALL SELECT 'UWWW','KBY','KURUMOCH','SAMARA','RUSSIA',53,30,19,'N',53.5052777777778,50,9,52,'E',50.1644444444444,476
UNION ALL SELECT 'VAAH','AMD','AHMEDABAD','AHMEDABAD','INDIA',23,4,29,'N',23.0747222222222,72,37,54,'E',72.6316666666667,189
UNION ALL SELECT 'VAAK','AKD','AKOLA','AKOLA','INDIA',20,41,56,'N',20.6988888888889,77,3,23,'E',77.0563888888889,1000
UNION ALL SELECT 'VAAU','IXU','AURANGABAD','AURANGABAD','INDIA',19,51,47,'N',19.8630555555556,75,23,53,'E',75.3980555555556,1911
UNION ALL SELECT 'VABB','BOM','CHHATRAPATI SHIVAJI INTERNATIONAL','BOMBAY','INDIA',19,5,19,'N',19.0886111111111,72,52,4,'E',72.8677777777778,38
UNION ALL SELECT 'VABI','PAB','BILASPUR','BILASPUR','INDIA',21,59,19,'N',21.9886111111111,82,6,40,'E',82.1111111111111,899
UNION ALL SELECT 'VABJ','BHJ','BHUJ','BHUJ','INDIA',23,17,16,'N',23.2877777777778,69,40,12,'E',69.67,268
UNION ALL SELECT 'VABM','IXG','BELGAUM','BELGAUM','INDIA',15,51,33,'N',15.8591666666667,74,37,5,'E',74.6180555555555,2488
UNION ALL SELECT 'VABO','BDQ','VADODARA','BARODA','INDIA',22,20,10,'N',22.3361111111111,73,13,34,'E',73.2261111111111,127
UNION ALL SELECT 'VABP','BHO','BHOPAL','BHOPAL','INDIA',23,17,6,'N',23.285,77,20,14,'E',77.3372222222222,1716
UNION ALL SELECT 'VABV','BHU','BHAVNAGAR','BHAUNAGAR','INDIA',21,45,7,'N',21.7519444444444,72,11,6,'E',72.185,38
UNION ALL SELECT 'VADN','NMB','DAMAN','DAMAN','INDIA',20,26,6,'N',20.435,72,50,37,'E',72.8436111111111,33
UNION ALL SELECT 'VAGO','GOI','GOA','GOA','INDIA',15,22,50,'N',15.3805555555556,73,49,59,'E',73.8330555555555,184
UNION ALL SELECT 'VAID','IDR','DEVI AHILYABAI HOLKAR','INDORE','INDIA',22,43,18,'N',22.7216666666667,75,48,3,'E',75.8008333333333,1849
UNION ALL SELECT 'VAJB','JLR','JABALPUR','JABALPUR','INDIA',23,10,40,'N',23.1777777777778,80,3,7,'E',80.0519444444444,1624
UNION ALL SELECT 'VAJM','JGA','JAMNAGAR','JAMNAGAR','INDIA',22,27,59,'N',22.4663888888889,70,0,41,'E',70.0113888888889,69
UNION ALL SELECT 'VAKE','IXY','KANDLA','KANDLA','INDIA',23,6,45,'N',23.1125,70,6,1,'E',70.1002777777778,95
UNION ALL SELECT 'VAKJ','HJR','KHAJURAHO','KHAJURAHO','INDIA',24,49,10,'N',24.8194444444444,79,55,9,'E',79.9191666666667,712
UNION ALL SELECT 'VAKP','KLH','KOLHAPUR','KOLHAPUR','INDIA',16,39,50,'N',16.6638888888889,74,17,17,'E',74.2880555555556,1992
UNION ALL SELECT 'VAKS','IXK','KESHOD','KESHOD','INDIA',21,19,0,'N',21.3166666666667,70,16,12,'E',70.27,162
UNION ALL SELECT 'VAND','NDC','','NANDED','INDIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VANP','NAG','NAGPUR','NAGPUR','INDIA',21,5,31,'N',21.0919444444444,79,2,49,'E',79.0469444444444,1012
UNION ALL SELECT 'VANR','ISK','NASIK ROAD','NASIK ROAD','INDIA',19,57,45,'N',19.9625,73,48,25,'E',73.8069444444444,1959
UNION ALL SELECT 'VAPO','PNQ','PUNE','PUNE','INDIA',18,34,55,'N',18.5819444444444,73,55,10,'E',73.9194444444445,1942
UNION ALL SELECT 'VAPR','PBD','PORBANDAR','PORBANDAR','INDIA',21,38,58,'N',21.6494444444444,69,39,23,'E',69.6563888888889,17
UNION ALL SELECT 'VARK','RAJ','RAJKOT','RAJKOT','INDIA',22,18,33,'N',22.3091666666667,70,46,46,'E',70.7794444444444,440
UNION ALL SELECT 'VARP','RPR','RAIPUR','RAIPUR','INDIA',21,10,49,'N',21.1802777777778,81,44,19,'E',81.7386111111111,1042
UNION ALL SELECT 'VASL','SSE','SHOLAPUR','SHOLAPUR','INDIA',17,37,40,'N',17.6277777777778,75,56,5,'E',75.9347222222222,1578
UNION ALL SELECT 'VASU','STV','SURAT','SURAT','INDIA',21,6,54,'N',21.115,72,44,34,'E',72.7427777777778,50
UNION ALL SELECT 'VAUD','UDR','UDAIPUR','UDAIPUR','INDIA',24,37,3,'N',24.6175,73,54,46,'E',73.9127777777778,1670
UNION ALL SELECT 'VCBI','CMB','BANDARANAIKE INTERNATIONAL','COLOMBO','SRI LANKA',7,10,52,'N',7.18111111111111,79,53,1,'E',79.8836111111111,29
UNION ALL SELECT 'VCCC','RML','COLOMBO RATMALANA','COLOMBO','SRI LANKA',6,49,19,'N',6.82194444444444,79,53,10,'E',79.8861111111111,22
UNION ALL SELECT 'VCCG','GOY','AMPARAI','GALOYA','SRI LANKA',7,20,15,'N',7.3375,81,37,32,'E',81.6255555555556,150
UNION ALL SELECT 'VCCJ','JAF','KANKESANTURAI','JAFFNA','SRI LANKA',9,47,32,'N',9.79222222222222,80,4,12,'E',80.07,33
UNION ALL SELECT 'VCCT','TRR','CHINA BAY','TRINCIOMALEE','SRI LANKA',8,32,20,'N',8.53888888888889,81,10,53,'E',81.1813888888889,6
UNION ALL SELECT 'VDPP','PNH','POCHENTONG INTERNATIONAL','PHNOM-PENH','CAMBODIA',11,32,47,'N',11.5463888888889,104,50,38,'E',104.843888888889,40
UNION ALL SELECT 'VDSR','REP','SIEM REAP','SIEM-REAP','CAMBODIA',13,24,38,'N',13.4105555555556,103,48,46,'E',103.812777777778,60
UNION ALL SELECT 'VEAT','IXA','AGARTALA','AGARTALA','INDIA',23,53,20,'N',23.8888888888889,91,14,27,'E',91.2408333333333,48
UNION ALL SELECT 'VEAZ','AJL','AIZAWL','AIZWAL','INDIA',23,44,46,'N',23.7461111111111,92,48,11,'E',92.8030555555556,1001
UNION ALL SELECT 'VEBD','IXB','BAGDOGRA','BAGHDOGRA','INDIA',26,40,53,'N',26.6813888888889,88,19,41,'E',88.3280555555556,412
UNION ALL SELECT 'VEBG','RGH','BALURGHAT','BALURGHAT','INDIA',25,15,39,'N',25.2608333333333,88,47,44,'E',88.7955555555556,79
UNION ALL SELECT 'VEBS','BBI','BHUBANESHWAR','BHUBANESWAR','INDIA',20,14,39,'N',20.2441666666667,85,49,4,'E',85.8177777777778,130
UNION ALL SELECT 'VECC','CCU','NETAJI SUBHASH CHANDRA BOSE INTERNATIONAL','CALCUTTA','INDIA',22,39,17,'N',22.6547222222222,88,26,48,'E',88.4466666666667,20
UNION ALL SELECT 'VECO','COH','COOCH BEHAR','COOCH-BEHAR','INDIA',26,19,49,'N',26.3302777777778,89,28,1,'E',89.4669444444445,138
UNION ALL SELECT 'VECX','CBD','','CAR NICOBAR','INDIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VEDB','DBO','DHANBAD','DHANBAD','INDIA',23,50,2,'N',23.8338888888889,86,25,30,'E',86.425,847
UNION ALL SELECT 'VEGK','YOP','GORAKHPUR','GORAKHPUR','INDIA',26,44,22,'N',26.7394444444444,83,26,58,'E',83.4494444444445,259
UNION ALL SELECT 'VEGY','GAY','GAYA','GAYA','INDIA',24,44,53,'N',24.7480555555556,84,56,33,'E',84.9425,377
UNION ALL SELECT 'VEIM','IMF','IMPHAL','IMPHAL','INDIA',24,45,35,'N',24.7597222222222,93,53,49,'E',93.8969444444445,2542
UNION ALL SELECT 'VEJS','IXW','JAMSHEDPUR','JAMSHEDPUR','INDIA',22,48,43,'N',22.8119444444444,86,10,3,'E',86.1675,475
UNION ALL SELECT 'VEJT','JRH','JORHAT','JORHAT','INDIA',26,43,50,'N',26.7305555555556,94,10,32,'E',94.1755555555556,284
UNION ALL SELECT 'VEKR','IXH','KAILASHAHAR','KAILASHAHAR','INDIA',24,18,30,'N',24.3083333333333,92,0,27,'E',92.0075,79
UNION ALL SELECT 'VEKU','IXS','SILCHAR','SILCHAR','INDIA',24,54,46,'N',24.9127777777778,92,58,43,'E',92.9786111111111,352
UNION ALL SELECT 'VELR','IXI','LILABARI','LILABARI','INDIA',27,17,26,'N',27.2905555555556,94,5,48,'E',94.0966666666667,329
UNION ALL SELECT 'VEMH','LDA','','MALDA','INDIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VEMN','MOH','DIBRUGARH','MOHANBARI','INDIA',27,29,0,'N',27.4833333333333,95,1,3,'E',95.0175,361
UNION ALL SELECT 'VEPG','IXT','PASIGHAT','PASIGHAT','INDIA',28,3,58,'N',28.0661111111111,95,20,8,'E',95.3355555555555,513
UNION ALL SELECT 'VEPT','PAT','PATNA','PATINA','INDIA',25,35,26,'N',25.5905555555556,85,5,16,'E',85.0877777777778,169
UNION ALL SELECT 'VERC','IXR','BIRSA MUNDA','RANCHI','INDIA',23,18,53,'N',23.3147222222222,85,19,17,'E',85.3213888888889,2146
UNION ALL SELECT 'VERK','RRK','ROURKELA','ROURKELA','INDIA',22,15,23,'N',22.2563888888889,84,48,52,'E',84.8144444444444,659
UNION ALL SELECT 'VETJ','TEI','','TEZU','INDIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VEVZ','VTZ','VISHAKHAPATNAM','VISHAKHAPATNAM','INDIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VGCB','CXB','COXS BAZAR','COX''S BAZAR','BANGLADESH',21,27,7,'N',21.4519444444444,91,57,51,'E',91.9641666666667,12
UNION ALL SELECT 'VGEG','CGP','SHAH AMANAT INTERNATIONAL','CHITTAGONG','BANGLADESH',22,14,58,'N',22.2494444444444,91,48,47,'E',91.8130555555556,12
UNION ALL SELECT 'VGIS','IRD','ISHURDI','ISHURDI','BANGLADESH',24,9,9,'N',24.1525,89,2,58,'E',89.0494444444444,45
UNION ALL SELECT 'VGJR','JSR','JESSORE','JESSORE','BANGLADESH',23,11,1,'N',23.1836111111111,89,9,39,'E',89.1608333333333,20
UNION ALL SELECT 'VGRJ','RJH','RAJSHAHI','RAJSHAHI','BANGLADESH',24,26,13,'N',24.4369444444444,88,36,59,'E',88.6163888888889,55
UNION ALL SELECT 'VGSD','SPD','SAIDPUR','SAIDPUR','BANGLADESH',25,45,33,'N',25.7591666666667,88,54,31,'E',88.9086111111111,125
UNION ALL SELECT 'VGSY','ZYL','OSMANY INTERNATIONAL','SYLHET OSMANI','BANGLADESH',24,57,46,'N',24.9627777777778,91,52,2,'E',91.8672222222222,50
UNION ALL SELECT 'VGZR','DAC','ZIA INTERNATIONAL','DHAKA','BANGLADESH',23,50,36,'N',23.8433333333333,90,23,52,'E',90.3977777777778,27
UNION ALL SELECT 'VHHH','HKG','HONG KONG INTERNATIONAL','HONG KONG','HONG KONG',22,18,32,'N',22.3088888888889,113,54,52,'E',113.914444444444,28
UNION ALL SELECT 'VIAG','AGR','AGRA','AGRA','INDIA',27,9,20,'N',27.1555555555556,77,57,39,'E',77.9608333333333,551
UNION ALL SELECT 'VIAL','IXD','ALLAHABAD','ALLAHABAD','INDIA',25,26,20,'N',25.4388888888889,81,44,3,'E',81.7341666666667,322
UNION ALL SELECT 'VIAR','ATQ','AMRITSAR','AMRITSAR','INDIA',31,42,27,'N',31.7075,74,47,57,'E',74.7991666666667,755
UNION ALL SELECT 'VIBN','VNS','VARANASI','VARANASI','INDIA',25,27,7,'N',25.4519444444444,82,51,32,'E',82.8588888888889,264
UNION ALL SELECT 'VIBR','KUU','KULLU MANALI','KULU','INDIA',31,52,54,'N',31.8816666666667,77,11,4,'E',77.1844444444445,3557
UNION ALL SELECT 'VICG','IXC','CHANDIGARH','CHANDIGARH','INDIA',30,40,24,'N',30.6733333333333,76,47,18,'E',76.7883333333333,1012
UNION ALL SELECT 'VIDN','DED','DEHRADUN','DEHRA DUN','INDIA',30,11,14,'N',30.1872222222222,78,10,48,'E',78.18,1805
UNION ALL SELECT 'VIDP','DEL','INDIRA GANDHI INTERNATIONAL','DELHI','INDIA',28,33,59,'N',28.5663888888889,77,6,11,'E',77.1030555555556,777
UNION ALL SELECT 'VIGR','GWL','GWALIOR','GWALIOR','INDIA',26,17,38,'N',26.2938888888889,78,13,39,'E',78.2275,617
UNION ALL SELECT 'VIJO','JOH','JODHPUR','JODHPUR','INDIA',26,15,5,'N',26.2513888888889,73,2,53,'E',73.0480555555555,717
UNION ALL SELECT 'VIJP','JAI','JAIPUR','JAIPUR','INDIA',26,49,26,'N',26.8238888888889,75,48,35,'E',75.8097222222222,1263
UNION ALL SELECT 'VIJR','JSA','JAISALMER','JAISALMER','INDIA',26,53,21,'N',26.8891666666667,70,51,52,'E',70.8644444444444,887
UNION ALL SELECT 'VIJU','IXJ','JAMMU','JAMMU','INDIA',32,41,23,'N',32.6897222222222,74,50,17,'E',74.8380555555556,1029
UNION ALL SELECT 'VIKA','KNU','KANPUR','KANPUR','INDIA',26,26,28,'N',26.4411111111111,80,21,48,'E',80.3633333333333,410
UNION ALL SELECT 'VIKO','KTU','KOTA','KOTA','INDIA',25,9,38,'N',25.1605555555556,75,50,41,'E',75.8447222222222,896
UNION ALL SELECT 'VILD','LUH','LUDHIANA','LUDHIAHA','INDIA',30,51,16,'N',30.8544444444444,75,57,4,'E',75.9511111111111,834
UNION ALL SELECT 'VILH','IXL','LEH','LEH','INDIA',34,8,8,'N',34.1355555555556,77,32,44,'E',77.5455555555556,10682
UNION ALL SELECT 'VILK','LKO','LUCKNOW','LUCKNOW','INDIA',26,45,38,'N',26.7605555555556,80,53,11,'E',80.8863888888889,402
UNION ALL SELECT 'VIPK','IXP','PATHANKOT','PATHANKOT','INDIA',32,14,1,'N',32.2336111111111,75,38,4,'E',75.6344444444445,1017
UNION ALL SELECT 'VIPT','PGH','PANTNAGAR','NAINITAL','INDIA',29,1,59,'N',29.0330555555556,79,28,25,'E',79.4736111111111,764
UNION ALL SELECT 'VISR','SXR','SRINAGAR','SRINAGAR','INDIA',33,59,12,'N',33.9866666666667,74,46,25,'E',74.7736111111111,5458
UNION ALL SELECT 'VIST','TNI','','SATNA','INDIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VLLB','LPQ','LUANG PRABANG','LUANG PRABANG','LAOS',19,53,50,'N',19.8972222222222,102,9,39,'E',102.160833333333,948
UNION ALL SELECT 'VLOS','ODY','','OUDOMXAY','LAOS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VLPS','PKZ','PAKSE','PAKSE','LAOS',15,7,55,'N',15.1319444444444,105,46,53,'E',105.781388888889,351
UNION ALL SELECT 'VLSB','ZBY','','SAYABOURY','LAOS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VLSK','ZVK','SAVANNAKHET','SAVANNAKHET','LAOS',16,33,23,'N',16.5563888888889,104,45,34,'E',104.759444444444,509
UNION ALL SELECT 'VLSV','VNA','','SARAVANE','LAOS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VLTK','THK','','THAKHEK','LAOS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VLVT','VTE','WATTAY INTERNATIONAL','VIENTIANE','LAOS',17,59,17,'N',17.9880555555556,102,33,47,'E',102.563055555556,564
UNION ALL SELECT 'VLXK','XKH','','XIENG KHOUANG','LAOS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VMMC','MFM','MACAU INTERNATIONAL','MACAU','MACAU',22,8,58,'N',22.1494444444444,113,35,29,'E',113.591388888889,20
UNION ALL SELECT 'VNBW','BWA','BHAIRAHAWA','BHAIRAWA','NEPAL',27,30,20,'N',27.5055555555556,83,24,58,'E',83.4161111111111,358
UNION ALL SELECT 'VNKT','KTM','TRIBHUVAN INTERNATIONAL','KATHMANDU','NEPAL',27,41,47,'N',27.6963888888889,85,21,33,'E',85.3591666666667,4390
UNION ALL SELECT 'VNLK','LUA','','LUKLA','NEPAL',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VNMG','MEY','','MEGHAULI','NEPAL',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VNPK','PKR','POKHARA','POKHARA','NEPAL',28,12,1,'N',28.2002777777778,83,58,52,'E',83.9811111111111,2712
UNION ALL SELECT 'VNSI','SIF','SIMARA','SIMARA','NEPAL',27,9,34,'N',27.1594444444444,84,58,48,'E',84.98,450
UNION ALL SELECT 'VNVT','BIR','BIRATNAGAR','BIRATNAGAR','NEPAL',26,29,0,'N',26.4833333333333,87,15,49,'E',87.2636111111111,236
UNION ALL SELECT 'VOAT','AGX','AGATTI','AGATTI ISLAND','INDIA',10,49,24,'N',10.8233333333333,72,10,32,'E',72.1755555555556,13
UNION ALL SELECT 'VOBG','BLR','BANGALORE','BANGALORE','INDIA',12,56,59,'N',12.9497222222222,77,40,5,'E',77.6680555555556,2914
UNION ALL SELECT 'VOBI','BEP','','BELLARY','INDIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VOBZ','VGA','VIJAYAWADA','VIJAYAWADA','INDIA',16,31,49,'N',16.5302777777778,80,47,48,'E',80.7966666666667,77
UNION ALL SELECT 'VOCB','CJB','COIMBATORE','COIMBATORE','INDIA',11,1,53,'N',11.0313888888889,77,2,38,'E',77.0438888888889,1319
UNION ALL SELECT 'VOCC','COK','','COCHIN','INDIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VOCL','CCJ','CALICUT','CALICUT','INDIA',11,8,8,'N',11.1355555555556,75,57,17,'E',75.9547222222222,331
UNION ALL SELECT 'VOCP','CDP','CUDDAPAH','CUDDAPAH','INDIA',14,30,35,'N',14.5097222222222,78,46,22,'E',78.7727777777778,430
UNION ALL SELECT 'VOHY','HYD','HYDERABAD','HYDERABAD','INDIA',17,27,8,'N',17.4522222222222,78,27,40,'E',78.4611111111111,1741
UNION ALL SELECT 'VOMD','IXM','MADURAI','MADURAI','INDIA',9,50,4,'N',9.83444444444445,78,5,36,'E',78.0933333333333,461
UNION ALL SELECT 'VOML','IXE','MANGALORE','MANGALORE','INDIA',12,57,36,'N',12.96,74,53,33,'E',74.8925,334
UNION ALL SELECT 'VOMM','MAA','CHENNAI INTERNATIONAL','MADRAS','INDIA',12,59,39,'N',12.9941666666667,80,10,49,'E',80.1802777777778,53
UNION ALL SELECT 'VONV','NVY','','NEYVELI','INDIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VOPB','IXZ','PORT BLAIR','PORT BLAIR','INDIA',11,38,44,'N',11.6455555555556,92,43,59,'E',92.7330555555556,16
UNION ALL SELECT 'VORY','RJA','RAJAHMUNDRY','RAJAHMUNDRY','INDIA',17,6,34,'N',17.1094444444444,81,49,6,'E',81.8183333333333,146
UNION ALL SELECT 'VOTP','TIR','TIRUPATI','TIRUPETI','INDIA',13,37,55,'N',13.6319444444444,79,32,35,'E',79.5430555555556,339
UNION ALL SELECT 'VOTR','TRZ','TIRUCHIRAPPALLI','TIRUCHCHIRAPPALLI','INDIA',10,45,55,'N',10.7652777777778,78,42,32,'E',78.7088888888889,288
UNION ALL SELECT 'VOTV','TRV','THIRUVANANTHAPURAM INTERNATIONAL','TRIVANDRUM','INDIA',8,28,55,'N',8.48194444444444,76,55,5,'E',76.9180555555556,15
UNION ALL SELECT 'VQPR','PBH','PARO','PARO','BHUTAN',27,24,11,'N',27.4030555555556,89,25,33,'E',89.4258333333333,7333
UNION ALL SELECT 'VRMM','MLE','MALE INTERNATIONAL','MALE','MALDIVES',4,11,30,'N',4.19166666666667,73,31,44,'E',73.5288888888889,6
UNION ALL SELECT 'VTBD','BKK','BANGKOK INTERNATIONAL','BANGKOK','THAILAND',13,54,45,'N',13.9125,100,36,24,'E',100.606666666667,9
UNION ALL SELECT 'VTBU','UTP','U TAPHAO INTERNATIONAL','RAYONG','THAILAND',12,40,47,'N',12.6797222222222,101,0,18,'E',101.005,59
UNION ALL SELECT 'VTCL','LPT','LAMPANG','LAMPANG','THAILAND',18,16,19,'N',18.2719444444444,99,30,14,'E',99.5038888888889,809
UNION ALL SELECT 'VTCP','PRH','PHRAE','PHRAE','THAILAND',18,7,55,'N',18.1319444444444,100,9,52,'E',100.164444444444,538
UNION ALL SELECT 'VTPH','HHQ','HUA HIN','PRACHUAP KHIRI KHAN','THAILAND',12,38,2,'N',12.6338888888889,99,57,3,'E',99.9508333333333,62
UNION ALL SELECT 'VTPP','PHS','PHITSANULOK','PHITSANULOK','THAILAND',16,46,58,'N',16.7827777777778,100,16,44,'E',100.278888888889,145
UNION ALL SELECT 'VTSC','NAW','NARATHIWAT','NARATHIWAT','THAILAND',6,31,11,'N',6.51972222222222,101,44,36,'E',101.743333333333,18
UNION ALL SELECT 'VTSK','PAN','PATTANI','PATTANI','THAILAND',6,47,7,'N',6.78527777777778,101,9,12,'E',101.153333333333,8
UNION ALL SELECT 'VTSN','NST','CHA IAN','NAKHON SI THAMMARAT','THAILAND',8,28,16,'N',8.47111111111111,99,57,20,'E',99.9555555555556,44
UNION ALL SELECT 'VTSP','HKT','PHUKET INTERNATIONAL','PHUKET','THAILAND',8,6,47,'N',8.11305555555555,98,19,0,'E',98.3166666666667,82
UNION ALL SELECT 'VTSS','HDY','HAT YAI INTERNATIONAL','SONGKHLA','THAILAND',6,55,59,'N',6.93305555555556,100,23,34,'E',100.392777777778,90
UNION ALL SELECT 'VTST','TST','TRANG','TRANG','THAILAND',7,30,31,'N',7.50861111111111,99,36,59,'E',99.6163888888889,67
UNION ALL SELECT 'VTUD','UTH','UDON THANI','UDON THANI','THAILAND',17,23,11,'N',17.3863888888889,102,47,17,'E',102.788055555556,579
UNION ALL SELECT 'VTUI','SNO','SAKON NAKHON','SAKON NAKHON','THAILAND',17,11,42,'N',17.195,104,7,7,'E',104.118611111111,529
UNION ALL SELECT 'VTUL','LOE','LOEI','LOEI','THAILAND',17,26,20,'N',17.4388888888889,101,43,19,'E',101.721944444444,860
UNION ALL SELECT 'VTUN','NAK','KHORAT','NAKHON RATCHASIMA','THAILAND',14,56,3,'N',14.9341666666667,102,4,43,'E',102.078611111111,729
UNION ALL SELECT 'VTUP','KOP','NAKHON PHANOM','NAKHON PHANOM','THAILAND',17,24,45,'N',17.4125,104,46,38,'E',104.777222222222,452
UNION ALL SELECT 'VTUT','UBP','','UBON RATCHATHANI','THAILAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VTUZ','KKC','','KHON KAEN','THAILAND',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VVDN','DAD','DANANG INTERNATIONAL','DANANG','VIET NAM',16,2,38,'N',16.0438888888889,108,11,57,'E',108.199166666667,33
UNION ALL SELECT 'VVNB','HAN','NOIBAI INTERNATIONAL','HANOI','VIET NAM',21,13,18,'N',21.2216666666667,105,48,20,'E',105.805555555556,39
UNION ALL SELECT 'VVNT','NHA','NHA TRANG AIRPORT','NHATRANG','VIET NAM',12,13,5,'N',12.2180555555556,109,12,0,'E',109.2,20
UNION ALL SELECT 'VVTS','SGN','TANSONNHAT INTERNATIONAL','HO CHI MINH CITY','VIET NAM',10,49,12,'N',10.82,106,39,42,'E',106.661666666667,33
UNION ALL SELECT 'VYHH','HEH','HEHO','HEHO','MYANMAR',20,44,35,'N',20.7430555555556,96,47,30,'E',96.7916666666667,3888
UNION ALL SELECT 'VYKG','KET','KENGTUNG','KENGTUNG','MYANMAR',21,18,2,'N',21.3005555555556,99,38,12,'E',99.6366666666667,2798
UNION ALL SELECT 'VYKP','KYP','KYAUKPYU','KYAUKPYU','MYANMAR',19,25,36,'N',19.4266666666667,93,32,4,'E',93.5344444444444,20
UNION ALL SELECT 'VYLS','LSH','LASHIO','LASHIO','MYANMAR',22,58,39,'N',22.9775,97,45,8,'E',97.7522222222222,2450
UNION ALL SELECT 'VYMD','MDL','MANDALAY INTERNATIONAL','MANDALAY','MYANMAR',21,42,7,'N',21.7019444444444,95,58,40,'E',95.9777777777778,300
UNION ALL SELECT 'VYME','MGZ','MYEIK','MYEIK','MYANMAR',12,26,36,'N',12.4433333333333,98,37,16,'E',98.6211111111111,75
UNION ALL SELECT 'VYMG','MGZ','','MYINGYAN','MYANMAR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'VYMK','MYT','MYITKYINA','MYITKYINA','MYANMAR',25,22,57,'N',25.3825,97,21,10,'E',97.3527777777778,475
UNION ALL SELECT 'VYMS','MOG','MONGHSAT','MONG HSAT','MYANMAR',20,31,0,'N',20.5166666666667,99,15,24,'E',99.2566666666667,1875
UNION ALL SELECT 'VYPT','PBU','PUTAO','PUTAO','MYANMAR',27,19,47,'N',27.3297222222222,97,25,34,'E',97.4261111111111,1500
UNION ALL SELECT 'VYSW','AKY','SITTWE','SITTWE','MYANMAR',20,7,57,'N',20.1325,92,52,21,'E',92.8725,27
UNION ALL SELECT 'VYTD','SNW','THANDWE','THANDWE','MYANMAR',18,27,38,'N',18.4605555555556,94,17,58,'E',94.2994444444444,20
UNION ALL SELECT 'VYTL','THL','TACHILEK','TACHILEK','MYANMAR',20,29,1,'N',20.4836111111111,99,56,7,'E',99.9352777777778,1280
UNION ALL SELECT 'VYYY','RGN','YANGON INTERNATIONAL','YANGON','MYANMAR',16,54,26,'N',16.9072222222222,96,7,59,'E',96.1330555555555,109
UNION ALL SELECT 'WAAA','UPG','HASANUDDIN','UJUNG PANDANG','INDONESIA',5,3,42,'S',-5.06166666666667,119,33,14,'E',119.553888888889,47
UNION ALL SELECT 'WAAB','BUW','','BAU BAU','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAAU','KDI','WOLTER MONGINSIDI','KENDARI','INDONESIA',4,4,56,'S',-4.08222222222222,122,25,0,'E',122.416666666667,180
UNION ALL SELECT 'WABB','BIK','FRANS KAISIEPO','BIAK','INDONESIA',1,11,24,'S',-1.19,136,6,28,'E',136.107777777778,46
UNION ALL SELECT 'WABD','ONI','','MOANAMANI','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WABF','FOO','','NUMFOR','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WABI','NBX','NABIRE','NABIRE','INDONESIA',3,22,5,'S',-3.36805555555556,135,29,47,'E',135.496388888889,20
UNION ALL SELECT 'WABO','ZRI','','SERUI','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WABP','TIM','MOSES KILANGIN','TIMIKA','INDONESIA',4,31,41,'S',-4.52805555555556,136,53,14,'E',136.887222222222,103
UNION ALL SELECT 'WABT','EWI','','ENAROTALI','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAJB','BUI','','BOKONDINI','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAJI','ZRM','','SARMI','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAJJ','DJJ','SENTANI','JAYAPURA','INDONESIA',2,34,37,'S',-2.57694444444444,140,30,58,'E',140.516111111111,289
UNION ALL SELECT 'WAJL','LHI','','LEREH','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAJM','LII','','MULIA','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAJO','OKL','','OKSIBIL','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAJS','SEH','','SENGGEH','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAJW','WMX','WAMENA','WAMENA','INDONESIA',4,5,46,'S',-4.09611111111111,138,57,9,'E',138.9525,5085
UNION ALL SELECT 'WAKD','MDP','','MINDIPTANAH','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAKE','BXD','','BADE','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAKK','MKQ','MOPAH','MERAUKE','INDONESIA',8,31,13,'S',-8.52027777777778,140,25,6,'E',140.418333333333,10
UNION ALL SELECT 'WAKO','OKQ','','OKABA','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAKT','TMH','','TANAH MERAH','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAMA','GLX','','GALELA','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAMG','GTO','JALALUDDIN','GORONTALO','INDONESIA',0,38,12,'N',0.636666666666667,122,51,7,'E',122.851944444444,59
UNION ALL SELECT 'WAMI','TLI','','TOLI TOLI','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAML','PLW','MUTIARA','PALU','INDONESIA',0,55,6,'S',-0.918333333333333,119,54,34,'E',119.909444444444,284
UNION ALL SELECT 'WAMM','MDC','SAM RATULANGI','MANADO','INDONESIA',1,32,57,'N',1.54916666666667,124,55,35,'E',124.926388888889,270
UNION ALL SELECT 'WAMN','MNA','','MELANGGUANE','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAMP','PSJ','KASIGUNCU','POSO','INDONESIA',1,25,0,'S',-1.41666666666667,120,39,27,'E',120.6575,174
UNION ALL SELECT 'WAMR','OTI','','MOROTAI ISLAND','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAMT','TTE','BABULLAH','TERNATE','INDONESIA',0,49,55,'N',0.831944444444444,127,22,50,'E',127.380555555556,49
UNION ALL SELECT 'WAMW','LUW','BUBUNG','LUWUK','INDONESIA',1,2,20,'S',-1.03888888888889,122,46,18,'E',122.771666666667,56
UNION ALL SELECT 'WAPE','MAL','','MANGOLE','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WAPP','AMQ','PATTIMURA','AMBON','INDONESIA',3,42,32,'S',-3.70888888888889,128,5,24,'E',128.09,33
UNION ALL SELECT 'WASE','KEQ','','KEBAR','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WASF','FKQ','','FAK FAK','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WASI','INX','','INANWATAN','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WASK','KNG','KAIMANA','KAIMANA','INDONESIA',3,38,38,'S',-3.64388888888889,133,41,43,'E',133.695277777778,16
UNION ALL SELECT 'WASM','RDE','','MERDEI','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WASO','BXB','','BABO','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WASR','MKW','RENDANI','MANOKWARI','INDONESIA',0,52,48,'S',-0.88,134,3,1,'E',134.050277777778,15
UNION ALL SELECT 'WASS','SOQ','JEFMAN','SORONG','INDONESIA',0,55,33,'S',-0.925833333333333,131,7,12,'E',131.12,10
UNION ALL SELECT 'WAST','TXM','','TEMINABUAN','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBGB','BTU','BINTULU','BINTULU','MALAYSIA',3,10,20,'N',3.17222222222222,113,2,40,'E',113.044444444444,6
UNION ALL SELECT 'WBGC','BLG','','BELAGA','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBGD','LSM','','LONG SEMADO','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBGG','KCH','KUCHING INTERNATIONAL','KUCHING','MALAYSIA',1,29,5,'N',1.48472222222222,110,20,47,'E',110.346388888889,89
UNION ALL SELECT 'WBGI','ODN','','LONG SERIDAN','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBGJ','LMN','','LIMBANG','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBGK','MKM','','MUKAH','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBGM','MUR','MARUDI','MARUDI','MALAYSIA',4,10,41,'N',4.17805555555556,114,19,53,'E',114.331388888889,103
UNION ALL SELECT 'WBGO','BKM','','BAKELALAN','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBGP','KPI','','KAPIT','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBGR','MYY','MIRI','MIRI','MALAYSIA',4,19,30,'N',4.325,113,59,18,'E',113.988333333333,55
UNION ALL SELECT 'WBGS','SBW','SIBU','SIBU','MALAYSIA',2,15,50,'N',2.26388888888889,111,58,58,'E',111.982777777778,116
UNION ALL SELECT 'WBGZ','BBN','','BARIO','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBKA','SDK','','SANDAKAN','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBKD','LDU','LAHAD DATU','LAHAD DATU','MALAYSIA',5,1,56,'N',5.03222222222222,118,19,26,'E',118.323888888889,45
UNION ALL SELECT 'WBKK','BKI','KOTA KINABALU INTERNATIONAL','KOTA KINABALU','MALAYSIA',5,56,14,'N',5.93722222222222,116,3,4,'E',116.051111111111,10
UNION ALL SELECT 'WBKL','LBU','LABUAN','LABUAN','MALAYSIA',5,18,2,'N',5.30055555555556,115,15,0,'E',115.25,101
UNION ALL SELECT 'WBKP','PAY','','PAMOL','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBKT','KUD','','KUDAT','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WBKW','TWU','TAWAU','TAWAU','MALAYSIA',4,18,48,'N',4.31333333333333,118,7,19,'E',118.121944444444,57
UNION ALL SELECT 'WBSB','BWN','BRUNEI INTERNATIONAL','BRUNEI','BRUNEI',4,56,44,'N',4.94555555555556,114,55,40,'E',114.927777777778,73
UNION ALL SELECT 'WIAA','SBG','MAIMUN SALEH','SABANG','INDONESIA',5,52,26,'N',5.87388888888889,95,20,22,'E',95.3394444444444,361
UNION ALL SELECT 'WIAS','MLG','ABDUL RACHMAN SALEH','MALANG','INDONESIA',7,55,34,'S',-7.92611111111111,112,42,50,'E',112.713888888889,1726
UNION ALL SELECT 'WIBB','PKU','SULTAN SYARIF KASIM II','PEKANBARU','INDONESIA',0,27,40,'N',0.461111111111111,101,26,40,'E',101.444444444444,102
UNION ALL SELECT 'WIBD','DUM','PINANG KAMPAI','DUMAI','INDONESIA',1,36,33,'N',1.60916666666667,101,26,0,'E',101.433333333333,54
UNION ALL SELECT 'WIIB','BDO','HUSEIN SASTRANEGARA','BANDUNG','INDONESIA',6,54,2,'S',-6.90055555555556,107,34,34,'E',107.576111111111,2431
UNION ALL SELECT 'WIIC','CBN','PENGGUNG','CIREBON','INDONESIA',6,45,21,'S',-6.75583333333333,108,32,22,'E',108.539444444444,89
UNION ALL SELECT 'WIID','JAK','','JAKARTA','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WIIH','HLP','HALIM PERDANAKUSUMA INTERNATIONAL','JAKARTA','INDONESIA',6,15,59,'S',-6.26638888888889,106,53,28,'E',106.891111111111,98
UNION ALL SELECT 'WIII','CGK','SOEKARNO HATTA INTERNATIONAL','JAKARTA','INDONESIA',6,7,32,'S',-6.12555555555555,106,39,21,'E',106.655833333333,34
UNION ALL SELECT 'WIIJ','JOG','ADI SUTJIPTO','YOGYAKARTA','INDONESIA',7,47,17,'S',-7.78805555555556,110,25,55,'E',110.431944444444,350
UNION ALL SELECT 'WIIL','CXP','TUNGGUL WULUNG','CILACAP','INDONESIA',7,38,42,'S',-7.645,109,2,2,'E',109.033888888889,69
UNION ALL SELECT 'WIIP','PCB','PONDOK CABE','JAKARTA','INDONESIA',6,20,13,'S',-6.33694444444444,106,45,52,'E',106.764444444444,200
UNION ALL SELECT 'WIIS','SRG','ACHMAD YANI','SEMARANG','INDONESIA',6,58,23,'S',-6.97305555555556,110,22,31,'E',110.375277777778,10
UNION ALL SELECT 'WIKB','BTH','HANG NADIM','BATAM','INDONESIA',1,7,15,'N',1.12083333333333,104,7,7,'E',104.118611111111,126
UNION ALL SELECT 'WIKD','TJQ','H AS HANANDJOEDDIN','TANJUNG PANDAN','INDONESIA',2,44,44,'S',-2.74555555555556,107,45,17,'E',107.754722222222,164
UNION ALL SELECT 'WIKK','PGK','DEPATI AMIR','PANGKAL PINANG','INDONESIA',2,9,46,'S',-2.16277777777778,106,8,21,'E',106.139166666667,108
UNION ALL SELECT 'WIKN','TNJ','KIJANG','TANJUNG PINANG','INDONESIA',0,55,21,'N',0.9225,104,31,56,'E',104.532222222222,56
UNION ALL SELECT 'WIKS','SIQ','DABO','SINGKEP','INDONESIA',0,28,45,'S',-0.479166666666667,104,34,45,'E',104.579166666667,95
UNION ALL SELECT 'WIMB','GNS','BINAKA','GUNUNG SITOLI','INDONESIA',1,9,59,'N',1.16638888888889,97,42,10,'E',97.7027777777778,20
UNION ALL SELECT 'WIMG','PDG','TABING','PADANG','INDONESIA',0,52,34,'S',-0.876111111111111,100,21,9,'E',100.3525,9
UNION ALL SELECT 'WIMM','MES','POLONIA','MEDAN','INDONESIA',3,33,29,'N',3.55805555555556,98,40,18,'E',98.6716666666667,90
UNION ALL SELECT 'WIOK','KTG','RAHADI USMAN','KETAPANG','INDONESIA',1,48,59,'S',-1.81638888888889,109,57,48,'E',109.963333333333,46
UNION ALL SELECT 'WIOO','PNK','SUPADIO','PONTIANAK','INDONESIA',0,9,2,'S',-0.150555555555556,109,24,14,'E',109.403888888889,10
UNION ALL SELECT 'WIOS','SQC','SUSILO','SINTANG','INDONESIA',0,3,49,'N',0.0636111111111111,111,28,29,'E',111.474722222222,98
UNION ALL SELECT 'WIPA','DJB','SULTAN THAHA','JAMBI','INDONESIA',1,38,16,'S',-1.63777777777778,103,38,39,'E',103.644166666667,82
UNION ALL SELECT 'WIPJ','DJB','','JAMBI','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WIPL','BKS','PADANG KEMILING','BENGKULU','INDONESIA',3,51,50,'S',-3.86388888888889,102,20,27,'E',102.340833333333,50
UNION ALL SELECT 'WIPP','PLM','SULTAN MAHMUD BADARUDDIN II','PALEMBANG','INDONESIA',2,53,52,'S',-2.89777777777778,104,42,4,'E',104.701111111111,37
UNION ALL SELECT 'WIPR','RGT','JAPURA','RENGAT','INDONESIA',0,21,10,'S',-0.352777777777778,102,20,5,'E',102.334722222222,62
UNION ALL SELECT 'WITT','BTJ','SULTAN ISKANDARMUDA','BANDA ACEH','INDONESIA',5,31,24,'N',5.52333333333333,95,25,13,'E',95.4202777777778,65
UNION ALL SELECT 'WMAM','LGK','','LANGKAWI','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WMBA','SWY','','SITIAWAN','MALAYSIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WMKA','AOR','SULTAN ABDUL HALIM','ALOR SETAR','MALAYSIA',6,11,38,'N',6.19388888888889,100,24,9,'E',100.4025,15
UNION ALL SELECT 'WMKC','KBR','SULTAN ISMAIL PETRA','KOTA BAHRU','MALAYSIA',6,9,59,'N',6.16638888888889,102,17,37,'E',102.293611111111,16
UNION ALL SELECT 'WMKD','KUA','KUANTAN','KUANTAN','MALAYSIA',3,46,31,'N',3.77527777777778,103,12,32,'E',103.208888888889,58
UNION ALL SELECT 'WMKE','KTE','KERTEH','KERTEH','MALAYSIA',4,32,14,'N',4.53722222222222,103,25,35,'E',103.426388888889,18
UNION ALL SELECT 'WMKI','IPH','SULTAN AZLAN SHAH','IPOH','MALAYSIA',4,34,4,'N',4.56777777777778,101,5,31,'E',101.091944444444,130
UNION ALL SELECT 'WMKJ','JHB','SULTAN ISMAIL','JOHOR BAHRU','MALAYSIA',1,38,28,'N',1.64111111111111,103,40,10,'E',103.669444444444,121
UNION ALL SELECT 'WMKK','KUL','KUALA LUMPUR INTERNATIONAL','KUALA LUMPUR','MALAYSIA',2,44,44,'N',2.74555555555556,101,42,35,'E',101.709722222222,69
UNION ALL SELECT 'WMKL','LGK','LANGKAWI INTERNATIONAL','PULAU','MALAYSIA',6,19,47,'N',6.32972222222222,99,43,43,'E',99.7286111111111,29
UNION ALL SELECT 'WMKM','MKZ','MALACCA','MALACCA','MALAYSIA',2,15,48,'N',2.26333333333333,102,15,5,'E',102.251388888889,35
UNION ALL SELECT 'WMKN','TGG','SULTAN MAHMUD','KUALA TERENGGANU','MALAYSIA',5,22,57,'N',5.3825,103,6,12,'E',103.103333333333,21
UNION ALL SELECT 'WMKP','PEN','PENANG INTERNATIONAL','PENANG','MALAYSIA',5,17,49,'N',5.29694444444444,100,16,36,'E',100.276666666667,11
UNION ALL SELECT 'WPDL','DIL','COMORO (KOMORO) AIRPORT','DILI','EAST TIMOR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WPMN','MPT','','MALIANA','EAST TIMOR',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WRBB','BDJ','SYAMSUDIN NOOR','BANJARMASIN','INDONESIA',3,26,31,'S',-3.44194444444444,114,45,40,'E',114.761111111111,66
UNION ALL SELECT 'WRBI','PKN','ISKANDAR','PANGKALAN BUN','INDONESIA',2,42,18,'S',-2.705,111,40,23,'E',111.673055555556,75
UNION ALL SELECT 'WRBP','PKY','TJILIK RIWUT','PALANGKARAYA','INDONESIA',2,13,30,'S',-2.225,113,56,33,'E',113.9425,82
UNION ALL SELECT 'WRKA','ABU','','ATAMBUA','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WRKB','BJW','','BAJAWA','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WRKC','MOF','WAI OTI','MAUMERE','INDONESIA',8,38,26,'S',-8.64055555555555,122,14,12,'E',122.236666666667,115
UNION ALL SELECT 'WRKE','ENE','H HASAN AROEBOESMAN','ENDE','INDONESIA',8,50,56,'S',-8.84888888888889,121,39,43,'E',121.661944444444,49
UNION ALL SELECT 'WRKG','RTG','SATAR TACIK','RUTENG','INDONESIA',8,35,44,'S',-8.59555555555556,120,28,39,'E',120.4775,3510
UNION ALL SELECT 'WRKK','KOE','EL TARI','KUPANG','INDONESIA',10,10,17,'S',-10.1713888888889,123,40,16,'E',123.671111111111,335
UNION ALL SELECT 'WRKL','LKA','','LARANTUKA','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WRKO','LBJ','MUTIARA II','LABUHAN BAJO','INDONESIA',8,29,10,'S',-8.48611111111111,119,53,21,'E',119.889166666667,66
UNION ALL SELECT 'WRLB','LBW','','LONG BAWAN','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WRLG','TJS','','TANJUNG SELOR','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WRLL','BPN','SEPINGGAN','BALIKPAPAN','INDONESIA',1,16,5,'S',-1.26805555555556,116,53,40,'E',116.894444444444,12
UNION ALL SELECT 'WRLR','TRK','JUWATA','TARAKEN','INDONESIA',3,19,35,'N',3.32638888888889,117,33,59,'E',117.566388888889,20
UNION ALL SELECT 'WRLS','SRI','TEMINDUNG','SAMARINDA','INDONESIA',0,29,4,'S',-0.484444444444444,117,9,25,'E',117.156944444444,33
UNION ALL SELECT 'WRRA','AMI','SELAPARANG','MATARAM','INDONESIA',8,33,38,'S',-8.56055555555556,116,5,40,'E',116.094444444444,52
UNION ALL SELECT 'WRRB','BMU','MUHAMMAD SALAHUDDIN','BIMA','INDONESIA',8,32,22,'S',-8.53944444444444,118,41,14,'E',118.687222222222,70
UNION ALL SELECT 'WRRR','DPS','BALI INTERNATIONAL','DENPASAR','INDONESIA',8,44,54,'S',-8.74833333333333,115,10,2,'E',115.167222222222,14
UNION ALL SELECT 'WRRS','SWG','SUMBAWA BESAR','SUMBAWA','INDONESIA',8,29,20,'S',-8.48888888888889,117,24,43,'E',117.411944444444,16
UNION ALL SELECT 'WRRW','WGP','MAU HAU','WAINGAPU','INDONESIA',9,40,12,'S',-9.67,120,18,13,'E',120.303611111111,39
UNION ALL SELECT 'WRSJ','SUB','JUANDA','SURABAYA','INDONESIA',7,22,47,'S',-7.37972222222222,112,47,12,'E',112.786666666667,9
UNION ALL SELECT 'WRSQ','SOC','ADI SUMARMO WIRYOKUSUMO','SOLO CITY','INDONESIA',7,30,57,'S',-7.51583333333333,110,45,24,'E',110.756666666667,421
UNION ALL SELECT 'WRSS','SUB','','SURABAYA','INDONESIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'WSAP','QPG','PAYA LEBAR','PAYA LEBAR','SINGAPORE',1,21,37,'N',1.36027777777778,103,54,34,'E',103.909444444444,65
UNION ALL SELECT 'WSSL','XSP','SELETAR','SINGAPORE','SINGAPORE',1,25,1,'N',1.41694444444444,103,52,3,'E',103.8675,35
UNION ALL SELECT 'WSSS','SIN','SINGAPORE CHANGI','SINGAPORE','SINGAPORE',1,21,20,'N',1.35555555555556,103,59,14,'E',103.987222222222,22
UNION ALL SELECT 'YBAM','ABM','BAMAGA INJINOO','AMBERLEY','AUSTRALIA',10,57,3,'S',-10.9508333333333,142,27,34,'E',142.459444444444,34
UNION ALL SELECT 'YBAS','ASP','ALICE SPRINGS','ALICE SPRINGS','AUSTRALIA',23,48,25,'S',-23.8069444444444,133,54,8,'E',133.902222222222,1789
UNION ALL SELECT 'YBBN','BNE','BRISBANE INTERNATIONAL','BRISBANE','AUSTRALIA',27,23,3,'S',-27.3841666666667,153,7,3,'E',153.1175,13
UNION ALL SELECT 'YBCG','OOL','GOLD COAST COOLANGATTA','COOLANGATTA','AUSTRALIA',28,9,52,'S',-28.1644444444444,153,30,17,'E',153.504722222222,21
UNION ALL SELECT 'YBCS','CNS','CAIRNS INTERNATIONAL','CAIRNS','AUSTRALIA',16,53,9,'S',-16.8858333333333,145,45,19,'E',145.755277777778,10
UNION ALL SELECT 'YBCV','CTL','CHARLEVILLE','CHARLIEVILLE','AUSTRALIA',26,24,48,'S',-26.4133333333333,146,15,45,'E',146.2625,1003
UNION ALL SELECT 'YBMA','ISA','MOUNT ISA','MOUNT ISA','AUSTRALIA',20,39,50,'S',-20.6638888888889,139,29,19,'E',139.488611111111,1121
UNION ALL SELECT 'YBMC','MCY','MAROOCHYDORE SUNSHINE COAST','MAROOCHYDORE','AUSTRALIA',26,36,12,'S',-26.6033333333333,153,5,28,'E',153.091111111111,15
UNION ALL SELECT 'YBMK','MKY','MACKAY','MACKAY','AUSTRALIA',21,10,18,'S',-21.1716666666667,149,10,47,'E',149.179722222222,19
UNION ALL SELECT 'YBMN','HTI','','HAMILTON ISLAND','AUSTRALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YBPN','PPP','PROSERPINE WHITSUNDAY COAST','PROSSERPINE','AUSTRALIA',20,29,42,'S',-20.495,148,33,8,'E',148.552222222222,82
UNION ALL SELECT 'YBRK','ROK','ROCKHAMPTON','ROCKHAMPTON','AUSTRALIA',23,22,55,'S',-23.3819444444444,150,28,31,'E',150.475277777778,34
UNION ALL SELECT 'YBTL','TSV','TOWNSVILLE','TOWNSVILLE','AUSTRALIA',19,15,9,'S',-19.2525,146,45,55,'E',146.765277777778,18
UNION ALL SELECT 'YBWP','WEI','WEIPA','WEIPA','AUSTRALIA',12,40,43,'S',-12.6786111111111,141,55,31,'E',141.925277777778,63
UNION ALL SELECT 'YDDN','DRW','','DARWIN','AUSTRALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YDGE','GTE','','GROOTE EYLANDT','AUSTRALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YDGV','GOV','','GOVE','AUSTRALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YGGE','BAS','','BALALAE','SOLOMON ISLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YGGH','HIR','','HONIARA','SOLOMON ISLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YGGM','MUA','','MUNDA','SOLOMON ISLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YGGN','GZO','','GIZO','SOLOMON ISLANDS',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YMAV','AVV','AVALON','AVALON','AUSTRALIA',38,2,22,'S',-38.0394444444444,144,28,10,'E',144.469444444444,35
UNION ALL SELECT 'YMAY','ABX','ALBURY','ALBURY','AUSTRALIA',36,4,4,'S',-36.0677777777778,146,57,29,'E',146.958055555556,539
UNION ALL SELECT 'YMEN','MEB','MELBOURNE ESSENDON','MELBOURNE','AUSTRALIA',37,43,41,'S',-37.7280555555556,144,54,7,'E',144.901944444444,282
UNION ALL SELECT 'YMHB','HBA','HOBART','HOBART','AUSTRALIA',42,50,10,'S',-42.8361111111111,147,30,37,'E',147.510277777778,13
UNION ALL SELECT 'YMLT','LST','LAUNCESTON','LAUNCESTON','AUSTRALIA',41,32,43,'S',-41.5452777777778,147,12,51,'E',147.214166666667,562
UNION ALL SELECT 'YMLV','LVO','','LAVERTON','AUSTRALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YMMB','MBW','MELBOURNE MOORABBIN','MELBOURNE','AUSTRALIA',37,58,33,'S',-37.9758333333333,145,6,8,'E',145.102222222222,50
UNION ALL SELECT 'YMML','MEL','MELBOURNE INTERNATIONAL','MELBOURNE','AUSTRALIA',37,40,24,'S',-37.6733333333333,144,50,36,'E',144.843333333333,434
UNION ALL SELECT 'YNAU','INU','','NAURU ISLAND','NAURU',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YPAD','ADL','ADELAIDE INTERNATIONAL','ADELAIDE','AUSTRALIA',34,56,42,'S',-34.945,138,31,50,'E',138.530555555556,20
UNION ALL SELECT 'YPBR','BME','','BROOME','AUSTRALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YPCR','CVQ','','CARNARVON','AUSTRALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YPJT','JAD','PERTH JANDAKOT','PERTH','AUSTRALIA',32,5,50,'S',-32.0972222222222,115,52,52,'E',115.881111111111,99
UNION ALL SELECT 'YPKA','KTA','KARRATHA','KARRATHA','AUSTRALIA',20,42,44,'S',-20.7122222222222,116,46,24,'E',116.773333333333,29
UNION ALL SELECT 'YPKG','KGI','KALGOORLIE BOULDER','KALGOORLIE','AUSTRALIA',30,47,22,'S',-30.7894444444444,121,27,42,'E',121.461666666667,1203
UNION ALL SELECT 'YPKU','KNX','KUNUNURRA','KUNUNURRA','AUSTRALIA',15,46,41,'S',-15.7780555555556,128,42,27,'E',128.7075,145
UNION ALL SELECT 'YPLM','LEA','LEARMONTH','LEARMONTH','AUSTRALIA',22,14,8,'S',-22.2355555555556,114,5,19,'E',114.088611111111,19
UNION ALL SELECT 'YPNW','ZNE','','NEWMAN','AUSTRALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YPPB','PBO','','PARABURDOO','AUSTRALIA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'YPPD','PHE','PORT HEDLAND INTERNATIONAL','PORT HEDLAND','AUSTRALIA',20,22,40,'S',-20.3777777777778,118,37,35,'E',118.626388888889,33
UNION ALL SELECT 'YPPH','PER','PERTH INTERNATIONAL','PERTH','AUSTRALIA',31,56,25,'S',-31.9402777777778,115,58,1,'E',115.966944444444,67
UNION ALL SELECT 'YPWR','UMR','WOOMERA','WOOMERA','AUSTRALIA',31,8,39,'S',-31.1441666666667,136,49,1,'E',136.816944444444,548
UNION ALL SELECT 'YSBK','BWU','SYDNEY BANKSTOWN','SYDNEY','AUSTRALIA',33,55,28,'S',-33.9244444444444,150,59,18,'E',150.988333333333,29
UNION ALL SELECT 'YSCB','CBR','CANBERRA','CANBERRA','AUSTRALIA',35,18,30,'S',-35.3083333333333,149,11,38,'E',149.193888888889,1888
UNION ALL SELECT 'YSCH','CFS','COFFS HARBOUR','COFF''S HARBOUR','AUSTRALIA',30,19,14,'S',-30.3205555555556,153,6,59,'E',153.116388888889,18
UNION ALL SELECT 'YSCN','CDU','CAMDEN','CAMDEN','AUSTRALIA',34,2,25,'S',-34.0402777777778,150,41,14,'E',150.687222222222,230
UNION ALL SELECT 'YSDU','DBO','DUBBO','DUBBO','AUSTRALIA',32,13,0,'S',-32.2166666666667,148,34,29,'E',148.574722222222,935
UNION ALL SELECT 'YSNF','NLK','NORFOLK ISLAND INTERNATIONAL','NORFOLK ISLAND','AUSTRALIA',29,2,29,'S',-29.0413888888889,167,56,19,'E',167.938611111111,371
UNION ALL SELECT 'YSRI','RCM','RICHMOND','RICHMOND','AUSTRALIA',33,36,2,'S',-33.6005555555556,150,46,51,'E',150.780833333333,67
UNION ALL SELECT 'YSSY','SYD','KINGSFORD SMITH INTERNATIONAL AIRPORT','SYDNEY','AUSTRALIA',33,56,46,'S',-33.9461111111111,151,10,38,'E',151.177222222222,21
UNION ALL SELECT 'YSTW','TMW','TAMWORTH','TAMWORTH','AUSTRALIA',31,5,2,'S',-31.0838888888889,150,50,48,'E',150.846666666667,1334
UNION ALL SELECT 'YSWG','WGA','WAGGA WAGGA','WAGGA WAGGA','AUSTRALIA',35,9,55,'S',-35.1652777777778,147,27,59,'E',147.466388888889,724
UNION ALL SELECT 'ZBAA','PEK','CAPITAL','BEIJING','CHINA',40,4,48,'N',40.08,116,35,4,'E',116.584444444444,116
UNION ALL SELECT 'ZBCF','CIF','','CHIFENG','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZBCZ','CIH','','CHANGZHI','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZBLA','HLD','DONGSHAN','HAILAR','CHINA',49,12,18,'N',49.205,119,49,30,'E',119.825,2169
UNION ALL SELECT 'ZBOW','BAV','','BAOTOU','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZBTJ','TSN','BINHAI','TIANJIN','CHINA',39,7,26,'N',39.1238888888889,117,20,46,'E',117.346111111111,7
UNION ALL SELECT 'ZBTL','TGO','','TONGLIAO','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZBUL','HLH','','ULANHOT','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZBXH','XIL','','XILINHOT','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZBYN','TYN','WUSU','TAIYUAN','CHINA',37,44,48,'N',37.7466666666667,112,37,43,'E',112.628611111111,2575
UNION ALL SELECT 'ZGBH','BHY','','BEIHAI','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZGCS','CSX','','CHANGSHA','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZGGG','CAN','BAIYUN','GUANGZHOU','CHINA',23,11,3,'N',23.1841666666667,113,15,57,'E',113.265833333333,37
UNION ALL SELECT 'ZGHA','CSX','HUANGHUA','CHANGCHA','CHINA',28,11,20,'N',28.1888888888889,113,13,10,'E',113.219444444444,217
UNION ALL SELECT 'ZGHK','HAK','','HAIKOU','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZGHY','HNY','','HENGYANG','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZGKL','KWL','LIANGJIANG','GUILIN','CHINA',25,13,4,'N',25.2177777777778,110,2,21,'E',110.039166666667,570
UNION ALL SELECT 'ZGMX','MXZ','','MEIXIAN','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZGNN','NNG','WUXU','NANNING','CHINA',22,36,29,'N',22.6080555555556,108,10,20,'E',108.172222222222,420
UNION ALL SELECT 'ZGNU','ZHA','','ZHANJIANG','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZGOW','SWA','WAI SHA AIRPORT','SHANTOU','CHINA',23,24,0,'N',23.4,116,41,0,'E',116.683333333333,0
UNION ALL SELECT 'ZGSY','SYX','','SANYA','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZGSZ','SZX','BAOAN','SHENZHEN','CHINA',22,38,22,'N',22.6394444444444,113,48,44,'E',113.812222222222,13
UNION ALL SELECT 'ZGZH','LZH','','LIUZHOU','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZHCC','CGO','XINZHENG','ZHENGZHOU','CHINA',34,31,10,'N',34.5194444444444,113,50,27,'E',113.840833333333,495
UNION ALL SELECT 'ZHHH','WUH','TIANHE','WUHAN','CHINA',30,47,1,'N',30.7836111111111,114,12,29,'E',114.208055555556,115
UNION ALL SELECT 'ZHLY','LYA','','LUOYANG','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZHSS','SHS','','SHASHI','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZHWT','WUH','','WUHAN','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZKPY','FNJ','PYONGYANG / SUNAN (CAPITAL) AIRPORT','PYONGYANG','KOREA',39,2,0,'N',39.0333333333333,125,47,0,'E',125.783333333333,38
UNION ALL SELECT 'ZLDH','DNH','DUNHUANG AIRPORT','DUNHUANG','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZLIC','INC','','YINCHUAN','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZLLL','ZGC','ZHONGCHUAN','LANZHOU','CHINA',36,31,0,'N',36.5166666666667,103,37,18,'E',103.621666666667,6388
UNION ALL SELECT 'ZLXG','SIA','','XI''AN','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZLXY','XIY','XIANYANG','XI''AN','CHINA',34,26,45,'N',34.4458333333333,108,45,9,'E',108.7525,1572
UNION ALL SELECT 'ZMUB','ULN','BUYANT UKHAA','ULAN BATOR','MONGOLIA',47,50,35,'N',47.8430555555556,106,45,59,'E',106.766388888889,4364
UNION ALL SELECT 'ZPPP','KMG','WUJIABA','KUNMING','CHINA',24,59,32,'N',24.9922222222222,102,44,36,'E',102.743333333333,6217
UNION ALL SELECT 'ZSAM','XMN','GAOQI','XIAMEN','CHINA',24,32,38,'N',24.5438888888889,118,7,39,'E',118.1275,59
UNION ALL SELECT 'ZSCG','CZX','','CHANGZHOU','CHINA',0,0,0,'U',0,0,0,0,'U',0,0
UNION ALL SELECT 'ZSCN','KHN','NANCHANG AIRPORT','NANCHANG','CHINA',28,36,0,'N',28.6,115,55,0,'E',115.916666666667,0
) x (ICAO_Code,IATA_Code,[Name],[City],[Country],[LatDeg],[LatMin],[LatSec],[LatDir]
	,[LatDec],[LongDeg],[LongMin],[LongSec],[LongDir],[LongDec],[Altitude])
LEFT OUTER JOIN Airports a ON a.IATA_Code = x.IATA_Code
--WHERE x.[LatDir] <> 'U' and x.[LongDir] <> 'U' and x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE x.IATA_Code <> 'N/A' AND a.IATA_Code IS NULL) a
WHERE n=1
GO

;WITH USAAirports (IATA_Code, [Name], City, [State]) AS (
SELECT '1G4','GRAND CANYON WEST','PEACH SPRINGS','AZ'
UNION ALL SELECT 'ABE','LEHIGH VALLEY INTERNATIONAL','ALLENTOWN','PA'
UNION ALL SELECT 'ABI','ABILENE REGIONAL','ABILENE','TX'
UNION ALL SELECT 'ABQ','ALBUQUERQUE INTERNATIONAL SUNPORT','ALBUQUERQUE','NM'
UNION ALL SELECT 'ABR','ABERDEEN REGIONAL','ABERDEEN','SD'
UNION ALL SELECT 'ABY','SOUTHWEST GEORGIA REGIONAL','ALBANY','GA'
UNION ALL SELECT 'ACK','NANTUCKET MEMORIAL','NANTUCKET','MA'
UNION ALL SELECT 'ACT','WACO REGIONAL','WACO','TX'
UNION ALL SELECT 'ACV','ARCATA','ARCATA','CA'
UNION ALL SELECT 'ACY','ATLANTIC CITY INTERNATIONAL','ATLANTIC CITY','NJ'
UNION ALL SELECT 'ADQ','KODIAK','KODIAK','AK'
UNION ALL SELECT 'AEX','ALEXANDRIA INTERNATIONAL','ALEXANDRIA','LA'
UNION ALL SELECT 'AGS','AUGUSTA REGIONAL AT BUSH FIELD','AUGUSTA','GA'
UNION ALL SELECT 'AKN','KING SALMON','KING SALMON','AK'
UNION ALL SELECT 'ALB','ALBANY INTERNATIONAL','ALBANY','NY'
UNION ALL SELECT 'ALO','WATERLOO REGIONAL','WATERLOO','IA'
UNION ALL SELECT 'ALW','WALLA WALLA REGIONAL','WALLA WALLA','WA'
UNION ALL SELECT 'AMA','RICK HUSBAND AMARILLO INTERNATIONAL','AMARILLO','TX'
UNION ALL SELECT 'ANC','ANCHORAGE INTERNATIONAL','ANCHORAGE','AK'
UNION ALL SELECT 'ANI','ANIAK','ANIAK','AK'
UNION ALL SELECT 'ASE','ASPEN-PITKIN COUNTY/SARDY FIELD','ASPEN','CO'
UNION ALL SELECT 'ATL','HARTSFIELD - JACKSON ATLANTA INTERNATIONAL','ATLANTA','GA'
UNION ALL SELECT 'ATW','OUTAGAMIE COUNTY REGIONAL','APPLETON','WI'
UNION ALL SELECT 'AUS','AUSTIN-BERGSTROM INTERNATIONAL','AUSTIN','TX'
UNION ALL SELECT 'AVL','ASHEVILLE REGIONAL','ASHEVILLE','NC'
UNION ALL SELECT 'AVP','WILKES-BARRE/SCRANTON INTERNATIONAL','AVOCA','PA'
UNION ALL SELECT 'AZO','KALAMAZOO/BATTLE CREEK INTERNATIONAL','KALAMAZOO','MI'
UNION ALL SELECT 'BDL','BRADLEY INTERNATIONAL','WINDSOR LOCKS','CT'
UNION ALL SELECT 'BET','BETHEL','BETHEL','AK'
UNION ALL SELECT 'BFI','BOEING FIELD/KING COUNTY INTERNATIONAL','SEATTLE','WA'
UNION ALL SELECT 'BFL','MEADOWS FIELD','BAKERSFIELD','CA'
UNION ALL SELECT 'BGM','GREATER BINGHAMTON/EDWIN A LINK FIELD','BINGHAMTON','NY'
UNION ALL SELECT 'BGR','BANGOR INTERNATIONAL','BANGOR','ME'
UNION ALL SELECT 'BHB','HANCOCK COUNTY-BAR HARBOR','BAR HARBOR','ME'
UNION ALL SELECT 'BHM','BIRMINGHAM-SHUTTLESWORTH INTERNATIONAL','BIRMINGHAM','AL'
UNION ALL SELECT 'BIL','BILLINGS LOGAN INTERNATIONAL','BILLINGS','MT'
UNION ALL SELECT 'BIS','BISMARCK MUNICIPAL','BISMARCK','ND'
UNION ALL SELECT 'BJI','BEMIDJI REGIONAL','BEMIDJI','MN'
UNION ALL SELECT 'BLI','BELLINGHAM INTERNATIONAL','BELLINGHAM','WA'
UNION ALL SELECT 'BMI','CENTRAL IL REGIONAL AIRPORT AT BLOOMINGTON-NORMAL','BLOOMINGTON-NORMAL AIRPORT','IL'
UNION ALL SELECT 'BNA','NASHVILLE INTERNATIONAL','NASHVILLE','TN'
UNION ALL SELECT 'BOI','BOISE AIR TERMINAL','BOISE','ID'
UNION ALL SELECT 'BOS','LOGAN INTERNATIONAL','BOSTON','MA'
UNION ALL SELECT 'BPT','JACK BROOKS REGIONAL','BEAUMONT/PORT ARTHUR','TX'
UNION ALL SELECT 'BQK','BRUNSWICK GOLDEN ISLES','BRUNSWICK','GA'
UNION ALL SELECT 'BQN','RAFAEL HERNANDEZ','AGUADILLA','PR'
UNION ALL SELECT 'BRD','BRAINERD LAKES REGIONAL','BRAINERD','MN'
UNION ALL SELECT 'BRO','BROWNSVILLE/SOUTH PADRE ISLAND INTERNATIONAL','BROWNSVILLE','TX'
UNION ALL SELECT 'BRW','WILEY POST-WILL ROGERS MEMORIAL','BARROW','AK'
UNION ALL SELECT 'BTM','BERT MOONEY','BUTTE','MT'
UNION ALL SELECT 'BTR','BATON ROUGE METROPOLITAN','BATON ROUGE','LA'
UNION ALL SELECT 'BTV','BURLINGTON INTERNATIONAL','BURLINGTON','VT'
UNION ALL SELECT 'BUF','BUFFALO NIAGARA INTERNATIONAL','BUFFALO','NY'
UNION ALL SELECT 'BUR','BOB HOPE','BURBANK','CA'
UNION ALL SELECT 'BVU','BOULDER CITY MUNICIPAL','BOULDER CITY','NV'
UNION ALL SELECT 'BWI','BALTIMORE/WASHINGTON INTERNATIONAL THURGOOD MARSHAL','BALTIMORE','MD'
UNION ALL SELECT 'BZN','GALLATIN FIELD','BOZEMAN','MT'
UNION ALL SELECT 'CAE','COLUMBIA METROPOLITAN','COLUMBIA','SC'
UNION ALL SELECT 'CAK','AKRON-CANTON REGIONAL','AKRON','OH'
UNION ALL SELECT 'CDV','MERLE K (MUDHOLE) SMITH','CORDOVA','AK'
UNION ALL SELECT 'CEC','JACK MCNAMARA FIELD','CRESCENT CITY','CA'
UNION ALL SELECT 'CHA','LOVELL FIELD','CHATTANOOGA','TN'
UNION ALL SELECT 'CHO','CHARLOTTESVILLE-ALBEMARLE','CHARLOTTESVILLE','VA'
UNION ALL SELECT 'CHS','CHARLESTON AFB/INTERNATIONAL','CHARLESTON','SC'
UNION ALL SELECT 'CIC','CHICO MUNICIPAL','CHICO','CA'
UNION ALL SELECT 'CID','THE EASTERN IOWA','CEDAR RAPIDS','IA'
UNION ALL SELECT 'CIU','CHIPPEWA COUNTY INTERNATIONAL','SAULT STE. MARIE','MI'
UNION ALL SELECT 'CKB','NORTH CENTRAL WEST VIRGINIA','CLARKSBURG','WV'
UNION ALL SELECT 'CLE','CLEVELAND-HOPKINS INTERNATIONAL','CLEVELAND','OH'
UNION ALL SELECT 'CLL','EASTERWOOD FIELD','COLLEGE STATION','TX'
UNION ALL SELECT 'CLM','WILLIAM R FAIRCHILD INTERNATIONAL','PORT ANGELES','WA'
UNION ALL SELECT 'CLT','CHARLOTTE/DOUGLAS INTERNATIONAL','CHARLOTTE','NC'
UNION ALL SELECT 'CMH','PORT COLUMBUS INTERNATIONAL','COLUMBUS','OH'
UNION ALL SELECT 'CMI','UNIVERSITY OF ILLINOIS-WILLARD','SAVOY','IL'
UNION ALL SELECT 'CMX','HOUGHTON COUNTY MEMORIAL','HANCOCK','MI'
UNION ALL SELECT 'COD','YELLOWSTONE REGIONAL','CODY','WY'
UNION ALL SELECT 'COS','CITY OF COLORADO SPRINGS MUNICIPAL','COLORADO SPRINGS','CO'
UNION ALL SELECT 'COU','COLUMBIA REGIONAL','COLUMBIA','MO'
UNION ALL SELECT 'CPR','CASPER/NATRONA COUNTY INTERNATIONAL','CASPER','WY'
UNION ALL SELECT 'CRP','CORPUS CHRISTI INTERNATIONAL','CORPUS CHRISTI','TX'
UNION ALL SELECT 'CRQ','MCCLELLAN-PALOMAR','CARLSBAD','CA'
UNION ALL SELECT 'CRW','YEAGER','CHARLESTON','WV'
UNION ALL SELECT 'CSG','COLUMBUS METROPOLITAN','COLUMBUS','GA'
UNION ALL SELECT 'CVG','CINCINNATI/NORTHERN KENTUCKY INTERNATIONAL','CINCINNATI','KY'
UNION ALL SELECT 'CVX','CHARLEVOIX MUNICIPAL','CHARLEVOIX','MI'
UNION ALL SELECT 'CWA','CENTRAL WISCONSIN','MOSINEE','WI'
UNION ALL SELECT 'CYS','CHEYENNE REGIONAL/JERRY OLSON FIELD','CHEYENNE','WY'
UNION ALL SELECT 'DAB','DAYTONA BEACH INTERNATIONAL','DAYTONA BEACH','FL'
UNION ALL SELECT 'DAL','DALLAS LOVE FIELD','DALLAS','TX'
UNION ALL SELECT 'DAY','JAMES M COX DAYTON INTERNATIONAL','DAYTON','OH'
UNION ALL SELECT 'DBQ','DUBUQUE REGIONAL','DUBUQUE','IA'
UNION ALL SELECT 'DCA','RONALD REAGAN WASHINGTON NATIONAL','WASHINGTON DC','VA'
UNION ALL SELECT 'DEN','DENVER INTERNATIONAL','DENVER','CO'
UNION ALL SELECT 'DFW','DALLAS/FORT WORTH INTERNATIONAL','FORT WORTH','TX'
UNION ALL SELECT 'DHN','DOTHAN REGIONAL','DOTHAN','AL'
UNION ALL SELECT 'DIK','DICKINSON - THEODORE ROOSEVELT REGIONAL','DICKINSON','ND'
UNION ALL SELECT 'DLG','DILLINGHAM','DILLINGHAM','AK'
UNION ALL SELECT 'DLH','DULUTH INTERNATIONAL','DULUTH','MN'
UNION ALL SELECT 'DRO','DURANGO-LA PLATA COUNTY','DURANGO','CO'
UNION ALL SELECT 'DRT','DEL RIO INTERNATIONAL','DEL RIO','TX'
UNION ALL SELECT 'DSM','DES MOINES INTERNATIONAL','DES MOINES','IA'
UNION ALL SELECT 'DTW','DETROIT METROPOLITAN WAYNE COUNTY','DETROIT','MI'
UNION ALL SELECT 'DUT','UNALASKA','UNALASKA','AK'
UNION ALL SELECT 'DXZ','ST GEORGE MUNICIPAL','BEAVER','UT'
UNION ALL SELECT 'EAT','PANGBORN MEMORIAL','EAST WENATCHEE','WA'
UNION ALL SELECT 'EAU','CHIPPEWA VALLEY REGIONAL','EAU CLAIRE','WI'
UNION ALL SELECT 'ECP','NORTHWEST FLORIDA BEACHES INTERNATIONAL','PANAMA CITY','FL'
UNION ALL SELECT 'EGE','EAGLE COUNTY REGIONAL','EAGLE','CO'
UNION ALL SELECT 'EKO','ELKO REGIONAL','ELKO','NV'
UNION ALL SELECT 'ELM','ELMIRA/CORNING REGIONAL','ELMIRA','NY'
UNION ALL SELECT 'ELP','EL PASO INTERNATIONAL','EL PASO','TX'
UNION ALL SELECT 'ENA','KENAI MUNICIPAL','KENAI','AK'
UNION ALL SELECT 'ENM','EMMONAK','EMMONAK','AK'
UNION ALL SELECT 'ERI','ERIE INTERNATIONAL/TOM RIDGE FIELD','ERIE','PA'
UNION ALL SELECT 'EUG','MAHLON SWEET FIELD','EUGENE','OR'
UNION ALL SELECT 'EVV','EVANSVILLE REGIONAL','EVANSVILLE','IN'
UNION ALL SELECT 'EWB','NEW BEDFORD REGIONAL','NEW BEDFORD','MA'
UNION ALL SELECT 'EWN','COASTAL CAROLINA REGIONAL','NEW BERN','NC'
UNION ALL SELECT 'EWR','NEWARK LIBERTY INTERNATIONAL','NEWARK','NJ'
UNION ALL SELECT 'EYW','KEY WEST INTERNATIONAL','KEY WEST','FL'
UNION ALL SELECT 'FAI','FAIRBANKS INTERNATIONAL','FAIRBANKS','AK'
UNION ALL SELECT 'FAR','HECTOR INTERNATIONAL','FARGO','ND'
UNION ALL SELECT 'FAT','FRESNO YOSEMITE INTERNATIONAL','FRESNO','CA'
UNION ALL SELECT 'FAY','FAYETTEVILLE REGIONAL/GRANNIS FIELD','FAYETTEVILLE','NC'
UNION ALL SELECT 'FHR','FRIDAY HARBOR','FRIDAY HARBOR','WA'
UNION ALL SELECT 'FLG','FLAGSTAFF PULLIAM','FLAGSTAFF','AZ'
UNION ALL SELECT 'FLL','FORT LAUDERDALE/HOLLYWOOD INTERNATIONAL','FORT LAUDERDALE','FL'
UNION ALL SELECT 'FLO','FLORENCE REGIONAL','FLORENCE','SC'
UNION ALL SELECT 'FMN','FOUR CORNERS REGIONAL','FARMINGTON','NM'
UNION ALL SELECT 'FNL','FORT COLLINS-LOVELAND MUNICIPAL','FORT COLLINS/LOVELAND','CO'
UNION ALL SELECT 'FNT','BISHOP INTERNATIONAL','FLINT','MI'
UNION ALL SELECT 'FOE','FORBES FIELD','TOPEKA','KS'
UNION ALL SELECT 'FSD','JOE FOSS FIELD','SIOUX FALLS','SD'
UNION ALL SELECT 'FSM','FORT SMITH REGIONAL','FORT SMITH','AR'
UNION ALL SELECT 'FWA','FORT WAYNE INTERNATIONAL','FORT WAYNE','IN'
UNION ALL SELECT 'GAL','EDWARD G. PITKA SR','GALENA','AK'
UNION ALL SELECT 'GCC','GILLETTE-CAMPBELL COUNTY','GILLETTE','WY'
UNION ALL SELECT 'GCK','GARDEN CITY REGIONAL','GARDEN CITY','KS'
UNION ALL SELECT 'GCN','GRAND CANYON NATIONAL PARK','GRAND CANYON','AZ'
UNION ALL SELECT 'GEG','SPOKANE INTERNATIONAL','SPOKANE','WA'
UNION ALL SELECT 'GFK','GRAND FORKS INTERNATIONAL','GRAND FORKS','ND'
UNION ALL SELECT 'GGG','EAST TEXAS REGIONAL','LONGVIEW','TX'
UNION ALL SELECT 'GJT','GRAND JUNCTION REGIONAL','GRAND JUNCTION','CO'
UNION ALL SELECT 'GNV','GAINESVILLE REGIONAL','GAINESVILLE','FL'
UNION ALL SELECT 'GPI','GLACIER PARK INTERNATIONAL','KALISPELL','MT'
UNION ALL SELECT 'GPT','GULFPORT-BILOXI INTERNATIONAL','GULFPORT','MS'
UNION ALL SELECT 'GRB','AUSTIN STRAUBEL INTERNATIONAL','GREEN BAY','WI'
UNION ALL SELECT 'GRI','CENTRAL NEBRASKA REGIONAL','GRAND ISLAND','NE'
UNION ALL SELECT 'GRK','ROBERT GRAY AAF','KILLEEN','TX'
UNION ALL SELECT 'GRO','ROTA INTERNATIONAL','ROTA ISLAND','MP'
UNION ALL SELECT 'GRR','GERALD R. FORD INTERNATIONAL','GRAND RAPIDS','MI'
UNION ALL SELECT 'GSN','FRANCISCO C. ADA/SAIPAN INTERNATIONAL','SAIPAN','MP'
UNION ALL SELECT 'GSO','PIEDMONT TRIAD INTERNATIONAL','GREENSBORO','NC'
UNION ALL SELECT 'GSP','GREENVILLE SPARTANBURG INTERNATIONAL','GREENVILLE','SC'
UNION ALL SELECT 'GTF','GREAT FALLS INTERNATIONAL','GREAT FALLS','MT'
UNION ALL SELECT 'GTR','GOLDEN TRIANGLE REGIONAL','COLUMBUS','MS'
UNION ALL SELECT 'GUC','GUNNISON-CRESTED BUTTE REGIONAL','GUNNISON','CO'
UNION ALL SELECT 'GUM','GUAM INTERNATIONAL','TAMUNING','GU'
UNION ALL SELECT 'HDN','YAMPA VALLEY','HAYDEN','CO'
UNION ALL SELECT 'HGR','HAGERSTOWN REGIONAL-RICHARD A HENSON FIELD','HAGERSTOWN','MD'
UNION ALL SELECT 'HIB','RANGE REGIONAL','HIBBING','MN'
UNION ALL SELECT 'HLN','HELENA REGIONAL','HELENA','MT'
UNION ALL SELECT 'HNH','HOONAH','HOONAH','AK'
UNION ALL SELECT 'HNL','HONOLULU INTERNATIONAL','HONOLULU','HI'
UNION ALL SELECT 'HOM','HOMER','HOMER','AK'
UNION ALL SELECT 'HOU','WILLIAM P HOBBY','HOUSTON','TX'
UNION ALL SELECT 'HPN','WESTCHESTER COUNTY','WHITE PLAINS','NY'
UNION ALL SELECT 'HRL','VALLEY INTERNATIONAL','HARLINGEN','TX'
UNION ALL SELECT 'HSV','HUNTSVILLE INTERNATIONAL-CARL T JONES FIELD','HUNTSVILLE','AL'
UNION ALL SELECT 'HTS','TRI-STATE/MILTON J. FERGUSON FIELD','HUNTINGTON','WV'
UNION ALL SELECT 'HVN','TWEED-NEW HAVEN','NEW HAVEN','CT'
UNION ALL SELECT 'HXD','HILTON HEAD','HILTON HEAD ISLAND','SC'
UNION ALL SELECT 'HYA','BARNSTABLE MUNICIPAL-BOARDMAN/POLANDO FIELD','HYANNIS','MA'
UNION ALL SELECT 'IAD','DULLES INTERNATIONAL','DULLES','VA'
UNION ALL SELECT 'IAG','NIAGARA FALLS INTERNATIONAL','NIAGARA FALLS','NY'
UNION ALL SELECT 'IAH','GEORGE BUSH INTERCONTINENTAL','HOUSTON','TX'
UNION ALL SELECT 'ICT','WICHITA MID-CONTINENT','WICHITA','KS'
UNION ALL SELECT 'IDA','IDAHO FALLS REGIONAL','IDAHO FALLS','ID'
UNION ALL SELECT 'IFP','LAUGHLIN/BULLHEAD INTERNATIONAL','BULLHEAD CITY','AZ'
UNION ALL SELECT 'ILM','WILMINGTON INTERNATIONAL','WILMINGTON','NC'
UNION ALL SELECT 'IND','INDIANAPOLIS INTERNATIONAL','INDIANAPOLIS','IN'
UNION ALL SELECT 'INL','FALLS INTERNATIONAL','INTERNATIONAL FALLS','MN'
UNION ALL SELECT 'IPT','WILLIAMSPORT REGIONAL','WILLIAMSPORT','PA'
UNION ALL SELECT 'ISN','SLOULIN FIELD INTERNATIONAL','WILLISTON','ND'
UNION ALL SELECT 'ISP','LONG ISLAND MACARTHUR','ISLIP','NY'
UNION ALL SELECT 'ITH','ITHACA TOMPKINS REGIONAL','ITHACA','NY'
UNION ALL SELECT 'ITO','HILO INTERNATIONAL','HILO','HI'
UNION ALL SELECT 'IWA','PHOENIX-MESA GATEWAY','MESA','AZ'
UNION ALL SELECT 'IYK','INYOKERN','INYOKERN','CA'
UNION ALL SELECT 'JAC','JACKSON HOLE','JACKSON','WY'
UNION ALL SELECT 'JAN','JACKSON-EVERS INTERNATIONAL','JACKSON','MS'
UNION ALL SELECT 'JAX','JACKSONVILLE INTERNATIONAL','JACKSONVILLE','FL'
UNION ALL SELECT 'JFK','JOHN F KENNEDY INTERNATIONAL','NEW YORK','NY'
UNION ALL SELECT 'JNU','JUNEAU INTERNATIONAL','JUNEAU','AK'
UNION ALL SELECT 'KOA','KONA INTERNATIONAL','KAILUA KONA','HI'
UNION ALL SELECT 'KTN','KETCHIKAN INTERNATIONAL','KETCHIKAN','AK'
UNION ALL SELECT 'LAN','CAPITAL REGION INTERNATIONAL','CLINTON (TOWNSHIP OF)','MI'
UNION ALL SELECT 'LAS','MCCARRAN INTERNATIONAL','LAS VEGAS','NV'
UNION ALL SELECT 'LAW','LAWTON-FORT SILL REGIONAL','LAWTON','OK'
UNION ALL SELECT 'LAX','LOS ANGELES INTERNATIONAL','LOS ANGELES','CA'
UNION ALL SELECT 'LBB','LUBBOCK PRESTON SMITH INTERNATIONAL','LUBBOCK','TX'
UNION ALL SELECT 'LCH','LAKE CHARLES REGIONAL','LAKE CHARLES','LA'
UNION ALL SELECT 'LEX','BLUE GRASS','LEXINGTON','KY'
UNION ALL SELECT 'LFT','LAFAYETTE REGIONAL','LAFAYETTE','LA'
UNION ALL SELECT 'LGA','LA GUARDIA','NEW YORK','NY'
UNION ALL SELECT 'LGB','LONG BEACH','LONG BEACH','CA'
UNION ALL SELECT 'LIH','LIHUE','LIHUE','HI'
UNION ALL SELECT 'LIT','ADAMS FIELD','LITTLE ROCK','AR'
UNION ALL SELECT 'LMT','KLAMATH FALLS','KLAMATH FALLS','OR'
UNION ALL SELECT 'LNK','LINCOLN','LINCOLN','NE'
UNION ALL SELECT 'LNY','LANAI','LANAI CITY','HI'
UNION ALL SELECT 'LRD','LAREDO INTERNATIONAL','LAREDO','TX'
UNION ALL SELECT 'LSE','LA CROSSE MUNICIPAL','LA CROSSE','WI'
UNION ALL SELECT 'LWB','GREENBRIER VALLEY','LEWISBURG','WV'
UNION ALL SELECT 'LWS','LEWISTON-NEZ PERCE COUNTY','LEWISTON','ID'
UNION ALL SELECT 'LYH','LYNCHBURG REGIONAL/PRESTON GLENN FIELD','TIMBERLAKE','VA'
UNION ALL SELECT 'MAF','MIDLAND INTERNATIONAL','MIDLAND','TX'
UNION ALL SELECT 'MBA','MANOKOTAK','MANOKOTAK','AK'
UNION ALL SELECT 'MBS','MBS INTERNATIONAL','SAGINAW','MI'
UNION ALL SELECT 'MCI','KANSAS CITY INTERNATIONAL','KANSAS CITY','MO'
UNION ALL SELECT 'MCO','ORLANDO INTERNATIONAL','ORLANDO','FL'
UNION ALL SELECT 'MCW','MASON CITY MUNICIPAL','MASON CITY','IA'
UNION ALL SELECT 'MDT','HARRISBURG INTERNATIONAL','HARRISBURG','PA'
UNION ALL SELECT 'MDW','MIDWAY INTERNATIONAL','CHICAGO','IL'
UNION ALL SELECT 'MEI','KEY FIELD','MERIDIAN','MS'
UNION ALL SELECT 'MEM','MEMPHIS INTERNATIONAL','MEMPHIS','TN'
UNION ALL SELECT 'MFE','MCALLEN MILLER INTERNATIONAL','MCALLEN','TX'
UNION ALL SELECT 'MFR','ROGUE VALLEY INTERNATIONAL - MEDFORD','MEDFORD','OR'
UNION ALL SELECT 'MGM','MONTGOMERY REGIONAL (DANNELLY FIELD)','MONTGOMERY','AL'
UNION ALL SELECT 'MGW','MORGANTOWN MUNICIPAL-WALTER L. BILL HART FIELD','MORGANTOWN','WV'
UNION ALL SELECT 'MHK','MANHATTAN REGIONAL','MANHATTAN','KS'
UNION ALL SELECT 'MHT','MANCHESTER','MANCHESTER','NH'
UNION ALL SELECT 'MIA','MIAMI INTERNATIONAL','MIAMI','FL'
UNION ALL SELECT 'MKE','GENERAL MITCHELL INTERNATIONAL','MILWAUKEE','WI'
UNION ALL SELECT 'MKG','MUSKEGON COUNTY','MUSKEGON','MI'
UNION ALL SELECT 'MKK','MOLOKAI','KAUNAKAKAI','HI'
UNION ALL SELECT 'MLB','MELBOURNE INTERNATIONAL','MELBOURNE','FL'
UNION ALL SELECT 'MLI','QUAD CITY INTERNATIONAL','MOLINE','IL'
UNION ALL SELECT 'MLU','MONROE REGIONAL','MONROE','LA'
UNION ALL SELECT 'MMH','MAMMOTH YOSEMITE','MAMMOTH LAKES','CA'
UNION ALL SELECT 'MOB','MOBILE REGIONAL','MOBILE','AL'
UNION ALL SELECT 'MOD','MODESTO CITY COUNTY-HARRY SHAM FIELD','MODESTO','CA'
UNION ALL SELECT 'MOT','MINOT INTERNATIONAL','MINOT','ND'
UNION ALL SELECT 'MRI','MERRILL FIELD','ANCHORAGE','AK'
UNION ALL SELECT 'MRY','MONTEREY PENINSULA','MONTEREY','CA'
UNION ALL SELECT 'MSN','DANE COUNTY REGIONAL-TRUAX FIELD','MADISON','WI'
UNION ALL SELECT 'MSO','MISSOULA INTERNATIONAL','MISSOULA','MT'
UNION ALL SELECT 'MSP','MINNEAPOLIS-ST PAUL INTERNATIONAL','MINNEAPOLIS','MN'
UNION ALL SELECT 'MSY','NEW ORLEANS INTERNATIONAL','NEW ORLEANS','LA'
UNION ALL SELECT 'MTJ','MONTROSE REGIONAL','MONTROSE','CO'
UNION ALL SELECT 'MVY','MARTHAS VINEYARD','VINEYARD HAVEN','MA'
UNION ALL SELECT 'MYR','MYRTLE BEACH INTERNATIONAL','MYRTLE BEACH','SC'
UNION ALL SELECT 'NYL','YUMA MCAS/YUMA INTERNATIONAL','YUMA','AZ'
UNION ALL SELECT 'OAJ','ALBERT J ELLIS','JACKSONVILLE','NC'
UNION ALL SELECT 'OAK','OAKLAND INTERNATIONAL','OAKLAND','CA'
UNION ALL SELECT 'OGG','KAHULUI','KAHULUI','HI'
UNION ALL SELECT 'OKC','WILL ROGERS WORLD','OKLAHOMA CITY','OK'
UNION ALL SELECT 'OMA','EPPLEY AIRFIELD','OMAHA','NE'
UNION ALL SELECT 'OME','NOME','NOME','AK'
UNION ALL SELECT 'ONT','ONTARIO INTERNATIONAL','ONTARIO','CA'
UNION ALL SELECT 'ORD','O''HARE INTERNATIONAL','CHICAGO','IL'
UNION ALL SELECT 'ORF','NORFOLK INTERNATIONAL','NORFOLK','VA'
UNION ALL SELECT 'OTH','SOUTHWEST OREGON REGIONAL','NORTH BEND','OR'
UNION ALL SELECT 'OTZ','RALPH WIEN MEMORIAL','KOTZEBUE','AK'
UNION ALL SELECT 'OWB','OWENSBORO-DAVIESS COUNTY','OWENSBORO','KY'
UNION ALL SELECT 'PAH','BARKLEY REGIONAL','PADUCAH','KY'
UNION ALL SELECT 'PBG','PLATTSBURGH INTERNATIONAL','PLATTSBURGH','NY'
UNION ALL SELECT 'PBI','PALM BEACH INTERNATIONAL','WEST PALM BEACH','FL'
UNION ALL SELECT 'PDX','PORTLAND INTERNATIONAL','PORTLAND','OR'
UNION ALL SELECT 'PGA','PAGE MUNICIPAL','PAGE','AZ'
UNION ALL SELECT 'PGD','PUNTA GORDA','PUNTA GORDA','FL'
UNION ALL SELECT 'PGV','PITT-GREENVILLE','GREENVILLE','NC'
UNION ALL SELECT 'PHF','NEWPORT NEWS/WILLIAMSBURG INTERNATIONAL','NEWPORT NEWS','VA'
UNION ALL SELECT 'PHL','PHILADELPHIA INTERNATIONAL','PHILADELPHIA','PA'
UNION ALL SELECT 'PHX','PHOENIX SKY HARBOR INTERNATIONAL','PHOENIX','AZ'
UNION ALL SELECT 'PIA','GENERAL DOWNING - PEORIA INTERNATIONAL','PEORIA','IL'
UNION ALL SELECT 'PIB','HATTIESBURG-LAUREL REGIONAL','MOSELLE','MS'
UNION ALL SELECT 'PIE','ST. PETERSBURG-CLEARWATER INTERNATIONAL','CLEARWATER','FL'
UNION ALL SELECT 'PIH','POCATELLO REGIONAL','ARBON VALLEY','ID'
UNION ALL SELECT 'PIR','PIERRE REGIONAL','PIERRE','SD'
UNION ALL SELECT 'PIT','PITTSBURGH INTERNATIONAL','PITTSBURGH','PA'
UNION ALL SELECT 'PLN','PELLSTON REGIONAL AIRPORT OF EMMET COUNTY','PELLSTON','MI'
UNION ALL SELECT 'PNS','PENSACOLA GULF COAST REGIONAL','PENSACOLA','FL'
UNION ALL SELECT 'PPG','PAGO PAGO INTERNATIONAL','PAGO PAGO','AS'
UNION ALL SELECT 'PQI','NORTHERN MAINE REGIONAL AIRPORT AT PRESQUE ISLE','PRESQUE ISLE','ME'
UNION ALL SELECT 'PSC','TRI-CITIES','PASCO','WA'
UNION ALL SELECT 'PSE','MERCEDITA','PONCE','PR'
UNION ALL SELECT 'PSG','PETERSBURG JAMES A JOHNSON','PETERSBURG','AK'
UNION ALL SELECT 'PSP','PALM SPRINGS INTERNATIONAL','PALM SPRINGS','CA'
UNION ALL SELECT 'PUB','PUEBLO MEMORIAL','PUEBLO','CO'
UNION ALL SELECT 'PUW','PULLMAN/MOSCOW REGIONAL','PULLMAN','WA'
UNION ALL SELECT 'PVC','PROVINCETOWN MUNICIPAL','PROVINCETOWN','MA'
UNION ALL SELECT 'PVD','THEODORE FRANCIS GREEN STATE','PROVIDENCE','RI'
UNION ALL SELECT 'PWM','PORTLAND INTERNATIONAL JETPORT','PORTLAND','ME'
UNION ALL SELECT 'RAP','RAPID CITY REGIONAL','RAPID CITY','SD'
UNION ALL SELECT 'RDD','REDDING MUNICIPAL','REDDING','CA'
UNION ALL SELECT 'RDM','ROBERTS FIELD','REDMOND','OR'
UNION ALL SELECT 'RDU','RALEIGH-DURHAM INTERNATIONAL','RALEIGH','NC'
UNION ALL SELECT 'RFD','CHICAGO/ROCKFORD INTERNATIONAL','ROCKFORD','IL'
UNION ALL SELECT 'RHI','RHINELANDER-ONEIDA COUNTY','RHINELANDER','WI'
UNION ALL SELECT 'RIC','RICHMOND INTERNATIONAL','RICHMOND','VA'
UNION ALL SELECT 'RIW','RIVERTON REGIONAL','RIVERTON','WY'
UNION ALL SELECT 'RKD','KNOX COUNTY REGIONAL','ROCKLAND','ME'
UNION ALL SELECT 'RKS','ROCK SPRINGS-SWEETWATER COUNTY','ROCK SPRINGS','WY'
UNION ALL SELECT 'RNO','RENO/TAHOE INTERNATIONAL','RENO','NV'
UNION ALL SELECT 'ROA','ROANOKE REGIONAL/WOODRUM FIELD','ROANOKE','VA'
UNION ALL SELECT 'ROC','GREATER ROCHESTER INTERNATIONAL','ROCHESTER','NY'
UNION ALL SELECT 'ROW','ROSWELL INTERNATIONAL AIR CENTER','ROSWELL','NM'
UNION ALL SELECT 'RST','ROCHESTER INTERNATIONAL','ROCHESTER','MN'
UNION ALL SELECT 'RSW','SOUTHWEST FLORIDA INTERNATIONAL','FORT MYERS','FL'
UNION ALL SELECT 'RVR','JOSE APONTE DE LA TORRE','CEIBA','PR'
UNION ALL SELECT 'SAF','SANTA FE MUNICIPAL','SANTA FE','NM'
UNION ALL SELECT 'SAN','SAN DIEGO INTERNATIONAL','SAN DIEGO','CA'
UNION ALL SELECT 'SAT','SAN ANTONIO INTERNATIONAL','SAN ANTONIO','TX'
UNION ALL SELECT 'SAV','SAVANNAH/HILTON HEAD INTERNATIONAL','SAVANNAH','GA'
UNION ALL SELECT 'SAW','SAWYER INTERNATIONAL','GWINN','MI'
UNION ALL SELECT 'SBA','SANTA BARBARA MUNICIPAL','SANTA BARBARA','CA'
UNION ALL SELECT 'SBN','SOUTH BEND REGIONAL','SOUTH BEND','IN'
UNION ALL SELECT 'SBP','SAN LUIS COUNTY REGIONAL','SAN LUIS OBISPO','CA'
UNION ALL SELECT 'SBY','SALISBURY-OCEAN CITY WICOMICO REGIONAL','SALISBURY','MD'
UNION ALL SELECT 'SCC','DEADHORSE','DEADHORSE','AK'
UNION ALL SELECT 'SCK','STOCKTON METROPOLITAN','STOCKTON','CA'
UNION ALL SELECT 'SDF','LOUISVILLE INTERNATIONAL','LOUISVILLE','KY'
UNION ALL SELECT 'SEA','SEATTLE-TACOMA INTERNATIONAL','SEATTLE','WA'
UNION ALL SELECT 'SFB','ORLANDO SANFORD INTERNATIONAL','SANFORD','FL'
UNION ALL SELECT 'SFO','SAN FRANCISCO INTERNATIONAL','SAN FRANCISCO','CA'
UNION ALL SELECT 'SGF','SPRINGFIELD-BRANSON NATIONAL','SPRINGFIELD','MO'
UNION ALL SELECT 'SHD','SHENANDOAH VALLEY REGIONAL','WEYERS CAVE','VA'
UNION ALL SELECT 'SHR','SHERIDAN COUNTY','SHERIDAN','WY'
UNION ALL SELECT 'SHV','SHREVEPORT REGIONAL','SHREVEPORT','LA'
UNION ALL SELECT 'SIG','FERNANDO LUIS RIBAS DOMINICCI','SAN JUAN','PR'
UNION ALL SELECT 'SIT','SITKA ROCKY GUTIERREZ','SITKA','AK'
UNION ALL SELECT 'SJC','SAN JOSE INTERNATIONAL','SAN JOSE','CA'
UNION ALL SELECT 'SJT','SAN ANGELO REGIONAL/MATHIS FIELD','SAN ANGELO','TX'
UNION ALL SELECT 'SJU','LUIS MUNOZ MARIN INTERNATIONAL','SAN JUAN','PR'
UNION ALL SELECT 'SLC','SALT LAKE CITY INTERNATIONAL','SALT LAKE CITY','UT'
UNION ALL SELECT 'SMF','SACRAMENTO INTERNATIONAL','SACRAMENTO','CA'
UNION ALL SELECT 'SMX','SANTA MARIA PUBLIC/CAPT G ALLAN HANCOCK FIELD','SANTA MARIA','CA'
UNION ALL SELECT 'SNA','JOHN WAYNE AIRPORT-ORANGE COUNTY','SANTA ANA','CA'
UNION ALL SELECT 'SPI','ABRAHAM LINCOLN CAPITAL','SPRINGFIELD','IL'
UNION ALL SELECT 'SPS','SHEPPARD AFB/WICHITA FALLS MUNICIPAL','WICHITA FALLS','TX'
UNION ALL SELECT 'SRQ','SARASOTA/BRADENTON INTERNATIONAL','SARASOTA','FL'
UNION ALL SELECT 'STL','ST LOUIS INTERNATIONAL','ST. LOUIS','MO'
UNION ALL SELECT 'STS','CHARLES M. SCHULZ - SONOMA COUNTY','SANTA ROSA','CA'
UNION ALL SELECT 'STT','CYRIL E KING','CHARLOTTE AMALIE','VI'
UNION ALL SELECT 'STX','HENRY E ROHLSEN','CHRISTIANSTED','VI'
UNION ALL SELECT 'SUN','FRIEDMAN MEMORIAL','HAILEY','ID'
UNION ALL SELECT 'SUX','SIOUX GATEWAY/COL. BUD DAY FIELD','SIOUX CITY','IA'
UNION ALL SELECT 'SWF','STEWART INTERNATIONAL','NEWBURGH','NY'
UNION ALL SELECT 'SYR','SYRACUSE HANCOCK INTERNATIONAL','SYRACUSE','NY'
UNION ALL SELECT 'TLH','TALLAHASSEE REGIONAL','TALLAHASSEE','FL'
UNION ALL SELECT 'TNI','TINIAN INTERNATIONAL','TINIAN (MUNICIPALITY)','MP'
UNION ALL SELECT 'TOL','TOLEDO EXPRESS','TOLEDO','OH'
UNION ALL SELECT 'TPA','TAMPA INTERNATIONAL','TAMPA','FL'
UNION ALL SELECT 'TRI','TRI-CITIES REGIONAL TN/VA','BRISTOL/JOHNSON/KINGSPORT','TN'
UNION ALL SELECT 'TUL','TULSA INTERNATIONAL','TULSA','OK'
UNION ALL SELECT 'TUP','TUPELO REGIONAL','TUPELO','MS'
UNION ALL SELECT 'TUS','TUCSON INTERNATIONAL','TUCSON','AZ'
UNION ALL SELECT 'TVC','CHERRY CAPITAL','TRAVERSE CITY','MI'
UNION ALL SELECT 'TWF','JOSLIN FIELD - MAGIC VALLEY REGIONAL','TWIN FALLS','ID'
UNION ALL SELECT 'TXK','TEXARKANA REGIONAL-WEBB FIELD','TEXARKANA','AR'
UNION ALL SELECT 'TYR','TYLER POUNDS REGIONAL','TYLER','TX'
UNION ALL SELECT 'TYS','MCGHEE TYSON','KNOXVILLE','TN'
UNION ALL SELECT 'UNK','UNALAKLEET','UNALAKLEET','AK'
UNION ALL SELECT 'UNV','UNIVERSITY PARK','STATE COLLEGE','PA'
UNION ALL SELECT 'UTA','TUNICA MUNICIPAL','TUNICA','MS'
UNION ALL SELECT 'VDZ','VALDEZ PIONEER FIELD','VALDEZ','AK'
UNION ALL SELECT 'VGT','NORTH LAS VEGAS','LAS VEGAS','NV'
UNION ALL SELECT 'VLD','VALDOSTA REGIONAL','VALDOSTA','GA'
UNION ALL SELECT 'VPS','EGLIN AFB','VALPARAISO','FL'
UNION ALL SELECT 'VQS','ANTONIO RIVERA RODRIGUEZ','ISLA DE VIEQUES','PR'
UNION ALL SELECT 'WRG','WRANGELL','WRANGELL','AK'
UNION ALL SELECT 'WST','WESTERLY STATE','WESTERLY','RI'
UNION ALL SELECT 'XNA','NORTHWEST ARKANSAS REGIONAL','BENTONVILLE','AR'
UNION ALL SELECT 'YAK','YAKUTAT','YAKUTAT','AK'
UNION ALL SELECT 'YKM','YAKIMA AIR TERMINAL/MCALLISTER FIELD','YAKIMA','WA'
UNION ALL SELECT 'YNG','YOUNGSTOWN-WARREN REGIONAL','YOUNGSTOWN','OH'
)
UPDATE a
SET [Name] = b.Name
    ,[City] = b.City
    ,[State] = b.[State]
FROM Airports a
INNER JOIN USAAirports b ON a.IATA_Code = b.IATA_Code
WHERE Country LIKE 'USA%'

INSERT INTO Airports (ICAO_Code, IATA_Code, Name, City, Country)
SELECT 'UNK', a.IATA_Code, a.City, a.City, a.Country
FROM (
-- PNG Airports
SELECT 'AGL','','WANIGELA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'AWB','','AWABA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'BOT','','BOSSET', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'BUA','','BUKA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'CMU','','KUNDIAWA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'DAU','','DARU', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'EFG','','EFOGI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'FNE','','FANE', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'GKA','','GOROKA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'GUR','','GURNEY / ALOTAU', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'HGU','','MOUNT HAGEN', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'HKG','','HONG KONG', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'HKN','','HOSKINS AIRPORT (PNG)', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'ITK','','ITOKAMA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'KGW','','KAGI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'KKD','','KOKODA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'KMA','','KEREMA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'KRI','','KIKORI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'KUL','','KUALA LUMPUR', 'MALAYSIA'
UNION ALL SELECT 'KVG','','KAVIENG', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'LAE','','LAE', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'LMY','','LAKE MURRAY', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'LNV','','LIHIR', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'LSA','','LOSUIA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'MAG','','MADANG', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'MAS','','MANUS ISLAND', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'MDU','','MENDI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'MIS','','MISIMA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'MMV','','MILEI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'MRM','','MANARI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'MXH','','MORO', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'OBX','','OBO', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'ONB','','ONONGE', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'OPU','','BALIMO', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'PNP','','POPONDETTA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'POM','','PORT MORESBY', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'RAB','','RABAUL (TOKUA)', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'SGK','','SANGAPI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'SIN','','SINGAPORE', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'SKC','','SUKI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'TBG','','TABUBIL', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'TDS','','SASEREME', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'TFI','','TUFI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'TIZ','','TARI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'TPI','','TAPINI', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'UNG','','KIUNGA', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'VAI','','VANIMO', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'WPM','','WIPIM', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'WTP','','WOITAPE', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'WWK','','WEWAK', 'PAPUA NEW GUINEA'
UNION ALL SELECT 'WBM','','WAPENAMANDA', 'PAPUA NEW GUINEA'
-- Thailand airports
UNION ALL SELECT 'CNX',UPPER('Chiang Mai International Airport'), 'CHIANG MAI', 'THAILAND' 
UNION ALL SELECT 'CEI',UPPER('Chiang Rai International Airport'), 'CHIANG RAI', 'THAILAND' 
-- Other countries
UNION ALL SELECT 'BNE','','BRISBANE', 'AUSTRALIA'
UNION ALL SELECT 'CNS','','CAIRNS', 'AUSTRALIA'
UNION ALL SELECT 'HIR','','HENDERSON INTL', 'SOLOMEN ISLANDS'
UNION ALL SELECT 'MNL','','MANILA', 'PHILLIPPINES'
UNION ALL SELECT 'NAN','','NADI INTL', 'FIJI'
UNION ALL SELECT 'NRT','','NARITA', 'JAPAN'
UNION ALL SELECT 'SYD','','SYDNEY', 'AUSTRALIA'
) a(IATA_Code, Name, City, Country)
LEFT OUTER JOIN Airports b ON a.IATA_Code = b.IATA_Code
WHERE b.IATA_Code IS NULL
GO


-- Roughly set the UTC time zone for airports
UPDATE a
SET UTC = CASE IATA_Code 
        WHEN 'HKG' THEN '+08:00' 
        WHEN 'MNL' THEN '+08:00' 
        WHEN 'NRT' THEN '+09:00' 
        WHEN 'SIN' THEN '+08:00' 
        WHEN 'LAX' THEN '-08:00' 
        WHEN 'JFK' THEN '-05:00' 
    ELSE CASE Country 
        WHEN 'FRENCH POLYNESIA' THEN '-10:00'
        WHEN 'MARQUESAS ISLANDS' THEN '-09:30'
        WHEN 'GAMBIER ISLANDS' THEN '-09:00'
        WHEN 'CLIPPERTON ISLAND' THEN '-08:00'
        WHEN 'GUADELOUPE' THEN '-04:00'
        WHEN 'FRENCH GUIANA' THEN '-03:00'
        WHEN 'FRANCE' THEN '+01:00'
        WHEN 'CORSE ISL.' THEN '+01:00'
        WHEN 'CENTRAL AFRICAN REP.' THEN '+01:00'
        WHEN 'SAO TOME & PRINCIPE' THEN '+00:00'
        WHEN 'MAYOTTE' THEN '+03:00'
        WHEN 'MAYOTTE ISLAND' THEN '+03:00'
        WHEN 'REUNION' THEN '+04:00'
        WHEN 'REUNION ISLAND' THEN '+04:00'
        WHEN 'KERGUELEN ISLANDS' THEN '+05:00'
        WHEN 'NEW CALEDONIA' THEN '+11:00'
        WHEN 'WALLIS AND FUTUNA' THEN '+12:00'
        WHEN 'BAKER ISLAND' THEN '-12:00'
        WHEN 'AMERICAN SAMOA' THEN '-11:00'
        WHEN 'HAWAII' THEN '-10:00'
        WHEN 'UNITED STATES' THEN '-05:00'
        WHEN 'USA' THEN '-05:00'
        WHEN 'PUERTO RICO' THEN '-04:00'
        WHEN 'RUSSIA' THEN '+04:00'
        WHEN 'MCDONALD ISLANDS' THEN '+05:00'
        WHEN 'COCOS ISLANDS' THEN '+06:30'
        WHEN 'CHRISTMAS ISLAND' THEN '+07:00'
        WHEN 'AUSTRALIA' THEN '+09:30'
        WHEN 'LORD HOWE ISLAND' THEN '+10:30'
        WHEN 'NORFOLK ISLAND' THEN '+11:30'
        WHEN 'PITCAIRN ISLANDS' THEN '-08:00'
        WHEN 'CAYMEN ISLANDS' THEN '-05:00'
        WHEN 'ANGUILLA' THEN '-04:00'
        WHEN 'U.K.' THEN '+00:00'
        WHEN 'ENGLAND' THEN '+00:00'
        WHEN 'GIBRALTER' THEN '+01:00'
        WHEN 'CANADA' THEN '-05:00'
        WHEN 'DENMARK' THEN '+01:00'
        WHEN 'COOK ISLANDS' THEN '-10:00'
        WHEN 'NEW ZEALAND' THEN '+12:00'
        WHEN 'BRAZIL' THEN '-03:00'
        WHEN 'INDONESIA' THEN '+08:00'
        WHEN 'KIRIBATI' THEN '+12:00'
        WHEN 'MEXICO' THEN '-06:00'
        WHEN 'EASTER ISLAND' THEN '-06:00'
        WHEN 'CHILE' THEN '-04:00'
        WHEN 'CONGO' THEN '+01:00'
        WHEN 'GALAPAGOS' THEN '-06:00'
        WHEN 'ECUADOR' THEN '-05:00'
        WHEN 'MICRONESIA' THEN '+10:00'
        WHEN 'KAZAKHSTAN' THEN '+05:00'
        WHEN 'NETHERLANDS' THEN '+01:00'
        WHEN 'MONGOLIA' THEN '+08:00'
        WHEN 'AZORES' THEN '-01:00'
        WHEN 'PORTUGAL' THEN '+00:00'
        WHEN 'CANARY ISLANDS' THEN '+00:00'
        WHEN 'SPAIN' THEN '+01:00'
        WHEN 'AFGHANISTAN' THEN '+04:30'
        WHEN 'ALBANIA' THEN '+01:00'
        WHEN 'ALGERIA' THEN '+01:00'
        WHEN 'ANDORRA' THEN '+01:00'
        WHEN 'ANGOLA' THEN '+01:00'
        WHEN 'ANTIGUA AND BARBUDA' THEN '-04:00'
        WHEN 'ARGENTINA' THEN '-03:00'
        WHEN 'ARMENIA' THEN '+04:00'
        WHEN 'AUSTRIA' THEN '+01:00'
        WHEN 'AZERBAIJAN' THEN '+04:00'
        WHEN 'BAHAMAS' THEN '-05:00'
        WHEN 'BAHRAIN' THEN '+03:00'
        WHEN 'BANGLADESH' THEN '+06:00'
        WHEN 'BARBADOS' THEN '-04:00'
        WHEN 'BELARUS' THEN '+03:00'
        WHEN 'BELGIUM' THEN '+01:00'
        WHEN 'BELIZE' THEN '-06:00'
        WHEN 'BENIN' THEN '+01:00'
        WHEN 'BHUTAN' THEN '+06:00'
        WHEN 'BOLIVIA' THEN '-04:00'
        WHEN 'BOSNIA AND HERZEGOVINA' THEN '+01:00'
        WHEN 'BOSNIA-HERCEGOVINA' THEN '+01:00'
        WHEN 'YUGOSLAVIA' THEN '+01:00'
        WHEN 'BOTSWANA' THEN '+02:00'
        WHEN 'BRUNEI' THEN '+08:00'
        WHEN 'BULGARIA' THEN '+02:00'
        WHEN 'BURKINA FASO' THEN '+00:00'
        WHEN 'BURUNDI' THEN '+02:00'
        WHEN 'CAMBODIA' THEN '+07:00'
        WHEN 'CAMEROON' THEN '+01:00'
        WHEN 'CAPE VERDE' THEN '-01:00'
        WHEN 'CENTRAL AFRICAN REPUBLIC' THEN '+01:00'
        WHEN 'CHAD' THEN '+01:00'
        WHEN 'CHINA' THEN '+08:00'
        WHEN 'CHINA, REPUBLIC OF' THEN '+08:00'
        WHEN 'COLOMBIA' THEN '-05:00'
        WHEN 'COMOROS' THEN '+03:00'
        WHEN 'COMOROS ISLANDS' THEN '+03:00'
        WHEN 'REPUBLIC OF THE CONGO' THEN '+01:00'
        WHEN 'COSTA RICA' THEN '-06:00'
        WHEN 'CTE D''IVOIRE' THEN '+00:00'
        WHEN 'CROATIA' THEN '+01:00'
        WHEN 'CUBA' THEN '-05:00'
        WHEN 'CYPRUS' THEN '+02:00'
        WHEN 'CZECH REPUBLIC' THEN '+01:00'
        WHEN 'DJIBOUTI' THEN '+03:00'
        WHEN 'DOMINICA' THEN '-04:00'
        WHEN 'DOMINICAN REPUBLIC' THEN '-04:00'
        WHEN 'EAST TIMOR' THEN '+09:00'
        WHEN 'EGYPT' THEN '+02:00'
        WHEN 'EL SALVADOR' THEN '-06:00'
        WHEN 'EQUATORIAL GUINEA' THEN '+01:00'
        WHEN 'ERITREA' THEN '+03:00'
        WHEN 'ESTONIA' THEN '+02:00'
        WHEN 'ETHIOPIA' THEN '+03:00'
        WHEN 'FIJI' THEN '+12:00'
        WHEN 'FINLAND' THEN '+02:00'
        WHEN 'GABON' THEN '+01:00'
        WHEN 'GAMBIA' THEN '+00:00'
        WHEN 'GEORGIA' THEN '+04:00'
        WHEN 'GERMANY' THEN '+01:00'
        WHEN 'GHANA' THEN '+00:00'
        WHEN 'GREECE' THEN '+02:00'
        WHEN 'GRENADA' THEN '-04:00'
        WHEN 'GUATEMALA' THEN '-06:00'
        WHEN 'GUINEA' THEN '+00:00'
        WHEN 'GUINEA-BISSAU' THEN '+00:00'
        WHEN 'GUYANA' THEN '-04:00'
        WHEN 'HAITI' THEN '-05:00'
        WHEN 'HONDURAS' THEN '-06:00'
        WHEN 'HONG KONG (CHINA)' THEN '+08:00'
        WHEN 'HUNGARY' THEN '+01:00'
        WHEN 'ICELAND' THEN '+00:00'
        WHEN 'INDIA' THEN '+05:30'
        WHEN 'IRAN' THEN '+03:30'
        WHEN 'IRAQ' THEN '+03:00'
        WHEN 'IRELAND' THEN '+00:00'
        WHEN 'ISRAEL' THEN '+02:00'
        WHEN 'ITALY' THEN '+01:00'
        WHEN 'JAMAICA' THEN '-05:00'
        WHEN 'JAPAN' THEN '+09:00'
        WHEN 'JORDAN' THEN '+02:00'
        WHEN 'KENYA' THEN '+03:00'
        WHEN 'KOREA, NORTH' THEN '+09:00'
        WHEN 'KOREA, SOUTH' THEN '+09:00'
        WHEN 'KOREA' THEN '+09:00'
        WHEN 'KUWAIT' THEN '+03:00'
        WHEN 'KYRGYZSTAN' THEN '+06:00'
        WHEN 'LAOS' THEN '+07:00'
        WHEN 'LATVIA' THEN '+02:00'
        WHEN 'LEBANON' THEN '+02:00'
        WHEN 'LESOTHO' THEN '+02:00'
        WHEN 'LIBERIA' THEN '+00:00'
        WHEN 'LIBYA' THEN '+02:00'
        WHEN 'LIECHTENSTEIN' THEN '+01:00'
        WHEN 'LITHUANIA' THEN '+02:00'
        WHEN 'LUXEMBOURG' THEN '+01:00'
        WHEN 'LUXEMBURG' THEN '+01:00'
        WHEN 'MACAU' THEN '+08:00'
        WHEN 'MACEDONIA' THEN '+01:00'
        WHEN 'FORMER MACEDONIA' THEN '+01:00'
        WHEN 'MADAGASCAR' THEN '+03:00'
        WHEN 'MALAWI' THEN '+02:00'
        WHEN 'MALAYSIA' THEN '+08:00'
        WHEN 'MALDIVES' THEN '+05:00'
        WHEN 'MALI' THEN '+00:00'
        WHEN 'MALTA' THEN '+01:00'
        WHEN 'MARSHALL ISLANDS' THEN '+12:00'
        WHEN 'MARIANA ISLANDS' THEN '+10:00'
        WHEN 'MAURITANIA' THEN '+00:00'
        WHEN 'MAURITIUS' THEN '+04:00'
        WHEN 'MOLDOVA' THEN '+02:00'
        WHEN 'MONACO' THEN '+01:00'
        WHEN 'MONTENEGRO' THEN '+01:00'
        WHEN 'MOROCCO' THEN '+00:00'
        WHEN 'MOZAMBIQUE' THEN '+02:00'
        WHEN 'MYANMAR' THEN '+06:30'
        WHEN 'NAMIBIA' THEN '+01:00'
        WHEN 'NAURU' THEN '+12:00'
        WHEN 'NEPAL' THEN '+05:45'
        WHEN 'NICARAGUA' THEN '-06:00'
        WHEN 'NIGER' THEN '+01:00'
        WHEN 'NIGERIA' THEN '+01:00'
        WHEN 'NORWAY' THEN '+01:00'
        WHEN 'OMAN' THEN '+04:00'
        WHEN 'PAKISTAN' THEN '+05:00'
        WHEN 'PALAU' THEN '+09:00'
        WHEN 'PALAU ISLAND' THEN '+09:00'
        WHEN 'PANAMA' THEN '-05:00'
        WHEN 'PAPUA NEW GUINEA' THEN '+10:00'
        WHEN 'PARAGUAY' THEN '-04:00'
        WHEN 'PERU' THEN '-05:00'
        WHEN 'PHILIPPINES' THEN '+08:00'
        WHEN 'POLAND' THEN '+01:00'
        WHEN 'QATAR' THEN '+03:00'
        WHEN 'ROMANIA' THEN '+02:00'
        WHEN 'RWANDA' THEN '+02:00'
        WHEN 'SAINT KITTS AND NEVIS' THEN '-04:00'
        WHEN 'SAINT LUCIA' THEN '-04:00'
        WHEN 'SAINT VINCENT AND THE GRENADINES' THEN '-04:00'
        WHEN 'SAMOA' THEN '+13:00'
        WHEN 'SAN MARINO' THEN '+01:00'
        WHEN 'SO TOM AND PRNCIPE' THEN '+00:00'
        WHEN 'SAUDI ARABIA' THEN '+03:00'
        WHEN 'SENEGAL' THEN '+00:00'
        WHEN 'SERBIA' THEN '+01:00'
        WHEN 'SEYCHELLES' THEN '+04:00'
        WHEN 'SIERRA LEONE' THEN '+00:00'
        WHEN 'SINGAPORE' THEN '+08:00'
        WHEN 'SLOVAKIA' THEN '+01:00'
        WHEN 'SLOVENIA' THEN '+01:00'
        WHEN 'SOLOMON ISLANDS' THEN '+11:00'
        WHEN 'SOLOMEN ISLANDS' THEN '+11:00'
        WHEN 'SOMALIA' THEN '+03:00'
        WHEN 'SOUTH AFRICA' THEN '+02:00'
        WHEN 'BOPHUTHATSWANA' THEN '+02:00'
        WHEN 'SOUTH SUDAN' THEN '+03:00'
        WHEN 'SRI LANKA' THEN '+05:30'
        WHEN 'SUDAN' THEN '+03:00'
        WHEN 'SURINAME' THEN '-03:00'
        WHEN 'SWAZILAND' THEN '+02:00'
        WHEN 'SWEDEN' THEN '+01:00'
        WHEN 'SWITZERLAND' THEN '+01:00'
        WHEN 'SYRIA' THEN '+02:00'
        WHEN 'TAIWAN' THEN '+08:00'
        WHEN 'TAJIKISTAN' THEN '+05:00'
        WHEN 'TANZANIA' THEN '+03:00'
        WHEN 'THAILAND' THEN '+07:00'
        WHEN 'TOGO' THEN '+00:00'
        WHEN 'TONGA' THEN '+13:00'
        WHEN 'TRINIDAD AND TOBAGO' THEN '-04:00'
        WHEN 'TUNISIA' THEN '+01:00'
        WHEN 'TURKEY' THEN '+02:00'
        WHEN 'TURKMENISTAN' THEN '+05:00'
        WHEN 'TUVALU' THEN '+12:00'
        WHEN 'TUVALU ISLAND' THEN '+12:00'
        WHEN 'UGANDA' THEN '+03:00'
        WHEN 'UKRAINE' THEN '+02:00'
        WHEN 'UNITED ARAB EMIRATES' THEN '+04:00'
        WHEN 'URUGUAY' THEN '-03:00'
        WHEN 'UZBEKISTAN' THEN '+05:00'
        WHEN 'VANUATU' THEN '+11:00'
        WHEN 'VATICAN CITY' THEN '+01:00'
        WHEN 'VENEZUELA' THEN '-04:30'
        WHEN 'VIETNAM' THEN '+07:00'
        WHEN 'VIET NAM' THEN '+07:00'
        WHEN 'YEMEN' THEN '+03:00'
        WHEN 'ZAMBIA' THEN '+02:00'
        WHEN 'ZAIRE' THEN '+02:00'
        WHEN 'ZIMBABWE' THEN '+02:00'
        ELSE 'UNKNWN' END END
FROM Airports a

;WITH PNGAirports 
    (IATA_Code,Name, City, LatDeg, LatMin, LatSec, LatDir, LatDec, LongDeg, LongMin, LongSec, LongDir, LongDec)
AS (
-- PNG airport coordinates
SELECT 'AGL','WANIGELA','WANIGELA',09,20,15,'S',-9.3375,149,09,20,'E',149.155555555556
UNION ALL SELECT 'AWB','AWABA','AWABA',08,0,52,'S',-8.01444444444444,142,45,06,'E',142.751666666667
UNION ALL SELECT 'BOT','BOSSET','BOSSET',07,14,27,'S',-7.24083333333333,141,05,54,'E',141.098333333333
UNION ALL SELECT 'BUA','BUKA','BUKA',05,25,20,'S',-5.42222222222222,154,40,21,'E',154.6725
UNION ALL SELECT 'CMU','KUNDIAWA','KUNDIAWA',06,1,45,'S',-6.02916666666667,144,58,07,'E',144.968611111111
UNION ALL SELECT 'DAU','DARU','DARU',09,5,15,'S',-9.0875,143,12,30,'E',143.208333333333
UNION ALL SELECT 'EFG','EFOGI','EFOGI',09,9,20,'S',-9.15555555555556,147,39,60,'E',147.666666666667
UNION ALL SELECT 'FNE','FANE','FANE',08,33,4,'S',-8.55111111111111,147,05,11,'E',147.086388888889
UNION ALL SELECT 'GUR','GURNEY / ALOTAU','GURNEY / ALOTAU',10,18,42,'S',-10.3116666666667,150,20,21,'E',150.339166666667
UNION ALL SELECT 'HIR','HENDERSON INTL','HENDERSON INTL',9,25, 0,'S',-9.41666666666667,160,0,0,'E',160
UNION ALL SELECT 'HKN','HOSKINS AIRPORT (PNG)','HOSKINS AIRPORT (PNG)',05,27,44,'S',-5.46222222222222,150,24,18,'E',150.405
UNION ALL SELECT 'ITK','ITOKAMA','ITOKAMA',09,12,1,'S',-9.20027777777778,148,15,53,'E',148.264722222222
UNION ALL SELECT 'KGW','KAGI','KAGI',09,8,13,'S',-9.13694444444444,147,40,12,'E',147.67
UNION ALL SELECT 'KKD','KOKODA','KOKODA',08,53,23,'S',-8.88972222222222,147,43,48,'E',147.73
UNION ALL SELECT 'KMA','KEREMA','KEREMA',07,57,54,'S',-7.965,145,46,13,'E',145.770277777778
UNION ALL SELECT 'KRI','KIKORI','KIKORI',07,25,17,'S',-7.42138888888889,144,14,35,'E',144.243055555556
UNION ALL SELECT 'KVG','KAVIENG','KAVIENG',02,34,27,'S',-2.57416666666667,150,48,17,'E',150.804722222222
UNION ALL SELECT 'LMY','LAKE MURRAY','LAKE MURRAY',07,0,29,'S',-7.00805555555556,141,29,32,'E',141.492222222222
UNION ALL SELECT 'LNV','LIHIR','LIHIR',03,2,34,'S',-3.04277777777778,152,37,38,'E',152.627222222222
UNION ALL SELECT 'LSA','LOSUIA','LOSUIA',8,30,18,'S',8.5051,151,4,48,'E',151.08
UNION ALL SELECT 'MAS','MANUS ISLAND','MANUS ISLAND',02,3,31,'S',-2.05861111111111,147,25,16,'E',147.421111111111
UNION ALL SELECT 'MDU','MENDI','MENDI',06,08,52,'S',-6.14777777777778,143,39,26,'E',143.657222222222
UNION ALL SELECT 'MIS','MISIMA','MISIMA',10,41,26,'S',-10.6905555555556,152,50,8,'E',152.835555555556
UNION ALL SELECT 'MMV','MILEI','MILEI',09,4,49,'S',-9.08027777777778,147,36,10,'E',147.602777777778
UNION ALL SELECT 'MRM','MANARI','MANARI',09,11,32,'S',-9.19222222222222,147,37,15,'E',147.620833333333
UNION ALL SELECT 'MXH','MORO','MORO',6,21,48,'S',-6.36333333333333,143,14,17,'E',143.238055555556
UNION ALL SELECT 'OBX','OBO','OBO',7,35,26,'S',-7.59055555555556,141,19,27,'E',141.324166666667
UNION ALL SELECT 'ONB','ONONGE','ONONGE',08,40,29,'S',-8.6747,147,15,40,'E',147.261
UNION ALL SELECT 'OPU','BALIMO','BALIMO',08,4,4,'S',-8.06777777777778,142,56,25,'E',142.940277777778
UNION ALL SELECT 'PNP','POPONDETTA','POPONDETTA',08,48,21,'S',-8.80583333333333,148,18,25,'E',148.306944444444
UNION ALL SELECT 'RAB','RABAUL (TOKUA)','RABAUL (TOKUA)',04,20,25,'S',-4.34027777777778,152,22,46,'E',152.379444444444
UNION ALL SELECT 'SGK','SANGAPI','SANGAPI',05,07,30,'S',-5.125,144,19,23,'E',144.323055555556
UNION ALL SELECT 'TDS','SASEREME','SASEREME',07,37,22,'S',-7.62277777777778,142,52,8,'E',142.868888888889
UNION ALL SELECT 'SKC','SUKI','SUKI',8,5,0,'S',-8.08333333333333,141,48,0,'E',141.8
UNION ALL SELECT 'TBG','TABUBIL','TABUBIL',05,16,40,'S',-5.27777777777778,141,13,34,'E',141.226111111111
UNION ALL SELECT 'TFI','TUFI','TUFI',9,4,34,'S',-9.07611111111111,149,19,12,'E',149.32
UNION ALL SELECT 'TIZ','TARI','TARI',05,50,40,'S',-5.84444444444444,142,56,48,'E',142.946666666667
UNION ALL SELECT 'TPI','TAPINI','TAPINI',8,21,24,'S',-8.35666666666667,146,59,21,'E',146.989166666667
UNION ALL SELECT 'UNG','KIUNGA','KIUNGA',6,7,32,'S',-6.12555555555555,141,16,55,'E',141.281944444444
UNION ALL SELECT 'VAI','VANIMO','VANIMO',02,41,50,'S',-2.69722222222222,141,18,8,'E',141.302222222222
UNION ALL SELECT 'WBM','WAPENAMANDA','WAPENAMANDA',05,38,36,'S',-5.64333333333333,143,53,43,'E',143.895277777778
UNION ALL SELECT 'WPM','WIPIM','WIPIM',08,47,22,'S',-8.78944444444444,142,52,52,'E',142.881111111111
UNION ALL SELECT 'WTP','WOITAPE','WOITAPE',8,33,45,'S',-8.5625,147,15,9,'E',147.2525
-- Thailand airport coordinates
UNION ALL SELECT 'CNX',UPPER('Chiang Mai International Airport'), 'CHIANG MAI', 18, 46, 00, 'N', 0, 98, 57, 45, 'E', 0
UNION ALL SELECT 'CEI',UPPER('Chiang Rai International Airport'), 'CHIANG RAI', 19, 57, 08, 'N', 0, 99, 52, 58, 'E', 0 
)
UPDATE a
SET Name = b.Name
    , City = b.City
    , LatDeg = b.LatDeg
    , LatMin = b.LatMin
    , LatSec = b.LatSec
    --, LatDec = b.LatDec
    ,LatDir = b.LatDir
    , LongDeg = b.LongDeg
    , LongMin = b.LongMin
    , LongSec = b.LongSec
    ,LongDir = b.LongDir
    --, LongDec = b.LongDec
FROM Airports a
INNER JOIN PNGAirports b
    ON a.IATA_Code = b.IATA_Code 

-- Fix U directions when country has only one direction E/W, N/S
UPDATE a
SET LatDir = CASE WHEN a.LatDir = 'U' AND (LatDeg <> 0 OR LatMin <> 0 OR LatSec <> 0) 
        THEN c.LatDir ELSE a.LatDir END
    ,LongDir = CASE WHEN a.LongDir = 'U' AND (LongDeg <> 0 OR LongMin <> 0 OR LongSec <> 0)
        THEN c.LongDir ELSE a.LongDir END
FROM Airports a
INNER JOIN (
SELECT Country, LatDir, LongDir
FROM (
SELECT Country, LatDir, LongDir
    ,n=COUNT(Country) OVER (PARTITION BY Country)
FROM (
    SELECT Country, LatDir, LongDir
    FROM Airports
    WHERE (LatDeg <> 0 OR LatMin <> 0 OR LatSec <> 0) AND
        (LongDeg <> 0 OR LongMin <> 0 OR LongSec <> 0) AND
        (LatDir <> 'U' AND LongDir <> 'U')
    ) a
GROUP BY Country, LatDir, LongDir) c
WHERE n = 1) c ON a.Country = c.Country

UPDATE a
SET LatDir = CASE WHEN LatDir = 'U' AND LatDeg <> 0 THEN 'N' ELSE LatDir END
    ,LongDir = CASE WHEN LongDir = 'U' AND LongDeg <> 0 THEN 'W' ELSE LongDir END
FROM Airports a
WHERE Country LIKE 'USA%' OR Country = 'ARGENTINA' OR Country = 'ARUBA' OR Country = 'BAHAMAS' OR
    Country = 'ARGENTINA' OR Country = 'BARBADOS' OR Country = 'CAYMAN ISLANDS' OR Country = 'COSTA RICA' OR 
    Country = 'CUBA' OR Country = 'DOMINICA' OR Country = 'DOMINICAN REPUBLIC' OR
    Country = 'EL SALVADOR' OR Country = 'GUATEMALA' OR Country = 'HAITI' OR
    Country = 'HONDURAS' OR Country = 'JAMAICA' OR Country = 'MEXICO' OR
    Country = 'NICARAGUA' OR Country = 'PANAMA' OR Country = 'PUERTO RICO' OR 
    Country = 'BOLIVIA' OR Country = 'BRAZIL' OR Country = 'CHILE' OR 
    Country = 'ECUADOR' OR Country = 'FALKLAND ISLANDS' OR Country = 'GRENADA' OR 
    Country = 'PARAGUAY' OR Country = 'PERU' OR Country = 'URUGUAY' OR 
    Country = 'VENEZUELA' 
UPDATE a
SET LatDir = CASE WHEN LatDeg = 0 AND LatMin = 0 AND LatSec = 0 THEN 'U' ELSE LatDir END
    ,LongDir = CASE WHEN LongDeg = 0 AND LongMin = 0 AND LongSec = 0 THEN 'U' ELSE LongDir END
FROM Airports a

;WITH ThailandAirports 
    (IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir, LongDeg, LongMin, LongSec, LongDir)
AS (
SELECT 'BKK','BANGKOK INTERNATIONAL,SUVARNABHUMI','BANGKOK','THAILAND',13,41,33,'N',100,45,0,'E'
UNION ALL SELECT 'DMK','DON MUEANG INTERNATIONAL','BANGKOK','THAILAND',13,54,45,'N',100,36,24,'E'
UNION ALL SELECT 'CEI','MAE FAH LUANG - CHIANG RAI INTERNATIONAL','CHIANG RAI','THAILAND',19,57,8,'N',99,52,58,'E'
UNION ALL SELECT 'CNX','CHIANG MAI INTERNATIONAL AIRPORT','CHIANG MAI','THAILAND',18,46,0,'N',98,57,45,'E'
UNION ALL SELECT 'HDY','HAT YAI INTERNATIONAL ','SONGKHLA','THAILAND',6,55,59,'N',100,23,34,'E'
UNION ALL SELECT 'HHQ','HUA HIN ','PRACHUAP KHIRI KHAN','THAILAND',12,38,10,'N',99,57,5,'E'
UNION ALL SELECT 'HKT','PHUKET INTERNATIONAL ','PHUKET','THAILAND',8,6,47,'N',98,19,0,'E'
UNION ALL SELECT 'KKC','KHON KAEN','KHON KAEN','THAILAND',16,28,0,'N',102,47,1,'E'
UNION ALL SELECT 'KOP','NAKHON PHANOM ','NAKHON PHANOM','THAILAND',17,23,2,'N',104,38,35,'E'
UNION ALL SELECT 'LOE','LOEI ','LOEI','THAILAND',17,26,21,'N',101,43,19,'E'
UNION ALL SELECT 'LPT','LAMPANG ','LAMPANG','THAILAND',18,16,14,'N',99,30,15,'E'
UNION ALL SELECT 'NAK','KHORAT/NAKHON RATCHASIMA','NAKHON RATCHASIMA','THAILAND',14,56,58,'N',102,18,45,'E'
UNION ALL SELECT 'NAW','NARATHIWAT','NARATHIWAT','THAILAND',6,31,12,'N',101,44,36,'E'
UNION ALL SELECT 'NST','CHA IAN/NAKHON SI THAMMARAT','NAKHON SI THAMMARAT','THAILAND',8,32,22,'N',99,56,41,'E'
UNION ALL SELECT 'PAN','PATTANI','PATTANI','THAILAND',6,47,8,'N',101,9,13,'E'
UNION ALL SELECT 'PHS','PHITSANULOK','PHITSANULOK','THAILAND',16,46,23,'N',100,16,56,'E'
UNION ALL SELECT 'PRH','PHRAE','PHRAE','THAILAND',18,7,56,'N ',100,9,54,'E'
UNION ALL SELECT 'SNO','SAKON NAKHON','SAKON NAKHON','THAILAND',17,11,43,'N',104,7,7,'E'
UNION ALL SELECT 'TST','TRANG','TRANG','THAILAND',7,30,32,'N',99,36,60,'E'
UNION ALL SELECT 'UBP','UBON RATCHATHANI','UBON RATCHATHANI','THAILAND',15,15,5,'N',104,52,13,'E'
UNION ALL SELECT 'UTH','UDON THANI/UDON THANI INTERNATIONAL','UDON THANI','THAILAND',17,23,11,'N',102,47,18,'E'
UNION ALL SELECT 'UTP','U TAPHAO INTERNATIONAL','RAYONG','THAILAND',12,40,47,'N',101,0,18,'E'
UNION ALL SELECT 'BFV','BURIRAM','BURIRAM','THAILAND',15,13,46,'N',103,15,4,'E'
UNION ALL SELECT 'CJM','CHUMPON','CHUMPON','THAILAND',10,42,40,'N',99,21,42,'E'
UNION ALL SELECT 'USM','SAMUI','SURAT THANI','THAILAND',9,32,52,'N',100,3,44,'E'
UNION ALL SELECT 'KBV','KRABI INTERNATIONAL','KRABI','THAILAND',8,6,3,'N',98,59,5,'E'
UNION ALL SELECT 'PHY','PHETCHABUN','PHETCHABUN','THAILAND',16,40,33,'N',101,11,42,'E'
UNION ALL SELECT 'HGN','MAE HONG SON','MAE HONG SON','THAILAND',19,18,4,'N',97,58,29,'E'
UNION ALL SELECT 'MAQ','MAE SOT','TAK','THAILAND',16,41,59,'N',98,32,42,'E'
UNION ALL SELECT 'TKH','TAKHLI ROYAL THAI AIR FORCE BASE','NAKHON SAWAN','THAILAND',15,16,5,'N',100,17,32,'E'
UNION ALL SELECT 'UNN','RANONG','RANONG','THAILAND',9,46,39,'N',98,35,7,'E'
UNION ALL SELECT 'ROI','ROI ET','ROI ET','THAILAND',16,7,0,'N',103,46,25,'E'
UNION ALL SELECT 'THS','SUKHOTHAI','SUKHOTHAI','THAILAND',17,14,16,'N',99,49,5,'E'
UNION ALL SELECT 'URT','SURAT THANI','SURAT THANI','THAILAND',9,7,57,'N',99,8,8,'E'
UNION ALL SELECT 'TKT','TAK','TAK','THAILAND',16,53,46,'N',99,15,12,'E'
UNION ALL SELECT 'TDX','TRAT','TRAT','THAILAND',12,16,28,'N',102,19,8,'E'
)
MERGE INTO Airports a
USING ThailandAirports b
    ON a.IATA_Code = b.IATA_Code AND a.Country = b.Country
WHEN MATCHED THEN
    UPDATE SET Name = b.Name, City = b.City, Country = b.Country, LatDeg = b.LatDeg
        ,LatMin = b.LatMin, LatSec = b.LatSec, LatDir = b.LatDir
        ,LongDeg = b.LongDeg, LongMin = b.LongMin, LongSec = b.LongSec, LongDir = b.LongDir
WHEN NOT MATCHED THEN
    INSERT (ICAO_Code, IATA_Code, Name, City, Country, LatDeg, LatMin, LatSec, LatDir
        ,LongDeg, LongMin, LongSec, LongDir, UTC)
    VALUES ('UNK', b.IATA_Code, b.Name, b.City, b.Country, b.LatDeg, b.LatMin, b.LatSec, b.LatDir
        ,b.LongDeg, b.LongMin, b.LongSec, b.LongDir, '+07:00');